/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.io.File;
import java.io.IOException;

import javax.servlet.http.HttpServletResponse;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.util.FileUtil;
import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.fw.web.struts.action.ActionMappingEx;
import jp.terasoluna.fw.web.struts.form.DynaValidatorActionFormEx;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.utlib.PropertyTestCase;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;

/**
 * {@link jp.terasoluna.fw.web.struts.actions.MakeSessionDirectoryAction}
 * NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * ZbVfBNg쐬ANVB
 * <p>
 *
 * @see jp.terasoluna.fw.web.struts.actions.MakeSessionDirectoryAction
 */
public class MakeSessionDirectoryActionTest extends PropertyTestCase {

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
        LogUTUtil.flush();
        Thread.sleep(100);

        addProperty("session.dir.base", "c:/sessions");

        // t@C폜
        FileUtil.removeSessionDirectory("dummyID");
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
        // t@C폜
        FileUtil.removeSessionDirectory("dummyID");
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public MakeSessionDirectoryActionTest(String name) {
        super(name);
    }

    /**
     * testDoExecute01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () session:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"error.session.not.found"<br>
     *                    bvOFnull<br>
     *         (ԕω) O<br>
     *                    G[OF"HttpSession is not available."<br>
     *
     * <br>
     * HttpSessionnullꍇSystemException邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute01() throws Exception {
        // O
        MakeSessionDirectoryAction action = new MakeSessionDirectoryAction();

        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();

        ActionForm form = new DynaValidatorActionFormEx();

        // session:null
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setSession(null);

        // sendErrořĂяomFp
        MockHttpServletResponse res = new MockHttpServletResponse();

        // eXg{
        try {
            action.doExecute(mapping, form, req, res);
            fail("O܂ł");
        } catch (SystemException e) {
            // 
            // G[OmF
            assertTrue(LogUTUtil.checkError("HttpSession is not available."));
            assertEquals("error.session.not.found", e.getErrorCode());
        }
    }

    /**
     * testDoExecute02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () session:not null<br>
     *         () sessionId:"dummyID"<br>
     *         () path:null<br>
     *
     * <br>
     * ҒlF(߂l) actionForward:null<br>
     *         (ԕω) directory:
     *         "c:/sessions/" + FileUtil.getSessionDirectoryName("dummyID")
     *         fBNg݂邱ƂmF<br>
     *         (ԕω) res.sendError():Ăяo<br>
     *
     * <br>
     * mappingp[^̎擾ʂnullłA
     * HttpServletResponse.sendError()ĂяoꂽꍇAnullԂƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute02() throws Exception {
        // O
        MakeSessionDirectoryAction action = new MakeSessionDirectoryAction();

        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        // path : null
        String path = null;
        mapping.setParameter(path);

        ActionForm form = new DynaValidatorActionFormEx();

        // sessionId:"dummyID"
        MockHttpServletRequest req = new MockHttpServletRequest();

        // sendErrořĂяomFp
        MockHttpServletResponse res = new MockHttpServletResponse();

        ActionForward forward = null;

        // eXg{
        forward = action.doExecute(mapping, form, req, res);

        // 
        assertNull(forward);
        File file = new File(PropertyUtil.getProperty("session.dir.base") + "/"
                + FileUtil.getSessionDirectoryName(req.getSession().getId()));
        assertTrue(file.exists());
        assertEquals(HttpServletResponse.SC_NOT_FOUND, res.getStatus());
    }

    /**
     * testDoExecute03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () session:not null<br>
     *         () sessionId:"dummyID"<br>
     *         () path:null<br>
     *         () vpeB:session.dir.base=c:/sessions<br>
     *         () res.sendError():IOException<br>
     *
     * <br>
     * ҒlF(ԕω) directory:
     *         "c:/sessions/" + FileUtil.getSessionDirectoryName("dummyID")
     *         fBNg݂邱ƂmF<br>
     *         (ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"error.forward.errorpage"<br>
     *                    bvOFIOException<br>
     *         (ԕω) O<br>
     *                    G[OF"Error page(404) forwarding failed."<br>
     *
     * <br>
     * mappingp[^̎擾ʂnullłA
     * HttpServletResponse.sendError()ďoŗOꍇA
     * w肵pXɃZbVfBNgꂽmFB
     * ܂SystemException邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute03() throws Exception {
        // O
        MakeSessionDirectoryAction action = new MakeSessionDirectoryAction();

        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        // path : null
        String path = null;
        mapping.setParameter(path);

        ActionForm form = new DynaValidatorActionFormEx();

        // sessionId:"dummyID"
        MockHttpServletRequest req = new MockHttpServletRequest();

        // sendError:IOException
        MakeSessionDirectoryAction_HttpServletResponseStub01 res =
            new MakeSessionDirectoryAction_HttpServletResponseStub01();

        // eXg{
        try {
            action.doExecute(mapping, form, req, res);
            fail("O܂ł");
        } catch (SystemException e) {
            // 
            // G[OmF
            assertTrue(LogUTUtil.checkError("Error page(404) forwarding failed."));
            // IOExceptionbv
            assertEquals(IOException.class.getName(),
                    e.getCause().getClass().getName());
            File file = FileUtil.getSessionDirectory(req.getSession().getId());
            assertTrue(file.exists());
            assertEquals("error.forward.errorpage", e.getErrorCode());
        }
    }

    /**
     * testDoExecute04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () session:not null<br>
     *         () sessionId:"dummyID"<br>
     *         () path:"abc"<br>
     *         () vpeB:session.dir.base=c:/sessions<br>
     *
     * <br>
     * ҒlF(߂l) actionForward:ActionForward.getPath()F"abc"<br>
     *         (ԕω) directory:
     *         "c:/sessions/" + FileUtil.getSessionDirectoryName("dummyID")
     *         fBNg݂邱ƂmF<br>
     *
     * <br>
     * mappingp[^̎擾ʂnot null̏ꍇA
     * w肵pXɃZbVfBNgꂽmFB
     * ܂ActionForwardpathw肵pathƈv邩mF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute04() throws Exception {
        // O
        MakeSessionDirectoryAction action = new MakeSessionDirectoryAction();

        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        // path : "abc"
        String path = "abc";
        mapping.setParameter(path);

        ActionForm form = new DynaValidatorActionFormEx();

        // sessionId:"dummyID"
        MockHttpServletRequest req = new MockHttpServletRequest();

        HttpServletResponse res = new MockHttpServletResponse();

        ActionForward forward = null;

        // eXg{
        forward = action.doExecute(mapping, form, req, res);

        // 
        File file = new File(PropertyUtil.getProperty("session.dir.base") +"/"
                + FileUtil.getSessionDirectoryName(req.getSession().getId()));
        assertTrue(file.exists());
        assertEquals("abc", forward.getPath());
    }
}
