/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.PropertyTestCase;

import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Msg;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.Var;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

/**
 * {@link jp.terasoluna.fw.web.struts.form.FieldChecksEx} NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Validatorǉ[NXB
 * <p>
 *
 * @see jp.terasoluna.fw.web.struts.form.FieldChecksEx
 */
public class FieldChecksExTest01 extends PropertyTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(FieldChecksExTest01.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
        LogUTUtil.flush();
        deleteProperty("validation.hankaku.kana.list");
        deleteProperty("validation.zenkaku.kana.list");
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public FieldChecksExTest01(String name) {
        super(name);
    }

    /**
     * testIsHankakuKana01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:¯֬
     *                  ܦް<br>
     *                ꕶmF<br>
     *         () hankakuKanaList:¯
     *                                ֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:SĂ̕ɂtrue<br>
     *
     * <br>
     * Ɏw肵hankakuKanaListɊ܂܂ꍇA
     * true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankakuKana01() throws Exception {
        // ͒l̐ݒ
        String hankakuKanaList =
            "¯֬ܦް";

        // isHankakuKanas
        for (int i = 0; i < hankakuKanaList.length(); i++) {
            assertTrue(FieldChecksEx.isHankakuKana(hankakuKanaList.charAt(i)));
        }
    }

    /**
     * testIsHankakuKana02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:''-1<br>
     *                ''+1<br>
     *                ꕶmF<br>
     *         () hankakuKanaList:¯
     *                                ֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:SĂ̕ɂfalse<br>
     *
     * <br>
     * Ɏw肵hankakuKanaListɊ܂܂ȂꍇA
     * false擾ł邱ƂmFBipJi̋EeXgj
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankakuKana02() throws Exception {
        // ͒l̐ݒ
        char chStart = '' - 1;
        char chEnd = '' + 1;

        // isHankakuKanas
        assertFalse(FieldChecksEx.isHankakuKana(chStart));
        assertFalse(FieldChecksEx.isHankakuKana(chEnd));
    }

    /**
     * testIsHankakuKana03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:'S'<br>
     *         () hankakuKanaList:¯
     *                                ֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * Ɏw肵hankakuKanaListɊ܂܂ȂꍇA
     * false擾ł邱ƂmFBiSpj
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankakuKana03() throws Exception {
        // ͒l̐ݒ
        char chZenkaku = 'S';

        // isHankakuKanas
        assertFalse(FieldChecksEx.isHankakuKana(chZenkaku));
    }

    /**
     * testIsZenkakuKana01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:ACEGI@BDFHJLNPRKMOQSTVXZ\
     *                  UWY[]^`ceg_adfhijklmnqtwz
     *                  orux{psvy|}~
     *                  b[<br>
     *                ꕶmF<br>
     *         () zenkakuKanaList:ACEGI@BDFHJLNPR
     *                                KMOQSTVXZ\UWY[]^`ceg
     *                                _adfhijklmnqtwzorux{
     *                                psvy|}~
     *                                b[<br>
     *         () vpeBt@C:validation.zenkaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:SĂ̕ɂtrue<br>
     *
     * <br>
     * Ɏw肵zenkakuKanaListɊ܂܂ꍇA
     * true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkakuKana01() throws Exception {
        // ͒l̐ݒ
        String zenkakuKanaList = "ACEGI@BDFHJLNPR" +
                "KMOQSTVXZ\UWY[]^`ceg" +
                "_adfhijklmnqtwzorux{" +
                "psvy|}~" +
                "b[";

        // eXgs
        for (int i = 0; i < zenkakuKanaList.length(); i++) {
            assertTrue(FieldChecksEx.isZenkakuKana(zenkakuKanaList.charAt(i)));
        }
    }

    /**
     * testIsZenkakuKana02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:'@' - 1<br>
     *                '[' + 1<br>
     *                ꕶmF<br>
     *         () zenkakuKanaList:ACEGI@BDFHJLNPR
     *                                KMOQSTVXZ\UWY[]^`ceg
     *                                _adfhijklmnqtwzorux{
     *                                psvy|}~
     *                                b[<br>
     *         () vpeBt@C:validation.zenkaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:SĂ̕ɂfalse<br>
     *
     * <br>
     * Ɏw肵zenkakuKanaListɊ܂܂ȂꍇA
     * false擾ł邱ƂmFBipJi̋EeXgj
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkakuKana02() throws Exception {
        // ͒l̐ݒ
        char chStart = '@' - 1;
        char chEnd = '[' + 1;

        // eXg̎s
        assertFalse(FieldChecksEx.isZenkakuKana(chStart));
        assertFalse(FieldChecksEx.isZenkakuKana(chEnd));
    }

    /**
     * testIsZenkakuKana03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:''<br>
     *         () zenkakuKanaList:ACEGI@BDFHJLNPR
     *                                KMOQSTVXZ\UWY[]^`ceg
     *                                _adfhijklmnqtwzorux{
     *                                psvy|}~
     *                                b[<br>
     *         () vpeBt@C:validation.zenkaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * Ɏw肵zenkakuKanaListɊ܂܂ȂꍇAfalse擾ł邱ƂmFBiSpj
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkakuKana03() throws Exception {
        // ͒l̐ݒ
        char chHiragana = '';

        // eXg̎s
        assertFalse(FieldChecksEx.isZenkakuKana(chHiragana));
    }

    /**
     * testIsHankaku01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:'\u00ff'<br>
     *                ''<br>
     *                ''<br>
     *                ꕶmF<br>
     *         () hankakuKanaList:¯
     *                                ֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:SĂ̕ɂtrue<br>
     *
     * <br>
     * Ɏw肵R[h'\00ff'ȉA
     * "_Nʁ}L~"ł͂ȂAhankakuKanaListɊ܂܂ꍇA
     * true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankaku01() throws Exception {

        // ͒l̐ݒ
        char chHankakuMax = '\u00ff';
        char chHankakuKanaStart = '';
        char chHankakuKanaEnd = '';

        // isHankakus
        // pݒ肳ꂽƂAtrueԋp邱
        assertTrue(FieldChecksEx.isHankaku(chHankakuMax));
        assertTrue(FieldChecksEx.isHankaku(chHankakuKanaStart));
        assertTrue(FieldChecksEx.isHankaku(chHankakuKanaEnd));
    }

    /**
     * testIsHankaku02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:'\u0100'<br>
     *                ''-1<br>
     *                ''+1<br>
     *                ꕶmF<br>
     *         () hankakuKanaList:¯
     *                                ֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:SĂ̕ɂfalse<br>
     *
     * <br>
     * Ɏw肵R[h'\00ff'ȏA܂́A
     * "_Nʁ}L~"Ɋ܂܂A܂́A
     * hankakuKanaListɊ܂܂ȂꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankaku02() throws Exception {

        // ͒l̐ݒ
        char chUpperff = '\u0100';

        char chKanaStart = '' - 1;
        char chKanaEnd = '' + 1;

        // isHankakus
        assertFalse(FieldChecksEx.isHankaku(chUpperff));
        assertFalse(FieldChecksEx.isHankaku(chKanaStart));
        assertFalse(FieldChecksEx.isHankaku(chKanaEnd));

    }

    /**
     * testIsHankaku03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:'A'<br>
     *                'U'<br>
     *                ''<br>
     *                ''<br>
     *                ''<br>
     *                '`'<br>
     *                'y'<br>
     *         () hankakuKanaList:¯
     *                                ֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * Ɏw肵SpłꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankaku03() throws Exception {

        // ͒l̐ݒ
        char[] input = {
            'A',
            'U',
            '',
            '',
            '',
            '`',
            'y'
        };

        // isHankakus
        // Spݒ肳ꂽƂAfalseԋp邱
        for (char c : input) {
            assertFalse(FieldChecksEx.isHankaku(c));
        }
    }

    /**
     * testIsHankaku04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:"_Nʁ}L~"<br>
     *                ꕶmF<br>
     *         () hankakuKanaList:¯
     *                                ֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * Ɏw肵R[h'\00ff'ȏA܂́A
     * "_Nʁ}L~"Ɋ܂܂A܂́A
     * hankakuKanaListɊ܂܂ȂꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankaku04() throws Exception {
        // ͒l̐ݒ
        String zenkakuBeginU00List = "_Nʁ}L~";

        // eXgs
        for (int i = 0; i < zenkakuBeginU00List.length(); i++) {
            assertFalse(FieldChecksEx.isHankaku(zenkakuBeginU00List.charAt(i)));
        }
    }

    /**
     * testIsZenkaku01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:'\u0100'<br>
     *                ''-1<br>
     *                ''+1<br>
     *                ꕶmF<br>
     *         () hankakuKanaList:¯
     *                                ֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:SĂ̕ɂtrue<br>
     *
     * <br>
     * Ɏw肵R[h'\00ff'傫AA
     * "_Nʁ}L~"Ɋ܂܂邩A
     * hankakuKanaListɊ܂܂ȂꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkaku01() throws Exception {

        // ͒l̐ݒ
        char chZenkakuMin = '\u0100';
        char chZenkakuKanaStart = '' - 1;
        char chZenkakuKanaEnd = '' + 1;

        // isZenkakus
        // Sp񂪐ݒ肳ꂽƂAtrueԋp邱
        assertTrue(FieldChecksEx.isZenkaku(chZenkakuMin));
        assertTrue(FieldChecksEx.isZenkaku(chZenkakuKanaStart));
        assertTrue(FieldChecksEx.isZenkaku(chZenkakuKanaEnd));
    }

    /**
     * testIsZenkaku02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:'\u00ff'<br>
     *                ''<br>
     *                ''<br>
     *                ꕶmF<br>
     *         () hankakuKanaList:¯
     *                                ֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:SĂ̕ɂfalse<br>
     *
     * <br>
     * Ɏw肵R[h'\00ff'ȉA
     * "_Nʁ}L~"ł͂ȂA
     * hankakuKanaListɊ܂܂ꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkaku02() throws Exception {

        // ͒l̐ݒ
        char chZenkakuMin = '\u00ff';
        char chZenkakuKanaStart = '';
        char chZenkakuKanaEnd = '';

        // isZenkakus
        // pݒ肳ꂽƂAfalseԋp邱
        assertFalse(FieldChecksEx.isZenkaku(chZenkakuMin));
        assertFalse(FieldChecksEx.isZenkaku(chZenkakuKanaStart));
        assertFalse(FieldChecksEx.isZenkaku(chZenkakuKanaEnd));

    }

    /**
     * testIsZenkaku03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:''<br>
     *                '6'<br>
     *                '&'<br>
     *                'a'<br>
     *                'z'<br>
     *                'A'<br>
     *                'Z'<br>
     *         () hankakuKanaList:¯
     *                                ֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * Ɏw肵płꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkaku03() throws Exception {

        // ͒l̐ݒ
        char[] input = {
            '',
            '6',
            '&',
            'a',
            'z',
            'A',
            'Z'
        };

        // isZenkakus
        // pݒ肳ꂽƂAfalseԋp邱
        for (char c : input) {
            assertFalse(FieldChecksEx.isZenkaku(c));
        }
    }

    /**
     * testIsZenkaku04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:"_Nʁ}L~"<br>
     *                ꕶmF<br>
     *         () hankakuKanaList:¯
     *                                ֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * Ɏw肵"_Nʁ}L~"Ɋ܂܂ꍇA
     * true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkaku04() throws Exception {
        // ͒l̐ݒ
        String zenkakuBeginU00List = "_Nʁ}L~";

        // eXgs
        for (int i = 0; i < zenkakuBeginU00List.length(); i++) {
            assertTrue(FieldChecksEx.isZenkaku(zenkakuBeginU00List.charAt(i)));
        }
    }

    /**
     * testIsValid01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() result:Boolean(true)<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * ̒lBooleantruȅꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsValid01() throws Exception {

        // ͒l̐ݒ
        Boolean result = new Boolean(true);

        // eXgs
        Boolean ret = FieldChecksEx.isValid(result);
        assertTrue(ret.booleanValue());
    }

    /**
     * testIsValid02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() result:Boolean(false)<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * ̒lBooleanfalsȅꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsValid02() throws Exception {

        // ͒l̐ݒ
        Boolean result = new Boolean(false);

        // eXgs
        Boolean ret = FieldChecksEx.isValid(result);
        assertFalse(ret.booleanValue());
    }

    /**
     * testIsValid03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() result:"String"<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * ̒lBoolean^ł͂ȂꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsValid03() throws Exception {

        // ͒l̐ݒ
        String result = "String";

        // eXgs
        Boolean ret = FieldChecksEx.isValid(result);
        assertTrue(ret.booleanValue());
    }

    /**
     * testReplaceIndexString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() arg:null<br>
     *         () pos:0<br>
     *
     * <br>
     * ҒlF(߂l) String:null<br>
     *
     * <br>
     * argnull̏ꍇAnull擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testReplaceIndexString01() throws Exception {
        // eXgs
        String ret = FieldChecksEx.replaceIndexString(null, 0);
        assertNull(ret);
    }

    /**
     * testReplaceIndexString02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() arg:"##INDEX"<br>
     *         () pos:0<br>
     *
     * <br>
     * ҒlF(߂l) String:"0"<br>
     *
     * <br>
     * arg"##INDEX"̏ꍇAœnpos̒l擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testReplaceIndexString02() throws Exception {
        // eXgs
        String ret = FieldChecksEx.replaceIndexString("##INDEX", 0);
        assertEquals("0", ret);
    }

    /**
     * testReplaceIndexString03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() arg:"test"<br>
     *         () pos:0<br>
     *
     * <br>
     * ҒlF(߂l) String:"test"<br>
     *
     * <br>
     * arg"##INDEX"ł͂ȂꍇAarg̒l擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testReplaceIndexString03() throws Exception {

        // eXgs
        String ret = FieldChecksEx.replaceIndexString("test", 0);
        assertEquals("test", ret);
    }

    /**
     * testReplaceIndexString04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() arg:"##index"<br>
     *         () pos:99<br>
     *
     * <br>
     * ҒlF(߂l) String:"99"<br>
     *
     * <br>
     * arg"##index"(܂܂)̏ꍇAœnpos̒l擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testReplaceIndexString04() throws Exception {
        // eXgs
        String ret = FieldChecksEx.replaceIndexString("##index", 99);
        assertEquals("99", ret);
    }

    /**
     * testReplaceIndexString05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() arg:""<br>
     *         () pos:999<br>
     *
     * <br>
     * ҒlF(߂l) String:""<br>
     *
     * <br>
     * arg"##INDEX"ł͂ȂꍇAarg̒l擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testReplaceIndexString05() throws Exception {
        // eXgs
        String ret = FieldChecksEx.replaceIndexString("", 999);
        assertEquals("", ret);
    }

    /**
     * testGetArrayIndexField01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() field:not null<br>
     *                Arg݂Ȃ<br>
     *         () pos:0<br>
     *
     * <br>
     * ҒlF(߂l) Field:not null<br>
     *                  iԕωȂj<br>
     *
     * <br>
     * fieldArgCX^Xݒ肳ĂȂꍇA
     * fieldɕωȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetArrayIndexField01() throws Exception {

        // ͒l̐ݒ
        Field field = new Field();

        // eXgs
        Field retField = FieldChecksEx.getArrayIndexField(field, 0);
        assertNull(retField.getArg(0));
        assertNull(retField.getArg(1));
        assertNull(retField.getArg(2));
        assertNull(retField.getArg(3));
    }

    /**
     * testGetArrayIndexField02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() field:not null<br>
     *                {Arg:key="arg0", position=0;<br>
     *                 Arg:key="arg1", position=1;<br>
     *                 Arg:key="arg2", position=2;<br>
     *                 Arg:key="arg3", position=3}<br>
     *         () pos:0<br>
     *
     * <br>
     * ҒlF(߂l) Field:not null<br>
     *                  {Arg:key="arg0", position=0;<br>
     *                   Arg:key="arg1", position=1;<br>
     *                   Arg:key="arg2", position=2;<br>
     *                   Arg:key="arg3", position=3}<br>
     *                  (ԕωȂ)<br>
     *
     * <br>
     * fieldɐݒ肳ꂽArgCX^Xkey̒l"##INDEX"ł͂ȂꍇA
     * fieldɕωȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetArrayIndexField02() throws Exception {

        // ͒l̐ݒ
        Field field = new Field();
        // argݒ
        Arg param0 = new Arg();
        param0.setKey("arg0");
        param0.setPosition(0);
        field.addArg(param0);

        Arg param1 = new Arg();
        param1.setKey("arg1");
        param1.setPosition(1);
        field.addArg(param1);

        Arg param2 = new Arg();
        param2.setPosition(2);
        param2.setKey("arg2");
        field.addArg(param2);

        Arg param3 = new Arg();
        param3.setPosition(3);
        param3.setKey("arg3");
        field.addArg(param3);

        // eXgs
        Field retField = FieldChecksEx.getArrayIndexField(field, 0);

        assertEquals("arg0", retField.getArg(0).getKey());
        assertEquals("arg1", retField.getArg(1).getKey());
        assertEquals("arg2", retField.getArg(2).getKey());
        assertEquals("arg3", retField.getArg(3).getKey());
    }

    /**
     * testGetArrayIndexField03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() field:not null<br>
     *                {Arg:key="##INDEX", position=0;<br>
     *                 Arg:key="##INDEX", position=1;<br>
     *                 Arg:key="##INDEX", position=2;<br>
     *                 Arg:key="##INDEX", position=3}<br>
     *         () pos:0<br>
     *
     * <br>
     * ҒlF(߂l) Field:not null<br>
     *                  {Arg:key="1", position=0;<br>
     *                   Arg:key="1", position=1;<br>
     *                   Arg:key="1", position=2;<br>
     *                   Arg:key="1", position=3}<br>
     *
     * <br>
     * fieldɐݒ肳ꂽArgCX^Xkey̒l"##INDEX"łꍇA
     * key̒lpos̒l{PɂȂ邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetArrayIndexField03() throws Exception {

        // ͒l̐ݒ
        Field field = new Field();
        // argݒ
        Arg param0 = new Arg();
        param0.setKey("##INDEX");
        param0.setPosition(0);
        field.addArg(param0);

        Arg param1 = new Arg();
        param1.setKey("##INDEX");
        param1.setPosition(1);
        field.addArg(param1);

        Arg param2 = new Arg();
        param2.setKey("##INDEX");
        param2.setPosition(2);
        field.addArg(param2);

        Arg param3 = new Arg();
        param3.setKey("##INDEX");
        param3.setPosition(3);
        field.addArg(param3);

        // eXgs
        Field retField = FieldChecksEx.getArrayIndexField(field, 0);

        assertEquals("1", retField.getArg(0).getKey());
        assertEquals("1", retField.getArg(1).getKey());
        assertEquals("1", retField.getArg(2).getKey());
        assertEquals("1", retField.getArg(3).getKey());
    }

    /**
     * testGetArrayIndexField04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() field:not null<br>
     *                {Arg:key="##INDEX", position=0;<br>
     *                 Arg:key="arg1", position=1;<br>
     *                 Arg:key="arg2", position=2;<br>
     *                 Arg:key="##INDEX", position=3}<br>
     *         () pos:0<br>
     *
     * <br>
     * ҒlF(߂l) Field:not null<br>
     *                  {Arg:key="1", position=0;<br>
     *                   Arg:key="arg1", position=1;<br>
     *                   Arg:key="arg2", position=2;<br>
     *                   Arg:key="1", position=3}<br>
     *
     * <br>
     * fieldɐݒ肳ꂽArgCX^Xkey̒l"##INDEX"łꍇA
     * key̒lpos̒l{PɂȂ邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetArrayIndexField04() throws Exception {

        // ͒l̐ݒ
        Field field = new Field();
        // argݒ
        Arg param0 = new Arg();
        param0.setKey("##INDEX");
        param0.setPosition(0);
        field.addArg(param0);

        Arg param1 = new Arg();
        param1.setKey("arg1");
        param1.setPosition(1);
        field.addArg(param1);

        Arg param2 = new Arg();
        param2.setKey("arg2");
        param2.setPosition(2);
        field.addArg(param2);

        Arg param3 = new Arg();
        param3.setKey("##INDEX");
        param3.setPosition(3);
        field.addArg(param3);

        // eXgs
        Field retField = FieldChecksEx.getArrayIndexField(field, 0);

        assertEquals("1", retField.getArg(0).getKey());
        assertEquals("arg1", retField.getArg(1).getKey());
        assertEquals("arg2", retField.getArg(2).getKey());
        assertEquals("1", retField.getArg(3).getKey());
    }

    /**
     * testValidateAlphaNumericString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *                field:var<br>
     *                name:"mask"<br>
     *                value="^[a-z]*$"<br>
     *                jsType="false"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () validateMask:true<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) field:varF<br>
     *                    name:"mask"<br>
     *                    value="^[a-z]*$"<br>
     *                    jsType="false"<br>
     *         (ԕω) errors:ԕωȂ<br>
     *
     * <br>
     * beannull̂ƂAtrueԋpA
     * errorsɃbZ[WǉȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateAlphaNumericString01() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setResource(false);
        field.addMsg(msg);
        field.addVar("mask", "^[a-z]*$", "false");
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        Validator validator = new Validator(new ValidatorResources());

        // eXgs
        boolean result =
            FieldChecksEx.validateAlphaNumericString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
        // field̏ԕωmF
        Var var = field.getVar("mask");
        assertNotNull(var);
        assertEquals("mask", var.getName());
        assertEquals("^[a-z]*$", var.getValue());
        assertEquals("false", var.getJsType());
    }

    /**
     * testValidateAlphaNumericString02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () validateMask:true<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) field:varF<br>
     *                    name="mask"<br>
     *                    nullł邱ƁB<br>
     *         (ԕω) errors:ԕωȂ<br>
     *
     * <br>
     * bean󕶎̂ƂAtrueԋpA
     * errorsɃbZ[WǉȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateAlphaNumericString02() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        Validator validator = new Validator(new ValidatorResources());

        // eXgs
        boolean result =
            FieldChecksEx.validateAlphaNumericString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
        // field̏ԕωmF
        Var var = field.getVar("mask");
        assertNull(var);
    }

    /**
     * testValidateAlphaNumericString03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"a0A"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () validateMask:true<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) field:varF<br>
     *                    name="mask"<br>
     *                    nullł邱ƁB<br>
     *         (ԕω) errors:ԕωȂ<br>
     *
     * <br>
     * beanpp݂̂ō\ĂꍇAtrueԋpA
     * errorsɃbZ[WǉȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateAlphaNumericString03() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "a0A";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[
        ActionMessages errors = new ActionMessages();

        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        Validator validator = new Validator(new ValidatorResources());

        // eXgs
        boolean result =
            FieldChecksEx.validateAlphaNumericString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertTrue(errors.isEmpty());
        // field̏ԕωmF
        Var var = field.getVar("mask");
        assertNull(var);
    }

    /**
     * testValidateAlphaNumericString04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:HashMap<br>
     *                ["field1"="Zg3%"]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                property="field1"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                ActionMessage("testMessage")<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () validateMask:false<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) field:varF<br>
     *                    name="mask"<br>
     *                    nullł邱ƁB<br>
     *         (ԕω) errors:ActionMessage("testMessage")<br>
     *                    ActionMessage("message")<br>
     *
     * <br>
     * beanString^ł͂ȂꍇA
     * field擾vpeB̒lɑ΂ă`FbNs邱ƂmFB
     * ̓`FbNG[ƂȂƂA
     * errorsɃbZ[Wǉ邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateAlphaNumericString04() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "Zg3%");

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field1");
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[iActionMessage1ݒj
        ActionMessages errors = new ActionMessages();
        ActionMessage error = new ActionMessage("testMessage");
        errors.add(Globals.ERROR_KEY, error);

        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        Validator validator = new Validator(new ValidatorResources());

        // eXgs
        boolean result =
            FieldChecksEx.validateAlphaNumericString(
                bean,
                va,
                field,
                errors,
                validator,
                request);

        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[ɃG[IuWFNg2o^Ă邱ƁB
        assertEquals(2, errors.size());
        // G[ɐݒ肳ꂽbZ[Wo^Ă邱ƁB
        // ActionMessage㏑ȂƁB
        Iterator it = errors.get();
        List<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            ActionMessage retError = (ActionMessage) it.next();
            list.add(retError.getKey());
        }
        assertTrue(list.contains("testMessage"));
        assertTrue(list.contains("message"));
        // field̏ԕωmF
        Var var = field.getVar("mask");
        assertNull(var);
    }

    /**
     * testGetByteLength01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() value:null<br>
     *
     * <br>
     * ҒlF(߂l) int:0<br>
     *
     * <br>
     * valuenull̂ƂA0擾ł邱ƂmFB<br>
     * ̑̃p^[validateByteLengthAvalidateByteRangeŕ܁B
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetByteLength01() throws Exception {
        int result = FieldChecksEx.getByteLength(null, "test");
        assertEquals(0, result);
    }

    /**
     * testGetByteLength02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() value:""<br>
     *
     * <br>
     * ҒlF(߂l) int:0<br>
     *
     * <br>
     * value󕶎̂ƂA0擾ł邱ƂmFB<br>
     * ̑̃p^[validateByteLengthAvalidateByteRangeŕ܁B
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetByteLength02() throws Exception {
        int result = FieldChecksEx.getByteLength("", "test");
        assertEquals(0, result);
    }

}
