/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.PropertyTestCase;

import org.apache.commons.validator.Field;
import org.apache.commons.validator.Msg;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.Var;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

/**
 * {@link jp.terasoluna.fw.web.struts.form.FieldChecksEx} NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Validatorǉ[NXB
 * <p>
 *
 * @see jp.terasoluna.fw.web.struts.form.FieldChecksEx
 */
public class FieldChecksExTest02 extends PropertyTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(FieldChecksExTest02.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
        LogUTUtil.flush();
        deleteProperty("validation.hankaku.kana.list");
        deleteProperty("validation.zenkaku.kana.list");
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public FieldChecksExTest02(String name) {
        super(name);
    }

    /**
     * testValidateCapAlphaNumericString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *                field:var<br>
     *                name:"mask"<br>
     *                value="^[a-z]*$"<br>
     *                jsType="false"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () validateMask:true<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) field:varF<br>
     *                    name:"mask"<br>
     *                    value="^[a-z]*$"<br>
     *                    jsType="false"<br>
     *         (ԕω) errors:ԕωȂ<br>
     *
     * <br>
     * beannull̂ƂAtrueԋpA
     * errorsɃbZ[WǉȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateCapAlphaNumericString01() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setResource(false);
        field.addMsg(msg);
        field.addVar("mask", "^[a-z]*$", "false");
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        Validator validator = new Validator(new ValidatorResources());

        // eXgs
        boolean result =
            FieldChecksEx.validateCapAlphaNumericString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
        // field̒g`FbN
        Var var = field.getVar("mask");
        assertNotNull(var);
        assertEquals("mask", var.getName());
        assertEquals("^[a-z]*$", var.getValue());
        assertEquals("false", var.getJsType());
    }

    /**
     * testValidateCapAlphaNumericString02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () validateMask:true<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) field:varF<br>
     *                    name="mask"<br>
     *                    nullł邱ƁB<br>
     *         (ԕω) errors:ԕωȂ<br>
     *
     * <br>
     * bean󕶎̂ƂAtrueԋpA
     * errorsɃbZ[WǉȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateCapAlphaNumericString02() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        Validator validator = new Validator(new ValidatorResources());

        // eXgs
        boolean result =
            FieldChecksEx.validateCapAlphaNumericString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
        // field̒g`FbN
        Var var = field.getVar("mask");
        assertNull(var);
    }

    /**
     * testValidateCapAlphaNumericString03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"ABC0"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () validateMask:true<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) field:varF<br>
     *                    name="mask"<br>
     *                    nullł邱ƁB<br>
     *         (ԕω) errors:ԕωȂ<br>
     *
     * <br>
     * bean啶̔pp݂̂ō\ĂꍇA
     * trueԋpAerrorsɃbZ[WǉȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateCapAlphaNumericString03() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "ABC0";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[
        ActionMessages errors = new ActionMessages();

        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        Validator validator = new Validator(new ValidatorResources());

        // eXgs
        boolean result =
            FieldChecksEx.validateCapAlphaNumericString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertTrue(errors.isEmpty());
        // field̒g`FbN
        Var var = field.getVar("mask");
        assertNull(var);
    }

    /**
     * testValidateCapAlphaNumericString04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:HashMap<br>
     *                ["field1"="Aa0"]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                property="field1"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                ActionMessage("testMessage")<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () validateMask:false<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) field:varF<br>
     *                    name="mask"<br>
     *                    nullł邱ƁB<br>
     *         (ԕω) errors:ActionMessage("testMessage")<br>
     *                    ActionMessage("message")<br>
     *
     * <br>
     * beanString^ł͂ȂꍇA
     * field擾vpeB̒lɑ΂ă`FbNs邱ƂmFB
     * ̓`FbNG[ƂȂƂAerrorsɃbZ[Wǉ邱Ƃ
     * mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateCapAlphaNumericString04() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "Aa0");

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field1");
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[iActionMessage1ݒj
        ActionMessages errors = new ActionMessages();
        ActionMessage error = new ActionMessage("testMessage");
        errors.add(Globals.ERROR_KEY, error);

        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        Validator validator = new Validator(new ValidatorResources());

        // eXgs
        boolean result =
            FieldChecksEx.validateCapAlphaNumericString(
                bean,
                va,
                field,
                errors,
                validator,
                request);

        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[ɃG[IuWFNg2o^Ă邱ƁB
        assertEquals(2, errors.size());
        // G[ɐݒ肳ꂽbZ[Wo^Ă邱ƁB
        // ActionMessage㏑ȂƁB
        Iterator it = errors.get();
        List<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            ActionMessage retError = (ActionMessage) it.next();
            list.add(retError.getKey());
        }
        assertTrue(list.contains("testMessage"));
        assertTrue(list.contains("message"));
        // field̒g`FbN
        Var var = field.getVar("mask");
        assertNull(var);
    }

    /**
     * testValidateHankakuKanaString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxF<br>
     *                    G[<br>
     *                    bZ[WF<br>
     *                    bean is null.<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beannull̂ƂA
     * G[Oo͂trueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuKanaString01() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        Validator validator = new Validator(new ValidatorResources());

        // eXgs
        boolean result =
            FieldChecksEx.validateHankakuKanaString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[OmF
        assertTrue(LogUTUtil.checkError("bean is null."));
    }

    /**
     * testValidateHankakuKanaString02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * bean󕶎̂ƂAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuKanaString02() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        Validator validator = new Validator(new ValidatorResources());

        // eXgs
        boolean result =
            FieldChecksEx.validateHankakuKanaString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateHankakuKanaString03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"ݶ"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beanpJî݂ō\ĂƂA
     * trueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuKanaString03() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "ݶ";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[
        ActionMessages errors = new ActionMessages();

        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        Validator validator = new Validator(new ValidatorResources());

        // eXgs
        boolean result =
            FieldChecksEx.validateHankakuKanaString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateHankakuKanaString04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"1a"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                ActionMessage("testMessage")<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("testMessage")<br>
     *                    ActionMessage("message")<br>
     *
     * <br>
     * beanɔpJiȊO̕񂪊܂܂ĂꍇA
     * G[bZ[WǉAfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuKanaString04() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "1a";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[iActionMessage1ݒj
        ActionMessages errors = new ActionMessages();
        ActionMessage error = new ActionMessage("testMessage");
        errors.add(Globals.ERROR_KEY, error);

        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        Validator validator = new Validator(new ValidatorResources());

        // eXgs
        boolean result =
            FieldChecksEx.validateHankakuKanaString(
                bean,
                va,
                field,
                errors,
                validator,
                request);

        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[ɃG[IuWFNg2o^Ă邱ƁB
        assertEquals(2, errors.size());
        // G[ɐݒ肳ꂽbZ[Wo^Ă邱ƁB
        // ActionMessage㏑ȂƁB
        Iterator it = errors.get();
        List<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            ActionMessage retError = (ActionMessage) it.next();
            list.add(retError.getKey());
        }
        assertTrue(list.contains("testMessage"));
        assertTrue(list.contains("message"));
    }

    /**
     * testValidateHankakuKanaString05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"ݶA"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * beanɔpJiȊO̕񂪊܂܂ĂꍇAG[bZ[WǉAfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuKanaString05() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "ݶA";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        Validator validator = new Validator(new ValidatorResources());

        // eXgs
        boolean result =
            FieldChecksEx.validateHankakuKanaString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[ɃG[IuWFNgo^Ă邱ƁB
        assertFalse(errors.isEmpty());
        // G[ɐݒ肳ꂽbZ[Wo^Ă邱ƁB
        Iterator it = errors.get();
        ActionMessage error = (ActionMessage) it.next();
        assertEquals("message", error.getKey());
        // G[1ł邱
        assertFalse(it.hasNext());
    }

    /**
     * testValidateHankakuKanaString06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map:["field1"=""]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                property="field1"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beanString^ł͂ȂꍇA
     * field擾ÕvpeBɑ΂ă`FbNsƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuKanaString06() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "");

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field1");
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        Validator validator = new Validator(new ValidatorResources());

        // eXgs
        boolean result =
            FieldChecksEx.validateHankakuKanaString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateHankakuKanaString07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map:["field1"="123"]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                property="field1"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * beanString^ł͂ȂꍇAfield擾ÕvpeB
     * ΂ă`FbNsƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuKanaString07() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "123");

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field1");
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        Validator validator = new Validator(new ValidatorResources());

        // eXgs
        boolean result =
            FieldChecksEx.validateHankakuKanaString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[ɃG[IuWFNgo^Ă邱ƁB
        assertFalse(errors.isEmpty());
        // G[ɐݒ肳ꂽbZ[Wo^Ă邱ƁB
        Iterator it = errors.get();
        ActionMessage error = (ActionMessage) it.next();
        assertEquals("message", error.getKey());
        // G[1ł邱
        assertFalse(it.hasNext());
    }

    /**
     * testValidateHankakuKanaString08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map:["field1"="123"]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                property="field2"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beanString^ł͂ȂAfield擾ÕvpeB݂ȂꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuKanaString08() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "123");

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field2");
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        Validator validator = new Validator(new ValidatorResources());

        // eXgs
        boolean result =
            FieldChecksEx.validateHankakuKanaString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateNumericString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *                field:var<br>
     *                name:"mask"<br>
     *                value="^[a-z]*$"<br>
     *                jsType="false"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () validateMask:true<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) field:varF<br>
     *                    name:"mask"<br>
     *                    value="^[a-z]*$"<br>
     *                    jsType="false"<br>
     *         (ԕω) errors:ԕωȂ<br>
     *
     * <br>
     * beannull̂ƂAtrueԋpA
     * errorsɃbZ[WǉȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumericString01() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        field.addVar("mask", "^[a-z]*$", "false");
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        Validator validator = new Validator(new ValidatorResources());

        // eXgs
        boolean result =
            FieldChecksEx.validateNumericString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
        // field̏ԕωmF
        Var var = field.getVar("mask");
        assertNotNull(var);
        assertEquals("mask", var.getName());
        assertEquals("^[a-z]*$", var.getValue());
        assertEquals("false", var.getJsType());
    }

    /**
     * testValidateNumericString02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () validateMask:true<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) field:varF<br>
     *                    name="mask"<br>
     *                    nullł邱ƁB<br>
     *         (ԕω) errors:ԕωȂ<br>
     *
     * <br>
     * bean󕶎̂ƂAtrueԋpA
     * errorsɃbZ[WǉȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumericString02() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        Validator validator = new Validator(new ValidatorResources());

        // eXgs
        boolean result =
            FieldChecksEx.validateNumericString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
        // field̏ԕωmF
        Var var = field.getVar("mask");
        assertNull(var);
    }

    /**
     * testValidateNumericString03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"9876"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () validateMask:true<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) field:varF<br>
     *                    name="mask"<br>
     *                    nullł邱ƁB<br>
     *         (ԕω) errors:ԕωȂ<br>
     *
     * <br>
     * bean݂̂ō\ĂꍇAtrueԋpA
     * errorsɃbZ[WǉȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumericString03() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "9876";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[
        ActionMessages errors = new ActionMessages();

        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        Validator validator = new Validator(new ValidatorResources());

        // eXgs
        boolean result =
            FieldChecksEx.validateNumericString(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertTrue(errors.isEmpty());
        // field̏ԕωmF
        Var var = field.getVar("mask");
        assertNull(var);
    }

    /**
     * testValidateNumericString04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:HashMap<br>
     *                ["field1"="Aa0"]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                property="field1"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                ActionMessage("testMessage")<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () validateMask:false<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) field:varF<br>
     *                    name="mask"<br>
     *                    nullł邱ƁB<br>
     *         (ԕω) errors:ActionMessage("testMessage")<br>
     *                    ActionMessage("message")<br>
     *
     * <br>
     * beanString^ł͂ȂꍇAfield擾vpeB̒lɑ΂
     * `FbNs邱ƂmFB
     * ̓`FbNG[ƂȂƂAerrorsɃbZ[Wǉ邱Ƃ
     * mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumericString04() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "Aa0");

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field1");
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);

        // G[iActionMessage1ݒj
        ActionMessages errors = new ActionMessages();
        ActionMessage error = new ActionMessage("testMessage");
        errors.add(Globals.ERROR_KEY, error);

        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        Validator validator = new Validator(new ValidatorResources());

        // eXgs
        boolean result =
            FieldChecksEx.validateNumericString(
                bean,
                va,
                field,
                errors,
                validator,
                request);

        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[ɃG[IuWFNg2o^Ă邱ƁB
        assertEquals(2, errors.size());
        // G[ɐݒ肳ꂽbZ[Wo^Ă邱ƁB
        // ActionMessage㏑ȂƁB
        Iterator it = errors.get();
        List<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            ActionMessage retError = (ActionMessage) it.next();
            list.add(retError.getKey());
        }
        assertTrue(list.contains("testMessage"));
        assertTrue(list.contains("message"));
        // field̏ԕωmF
        Var var = field.getVar("mask");
        assertNull(var);
    }

}
