/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.taglib;

import java.io.BufferedReader;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

import jp.terasoluna.utlib.TagUTUtil;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.utlib.exception.Exception_JspWriterImpl;
import jp.terasoluna.utlib.exception.Exception_PageContextImpl;
import junit.framework.TestCase;

import org.apache.struts.Globals;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.taglib.logic.IterateTag;

import com.mockrunner.mock.web.MockHttpServletRequest;

/**
 * SubmitTag ubN{bNXeXg<br>
 * O<br>
 * Ȃ<br>
 * <br>
 */
public class SubmitTagTest extends TestCase {

    //eXgΏ
    SubmitTag tag = null;

    /**
     * Constructor for SubmitTagTest.
     * @param arg0
     */
    public SubmitTagTest(String arg0) {
        super(arg0);
    }

    /*
     * @see TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        tag = (SubmitTag) TagUTUtil.create(SubmitTag.class);
    }

    /*
     * @see TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testDoEndTag01<br>
     *
     * (n)<br>
     * ϓ_FF<br>
     *
     * ͒l
     * value(label)=Null<br>
     * text="text"<br>
     * target=Not Null<br>
     * frameScript=Null<br>
     * accesskey=Not Null<br>
     * tabindex=Not Null<br>
     * onClick=Null<br>
     * property= Not Null<br>
     * indexed = false<br>
     *
     * Ғl
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     *
     * Tu~bg^Õ{^xɃX[p[NX́htexthgpA
     * ^[Qbg̎w菈sAX[p[NX́haccesskeyh
     * htabindexh̎wsAy[WɊ֘AtꂽC^
     * ޏꍇ̃eXgNX<br>
     * indexed=falsȅꍇAname̒lz^ŏo͂ȂƂ̊mF<br>
     */
    public void testDoEndTag01() throws Exception {

        //eXgf[^ݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "text", "text");
        UTUtil.setPrivateField(tag, "target", "target");
        UTUtil.setPrivateField(tag, "accesskey", "accesskey");
        UTUtil.setPrivateField(tag, "tabindex", "tabindex");
        UTUtil.setPrivateField(tag, "property", "submit");

        ActionMapping mapping = new ActionMapping();
        mapping.setName("MAPPING_TEST_FORM");
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();
        req.setAttribute(Globals.MAPPING_KEY, mapping);

        //eXgs
        int result = tag.doEndTag();

        //eXgʊmF
        assertEquals(Tag.EVAL_PAGE, result);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("", reader.readLine());
        assertEquals("<script type=\"text/javascript\">", reader.readLine());
        assertEquals("<!--", reader.readLine());
        assertEquals(
            "  function __setFrameTarget(__frTarget) {",
            reader.readLine());
        assertEquals(
            "    document.MAPPING_TEST_FORM.target = __frTarget;",
            reader.readLine());
        assertEquals("  }", reader.readLine());
        assertEquals("//-->", reader.readLine());
        assertEquals("</script>", reader.readLine());
        assertEquals("", reader.readLine());
        assertEquals(
            "<input type=\"submit\" name=\"submit\" "
                + "accesskey=\"accesskey\" "
                + "tabindex=\"tabindex\" value=\"text\" "
                + "onclick=\"__setFrameTarget('target');\"/>",
            reader.readLine());
        assertEquals("frameScript", (String) pc.getAttribute("frameScript"));

    } /* testDoEndTag01 End */

    /**
     * testDoEndTag02<br>
     *
     * (n)<br>
     * ϓ_FF<br>
     *
     * ͒l
     * value(label)="label"<br>
     * text=*<br>
     * target=Not Null<br>
     * frameScript=Not Null<br>
     * accesskey=Null<br>
     * tabindex=Null<br>
     * onClick=Not Null<br>
     * property= Not Null<br>
     * indexed=true<br>
     *
     * Ғl
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     * o͓e=
     * u<input type="submit" name="[property]" 
     * value="[label]" [EventHandlers] [onclick] />v<br>
     * onclickOŃZbglƓł邱ƁB<br>
     *
     * Tu~bg^Õ{^x͎w肳ꂽgpA
     * X[p[NXgetOnclick\bh擾lt^A
     * y[WɊ֘AtꂽC^ɏޏꍇ̃eXgNX<br>
     * indexed=truȅꍇAname̒lz^ŏo͂邱Ƃ̊mF<br>
     */
    public void testDoEndTag02() throws Exception {

        //eXgf[^ݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        UTUtil.setPrivateField(tag, "value", "label");
        UTUtil.setPrivateField(tag, "text", "text");
        UTUtil.setPrivateField(tag, "target", "target");
        pc.setAttribute("frameScript", "frameScript");
        UTUtil.setPrivateField(tag, "accesskey", null);
        UTUtil.setPrivateField(tag, "tabindex", null);
        tag.setOnclick("onclick");
        UTUtil.setPrivateField(tag, "property", "submit");
        tag.setIndexed(true);
        tag.setParent(new IterateTag());

        ActionMapping mapping = new ActionMapping();
        mapping.setName("MAPPING_TEST_FORM");
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();
        req.setAttribute(Globals.MAPPING_KEY, mapping);

        //eXgs
        int result = tag.doEndTag();

        //eXgʊmF
        assertEquals(Tag.EVAL_PAGE, result);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals(
            "<input type=\"submit\" name=\"submit[0]\" "
                + "value=\"label\" "
                + "onclick=\"__setFrameTarget('target');onclick\"/>",
            reader.readLine());
        assertEquals("onclick", UTUtil.getPrivateField(tag, "onclick"));

    } /* testDoEndTag02 End */

    /**
     * testDoEndTag03<br>
     *
     * (n)<br>
     * ϓ_FF<br>
     *
     * ͒l
     * value(label)=Null<br>
     * text=Null<br>
     * target=Null<br>
     * frameScript=Not Null<br>
     * accesskey=Null<br>
     * tabindex=Null<br>
     * onClick=*<br>
     * property= Not Null<br>
     * indexed=false<br>
     *
     * Ғl
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     * o͓e=u<input type="submit" name="[property]" 
     * accesskey="[accesskey]" tabindex="[tabindex]" 
     * value="[label]" [EventHandlers] [Styles] />v<br>
     *
     * Tu~bg^Õ{^x́A
     * w肪ȂߕhsubmithgpA
     * Tu~bg{^^O̕𐶐A
     * y[WɊ֘AtꂽC^ɏޏꍇ̃eXgNX<br>
     * indexed=falsȅꍇAname̒lz^ŏo͂ȂƂ̊mF<br>
     */
    public void testDoEndTag03() throws Exception {

        //eXgf[^ݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "text", null);
        UTUtil.setPrivateField(tag, "target", null);
        pc.setAttribute("frameScript", "frameScript");
        UTUtil.setPrivateField(tag, "accesskey", null);
        UTUtil.setPrivateField(tag, "tabindex", null);
        UTUtil.setPrivateField(tag, "property", "submit");

        ActionMapping mapping = new ActionMapping();
        mapping.setName("MAPPING_TEST_FORM");
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();
        req.setAttribute(Globals.MAPPING_KEY, mapping);

        //eXgs
        int result = tag.doEndTag();

        //eXgʊmF
        assertEquals(Tag.EVAL_PAGE, result);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals(
            "<input type=\"submit\" name=\"submit\" " + "value=\"Submit\"/>",
            reader.readLine());

    } /* testDoEndTag03 End */

    /**
     * testDoEndTag04<br>
     *
     * (n)<br>
     * ϓ_FF<br>
     *
     * ͒l
     * value(label)=Null<br>
     * text=""<br>
     * target=Null<br>
     * frameScript=Not Null<br>
     * accesskey=Null<br>
     * tabindex=Null<br>
     * onClick=*<br>
     * property= Not Null<br>
     * indexed=true<br>
     *
     * Ғl
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     * o͓e=u<input type="submit" 
     * name="[property]" accesskey="[accesskey]" 
     * tabindex="[tabindex]" value="[label]" 
     * [EventHandlers] [Styles] />v<br>
     *
     * w肳ꂽTu~bg^Õ{^x󔒕̂߁A
     * xɂ͕hsubmithgpA
     * Tu~bg{^^O̕𐶐A
     * y[WɊ֘AtꂽC^ɏޏꍇ̃eXgNX<br>
     * indexed=truȅꍇAname̒lz^ŏo͂邱Ƃ̊mF<br>
     */
    public void testDoEndTag04() throws Exception {

        //eXgf[^ݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "text", "");
        UTUtil.setPrivateField(tag, "target", null);
        pc.setAttribute("frameScript", "frameScript");
        UTUtil.setPrivateField(tag, "accesskey", null);
        UTUtil.setPrivateField(tag, "tabindex", null);
        UTUtil.setPrivateField(tag, "property", "submit");
        tag.setIndexed(true);
        tag.setParent(new IterateTag());

        ActionMapping mapping = new ActionMapping();
        mapping.setName("MAPPING_TEST_FORM");
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();
        req.setAttribute(Globals.MAPPING_KEY, mapping);

        //eXgs
        int result = tag.doEndTag();

        //eXgʊmF
        assertEquals(Tag.EVAL_PAGE, result);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals(
            "<input type=\"submit\" name=\"submit[0]\" " + "value=\"Submit\"/>",
            reader.readLine());

    } /* testDoEndTag04 End */

    /**
     * testDoEndTag05<br>
     *
     * (n)<br>
     * ϓ_FF<br>
     *
     * ͒l
     * value(label)=""<br>
     * text=*<br>
     * target=Null<br>
     * frameScript=Not Null<br>
     * accesskey=Null<br>
     * tabindex=Null<br>
     * onClick=*<br>
     * property= Not Null<br>
     * indexed=false<br>
     *
     * Ғl
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     * o͓e=u<input type="submit" name="[property]" 
     * accesskey="[accesskey]" tabindex="[tabindex]" 
     * value="[label]" [EventHandlers] [Styles] />v<br>
     *
     * w肳ꂽTu~bg^Õ{^x󔒕̂߁A
     * xɂ͕hsubmithgpA
     * Tu~bg{^^O̕𐶐A
     * y[WɊ֘AtꂽC^ɏޏꍇ̃eXgNX<br>
     * indexed=falsȅꍇAname̒lz^ŏo͂ȂƂ̊mF<br>
     */
    public void testDoEndTag05() throws Exception {

        //eXgf[^ݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        UTUtil.setPrivateField(tag, "value", "");
        UTUtil.setPrivateField(tag, "text", "CLICK!!");
        UTUtil.setPrivateField(tag, "target", null);
        pc.setAttribute("frameScript", "frameScript");
        UTUtil.setPrivateField(tag, "accesskey", null);
        UTUtil.setPrivateField(tag, "tabindex", null);
        UTUtil.setPrivateField(tag, "property", "submit");

        ActionMapping mapping = new ActionMapping();
        mapping.setName("MAPPING_TEST_FORM");
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();
        req.setAttribute(Globals.MAPPING_KEY, mapping);

        //eXgs
        int result = tag.doEndTag();

        //eXgʊmF
        assertEquals(Tag.EVAL_PAGE, result);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals(
            "<input type=\"submit\" name=\"submit\" " + "value=\"Submit\"/>",
            reader.readLine());

    } /* testDoEndTag05 End */

    /**
     * testDoEndTag06<br>
     *
     * (ُn)<br>
     * ϓ_FG<br>
     *
     * ͒l
     * value(label)=Null<br>
     * text=Null<br>
     * target=Not Null<br>
     * frameScript=*<br>
     * accesskey=*<br>
     * tabindex=*<br>
     * onClick=Null<br>
     * property= Not Null<br>
     *
     * Ғl
     * ߂l:int=NullPointerException<br>
     * o͓e=-<br>
     *
     * y[WReLXghframeScripth擾
     * NullPointerExceptionꍇ̃eXgP[X<br>
     */
    public void testDoEndTag06() throws Exception {

        //eXgf[^ݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "text", null);
        UTUtil.setPrivateField(tag, "target", "target");
        UTUtil.setPrivateField(tag, "accesskey", null);
        UTUtil.setPrivateField(tag, "tabindex", null);
        UTUtil.setPrivateField(tag, "property", "submit");

        ActionMapping mapping = new ActionMapping();
        mapping.setName("MAPPING_TEST_FORM");
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();
        req.setAttribute(Globals.MAPPING_KEY, mapping);

        Exception_PageContextImpl pc2 =
            new Exception_PageContextImpl(
                pc.getServletConfig(),
                pc.getRequest(),
                pc.getResponse());
        pc2.setNullPointerEx();
        //pc2.setIllegalArgumentEx();
        pc2.setTiming(1);
        tag.setPageContext(pc2);

        //eXgs
        try {
            tag.doEndTag();
            fail();
        } catch (NullPointerException ex) {
            //eXgʊmF
            assertEquals(NullPointerException.class.getName(), ex.getClass()
                    .getName());
            return;
        }
    } /* testDoEndTag06 End */

    /**
     * testDoEndTag07<br>
     *
     * (ُn)<br>
     * ϓ_FG<br>
     *
     * ͒l
     * value(label)=Null<br>
     * text=Null<br>
     * target=Not Null<br>
     * frameScript=*<br>
     * accesskey=*<br>
     * tabindex=*<br>
     * onClick=Null<br>
     * property= Not Null<br>
     *
     * Ғl
     * ߂l:int=IllegalArgumentException<br>
     * o͓e=-<br>
     *
     * y[WReLXghframeScripth擾
     * IllegalArgumentExceptionꍇ̃eXgP[X<br>
     */
    public void testDoEndTag07() throws Exception {

        //eXgf[^ݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "text", null);
        UTUtil.setPrivateField(tag, "target", "target");
        UTUtil.setPrivateField(tag, "accesskey", null);
        UTUtil.setPrivateField(tag, "tabindex", null);
        UTUtil.setPrivateField(tag, "property", "submit");

        ActionMapping mapping = new ActionMapping();
        mapping.setName("MAPPING_TEST_FORM");
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();
        req.setAttribute(Globals.MAPPING_KEY, mapping);

        Exception_PageContextImpl pc2 =
            new Exception_PageContextImpl(
                pc.getServletConfig(),
                pc.getRequest(),
                pc.getResponse());
        //pc2.setNullPointerEx();
        pc2.setIllegalArgumentEx();
        pc2.setTiming(1);
        tag.setPageContext(pc2);

        //eXgs
        try {
            tag.doEndTag();
            fail();
        } catch (IllegalArgumentException ex) {

            //eXgʊmF
            assertEquals(IllegalArgumentException.class.getName(), ex
                    .getClass().getName());
            return;
        }
    } /* testDoEndTag07 End */

    /**
     * testDoEndTag08<br>
     *
     * (ُn)<br>
     * ϓ_FG<br>
     *
     * ͒l
     * value(label)=Null<br>
     * text="text"<br>
     * target=Not Null<br>
     * frameScript=Null<br>
     * accesskey=Not Null<br>
     * tabindex=Not Null<br>
     * onClick=Null<br>
     * property= Not Null<br>
     *
     * Ғl
     * ߂l:int=NullPointerException<br>
     * o͓e=-<br>
     *
     * y[WReLXgցhframeScripth̃Zbg
     * NullPointerExceptionꍇ̃eXgP[X<br>
     */
    public void testDoEndTag08() throws Exception {

        //eXgf[^ݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "text", null);
        UTUtil.setPrivateField(tag, "target", "target");
        UTUtil.setPrivateField(tag, "accesskey", null);
        UTUtil.setPrivateField(tag, "tabindex", null);
        UTUtil.setPrivateField(tag, "property", "submit");

        ActionMapping mapping = new ActionMapping();
        mapping.setName("MAPPING_TEST_FORM");
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();
        req.setAttribute(Globals.MAPPING_KEY, mapping);

        Exception_PageContextImpl pc2 =
            new Exception_PageContextImpl(
                pc.getServletConfig(),
                pc.getRequest(),
                pc.getResponse());
        pc2.setNullPointerEx();
        pc2.setTiming(2);
        tag.setPageContext(pc2);

        //eXgs
        try {
            tag.doEndTag();
            fail();
        } catch (NullPointerException ex) {

            //eXgʊmF
            assertEquals(NullPointerException.class.getName(), ex.getClass()
                    .getName());
            return;
        }
    } /* testDoEndTag08 End */

    /**
     * testDoEndTag09<br>
     *
     * (ُn)<br>
     * ϓ_FG<br>
     *
     * ͒l
     * value(label)=Null<br>
     * text="text"<br>
     * target=Not Null<br>
     * frameScript=Null<br>
     * accesskey=Not Null<br>
     * tabindex=Not Null<br>
     * onClick=Null<br>
     * property= Not Null<br>
     *
     * Ғl
     * ߂l:int=IllegalArgumentException<br>
     * o͓e=-<br>
     *
     * y[WReLXgցhframeScripth̃Zbg
     * IllegalArgumentExceptionꍇ̃eXgP[X<br>
     */
    public void testDoEndTag09() throws Exception {

        //eXgf[^ݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "text", null);
        UTUtil.setPrivateField(tag, "target", "target");
        UTUtil.setPrivateField(tag, "accesskey", null);
        UTUtil.setPrivateField(tag, "tabindex", null);
        UTUtil.setPrivateField(tag, "property", "submit");

        ActionMapping mapping = new ActionMapping();
        mapping.setName("MAPPING_TEST_FORM");
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();
        req.setAttribute(Globals.MAPPING_KEY, mapping);

        Exception_PageContextImpl pc2 =
            new Exception_PageContextImpl(
                pc.getServletConfig(),
                pc.getRequest(),
                pc.getResponse());
        pc2.setIllegalArgumentEx();
        pc2.setTiming(2);
        tag.setPageContext(pc2);

        //eXgs
        try {
            tag.doEndTag();
            fail();
        } catch (IllegalArgumentException ex) {

            //eXgʊmF
            assertEquals(IllegalArgumentException.class.getName(), ex
                    .getClass().getName());
            return;
        }
    } /* testDoEndTag09 End */

    /**
     * testDoEndTag10<br>
     *
     * (ُn)<br>
     * ϓ_FG<br>
     *
     * ͒l
     * value(label)=Null<br>
     * text=Null<br>
     * target=Null<br>
     * frameScript=*<br>
     * accesskey=Null<br>
     * tabindex=Null<br>
     * onClick=Null<br>
     * property= Not Null<br>
     *
     * Ғl
     * ߂l:int=JapException<br>
     * o͓e=-<br>
     *
     * C^ɏނƂExceptionꍇ̃eXgP[X<br>
     */
    public void testDoEndTag10() throws Exception {

        //eXgf[^ݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "text", null);
        UTUtil.setPrivateField(tag, "target", null);
        UTUtil.setPrivateField(tag, "accesskey", null);
        UTUtil.setPrivateField(tag, "tabindex", null);
        UTUtil.setPrivateField(tag, "property", "submit");

        ActionMapping mapping = new ActionMapping();
        mapping.setName("MAPPING_TEST_FORM");
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();
        req.setAttribute(Globals.MAPPING_KEY, mapping);

        Exception_JspWriterImpl out = new Exception_JspWriterImpl();
        out.setTrue();
        out.setTiming(1);
        UTUtil.setPrivateField(pc, "jspWriter", out);

        //eXgs
        try {
            tag.doEndTag();
            fail();
        } catch (JspException ex) {

            //eXgʊmF
            assertEquals(JspException.class.getName(), ex.getClass().getName());
            assertEquals("o̓G[: java.io.IOException", ex.getMessage());
            return;
        }
    } /* testDoEndTag10 End */

    /**
     * testDoEndTag11<br>
     *
     * (n)<br>
     * ϓ_FF<br>
     *
     * ͒l
     * value(label)=Null<br>
     * text="text"<br>
     * target=Not Null<br>
     * frameScript=Null<br>
     * accesskey=Not Null<br>
     * tabindex=Not Null<br>
     * onClick=Null<br>
     * property= Null<br>
     *
     * Ғl
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     *
     * Tu~bg^Õ{^xɃX[p[NX́htexthgpA
     * ^[Qbg̎w菈sAX[p[NX́haccesskeyh
     * htabindexh̎wsAy[WɊ֘AtꂽC^
     * ޏꍇ̃eXgNX<br>
     * property= Null̏ꍇ propertyo͂ȂB<br>
     */
    public void testDoEndTag11() throws Exception {

        //eXgf[^ݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "text", "text");
        UTUtil.setPrivateField(tag, "target", "target");
        UTUtil.setPrivateField(tag, "accesskey", "accesskey");
        UTUtil.setPrivateField(tag, "tabindex", "tabindex");
        UTUtil.setPrivateField(tag, "property", null);

        ActionMapping mapping = new ActionMapping();
        mapping.setName("MAPPING_TEST_FORM");
        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();
        req.setAttribute(Globals.MAPPING_KEY, mapping);

        //eXgs
        int result = tag.doEndTag();

        //eXgʊmF
        assertEquals(Tag.EVAL_PAGE, result);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("", reader.readLine());
        assertEquals("<script type=\"text/javascript\">", reader.readLine());
        assertEquals("<!--", reader.readLine());
        assertEquals(
            "  function __setFrameTarget(__frTarget) {",
            reader.readLine());
        assertEquals(
            "    document.MAPPING_TEST_FORM.target = __frTarget;",
            reader.readLine());
        assertEquals("  }", reader.readLine());
        assertEquals("//-->", reader.readLine());
        assertEquals("</script>", reader.readLine());
        assertEquals("", reader.readLine());
        assertEquals(
            "<input type=\"submit\" "
                + "accesskey=\"accesskey\" "
                + "tabindex=\"tabindex\" value=\"text\" "
                + "onclick=\"__setFrameTarget('target');\"/>",
            reader.readLine());
        assertEquals("frameScript", (String) pc.getAttribute("frameScript"));
        //property"name="o͂ȂB
        reader = TagUTUtil.getOutputReader(tag);
        assertEquals(-1, reader.readLine().indexOf("name="));

    } /* testDoEndTag11 End */

    /**
     * testDoEndTag12<br>
     *
     * (n)<br>
     * ϓ_FF<br>
     *
     * ͒l
     * value(label)="label"<br>
     * text="text"<br>
     * target=Not Null<br>
     * frameScript=Not Null<br>
     * accesskey=Null<br>
     * tabindex=Null<br>
     * onClick=__setFrameTarget('target');hoge();<br>
     * property= Not Null<br>
     * indexed=true<br>
     *
     * Ғl
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     * o͓e=
     * u<input type="submit" name="[property(z^)]"
     * value="[label]" [EventHandlers]/>v<br>
     *
     * Tu~bg^Õ{^x͎w肳ꂽgpA
     * X[p[NXgetOnclick\bh擾l
     * "__setFrameTarget"܂܂Ăꍇ͐VKonClick𐶐
     * Ay[WɊ֘AtꂽC^ɏޏꍇ̃eXgNX<br>
     * indexed=truȅꍇAname̒lz^ŏo͂邱Ƃ̊mF<br>
     */
//    public void testDoEndTag12() throws Exception {
//
//        //eXgf[^ݒ
//        PageContext pc = TagUTUtil.getPageContext(tag);
//        UTUtil.setPrivateField(tag, "value", "label");
//        UTUtil.setPrivateField(tag, "text", "text");
//        UTUtil.setPrivateField(tag, "target", "target");
//        pc.setAttribute("frameScript", "frameScript");
//        UTUtil.setPrivateField(tag, "accesskey", null);
//        UTUtil.setPrivateField(tag, "tabindex", null);
//        tag.setOnclick("__setFrameTarget('target');hoge();");
//        UTUtil.setPrivateField(tag, "property", "submit");
//        tag.setIndexed(true);
//        tag.setParent(new IterateTag());
//
//        ActionMapping mapping = new ActionMapping();
//        mapping.setName("MAPPING_TEST_FORM");
//        MockHttpServletRequest req = (MockHttpServletRequest) pc.getRequest();
//        req.setAttribute(Globals.MAPPING_KEY, mapping);
//
//        //eXgs
//        int result = tag.doEndTag();
//
//        //eXgʊmF
//        assertEquals(Tag.EVAL_PAGE, result);
//        BufferedReader reader = TagUTUtil.getOutputReader(tag);
//        assertEquals(
//            "<input type=\"submit\" name=\"submit[0]\" "
//                + "value=\"label\" "
//                + "onclick=\"__setFrameTarget('target');hoge();\"/>",
//            reader.readLine());
//
//    } /* testDoEndTag12 End */
    
    /**
     * testRelease01<br>
     *
     * (n)<br>
     * ϓ_FC<br>
     *
     * ͒l
     * target=*<br>
     *
     * Ғl
     * ߂l:void<br>
     * target=Null<br>
     *
     * OƂĐݒ肵elA
     * sɊel邱ƂmF<br>
     */
    public void testRelease01() throws Exception {

        //eXgf[^ݒ
        UTUtil.setPrivateField(tag, "target", "Jesus!!");

        //eXgs
        tag.release();

        //eXgʊmF
        assertNull(UTUtil.getPrivateField(tag, "target"));

    } /* testRelease01 End */

    /**
     * testSetTarget01<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒l
     * target="("target");"<br>
     *
     * Ғl
     * ߂l:void<br>
     * target="("target");"<br>
     *
     * ZbglmFeXgP[X<br>
     */
    public void testSetTarget01() throws Exception {
        //eXgs
        tag.setTarget("target");

        //eXgʊmF
        assertEquals("target", UTUtil.getPrivateField(tag, "target"));

    } /* testSetTarget01 End */

    /**
     * testGetTarget01<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒l
     * target="("target");"<br>
     *
     * Ғl
     * ߂l:String="("target");"<br>
     *
     * QbglmFeXgP[X<br>
     */
    public void testGetTarget01() throws Exception {
        //eXgݒ
        String value = "target";
        UTUtil.setPrivateField(tag, "target", value);

        //eXgs
        String result = tag.getTarget();

        //eXgʊmF
        assertEquals(value, result);

    } /* testGetTarget01 End */

} /* SubmitTagTest Class End */
