/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import java.io.BufferedReader;
import java.math.BigDecimal;

import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.TagUTUtil;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.utlib.exception.Exception_PageContextImpl;
import junit.framework.TestCase;

/**
 * DecimalTag ubN{bNXeXgB<br>
 * 
 */
public class DecimalTagTest extends TestCase {

    //eXgΏۃNX
    DecimalTag tag = null;

    /**
     * Constructor for IterateRowSetTeiTest.
     * @param arg0
     */
    public DecimalTagTest(String arg0) {
        super(arg0);
    }

    /**
     * @see TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        tag = (DecimalTag) TagUTUtil.create(DecimalTag.class);
    }

    /*
     * @see TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testGetId01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * value="id"<br>
     * 
     * Ғl
     * ߂l:String="id"<br>
     * 
     * "id"擾o邱ƂmFB<br>
     */
    public void testGetId01() throws Exception {
        //eXgf[^ݒ
        String value = "id";
        UTUtil.setPrivateField(tag, "id", value);

        //eXgs
        String result = tag.getId();

        //eXgʊmF
        assertEquals(value, result);

    }

    /**
     * testSetId01()B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lF
     *   F"id"
     * 
     * ҒlFɂĐݒ肵l
     *
     * Őݒ肵lݒ肳Ă邱ƂmFB
     *
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testSetId01() throws Exception {
        //eXgf[^ݒ
        String value = "id";

        //eXgs
        tag.setId(value);

        //ʊmF
        String result = (String) UTUtil.getPrivateField(tag, "id");
        assertEquals(value, result);
    }

    /**
     * testGetFilter01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * value=false<br>
     * 
     * Ғl
     * ߂l:boolean=false<br>
     * 
     * <code>false</code> Ԃ邱ƂmFB<br>
     */
    public void testGetFilter01() throws Exception {
        //eXgf[^ݒ
        Boolean value = new Boolean(false);
        UTUtil.setPrivateField(tag, "filter", value);

        //eXgs
        boolean result = tag.getFilter();

        //eXgʊmF
        assertFalse(result);

    }

    /**
     * testSetFilter01()B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lF
     *   Ffalse
     * 
     * ҒlFɂĐݒ肵l
     *
     * Őݒ肵lݒ肳Ă邱ƂmFB
     *
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testSetFilter01() throws Exception {
        //eXgf[^ݒ
        boolean value = false;

        //eXgs
        tag.setFilter(value);

        //ʊmF
        Boolean result = (Boolean) UTUtil.getPrivateField(tag, "filter");
        assertFalse(result.booleanValue());
    }

    /**
     * testGetIgnore01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * value=true<br>
     * 
     * Ғl
     * ߂l:boolean=true<br>
     * 
     * <code>true</code> Ԃ邱ƂmFB<br>
     */
    public void testGetIgnore01() throws Exception {
        //eXgf[^ݒ
        Boolean value = new Boolean(true);
        UTUtil.setPrivateField(tag, "ignore", value);

        //eXgs
        boolean result = tag.getIgnore();

        //eXgʊmF
        assertTrue(result);

    }

    /**
     * testSetIgnore01()B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lF
     *   Ftrue
     * 
     * ҒlFɂĐݒ肵l
     *
     * Őݒ肵lݒ肳Ă邱ƂmFB
     *
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testSetIgnore01() throws Exception {
        //eXgf[^ݒ
        boolean value = true;

        //eXgs
        tag.setIgnore(value);

        //ʊmF
        Boolean result = (Boolean) UTUtil.getPrivateField(tag, "ignore");
        assertTrue(result.booleanValue());
    }

    /**
     * testGetName01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * value="name"<br>
     * 
     * Ғl
     * ߂l:String="name"<br>
     * 
     * "name"擾o邱ƂmFB<br>
     */
    public void testGetName01() throws Exception {
        //eXgf[^ݒ
        String value = "name";
        UTUtil.setPrivateField(tag, "name", value);

        //eXgs
        String result = tag.getName();

        //eXgʊmF
        assertEquals(value, result);

    }

    /**
     * testSetName01()B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lF
     *   F"name"
     * 
     * ҒlFɂĐݒ肵l
     *
     * Őݒ肵lݒ肳Ă邱ƂmFB
     *
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testSetName01() throws Exception {
        //eXgf[^ݒ
        String value = "name";

        //eXgs
        tag.setName(value);

        //ʊmF
        String result = (String) UTUtil.getPrivateField(tag, "name");
        assertEquals(value, result);
    }

    /**
     * testGetProperty01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * value="property"<br>
     * 
     * Ғl
     * ߂l:String="property"<br>
     * 
     * "property"擾o邱ƂmFB<br>
     */
    public void testGetProperty01() throws Exception {
        //eXgf[^ݒ
        String value = "property";
        UTUtil.setPrivateField(tag, "property", value);

        //eXgs
        String result = tag.getProperty();

        //eXgʊmF
        assertEquals(value, result);

    }

    /**
     * testSetProperty01()B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lF
     *   F"property"
     * 
     * ҒlFɂĐݒ肵l
     *
     * Őݒ肵lݒ肳Ă邱ƂmFB
     *
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testSetProperty01() throws Exception {
        //eXgf[^ݒ
        String value = "property";

        //eXgs
        tag.setProperty(value);

        //ʊmF
        String result = (String) UTUtil.getPrivateField(tag, "property");
        assertEquals(value, result);
    }

    /**
     * testGetScope01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * value="scope"<br>
     * 
     * Ғl
     * ߂l:String="scope"<br>
     * 
     * "scope"擾o邱ƂmFB<br>
     */
    public void testGetScope01() throws Exception {
        //eXgf[^ݒ
        String value = "scope";
        UTUtil.setPrivateField(tag, "scope", value);

        //eXgs
        String result = tag.getScope();

        //eXgʊmF
        assertEquals(value, result);

    }

    /**
     * testSetScope01()B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lF
     *   F"scope"
     * 
     * ҒlFɂĐݒ肵l
     *
     * Őݒ肵lݒ肳Ă邱ƂmFB
     *
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testSetScope01() throws Exception {
        //eXgf[^ݒ
        String value = "scope";

        //eXgs
        tag.setScope(value);

        //ʊmF
        String result = (String) UTUtil.getPrivateField(tag, "scope");
        assertEquals(value, result);
    }

    /**
     * testGetPattern01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * value="pattern"<br>
     * 
     * Ғl
     * ߂l:String="pattern"<br>
     * 
     * "pattern"擾o邱ƂmFB<br>
     */
    public void testGetPattern01() throws Exception {
        //eXgf[^ݒ
        String value = "pattern";
        UTUtil.setPrivateField(tag, "pattern", value);

        //eXgs
        String result = tag.getPattern();

        //eXgʊmF
        assertEquals(value, result);

    }

    /**
     * testSetPattern01()B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lF
     *   F"pattern"
     * 
     * ҒlFɂĐݒ肵l
     *
     * Őݒ肵lݒ肳Ă邱ƂmFB
     *
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testSetPattern01() throws Exception {
        //eXgf[^ݒ
        String value = "pattern";

        //eXgs
        tag.setPattern(value);

        //ʊmF
        String result = (String) UTUtil.getPrivateField(tag, "pattern");
        assertEquals(value, result);
    }

    /**
     * testGetValue01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * value="value"<br>
     * 
     * Ғl
     * ߂l:String="value"<br>
     * 
     * "value"擾o邱ƂmFB<br>
     */
    public void testGetValue01() throws Exception {
        //eXgf[^ݒ
        String value = "value";
        UTUtil.setPrivateField(tag, "value", value);

        //eXgs
        String result = tag.getValue();

        //eXgʊmF
        assertEquals(value, result);

    }

    /**
     * testSetValueString01()B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lF
     *   F"value"
     * 
     * ҒlFɂĐݒ肵l
     *
     * Őݒ肵lݒ肳Ă邱ƂmFB
     *
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testSetValueString01() throws Exception {
        //eXgf[^ݒ
        String value = "value";

        //eXgs
        tag.setValue(value);

        //ʊmF
        String result = (String) UTUtil.getPrivateField(tag, "value");
        assertEquals(value, result);
    }

    /**
     * testGetScale01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * value=1<br>
     * 
     * Ғl
     * ߂l:int=1<br>
     * 
     * 1擾o邱ƂmFB<br>
     */
    public void testGetScale01() throws Exception {
        //eXgf[^ݒ
        Integer value = new Integer(1);
        UTUtil.setPrivateField(tag, "scale", value);

        //eXgs
        int result = tag.getScale();

        //eXgʊmF
        assertEquals(value.intValue(), result);

    }

    /**
     * testSetScale01()B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lF
     *   F1
     * 
     * ҒlFɂĐݒ肵l
     *
     * Őݒ肵lݒ肳Ă邱ƂmFB
     *
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testSetScale01() throws Exception {
        //eXgf[^ݒ
        int value = 1;

        //eXgs
        tag.setScale(value);

        //ʊmF
        Integer result = (Integer) UTUtil.getPrivateField(tag, "scale");
        assertEquals(value, result.intValue());
    }

    /**
     * testGetRound01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * value="ROUND_HALF_UP"<br>
     * 
     * Ғl
     * ߂l:"ROUND_HALF_UP"<br>
     * 
     * "ROUND_HALF_UP"擾o邱ƂmFB<br>
     */
    public void testGetRound01() throws Exception {
        //eXgf[^ݒ
        String value = "ROUND_HALF_UP";
        UTUtil.setPrivateField(tag, "round", value);

        //eXgs
        String result = tag.getRound();

        //eXgʊmF
        assertEquals(value, result);

    }

    /**
     * testSetRound01()B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lF
     *   F"ROUND_HALF_UP"
     * 
     * ҒlFɂĐݒ肵l
     *
     * Őݒ肵lݒ肳Ă邱ƂmFB
     *
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testSetRound01() throws Exception {
        //eXgf[^ݒ
        String value = "ROUND_HALF_UP";

        //eXgs
        tag.setRound(value);

        //ʊmF
        String result = (String) UTUtil.getPrivateField(tag, "round");
        assertEquals(value, result);
    }

    /**
     * testDoStartTag01B<br>
     * 
     * (n)<br>
     * ϓ_FAAF<br>
     * 
     * ͒l
     * value=null<br>
     * ignore=true<br>
     * RequestUtils.lookup(pageContext, name, scope)=null<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * 
     * tH[}bgΏۂ̒l(value)nullAbeen݂͑ȂꍇA
     * SKIP_BODYԂ邱ƂmFB<br>
     */
    public void testDoStartTag01() throws Exception {
        //eXgf[^ݒ
        // PageContext
        PageContext pc = TagUTUtil.getPageContext(tag);
        String name = "aa";
        pc.setAttribute(name, null);
        // NXϐݒ
        String value = null;
        UTUtil.setPrivateField(tag, "value", value);
        Boolean ignore = new Boolean(true);
        UTUtil.setPrivateField(tag, "ignore", ignore);
        UTUtil.setPrivateField(tag, "name", name);

        //eXgs
        int result = tag.doStartTag();

        //eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);

    }

    /**
     * testDoStartTag02B<br>
     * 
     * (n)<br>
     * ϓ_FAAF<br>
     * 
     * ͒l
     * value=null<br>
     * ignore=false<br>
     * RequestUtils.lookup(pageContext, name, property, scope)=not null
     * [Stringi"1.1 "j]<br>
     * scale=0<br>
     * id=not null<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * pageContext=1<br>
     * 
     * tH[}bgΏۂ̒l(value)nullAbeen݂͑A
     * vvpeB̒l݂ꍇA
     * SKIP_BODYԂ邱ƂmFB<br>
     */
    public void testDoStartTag02() throws Exception {
        //eXgf[^ݒ
        // DecimalTag_BeanStub01CX^X̐
        DecimalTag_BeanStub01 bean = new DecimalTag_BeanStub01();
        bean.setField1("1.1 ");

        // PageContext
        PageContext pc = TagUTUtil.getPageContext(tag);
        String name = "aa";
        pc.setAttribute(name, bean);
        // NXϐݒ
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", name);
        UTUtil.setPrivateField(tag, "pattern", "##.##");
        UTUtil.setPrivateField(tag, "id", "id1");
        UTUtil.setPrivateField(tag, "scale", new Integer(0));

        String property = "field1";
        UTUtil.setPrivateField(tag, "property", property);

        //eXgs
        int result = tag.doStartTag();

        //eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);
        // PageControlInfo
        String id = (String) pc.getAttribute("id1");
        assertEquals("1", id);

    }

    /**
     * testDoStartTag03B<br>
     * 
     * (n)<br>
     * ϓ_FAAF<br>
     * 
     * ͒l
     * value=null<br>
     * ignore=true<br>
     * RequestUtils.lookup(pageContext, name, scope)=not null<br>
     * RequestUtils.lookup(pageContext, name, property, scope)=null<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * 
     * tH[}bgΏۂ̒l(value)nullAbeen݂͑A
     * vvpeB̒l݂ȂꍇA
     * SKIP_BODYԂ邱ƂmFB<br>
     */
    public void testDoStartTag03() throws Exception {
        //eXgf[^ݒ
        //DecimalTag_BeanStub01CX^X̐
        DecimalTag_BeanStub01 bean = new DecimalTag_BeanStub01();
        bean.setField1(null);

        // PageContext
        PageContext pc = TagUTUtil.getPageContext(tag);
        String name = "aa";
        pc.setAttribute(name, bean);
        // NXϐݒ
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "ignore", new Boolean(true));
        UTUtil.setPrivateField(tag, "name", name);
        String property = "field1";
        UTUtil.setPrivateField(tag, "property", property);

        //eXgs
        int result = tag.doStartTag();

        //eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);

    }

    /**
     * testDoStartTag04B<br>
     * 
     * (n)<br>
     * ϓ_FAAF<br>
     * 
     * ͒l
     * value=not null[Stringi"1.15"j]<br>
     * RequestUtils.lookup(pageContext, name, scope)=not null<br>
     * RequestUtils.lookup(pageContext, name, property, scope)=not null
     * [Stringi"1.00"j]<br>
     * scale=1<br>
     * id=not null<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * pageContext=idL[Ƃl݂<br>
     * 
     * tH[}bgΏۂ̒l(value)not nulliStringi"1.15"jjA
     * _ȉw肳Aidw肳ĂꍇAPageContext
     * ݒ肳SKIP_BODYԂ邱ƂmFB
     * ܂AbeanvalueD悷邱ƂmFB<br>
     */
    public void testDoStartTag04() throws Exception {
        //eXgf[^ݒ
        // DecimalTag_BeanStub01CX^X̐
        DecimalTag_BeanStub01 bean = new DecimalTag_BeanStub01();
        bean.setField1("1.00");

        // PageContext
        PageContext pc = TagUTUtil.getPageContext(tag);
        String name = "aa";
        pc.setAttribute(name, bean);
        // NXϐݒ
        UTUtil.setPrivateField(tag, "value", "1.15");
        UTUtil.setPrivateField(tag, "pattern", "##.##");
        UTUtil.setPrivateField(tag, "id", "id1");
        UTUtil.setPrivateField(tag, "scale", new Integer(1));

        String property = "field1";
        UTUtil.setPrivateField(tag, "property", property);

        //eXgs
        int result = tag.doStartTag();

        //eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);
        // PageControlInfo
        String id = (String) pc.getAttribute("id1");
        assertEquals("1.2", id);

    }

    /**
     * testDoStartTag05B<br>
     * 
     * (n)<br>
     * ϓ_FAAF<br>
     * 
     * ͒l
     * value=not null[Stringi"1.15"j]<br>
     * RequestUtils.lookup(pageContext, name, scope)=null<br>
     * scale=-1<br>
     * id=not null<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * pageContext=idL[Ƃl݂<br>
     * 
     * tH[}bgΏۂ̒l(value)not nulliStringi"1.15"jjA
     * _ȉw肳Aidw肳ĂꍇAPageContext
     * ݒ肳SKIP_BODYԂ邱ƂmFB<br>
     */
    public void testDoStartTag05() throws Exception {
        // eXgf[^ݒ
        // PageContext
        PageContext pc = TagUTUtil.getPageContext(tag);

        // NXϐݒ
        UTUtil.setPrivateField(tag, "value", "1.15");
        UTUtil.setPrivateField(tag, "pattern", "##.##");
        UTUtil.setPrivateField(tag, "id", "id1");
        UTUtil.setPrivateField(tag, "scale", new Integer(-1));

        String property = "field1";
        UTUtil.setPrivateField(tag, "property", property);

        //eXgs
        int result = tag.doStartTag();

        //eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);
        // PageControlInfo
        String id = (String) pc.getAttribute("id1");
        assertEquals("1.15", id);

    }

    /**
     * testDoStartTag06B<br>
     * 
     * (n)<br>
     * ϓ_FAAF<br>
     * 
     * ͒l
     * value=not null[Stringi"1.1 "j]<br>
     * scale=-1<br>
     * id=null<br>
     * filter=true<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * pageContext=X|XoutputtB^A܂Ă<br>
     * 
     * tH[}bgΏۂ̒l(value)not nulliStringi"1.1 "jjA
     * _ȉw肳Aidw肳ĂȂA
     * filtertruȅꍇAX|XփtB^lݒ肳
     * SKIP_BODYԂ邱ƂmFB<br>
     */
    public void testDoStartTag06() throws Exception {
        // eXgf[^ݒ
        // DecimalTag_BeanStub01CX^X̐
        DecimalTag_BeanStub01 bean = new DecimalTag_BeanStub01();
        bean.setField1("1.1 ");

        // PageContext
        PageContext pc = TagUTUtil.getPageContext(tag);
        String name = "aa";
        pc.setAttribute(name, bean);
        // NXϐݒ
        UTUtil.setPrivateField(tag, "value", "1.1 ");
        UTUtil.setPrivateField(tag, "pattern", "##.##");
        UTUtil.setPrivateField(tag, "id", null);
        UTUtil.setPrivateField(tag, "scale", new Integer(-1));

        String property = "field1";
        UTUtil.setPrivateField(tag, "property", property);

        //eXgs
        int result = tag.doStartTag();

        //eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);

        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("1.1", reader.readLine());

    }

    /**
     * testDoStartTag07B<br>
     * 
     * (n)<br>
     * ϓ_FAAF<br>
     * 
     * ͒l
     * value=not null[Stringi"1.1 "j]<br>
     * scale=-1<br>
     * id=null<br>
     * filter=false<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * pageContext=X|Xoutput܂Ă<br>
     * 
     * tH[}bgΏۂ̒l(value)not nulliStringi"1.1 "jjA
     * _ȉw肳Aidw肳AfilterfalsȅꍇA
     * X|X֒lݒ肳SKIP_BODYԂ邱ƂmFB<br>
     */
    public void testDoStartTag07() throws Exception {
        // eXgf[^ݒ
        // DecimalTag_BeanStub01CX^X̐
        DecimalTag_BeanStub01 bean = new DecimalTag_BeanStub01();
        bean.setField1("1.1 ");

        // PageContext
        PageContext pc = TagUTUtil.getPageContext(tag);
        String name = "aa";
        pc.setAttribute(name, bean);
        // NXϐݒ
        UTUtil.setPrivateField(tag, "value", "1.1 ");

        UTUtil.setPrivateField(tag, "filter", new Boolean(false));
        UTUtil.setPrivateField(tag, "pattern", "##.##");
        UTUtil.setPrivateField(tag, "id", null);
        UTUtil.setPrivateField(tag, "scale", new Integer(-1));

        String property = "field1";
        UTUtil.setPrivateField(tag, "property", property);

        //eXgs
        int result = tag.doStartTag();

        //eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);

        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("1.1", reader.readLine());

    }

    /**
     * testDoStartTag08B<br>
     * 
     * (n)<br>
     * ϓ_FAAF<br>
     * 
     * ͒l
     * value=not null[Stringi" "j]<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * 
     * tH[}bgΏۂ̒l(value)not nulliStringi" "jj
     * ꍇASKIP_BODYԂ邱ƂmFB<br>
     */
    public void testDoStartTag08() throws Exception {
        //eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", "");

        //eXgs
        int result = tag.doStartTag();

        //eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);

    }

    /**
     * testDoStartTag09B<br>
     * 
     * (ُn)<br>
     * ϓ_FG<br>
     * 
     * ͒l
     * value=not null[Stringi"aa "j]<br>
     * scale=1<br>
     * id=not null<br>
     * 
     * Ғl
     * ߂l:int=Exception<br>
     * 
     * tH[}bgΏۂ̒l(value)not nulliStringi"aa "jj
     * ꍇANumberFormatException邱ƂmFB<br>
     */
    public void testDoStartTag09() throws Exception {
        //eXgf[^ݒ
        UTUtil.setPrivateField(tag, "value", "aa");
        UTUtil.setPrivateField(tag, "id", "id1");
        UTUtil.setPrivateField(tag, "scale", new Integer(1));

        //eXgs
        try {
            tag.doStartTag();
            fail();
        } catch (NumberFormatException e) {
            //eXgʊmF
            return;
        }
    }

    /**
     * testDoStartTag10B<br>
     * 
     * (n)<br>
     * ϓ_FAAF<br>
     * 
     * ͒l
     * value=not null[BigDecimal]<br>
     * scale=*(0)<br>
     * id=*(not null)<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * pageContext=idL[Ƃl݂<br>
     * 
     * tH[}bgΏۂ̒l(value)not nulliBigDecimalj̏ꍇA
     * _ȉw肳Aidw肳ĂȂꍇA
     * X|XփtB^lݒ肳
     * SKIP_BODYԂ邱ƂmFB<br>
     */
    public void testDoStartTag10() throws Exception {
        //eXgf[^ݒ
        // DecimalTag_BeanStub01CX^X̐
        DecimalTag_BeanStub01 bean = new DecimalTag_BeanStub01();
        BigDecimal value = new BigDecimal("1.01");
        bean.setField2(value);

        // PageContext
        PageContext pc = TagUTUtil.getPageContext(tag);
        String name = "aa";
        pc.setAttribute(name, bean);
        // NXϐݒ
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", name);
        UTUtil.setPrivateField(tag, "pattern", "##.##");
        UTUtil.setPrivateField(tag, "id", "id1");
        UTUtil.setPrivateField(tag, "scale", new Integer(0));

        String property = "field2";
        UTUtil.setPrivateField(tag, "property", property);

        //eXgs
        int result = tag.doStartTag();

        //eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);
        // PageControlInfo
        String id = (String) pc.getAttribute("id1");
        assertEquals("1", id);

    }

    /**
     * testDoStartTag11B<br>
     * 
     * (n)<br>
     * ϓ_FAAF<br>
     * 
     * ͒l
     * value=not null[int(StringABigDecimalȊO)]<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * 
     * tH[}bgΏۂ̒l(value)not nulliintiStringABigDecimalȊOjj̏ꍇASKIP_BODYԂ邱ƂmFB<br>
     */
    public void testDoStartTag11() throws Exception {
        //eXgf[^ݒ
        // DecimalTag_BeanStub01CX^X̐
        DecimalTag_BeanStub01 bean = new DecimalTag_BeanStub01();
        
        Integer value = new Integer("1");
        bean.setField3(value);

        // PageContext
        PageContext pc = TagUTUtil.getPageContext(tag);
        String name = "aa";
        pc.setAttribute(name, bean);
        // NXϐݒ
        UTUtil.setPrivateField(tag, "value", null);
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", name);
        UTUtil.setPrivateField(tag, "pattern", "##.##");
        UTUtil.setPrivateField(tag, "id", "id1");
        UTUtil.setPrivateField(tag, "scale", new Integer(0));

        String property = "field3";
        UTUtil.setPrivateField(tag, "property", property);

        //eXgs
        int result = tag.doStartTag();

        //eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);

    }

    /**
     * testDoStartTag12B<br>
     * 
     * (n)<br>
     * ϓ_FAAF<br>
     * 
     * ͒l
     * value=not null[Stringi"1.1"j]<br>
     * scale=1<br>
     * id=not null<br>
     * 
     * Ғl
     * ߂l:void<br>
     *
     * pageContext#setAttribute()NullPointerExceptionꍇA
     * ꂪX[邱ƂmFB<br>
     */
    public void testDoStartTag12() throws Exception {
        //eXgf[^ݒ
        // DecimalTag_BeanStub01CX^X̐
        DecimalTag_BeanStub01 bean = new DecimalTag_BeanStub01();
        bean.setField1("1.1");

        // PageContext
        PageContext pc = TagUTUtil.getPageContext(tag);
        // eXgpy[WReLXg̐
        Exception_PageContextImpl pc2 =
            new Exception_PageContextImpl(
                pc.getServletConfig(),
                pc.getRequest(),
                pc.getResponse());

        pc2.setNullPointerEx();
        pc2.setTiming(1);
        // ݒseXgpy[WReLXgeXgΏۃ^OɃZbgB
        tag.setPageContext(pc2);

        String name = "aa";
        pc.setAttribute(name, bean);
        // NXϐݒ
        UTUtil.setPrivateField(tag, "value", "1.1");
        UTUtil.setPrivateField(tag, "pattern", "##.##");
        UTUtil.setPrivateField(tag, "id", "id1");
        UTUtil.setPrivateField(tag, "scale", new Integer(1));

        String property = "field1";
        UTUtil.setPrivateField(tag, "property", property);

        //eXgs
        try {
            tag.doStartTag();
            fail();
        } catch (NullPointerException e) {
            //eXgʊmF
            return;
        }

    }

    /**
     * testDoStartTag13B<br>
     * 
     * (n)<br>
     * ϓ_FAAF<br>
     * 
     * ͒l
     * value=not null[Stringi"1.1"j]<br>
     * scale=1<br>
     * id=not null<br>
     * 
     * Ғl
     * ߂l:void<br>
     *
     * pageContext#setAttribute()IllegalArgumentExceptionꍇA
     * ꂪX[邱ƂmFB<br>
     */
    public void testDoStartTag13() throws Exception {
        //eXgf[^ݒ
        // DecimalTag_BeanStub01CX^X̐
        DecimalTag_BeanStub01 bean = new DecimalTag_BeanStub01();
        bean.setField1("1.1");

        // PageContext
        PageContext pc = TagUTUtil.getPageContext(tag);
        // eXgpy[WReLXg̐
        Exception_PageContextImpl pc2 =
            new Exception_PageContextImpl(
                pc.getServletConfig(),
                pc.getRequest(),
                pc.getResponse());

        pc2.setIllegalArgumentEx();
        pc2.setTiming(1);
        // ݒseXgpy[WReLXgeXgΏۃ^OɃZbgB
        tag.setPageContext(pc2);

        String name = "aa";
        pc.setAttribute(name, bean);
        // NXϐݒ
        UTUtil.setPrivateField(tag, "value", "1.1");
        UTUtil.setPrivateField(tag, "pattern", "##.##");
        UTUtil.setPrivateField(tag, "id", "id1");
        UTUtil.setPrivateField(tag, "scale", new Integer(1));

        String property = "field1";
        UTUtil.setPrivateField(tag, "property", property);

        //eXgs
        try {
            tag.doStartTag();
            fail();
        } catch (IllegalArgumentException e) {
            //eXgʊmF
            return;
        }

    }

    /**
     * testDoStartTag14B<br>
     * 
     * (n)<br>
     * ϓ_FAAF<br>
     * 
     * ͒l
     * value=not null[Stringi"1.25"j]<br>
     * filter=false
     * pattern=#.###
     * id=null
     * scale=1
     * round=null
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * pageContext=X|Xoutput܂Ă<br>
     * 
     * tH[}bgΏۂ̒l(value)not nulliStringi"1.25"jjA
     * scale1Aroundݒ肳ĂȂꍇA
     * X|X֎w肵_ľܓlݒ肳A
     * SKIP_BODYԂ邱ƂmFB<br>
     */
    public void testDoStartTag14() throws Exception {
        //eXgf[^ݒ
        // DecimalTag_BeanStub01CX^X̐
        DecimalTag_BeanStub01 bean = new DecimalTag_BeanStub01();
        bean.setField1("1.25");

        // PageContext
        PageContext pc = TagUTUtil.getPageContext(tag);
        String name = "aa";
        pc.setAttribute(name, bean);
        // NXϐݒ
        UTUtil.setPrivateField(tag, "value", "1.25");

        UTUtil.setPrivateField(tag, "filter", new Boolean(false));
        UTUtil.setPrivateField(tag, "pattern", "##.##");
        UTUtil.setPrivateField(tag, "id", null);
        UTUtil.setPrivateField(tag, "scale", new Integer(1));

        String property = "field1";
        UTUtil.setPrivateField(tag, "property", property);

        //eXgs
        int result = tag.doStartTag();

        //eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);

        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("1.3", reader.readLine());

    }
    
    /**
     * testDoStartTag15B<br>
     * 
     * (n)<br>
     * ϓ_FAAF<br>
     * 
     * ͒l
     * value=not null[Stringi"1.23"j]<br>
     * filter=false
     * pattern=##.##
     * id=null
     * scale=1
     * round="rounding test"
     * 
     * Ғl
     * ߂l:
     * IllegalArgumentException
     * 
     * tH[}bgΏۂ̒l(value)not nulliStringi"1.23"jjA
     * scale1AroundɊۂ߃[hȊOݒ肳ĂꍇA
     * IllegalArgumentException邱ƂmFB
     * mFB<br>
     */
    public void testDoStartTag15() throws Exception {
        //eXgf[^ݒ
        // DecimalTag_BeanStub01CX^X̐
        DecimalTag_BeanStub01 bean = new DecimalTag_BeanStub01();
        bean.setField1("1.23");

        // PageContext
        PageContext pc = TagUTUtil.getPageContext(tag);
        String name = "aa";
        pc.setAttribute(name, bean);
        // NXϐݒ
        UTUtil.setPrivateField(tag, "value", "1.23");

        UTUtil.setPrivateField(tag, "filter", new Boolean(false));
        UTUtil.setPrivateField(tag, "pattern", "##.##");
        UTUtil.setPrivateField(tag, "id", null);
        UTUtil.setPrivateField(tag, "scale", new Integer(1));
        UTUtil.setPrivateField(tag, "round", "rounding test");

        String property = "field1";
        UTUtil.setPrivateField(tag, "property", property);

        //eXgs
        try {
            tag.doStartTag();
            fail();
        } catch (IllegalArgumentException e) {
            assertTrue(LogUTUtil.checkError("Please set a rounding mode"));
            assertEquals("Please set a rounding mode", e.getMessage());
        }
    }
    
    /**
     * testDoStartTag16B<br>
     * 
     * (n)<br>
     * ϓ_FAAF<br>
     * 
     * ͒l
     * value=not null[Stringi"1.29"j]<br>
     * filter=false
     * pattern=##.##
     * id=null
     * scale=1
     * round="ROUND_FLOOR"
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * pageContext=X|Xoutput܂Ă<br>
     * 
     * tH[}bgΏۂ̒l(value)not nulliStringi"1.29"jjA
     * scale1Around"ROUND_FLOOR"ݒ肳ĂꍇA
     * X|X֎w肵_؂̂Ăꂽlݒ肳A
     * SKIP_BODYԂ邱ƂmFB<br>
     */
    public void testDoStartTag16() throws Exception {
        //eXgf[^ݒ
        // DecimalTag_BeanStub01CX^X̐
        DecimalTag_BeanStub01 bean = new DecimalTag_BeanStub01();
        bean.setField1("1.29");

        // PageContext
        PageContext pc = TagUTUtil.getPageContext(tag);
        String name = "aa";
        pc.setAttribute(name, bean);
        // NXϐݒ
        UTUtil.setPrivateField(tag, "value", "1.29");

        UTUtil.setPrivateField(tag, "filter", new Boolean(false));
        UTUtil.setPrivateField(tag, "pattern", "##.##");
        UTUtil.setPrivateField(tag, "id", null);
        UTUtil.setPrivateField(tag, "scale", new Integer(1));
        UTUtil.setPrivateField(tag, "round", "round_floor");

        String property = "field1";
        UTUtil.setPrivateField(tag, "property", property);

        //eXgs
        int result = tag.doStartTag();

        //eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);

        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("1.2", reader.readLine());
    }
    
    /**
     * testDoStartTag17B<br>
     * 
     * (n)<br>
     * ϓ_FAAF<br>
     * 
     * ͒l
     * value=not null[Stringi"1.21"j]<br>
     * filter=false
     * pattern=##.##
     * id=null
     * scale=1
     * round=ROUND_CEILING
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * pageContext=X|Xoutput܂Ă<br>
     * 
     * tH[}bgΏۂ̒l(value)not nulliStringi"1.21"jjA
     * scale1Around"ROUND_CEILING"ݒ肳ĂꍇA
     * X|X֎w肵_؂グꂽlݒ肳A
     * SKIP_BODYԂ邱ƂmFB<br>
     */
    public void testDoStartTag17() throws Exception {
        //eXgf[^ݒ
        // DecimalTag_BeanStub01CX^X̐
        DecimalTag_BeanStub01 bean = new DecimalTag_BeanStub01();
        bean.setField1("1.21");

        // PageContext
        PageContext pc = TagUTUtil.getPageContext(tag);
        String name = "aa";
        pc.setAttribute(name, bean);
        // NXϐݒ
        UTUtil.setPrivateField(tag, "value", "1.21");

        UTUtil.setPrivateField(tag, "filter", new Boolean(false));
        UTUtil.setPrivateField(tag, "pattern", "##.##");
        UTUtil.setPrivateField(tag, "id", null);
        UTUtil.setPrivateField(tag, "scale", new Integer(1));
        UTUtil.setPrivateField(tag, "round", "round_ceiling");

        String property = "field1";
        UTUtil.setPrivateField(tag, "property", property);

        //eXgs
        int result = tag.doStartTag();

        //eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);

        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("1.3", reader.readLine());
    }
    
    /**
     * testDoStartTag18B<br>
     * 
     * (n)<br>
     * ϓ_FAAF<br>
     * 
     * ͒l
     * value=not null[Stringi"1.24"j]<br>
     * filter=false
     * pattern=##.##
     * id=null
     * scale=1
     * round="ROUND_HALF_UP"
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * pageContext=X|Xoutput܂Ă<br>
     * 
     * tH[}bgΏۂ̒l(value)not nulliStringi"1.24"jjA
     * scale1Around"ROUND_HALF_UP"ݒ肳ĂꍇA
     * X|X֎w肵_ľܓl
     * ݒ肳SKIP_BODYԂ邱ƂmFB<br>
     */
    public void testDoStartTag18() throws Exception {
        //eXgf[^ݒ
        // DecimalTag_BeanStub01CX^X̐
        DecimalTag_BeanStub01 bean = new DecimalTag_BeanStub01();
        bean.setField1("1.24");

        // PageContext
        PageContext pc = TagUTUtil.getPageContext(tag);
        String name = "aa";
        pc.setAttribute(name, bean);
        // NXϐݒ
        UTUtil.setPrivateField(tag, "value", "1.24");

        UTUtil.setPrivateField(tag, "filter", new Boolean(false));
        UTUtil.setPrivateField(tag, "pattern", "##.##");
        UTUtil.setPrivateField(tag, "id", null);
        UTUtil.setPrivateField(tag, "scale", new Integer(1));
        UTUtil.setPrivateField(tag, "round", "round_half_up");

        String property = "field1";
        UTUtil.setPrivateField(tag, "property", property);

        //eXgs
        int result = tag.doStartTag();

        //eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);

        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("1.2", reader.readLine());
    }
    
    /**
     * testRelease01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * id=*<br>
     * filter=*<br>
     * ignore=*<br>
     * name=*<br>
     * property=*<br>
     * scope=*<br>
     * pattern=*<br>
     * value=*<br>
     * scale=*<br>
     * 
     * Ғl
     * ߂l:void<br>
     * id=null<br>
     * filter=true<br>
     * ignore=false<br>
     * name=null<br>
     * property=null<br>
     * scope=null<br>
     * pattern=null<br>
     * value=null<br>
     * scale=-1<br>
     * 
     * OƂĐݒ肵elAsɊel邱ƂmF<br>
     */
    public void testRelease01() throws Exception {
        //eXgf[^ݒ
        UTUtil.setPrivateField(tag, "id", "id1");
        UTUtil.setPrivateField(tag, "filter", new Boolean(false));
        UTUtil.setPrivateField(tag, "ignore", new Boolean(false));
        UTUtil.setPrivateField(tag, "name", "aa");
        UTUtil.setPrivateField(tag, "property", "field1");
        UTUtil.setPrivateField(tag, "scope", "scope");
        UTUtil.setPrivateField(tag, "pattern", "##.##");
        UTUtil.setPrivateField(tag, "value", "aa");
        UTUtil.setPrivateField(tag, "scale", new Integer(0));

        //eXgs
        tag.release();

        //eXgʊmF
        String id2 = (String) UTUtil.getPrivateField(tag, "id");
        Boolean filter2 = (Boolean) UTUtil.getPrivateField(tag, "filter");
        Boolean ignore2 = (Boolean) UTUtil.getPrivateField(tag, "ignore");
        String name2 = (String) UTUtil.getPrivateField(tag, "name");
        String property2 = (String) UTUtil.getPrivateField(tag, "property");
        String scope2 = (String) UTUtil.getPrivateField(tag, "scope");
        String pattern2 = (String) UTUtil.getPrivateField(tag, "pattern");
        String value2 = (String) UTUtil.getPrivateField(tag, "value");
        Integer scale2 = (Integer) UTUtil.getPrivateField(tag, "scale");

        assertNull(id2);
        assertTrue(filter2.booleanValue());
        assertFalse(ignore2.booleanValue());
        assertNull(name2);
        assertNull(property2);
        assertNull(scope2);
        assertNull(pattern2);
        assertNull(value2);
        assertEquals(new Integer(-1), scale2);

    }

}
