/**
 * 
 */
package jp.terasoluna.fw.web.thin;

import java.lang.ref.ReferenceQueue;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.thin.SessionLockReference} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * WeakReference̊gNXB
 * ZbVIDێłB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.thin.SessionLockReference
 */
public class SessionLockReferenceTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(SessionLockReferenceTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public SessionLockReferenceTest(String name) {
        super(name);
    }

    /**
     * testSessionLockReference01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() sessionId:1111<br>
     *         () referent:LimitedLock<br>
     *         () q:ReferenceQueue<br>
     * <br>
     * ҒlF(߂l) SessionLockReference:not Null<br>
     *         (ԕω) sessionId:1111<br>
     *         (ԕω) get̖߂l:LimitedLock<br>
     * <br>
     * RXgN^̈sessionIdŗ^lsessionIdɐݒ肳邱ƂmFB<br>
     * referentŗ^IuWFNgAgetœ邱ƂmFB<br>
     * (sessionIdȊO̓́AX[p[NXɂ́B)<br>
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSessionLockReference01() throws Exception {
        // O
        ReferenceQueue<LimitedLock> refQueue = new ReferenceQueue<LimitedLock>();
        LimitedLock lock = new LimitedLock(1);
        
        // eXg{
        SessionLockReference ref = new SessionLockReference("1111", lock, refQueue);
        
        // 
        assertEquals("1111", UTUtil.getPrivateField(ref, "sessionId"));
        assertSame(lock, ref.get());
    }

    /**
     * testSessionLockReference02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() sessionId:null<br>
     *         () referent:null<br>
     *         () q:null<br>
     * <br>
     * ҒlF(߂l) SessionLockReference:not Null<br>
     *         (ԕω) sessionId:null<br>
     *         (ԕω) get̖߂l:null<br>
     * <br>
     * RXgN^̈SnullłACX^Xł邱ƂmFB<br>
     * RXgN^̈sessionIdŗ^nullsessionIdɐݒ肳邱ƂmFB<br>
     * referentŗ^nullAgetœ邱ƂmFB<br>
     * (sessionIdȊO̓́AX[p[NXɂ́B)<br>
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSessionLockReference02() throws Exception {
        // eXg{
        SessionLockReference ref = new SessionLockReference(null, null, null);
        
        // 
        assertNull(UTUtil.getPrivateField(ref, "sessionId"));
        assertNull(ref.get());
    }

    /**
     * testGetSessionId01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() sessionId:1111<br>
     *         () referent:LimitedLock<br>
     *         () queue:ReferenceQueue<br>
     * <br>
     * ҒlF(߂l) String:1111<br>
     * <br>
     * ݒ肳ĂsessionId擾ł邱ƂmFB<br>
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetSessionId01() {
        // O
        ReferenceQueue<LimitedLock> refQueue = new ReferenceQueue<LimitedLock>();
        LimitedLock lock = new LimitedLock(1);
        SessionLockReference ref = new SessionLockReference("1111", lock, refQueue);
        
        // eXg{
        String result = ref.getSessionId();
        
        // 
        assertEquals("1111", result);
    }
}
