/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.taglib;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import jp.terasoluna.fw.util.StringUtil;
import jp.terasoluna.fw.web.taglib.TagUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DateFormatterTagBase
extends TagSupport {
    private static Log log = LogFactory.getLog(DateFormatterTagBase.class);
    private static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    protected String format = null;
    protected String id = null;
    protected boolean filter = true;
    protected boolean ignore = false;
    protected String name = null;
    protected String property = null;
    protected String scope = null;
    protected String pattern = null;
    protected String value = null;

    protected String getDefaultDateFormat() {
        return DATE_FORMAT;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int doStartTag() throws JspException {
        Object value = this.value;
        if (value == null) {
            if (this.ignore && TagUtil.lookup(this.pageContext, this.name, this.scope) == null) {
                return 0;
            }
            value = TagUtil.lookup(this.pageContext, this.name, this.property, this.scope);
            if (value == null) {
                return 0;
            }
        }
        Date date = null;
        if (value instanceof String) {
            String trimed = StringUtil.rtrim((String)value);
            String dateFormat = StringUtils.defaultIfEmpty((String)this.getFormat(), (String)this.getDefaultDateFormat());
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            try {
                date = sdf.parse(trimed);
            }
            catch (ParseException e) {
                log.error((Object)"Date parsing error.");
                throw new JspTagException(e.getMessage());
            }
        } else if (value instanceof Date) {
            date = (Date)value;
        } else {
            return 0;
        }
        String output = this.doFormat(date);
        if (this.id != null) {
            this.pageContext.setAttribute(this.id, (Object)output);
        } else if (this.filter) {
            TagUtil.write(this.pageContext, TagUtil.filter(output));
        } else {
            TagUtil.write(this.pageContext, output);
        }
        return 0;
    }

    public void release() {
        super.release();
        this.id = null;
        this.filter = true;
        this.ignore = false;
        this.name = null;
        this.property = null;
        this.scope = null;
        this.pattern = null;
        this.value = null;
    }

    protected abstract String doFormat(Date var1);
}

