/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import java.util.Date;

import jp.terasoluna.fw.util.DateUtil;

/**
 * <p>
 *  tf[^aƂătH[}bgjdate^O̎NXB
 * </p>
 *
 * <p>
 * t̃f[^̃tH[}bgsۂɁAǎ
 * <code>i&quot;a&quot;A&quot;S&quot;Ȃǁj</code>A
 * a̔Ni <code>&quot;2002&quot;</code> Nł͂ȂA
 *  <code>&quot;14&quot;N</code> ȂǁjAїj̓{\L
 * i<code>&quot;j&quot;A&quot;&quot;</code> ȂǁjɕϊB
 * </p>
 *
 * <p>
 *  tH[}bǵA<code>pattern</code> ɂĎw肳ꂽ`ɏ]
 *  sB{@link JDateTag} NXł́A{Iɂ {@link DateTag}
 *  NXƓl <code>pattern</code> Ŏw肳ꂽo͌`̕
 *  <code>java.text.SimpleDateFormat</code> NX<em>p^[</em>
 *  Ƃĉ߂AtH[}bgBAp^[̉߂ɂ
 *  ȉ̓_ {@link DateTag} NXƈقȂB
 * </p>
 *
 * <div width="90%" align="center">
 *  <table border="1">
 *   <tr>
 *    <th>L</th>
 *    <th><code>&nbsp;SimpleDateFormat</code> ł̈Ӗ&nbsp;</th>
 *    <th><code>&nbsp;JdateTag</code> ł̈Ӗ&nbsp;</th>
 *   </tr>
 *   <tr>
 *    <td>G</td>
 *    <td align="left">I<br>FAD</td>
 *    <td align="left">a<br>
 *                     F<code>HHHH</code>  <br>
 *                         <code>HHH</code>  H</td>
 *   </tr>
 *   <tr>
 *    <td>y</td>
 *    <td align="left">Nij<br>F2002</td>
 *    <td align="left">Niaj<br>F14</td>
 *   </tr>
 *   <tr>
 *    <td>E</td>
 *    <td align="left">j<br>FTuesday</td>
 *    <td align="left">ji{\Lj<br><br>
 *                     F<code>EEEE</code>  j<br>
 *                         <code>EEE</code>  </td>
 *   </tr>
 * </table>
 * </div>
 *
 * <p>
 *  L̋L̂AaAјaNɂĂ
 *  {@link jp.terasoluna.fw.util.DateUtil} NX
 *  <code>dateToWarekiString(String pattern, java.util.Date date)</code>
 *  \bhɂĕϊBaAјaN̐ݒ@
 *  ϊ\ȔNɂĂ̐Ȃǂ́A
 *  {@link jp.terasoluna.fw.util.DateUtil} QƁB
 * </p>
 *
 * <p>
 *  ܂AjɂĂ <code>SimpleDateFotmat</code>
 *  ̃RXgN^ɂăP[ <code>&quot;ja&quot;</code>
 *  Ɏw肷邱ƂŕϊBP[⎞p^[̏ڍׂɂẮA
 *  <code>java.text.SimpleDateFormat</code>
 *  NX̃hLgQƂ̂ƁB
 * </p>
 *
 * <br>
 *
 * <h5>^OT|[g鑮</h5>
 * <p> {@link DateFormatterTagBase} QƁB</p>
 *
 * <br>
 *
 * <h5>JX^^ÕXNveBOϐ</h5>
 * <p> {@link DateFormatterTagBase} QƁB</p>
 *
 * <br>
 *
 * <h5>gp@</h5>
 * <p>
 *  <code>&quot;form0001&quot;</code> <code>bean</code>
 *  <code>&quot;field001&quot;</code> vpeB̒lw肵`ɃtH[}bg
 *  ďo͂ɂ́Aȉ̂悤ɋLqB
 * </p>
 *
 * <p><code><pre>
 *  &lt;t:jdate name="form0001"
 *              property="field001"
 *              pattern="GGGGyyNMMdd(EEEE) hhmmssb" /&gt;
 *
 * =&gt 14N0726(j) 110407b
 *
 *  &lt;t:jdate name="form0001"
 *              property="field001"
 *              pattern="G. yyNMMdd(E) hhmmssb" /&gt;
 *
 * =&gt H. 14N0726() 110407b
 * </pre></code></p>
 *
 * <p>
 *  L beañvpeBAJX^^Oŏo͂ɃXNveBOϐ
 *  <code>&quot;formatted&quot;</code>
 *  փZbgꍇɂ́Aȉ̂悤ɋLqB
 * </p>
 *
 * <p><code><pre>
 *  &lt;t:jdate id="formatted"
 *              name="form0001"
 *              property="field001"
 *              pattern="GGGGyyNMMdd(EEEE) hhmmssb" /&gt;
 * </pre></code></p>
 *
 * <p>
 *  tH[}bgtf[^beanoɁA
 *  JX^^O <code>value</code>
 *  ɂĎw肷ꍇɂ́Aȉ̂悤ɋLqB
 * </p>
 *
 * <p><code><pre>
 *  &lt;t:jdate value="2002/07/25 04:56:23"
 *              pattern="GGGGyyNMMdd(EEEE) hhmmssb" /&gt;
 * </pre></code></p>
 *
 * @see java.text.SimpleDateFormat
 * @see jp.terasoluna.fw.util.DateUtil
 * @see jp.terasoluna.fw.web.taglib.DateFormatterTagBase
 *
 */
public class JDateTag extends DateFormatterTagBase {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = 4097026346025126637L;

    /**
     * <code>pattern</code> Ŏw肳ꂽtH[}bgɂāA
     * w肳ꂽtf[^aƂătH[}bgB
     *
     * @param date tf[^
     * @return tf[^aƂătH[}bg
     */
    @Override
    protected String doFormat(Date date) {
        return DateUtil.dateToWarekiString(pattern, date);
    }

}
