/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import java.io.IOException;

import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

import jp.terasoluna.fw.web.codelist.CodeBean;
import jp.terasoluna.fw.web.codelist.CodeListLoader;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/**
 * WriteCodeValue ^OB
 *
 * <p>
 * T[ubgReLXg
 *  codeList Ŏw肳ꂽ CodeListLoader ToA
 * ̒ɕۑĂR[hXgl擾Ao͂B
 * Ȃꍇ͉o͂ȂB
 * </p>
 *
 * R[hXg̓ǂݍ݂́A
 * {@link jp.terasoluna.fw.web.codelist.CodeListLoader}
 * C^tF[X̎NXQƂ̂ƁB
 *
 * <strong>^OT|[g鑮</strong><br>
 * <p> writeCodeValue ^Oł́Aȉ̑T|[gB</p>
 * <div align="center">
 * <table width="90%" border="1" bgcolor="#FFFFFF">
 *  <tr>
 *   <td> <b></b> </td>
 *   <td> <b>ftHgl</b> </td>
 *   <td> <b>K{</b> </td>
 *   <td> <b>s</b> </td>
 *   <td> <b>Tv</b> </td>
 *  </tr>
 *  <tr>
 *   <td> <code>codeList</code> </td>
 *   <td> <code>-</code> </td>
 *   <td> <code>true</code> </td>
 *   <td> <code>true</code> </td>
 *   <td align="left">
 *    ̑CodeListLoaderB܂
 *    {@link jp.terasoluna.fw.web.codelist.CodeListLoader}
 *    C^tF[Xbean̖Ow肷B
 *  </tr>
 *  <tr>
 *   <td> <code>key</code> </td>
 *   <td> <code>-</code> </td>
 *   <td> <code>false</code> </td>
 *   <td> <code>true</code> </td>
 *   <td align="left">
 *    擾R[hXgl擾邽߂̃L[𒼐ڎw肷B
 *  </tr>
 *  <tr>
 *   <td> <code>name</code> </td>
 *   <td> <code>-</code> </td>
 *   <td> <code>false</code> </td>
 *   <td> <code>true</code> </td>
 *   <td align="left">
 *    擾R[hXgl擾邽߂̃L[ێBean̖OB
 *    keyw肳Ăꍇ́AB
 *  </tr>
 *  <tr>
 *   <td> <code>property</code> </td>
 *   <td> <code>-</code> </td>
 *   <td> <code>false</code> </td>
 *   <td> <code>true</code> </td>
 *   <td align="left">
 *    擾R[hXgl擾邽߂̃L[ێBeañvpeBB
 *    keyw肳Ăꍇ́AB
 *  </tr>
 *  <tr>
 *   <td> <code>scope</code> </td>
 *   <td> <code>-</code> </td>
 *   <td> <code>false</code> </td>
 *   <td> <code>true</code> </td>
 *   <td align="left">
 *    擾R[hXgl擾邽߂̃L[ێBean
 *    ݂XR[vB
 *  </tr>
 * </table>
 * </div>
 * </p>
 * <strong>JX^^ÕXNveBOϐ</strong><br>
 * <p>̃^OɂĐݒ肳XNveBOϐ͂܂B</p>
 * <br>
 * <strong>gp@</strong><br>
 * <p>
 * ȉ̗́ACodeListLoader C^tF[XNX bean 
 * &quot;loader1&quot;ƌOŒ`ĂA
 * ̒&quot;key1&quot;ƂL[Ŏ擾łl
 * o͂ꍇ̐ݒłB<br>
 * `̕@
 * {@link jp.terasoluna.fw.web.codelist.DBCodeListLoader}A
 * y
 * {@link jp.terasoluna.fw.web.codelist.MappedCodeListLoader}
 * QƁB
 * </p>
 *
 * <strong>JSP ł̋LqB</strong><br>
 *
 * <code><pre>
 *  &lt;t:writeCodeValue codeList=<b>"loader1"</b> key=<b>"key1"</b> /&gt;
 * </pre></code>
 * R[hXg̃TCY擾ɊւẮA{@link WriteCodeCountTag} Q
 * </p>
 *
 * @see jp.terasoluna.fw.web.codelist.CodeListLoader
 * @see jp.terasoluna.fw.web.codelist.DBCodeListLoader
 * @see jp.terasoluna.fw.web.codelist.MappedCodeListLoader
 * @see jp.terasoluna.fw.web.taglib.DefineCodeListTag
 * @see jp.terasoluna.fw.web.taglib.WriteCodeCountTag
 *
 */
public class WriteCodeValueTag extends TagSupport {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = 8199383777405058816L;

    /**
     * ONXB
     */
     private static Log log =
         LogFactory.getLog(WriteCodeValueTag.class);

     /**
      * R[hXgB
      */
     private String codeList = null;

     /**
      * R[hXgvalue擾邽߂̃L[B
      */
     private String key = null;

     /**
      *  propertyŎw肵loׂBeanB
      */
     private String name = null;

     /**
      *  nameɂĎw肳ꂽBeanŃANZXvpeBB
      */
     private String property = null;

     /**
      *  nameɂĎw肵beanoׂɌXR[vB
      */
     private String scope = null;

     /**
      * Beanݒ肷B
      *
      * @param name Bean
      */
     public void setName(String name) {
         this.name = name;
     }

     /**
      * vpeBݒ肷B
      *
      * @param property vpeB
      */
     public void setProperty(String property) {
         this.property = property;
     }

     /**
      * XR[vݒ肷B
      *
      * @param scope XR[v
      */
     public void setScope(String scope) {
         this.scope = scope;
     }

     /**
      * L[ݒ肷B
      *
      * @param key R[hXg̃L[
      */
     public void setKey(String key) {
         this.key = key;
     }

     /**
      * R[hXgݒ肷B
      *
      * @param codeList R[hXg
      */
     public void setCodeList(String codeList) {
         this.codeList = codeList;
     }


    /**
     * ^O]JnɌĂ΂郁\bhB
     *
     * <p>
     * T[ubgReLXgAApplicationContext擾A
     * &quot;codeList&quot; Ŏw肳ꂽ id
     *  CodeListLoader 擾A̒̃R[hXg
     * l擾Ao͂B
     * &quot;key&quot; w肳Ă΁ÃL[l擾A
     * w肳Ȃ΁A&quot;name&quot; Ŏw肳bean
     * L[擾ėpB
     *
     * R[hXgłȂꍇA
     * L[݂Ȃꍇ́Ao͂ȂB
     * </p>
     *
     * @return wB EVAL_BODY_INCLUDE
     * @throws JspException JSP O
     */
    @Override
    public int doStartTag() throws JspException {
        if (log.isDebugEnabled()) {
            log.debug("doStartTag() called.");
        }

        if ("".equals(codeList) || codeList == null) {
            // codeListw肳Ȃꍇ
            log.error("codeList is required.");
            throw new JspTagException("codeList is required.");
        }

        if (key == null && name == null) {
            // keynameɎw肳Ȃꍇ
            log.error("key and name is required.");
            throw new JspTagException("key and name is required.");
        }

        String codeKey = null;

        if ((key == null) && (name != null)) {
            if (TagUtil.lookup(pageContext, name, scope) == null) {
                log.error("bean id:" + name + " is not defined.");
                throw new JspTagException("bean id:" + name
                        + " is not defined.");
            }
            Object bean = null;
            try {
                bean = TagUtil.lookup(pageContext, name, property, scope);
            } catch (JspException e) {
                // Ȃ
            }
            if (bean == null) {
                log.error("Cannot get property[" + name + "."
                        + property + "].");
                throw new JspTagException("Cannot get property[" + name + "."
                        + property + "].");
            }
            codeKey = bean.toString();
        } else {
            codeKey = key;
        }

        // T[ubgReLXgAApplicationContext擾B
        ServletContext sc = pageContext.getServletContext();
        ApplicationContext context =
            WebApplicationContextUtils.getRequiredWebApplicationContext(sc);

        CodeListLoader loader = null;

        if (context.containsBean(codeList)) {
            try {
                loader = (CodeListLoader) context.getBean(codeList);
            } catch (ClassCastException e) {
                // 擾BeanCodeListLoaderł͂ȂOX[
                String errorMessage = "bean id:" + codeList
                        + " is not instance of CodeListLoader.";
                log.error(errorMessage);
                throw new JspTagException(errorMessage, e);
            }
        }

        JspWriter out = pageContext.getOut();

        if (loader == null) {
            log.error("CodeListLoader:" + codeList + " is not defined.");
            throw new JspTagException("CodeListLoader:" + codeList
                    + " is not defined.");
        }

        CodeBean[] codeBeanArray = loader.getCodeBeans();
        if (codeBeanArray == null) {
            // codeBeanListnull̏ꍇ
            if (log.isWarnEnabled()) {
                log.warn("Codebean is null. CodeListLoader(bean id:"
                        + codeList + ")");
            }
            // Ȃ
        } else {
            try {
                // Ɏ擾łꍇ̓R[hXg̒lo͂B
                for (int i = 0; i < codeBeanArray.length; i++) {
                    if (codeKey.equals(codeBeanArray[i].getId())) {
                        out.print(codeBeanArray[i].getName());
                        break;
                    }
                }
                // Ȃ
            } catch (IOException ioe) {
                log.error("", ioe);
                throw new JspTagException(ioe);
            }

        }

        return EVAL_BODY_INCLUDE;
    }

    /**
     * ^O]IɌĂ΂郁\bhB
     *
     * @return wB EVAL_PAGE
     * @throws JspException JSP O
     */
    @Override
    public int doEndTag() throws JspException {
        return EVAL_PAGE;
    }

    /**
     * ^Onh̏B
     */
    @Override
    public void release() {
        super.release();
        this.codeList = null;
        this.key = null;
        this.name = null;
        this.property = null;
        this.scope = null;
    }

}
