/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.thin;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import jp.terasoluna.fw.web.RequestUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ƖǏԂǂ̃`FbNsB
 *
 * <p>
 * ̃NXł̓uEŨNGXgɑ΂tB^A
 * Bean`t@CŎw肳ꂽCӂ{@link BlockageController}CX^X
 * ĂяoA w肳ꂽpXƖǏԂǂ̃`FbNϏB
 * </p>
 *
 * <h5>Ɩǃ`FbN@\</h5>
 * <p>
 * ANZXpXƖǏԂꍇ́A
 * {@link BlockageException} X[B
 * </p>
 * <h5>gp@</h5>
 * <p>
 * ̋@\gpɂ̓fvCgfBXNv^iweb.xmlj
 * Bean`t@CɈȉ̂悤ɐݒ肷B̂ƂABean`t@C
 * `idA sampleBlockageControllerł&lt;bean&gt;vf
 * classɂ́A{@link BlockageController}C^tF[X
 * NXݒ肷B<br>
 * ӂƂāÃtB^pꍇɂ́ANGXgpXƖʂł悤ɂȂĂȂ
 * ȂȂB
 * 
 * </p>
 * fvCgfBXNv^iweb.xmlj
 * <code><pre>
 * &lt;filter&gt;
 *   &lt;filter-name&gt;
 *     blockageControlFilter]
 *   &lt;/filter-name&gt;
 *   &lt;filter-class&gt;
 *       jp.terasoluna.fw.web.thin.BlockageControlFilter
 *   &lt;/filter-class&gt;
 *   &lt;init-param&gt;
 *     &lt;param-name&gt;controller&lt;/param-name&gt;
 *     &lt;param-value&gt;
 *       "sampleBlockageController"
 *     &lt;/param-value&gt;
 *   &lt;/init-param&gt;
 * &lt;/filter&gt;
 *
 * &lt;filter-mapping&gt;
 *   &lt;filter-name&gt;blockageControlFilter&lt;/filter-name&gt;
 *   &lt;url-pattern&gt;/*&lt;/url-pattern&gt;
 * &lt;/filter-mapping&gt;
 *
 * &lt;error-page&gt;
 *   &lt;exception-type&gt;
 *     jp.terasoluna.fw.web.thin.BlockageException
 *   &lt;/exception-type&gt;
 *   &lt;location&gt;
 *     /blockageError.jsp
 *   &lt;/location&gt;
 * &lt;/error-page&gt;
 * </pre></code>
 *
 * Bean`t@C
 * <code><pre>
 * &lt;bean id=&quot;sampleBlockageController&quot;
 *       class=&quot;jp.terasolunacSampleBlockageController&quot; /&gt;
 * </pre></code>
 * 
 * ȂABean`t@Cɒ`&lt;bean&gt;vfidftHglł
 * "blockageController"ɐݒ肷ꍇɂ́A
 * fvCgfBXNv^iweb.xmlj&lt;filter&gt;vf
 * &lt;init-param&gt;vfȗ邱ƂłB
 *
 * @see jp.terasoluna.fw.web.thin.AuthenticationControlFilter
 * @see jp.terasoluna.fw.web.thin.AuthenticationController
 * @see jp.terasoluna.fw.web.thin.AuthorizationControlFilter
 * @see jp.terasoluna.fw.web.thin.AuthorizationController
 * @see jp.terasoluna.fw.web.thin.BlockageController
 * @see jp.terasoluna.fw.web.thin.ServerBlockageControlFilter
 * @see jp.terasoluna.fw.web.thin.ServerBlockageController
 *
 */
public class BlockageControlFilter 
        extends AbstractControlFilter<BlockageController> {
    
    /**
     * NGXgtB^ʉ߂ƂNGXg̃L[B
     */
    public static final String BLOCKAGE_THRU_KEY 
        = "BLOCKAGE_THRU_KEY";   
    
    /**
     * DIReiRg[[̎NX擾邽߂
     * &lt;bean&gt;vfidɎgpftHgidB
     */
    public static final String DEFAULT_BLOCKAGE_BEAN_ID
        = "blockageController";
    
    /**
     * ƖǃRg[̐sG[R[hB
     */
    private static final String BLOCKAGE_CONTROLLER_ERROR 
        = "errors.blockage.controller";

    /**
     * ƖǏϏRg[NXB
     */
    private static final Class BLOCKAGE_CONTROLLER_CLASS 
        = BlockageController.class;
   
    /**
     * ONXB
     */
    private static Log log 
       = LogFactory
           .getLog(BlockageControlFilter.class);

    /**
     * BlockageControllerCX^XB
     */
    protected static BlockageController controller = null;

    /**
     * BlockageControllerCX^X߂B
     *
     * @return ̃tB^ɐݒ肳ĂBlockageControllerCX^X
     */
    public static BlockageController getBlockageController() {
        return controller;
    }
    
    /**
     * tB^T[rXJnԂɂȂۂɁAReiɂČĂяoB 
     * 
     * ReíAFilterCX^XɁAinit\bh
     * 1 񂾂ĂяoB<br>
     * FilterɃtB^Ƃs悤ɗvɂ́A
     * init \bh IĂȂ΂ȂȂB
     * init\bh ̂ꂩ̏Ԃ̏ꍇARei
     * FilterT[rXԂɂłȂB<br>
     * <ul>
     *  <li>ServletException X[B</li>
     *  <li>ReiɂĒ`ꂽԓɁAAȂB</li>
     *  <li>ݒ肳ꂽRg[̎NX݂ȂA 
     *      ܂͐ݒُ펞B</li>
     * </ul>
     * 
     * @param config FilterConfigCX^XB
     * 
     * @throws javax.servlet.ServletException ُ펞ɃX[OB
     *             
     * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
     * @see jp.terasoluna.fw.web.thin.AbstractControlFilter
     */
    @Override
    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        if (controller == null) {
            controller = getController();
        }
    }

    /**
     * Ɩǃ`FbNsB
     *
     * @param req HTTPNGXg
     * @param res HTTPX|X
     * @param chain tB^`F[
     *
     * @throws IOException I/OG[
     * @throws ServletException T[ubgO
     *
     * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)
     */
    @Override
    public void doFilter(ServletRequest req,
                         ServletResponse res,
                         FilterChain chain)
            throws IOException, 
                   ServletException {

        // NGXgtB^ʉ߂ǂ𔻒B
        if (req.getAttribute(BLOCKAGE_THRU_KEY) == null) {

            // tB^̒ʉߏZbg
            req.setAttribute(BLOCKAGE_THRU_KEY, "true");

            if (controller.isCheckRequired(req)) {
                // Ɩǃ`FbN
                if (controller
                    .isBlockaded(RequestUtil.getPathInfo(req), req)) {
                    if (log.isDebugEnabled()) {
                        log.debug("isBlockaded() failed.");
                    }
                    throw new BlockageException();
                }
            }
        }

        // ̃tB^܂̓T[ubg
        chain.doFilter(req, res);

    }

    /**
     * ANZXsNXׂC^tF[XԂB
     * 
     * @return ̃tB^ŎgpRg[̃NX
     */
    @Override
    protected Class getControllerClass() {
        return BLOCKAGE_CONTROLLER_CLASS;
    }

    /**
     * Rg[̐sG[R[hԂB
     * 
     * @return G[R[h
     */
    @Override
    protected String getErrorCode() {
        return BLOCKAGE_CONTROLLER_ERROR;
    }

    /**
     * DIReiRg[擾ۂ̃ftHgidԂB
     * 
     * @return ftHgidl
     */
    @Override
    public String getDefaultControllerBeanId() {
        return DEFAULT_BLOCKAGE_BEAN_ID;
    }
    
}
