/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.tutorial.web.usermanager.blogic;

import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.thin.tutorial.web.usermanager.dto.InsertInput;
import jp.terasoluna.thin.tutorial.web.usermanager.exception.InsertException;
import jp.terasoluna.thin.tutorial.web.usermanager.vo.SelectUserOutput;

/**
 * o^srWlXWbNB
 *
 */
public class InsertBLogic implements BLogic<InsertInput> {

    /**
     * QueryDAOB
     * SpringɂCX^Xݒ肳B
     */
    private QueryDAO queryDAO = null;
    
    /**
     * UpdateDAOB
     * SpringɂCX^Xݒ肳B
     */
    private UpdateDAO updateDAO = null;
    
    /**
     * o^sB
     */
    public BLogicResult execute(InsertInput param) {
        BLogicResult result = new BLogicResult();
            
        SelectUserOutput selectUserOutput 
            = queryDAO.executeForObject("getUser", param, SelectUserOutput.class);
        
        //o^IDdĂꍇُ͈폈
        if(selectUserOutput != null) {
            
            //G[bZ[W
            BLogicMessages messages = new BLogicMessages();
            messages.add("message",
                    new BLogicMessage("errors.input.id.repeat"));
            result.setErrors(messages);
            
            result.setResultString("failure");
            return result;
        }
        
        //o^
        updateDAO.execute("insertUser", param);
        
        //bZ[W
        BLogicMessages messages = new BLogicMessages();
        messages.add("message",
                new BLogicMessage("message.regist",param.getId()));
        result.setMessages(messages);
        result.setResultString("success");
        
        return result;
        
        //ƖOX[
        //throw new InsertException();
    }

    /**
     * QueryDAOݒ肷B
     * @param queryDAO
     */
    public void setQueryDAO(QueryDAO queryDAO) {
        this.queryDAO = queryDAO;
    }

    /**
     * UpdateDAOݒ肷B
     * @param updateDAO
     */
    public void setUpdateDAO(UpdateDAO updateDAO) {
        this.updateDAO = updateDAO;
    }

}
