/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.util.condition.collection;

import java.lang.reflect.Array;
import java.util.Collection;
import org.springframework.util.Assert;
import org.springmodules.validation.util.condition.collection.AbstractCollectionCondition;

public class MinSizeCollectionCondition
extends AbstractCollectionCondition {
    private int minSize;

    public MinSizeCollectionCondition(int minSize) {
        Assert.isTrue((minSize >= 0 ? 1 : 0) != 0, (String)"Min size cannot be negative");
        this.minSize = minSize;
    }

    protected boolean checkArray(Object array) {
        return Array.getLength(array) >= this.minSize;
    }

    protected boolean checkCollection(Collection collection) {
        return collection.size() >= this.minSize;
    }

    public int getMinSize() {
        return this.minSize;
    }
}

