/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.exception.handler;

import java.util.Map;
import java.util.Set;
import jp.terasoluna.fw.batch.exception.handler.ExceptionHandler;
import jp.terasoluna.fw.logger.TLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExceptionHandler
implements ExceptionHandler {
    private static final TLogger LOGGER = TLogger.getLogger(DefaultExceptionHandler.class);
    protected static final int DEFAULT_EXCEPTION_HANDLER_STATUS = 255;
    protected Map<Class<? extends Throwable>, Integer> exceptionToStatusMap = null;

    public void setExceptionToStatusMap(Map<Class<? extends Throwable>, Integer> exceptionToStatusMap) {
        this.exceptionToStatusMap = exceptionToStatusMap;
    }

    @Override
    public int handleThrowableException(Throwable e) {
        LOGGER.warn("WAL025007", e);
        if (this.exceptionToStatusMap != null && e != null) {
            Class<?> exClass = e.getClass();
            Set<Map.Entry<Class<? extends Throwable>, Integer>> es = this.exceptionToStatusMap.entrySet();
            for (Map.Entry<Class<? extends Throwable>, Integer> ent : es) {
                Class<? extends Throwable> entClass;
                if (ent == null || ent.getKey() == null || ent.getValue() == null || !(entClass = ent.getKey()).isAssignableFrom(exClass)) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("DAL025017", new Object[]{exClass.getName(), entClass.getName(), ent.getValue()});
                }
                return ent.getValue();
            }
        }
        return 255;
    }
}

