/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.executor;

import java.beans.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jp.terasoluna.fw.batch.annotation.JobComponent;
import jp.terasoluna.fw.batch.annotation.util.GenericBeanFactoryAccessorEx;
import jp.terasoluna.fw.batch.blogic.BLogic;
import jp.terasoluna.fw.batch.blogic.vo.BLogicParam;
import jp.terasoluna.fw.batch.exception.handler.ExceptionHandler;
import jp.terasoluna.fw.batch.executor.BatchExecutor;
import jp.terasoluna.fw.batch.executor.ThreadGroupApplicationContextHolder;
import jp.terasoluna.fw.batch.executor.vo.BLogicResult;
import jp.terasoluna.fw.batch.executor.vo.BatchJobData;
import jp.terasoluna.fw.batch.message.MessageAccessor;
import jp.terasoluna.fw.batch.util.MessageUtil;
import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.logger.TLogger;
import jp.terasoluna.fw.util.PropertyUtil;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class AbstractBatchExecutor
implements BatchExecutor {
    private static final TLogger LOGGER = TLogger.getLogger(AbstractBatchExecutor.class);
    protected static final String ENV_JOB_SEQ_ID = "JOB_SEQ_ID";
    protected static final String ENV_JOB_APP_CD = "JOB_APP_CD";
    protected static final String ENV_JOB_BEAN_DEFINITION_PATH = "JOB_BEAN_DEFINITION_PATH";
    protected static final int ENV_JOB_ARG_MAX = 20;
    protected static final String ENV_JOB_ARG_NM = "JOB_ARG_NM";
    protected static final String ENV_JOB_ARG_NM1 = "JOB_ARG_NM1";
    protected static final String ENV_JOB_ARG_NM2 = "JOB_ARG_NM2";
    protected static final String ENV_JOB_ARG_NM3 = "JOB_ARG_NM3";
    protected static final String ENV_JOB_ARG_NM4 = "JOB_ARG_NM4";
    protected static final String ENV_JOB_ARG_NM5 = "JOB_ARG_NM5";
    protected static final String ENV_JOB_ARG_NM6 = "JOB_ARG_NM6";
    protected static final String ENV_JOB_ARG_NM7 = "JOB_ARG_NM7";
    protected static final String ENV_JOB_ARG_NM8 = "JOB_ARG_NM8";
    protected static final String ENV_JOB_ARG_NM9 = "JOB_ARG_NM9";
    protected static final String ENV_JOB_ARG_NM10 = "JOB_ARG_NM10";
    protected static final String ENV_JOB_ARG_NM11 = "JOB_ARG_NM11";
    protected static final String ENV_JOB_ARG_NM12 = "JOB_ARG_NM12";
    protected static final String ENV_JOB_ARG_NM13 = "JOB_ARG_NM13";
    protected static final String ENV_JOB_ARG_NM14 = "JOB_ARG_NM14";
    protected static final String ENV_JOB_ARG_NM15 = "JOB_ARG_NM15";
    protected static final String ENV_JOB_ARG_NM16 = "JOB_ARG_NM16";
    protected static final String ENV_JOB_ARG_NM17 = "JOB_ARG_NM17";
    protected static final String ENV_JOB_ARG_NM18 = "JOB_ARG_NM18";
    protected static final String ENV_JOB_ARG_NM19 = "JOB_ARG_NM19";
    protected static final String ENV_JOB_ARG_NM20 = "JOB_ARG_NM20";
    protected static final String ENV_BLOGIC_APP_STATUS = "BLOGIC_APP_STATUS";
    protected static final String ENV_CUR_APP_STATUS = "CUR_APP_STATUS";
    protected static final String SYSTEM_DATASOURCE_QUERY_DAO = "systemDataSource.queryDAO";
    protected static final String SYSTEM_DATASOURCE_UPDATE_DAO = "systemDataSource.updateDAO";
    protected static final String SYSTEM_DATASOURCE_TRANSACTION_MANAGER = "systemDataSource.transactionManager";
    protected static final String BEAN_DEFINITION_ADMIN_CLASSPATH_KEY = "beanDefinition.admin.classpath";
    protected static final String BEAN_DEFINITION_DEFAULT = "beanDefinition.admin.default";
    protected static final String BEAN_DEFINITION_DATASOURCE = "beanDefinition.admin.dataSource";
    protected static final String BEAN_DEFINITION_BUSINESS_CLASSPATH_KEY = "beanDefinition.business.classpath";
    protected static final String PROPERTY_BEAN_FILENAME_SUFFIX = ".xml";
    protected static final String BEAN_MESSAGE_ACCESSOR_DEFAULT = "messageAccessor.default";
    protected static final String DEFAULT_BLOGIC_BEAN_NAME_SUFFIX = "BLogic";
    protected static final String DEFAULT_BLOGIC_EXCEPTION_HANDLER_BEAN_NAME_SUFFIX = "ExceptionHandler";
    protected static final String DEFAULT_BLOGIC_EXCEPTION_HANDLER_BEAN_NAME = "defaultExceptionHandler";
    protected static final String APPLICATION_CONTEXT = "org.springframework.context.support.ClassPathXmlApplicationContext";
    protected static final String REPLACE_STRING_PREFIX = "\\$\\{";
    protected static final String REPLACE_STRING_SUFFIX = "\\}";
    protected static final String REPLACE_STRING_JOB_APP_CD = "jobAppCd";
    protected static final String REPLACE_STRING_JOB_APP_CD_UPPER = "jobAppCdUpper";
    protected static final String REPLACE_STRING_JOB_APP_CD_LOWER = "jobAppCdLower";
    protected static final String REPLACE_STRING_JOB_ARG = "jobArg";
    protected static final int REPLACE_STRING_JOB_ARG_MAX = 20;
    protected static final int ARGUMENT_COUNT = 20;
    protected static final String FIELD_JOB_ARG = "JobArgNm";
    protected static ClassLoader cl = null;
    protected QueryDAO sysQueryDAO = null;
    protected UpdateDAO sysUpdateDAO = null;
    protected PlatformTransactionManager sysTransactionManager = null;
    protected ApplicationContext defaultApplicationContext = null;

    protected AbstractBatchExecutor() {
        this.init();
    }

    protected void init() {
        this.initDefaultAppContext();
        this.initSystemDatasourceDao();
        this.initDefaultErrorMessage();
    }

    protected void initDefaultAppContext() {
        String defaultAppContextName = AbstractBatchExecutor.getDefaultBeanFileName();
        if (defaultAppContextName == null || "".equals(defaultAppContextName)) {
            LOGGER.error("EAL025003");
            return;
        }
        this.defaultApplicationContext = AbstractBatchExecutor.getApplicationContext(defaultAppContextName);
        if (this.defaultApplicationContext == null) {
            LOGGER.error("EAL025004", new Object[]{defaultAppContextName});
            return;
        }
    }

    protected void initSystemDatasourceDao() {
    }

    protected void initDefaultErrorMessage() {
        if (this.defaultApplicationContext == null) {
            return;
        }
        String value = PropertyUtil.getProperty((String)BEAN_MESSAGE_ACCESSOR_DEFAULT);
        if (value == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("WAL025001", new Object[]{value, this.getThreadMessage()});
            }
            return;
        }
        if (this.defaultApplicationContext.containsBean(value)) {
            MessageAccessor messageAccessor;
            block12: {
                messageAccessor = null;
                try {
                    messageAccessor = (MessageAccessor)this.defaultApplicationContext.getBean(value, MessageAccessor.class);
                }
                catch (Throwable e) {
                    if (!LOGGER.isWarnEnabled()) break block12;
                    LOGGER.warn("WAL025001", new Object[]{value, this.getThreadMessage()});
                }
            }
            if (messageAccessor != null) {
                MessageUtil.setMessageAccessor(messageAccessor);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("TAL025001", new Object[]{this.getThreadMessage()});
                }
            } else if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("TAL025009", new Object[]{this.getThreadMessage()});
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("WAL025001", new Object[]{value, this.getThreadMessage()});
        }
    }

    protected String getThreadMessage() {
        StringBuilder sb = new StringBuilder();
        Thread ct = Thread.currentThread();
        if (ct != null && ct.getThreadGroup() != null) {
            sb.append(" tg:[");
            sb.append(ct.getThreadGroup().getName());
            sb.append("]");
        }
        if (ct != null) {
            sb.append(" t:[");
            sb.append(ct.getName());
            sb.append("]");
        }
        return sb.toString();
    }

    protected ApplicationContext initJobAppContext(String jobAppCd, BatchJobData jobRecord) {
        ApplicationContext context = null;
        String beanFileName = null;
        beanFileName = this.getBeanFileName(jobAppCd, jobRecord);
        LOGGER.debug("DAL025018", new Object[]{beanFileName});
        if (beanFileName != null && 0 < beanFileName.length()) {
            context = AbstractBatchExecutor.getApplicationContext(beanFileName);
            if (context == null) {
                LOGGER.error("EAL025006", new Object[]{beanFileName});
            }
            LOGGER.debug("DAL025019");
        }
        return context;
    }

    protected void closeApplicationContext(ApplicationContext context) {
        MessageUtil.removeMessageAccessor();
        if (context instanceof AbstractApplicationContext) {
            AbstractApplicationContext aac = (AbstractApplicationContext)context;
            aac.close();
            aac.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BLogicResult executeBatch(BatchJobData jobRecord) {
        BLogicResult result = new BLogicResult();
        BLogicParam param = this.convertBLogicParam(jobRecord);
        if (param == null) {
            return result;
        }
        LOGGER.debug("DAL025044", new Object[]{param});
        String jobAppCd = jobRecord.getJobAppCd();
        String blogicBeanName = this.getBlogicBeanName(jobAppCd);
        if (blogicBeanName == null || blogicBeanName.length() == 0) {
            LOGGER.error("EAL025007", new Object[]{jobRecord.getJobAppCd()});
            return result;
        }
        String exceptionHandlerBeanName = this.getExceptionHandlerBeanName(jobAppCd);
        if (exceptionHandlerBeanName == null || exceptionHandlerBeanName.length() == 0) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("EAL025007", new Object[]{jobRecord.getJobAppCd()});
            }
            return result;
        }
        ApplicationContext context = this.initJobAppContext(jobAppCd, jobRecord);
        ThreadGroupApplicationContextHolder.setApplicationContext(context);
        try {
            if (blogicBeanName != null && 0 < blogicBeanName.length()) {
                result = this.executeBatchClass(blogicBeanName, exceptionHandlerBeanName, param, context);
            }
        }
        finally {
            ThreadGroupApplicationContextHolder.removeApplicationContext();
            this.closeApplicationContext(context);
        }
        return result;
    }

    protected BLogicParam convertBLogicParam(BatchJobData jobRecord) {
        BLogicParam param = new BLogicParam();
        param.setJobSequenceId(jobRecord.getJobSequenceId());
        param.setJobAppCd(jobRecord.getJobAppCd());
        boolean ret = this.argumentCopy(jobRecord, param, FIELD_JOB_ARG);
        if (!ret) {
            return null;
        }
        return param;
    }

    protected static String getDefaultBeanFileName() {
        StringBuilder str = new StringBuilder();
        String classpath = PropertyUtil.getProperty((String)BEAN_DEFINITION_ADMIN_CLASSPATH_KEY);
        String beanFileName = PropertyUtil.getProperty((String)BEAN_DEFINITION_DEFAULT);
        str.append(classpath == null ? "" : classpath);
        str.append(beanFileName == null ? "" : beanFileName);
        LOGGER.debug("DAL025020", new Object[]{str});
        return str.toString();
    }

    protected static String getDataSourceBeanFileName() {
        StringBuilder str = new StringBuilder();
        String classpath = PropertyUtil.getProperty((String)BEAN_DEFINITION_ADMIN_CLASSPATH_KEY);
        String beanFileName = PropertyUtil.getProperty((String)BEAN_DEFINITION_DATASOURCE);
        str.append(classpath == null ? "" : classpath);
        str.append(beanFileName == null ? "" : beanFileName);
        LOGGER.debug("DAL025020", new Object[]{str});
        return str.toString();
    }

    protected BLogicResult executeBatchClass(String blogicBeanName, String exceptionHandlerBeanName, BLogicParam param, ApplicationContext context) {
        BLogicResult result;
        block22: {
            result = new BLogicResult();
            BLogic blogic = null;
            ExceptionHandler exceptionHandler = null;
            String findBlogicBeanName = null;
            if (context == null) {
                LOGGER.error("EAL025008");
                return result;
            }
            GenericBeanFactoryAccessorEx gbfa = new GenericBeanFactoryAccessorEx((ListableBeanFactory)context);
            Map<String, Object> jobMap = gbfa.getBeansWithAnnotation(JobComponent.class);
            if (param != null) {
                Set<Map.Entry<String, Object>> jobEs = jobMap.entrySet();
                for (Map.Entry<String, Object> jobEnt : jobEs) {
                    JobComponent jobComp;
                    Object jobObj = jobEnt.getValue();
                    if (jobObj == null || (jobComp = jobObj.getClass().getAnnotation(JobComponent.class)) == null || !param.getJobAppCd().equals(jobComp.jobId())) continue;
                    findBlogicBeanName = jobEnt.getKey();
                    break;
                }
            }
            if (findBlogicBeanName == null) {
                if (context.containsBean(blogicBeanName)) {
                    findBlogicBeanName = blogicBeanName;
                } else if (context.containsBean(Introspector.decapitalize(blogicBeanName))) {
                    findBlogicBeanName = Introspector.decapitalize(blogicBeanName);
                }
            }
            if (findBlogicBeanName != null) {
                try {
                    blogic = (BLogic)context.getBean(findBlogicBeanName, BLogic.class);
                }
                catch (Throwable e) {
                    LOGGER.error("EAL025009", new Object[]{blogicBeanName});
                    return result;
                }
            }
            if (blogic == null) {
                LOGGER.error("EAL025009", new Object[]{blogicBeanName});
                return result;
            }
            String findExceptionHandlerBeanName = null;
            if (context.containsBean(exceptionHandlerBeanName)) {
                findExceptionHandlerBeanName = exceptionHandlerBeanName;
            } else if (context.containsBean(Introspector.decapitalize(exceptionHandlerBeanName))) {
                findExceptionHandlerBeanName = Introspector.decapitalize(exceptionHandlerBeanName);
            }
            if (findExceptionHandlerBeanName != null) {
                try {
                    exceptionHandler = (ExceptionHandler)context.getBean(findExceptionHandlerBeanName, ExceptionHandler.class);
                }
                catch (Throwable e) {
                    LOGGER.trace("TAL025002", e, new Object[]{exceptionHandlerBeanName});
                }
            }
            if (exceptionHandler == null && context.containsBean(this.getDefaultExceptionHandlerBeanName())) {
                try {
                    exceptionHandler = (ExceptionHandler)context.getBean(this.getDefaultExceptionHandlerBeanName(), ExceptionHandler.class);
                }
                catch (Throwable e) {
                    LOGGER.trace("TAL025002", e, new Object[]{exceptionHandlerBeanName});
                }
            }
            try {
                int blogicStatus = blogic.execute(param);
                result.setBlogicStatus(blogicStatus);
            }
            catch (Throwable e) {
                if (exceptionHandler == null) break block22;
                result.setBlogicStatus(exceptionHandler.handleThrowableException(e));
            }
        }
        return result;
    }

    protected boolean argumentCopy(Object from, Object to, String field) {
        for (int i = 1; i <= 20; ++i) {
            StringBuilder getterName = new StringBuilder();
            getterName.append("get");
            getterName.append(field);
            getterName.append(i);
            String argument = (String)this.getMethod(from, getterName.toString());
            if (argument == null) continue;
            StringBuilder setterName = new StringBuilder();
            setterName.append("set");
            setterName.append(field);
            setterName.append(i);
            boolean ret = this.setMethod(to, setterName.toString(), argument);
            if (ret) continue;
            return ret;
        }
        return true;
    }

    protected boolean setMethod(Object obj, String methodName, String argument) {
        if (obj == null) {
            LOGGER.error("EAL025010");
            return false;
        }
        try {
            Method method = obj.getClass().getMethod(methodName, String.class);
            method.invoke(obj, argument);
        }
        catch (SecurityException e) {
            LOGGER.error("EAL025011", (Throwable)e);
            return false;
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("EAL025011", (Throwable)e);
            return false;
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("EAL025011", (Throwable)e);
            return false;
        }
        catch (InvocationTargetException e) {
            LOGGER.error("EAL025011", (Throwable)e);
            return false;
        }
        catch (IllegalAccessException e) {
            LOGGER.error("EAL025011", (Throwable)e);
            return false;
        }
        return true;
    }

    protected Object getMethod(Object obj, String methodName) {
        Method method = null;
        Object result = null;
        if (obj == null) {
            LOGGER.error("EAL025010");
            return null;
        }
        try {
            method = obj.getClass().getMethod(methodName, new Class[0]);
            result = method.invoke(obj, new Object[0]);
        }
        catch (SecurityException e) {
            LOGGER.error("EAL025012", (Throwable)e);
            return null;
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("EAL025012", (Throwable)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("EAL025012", (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            LOGGER.error("EAL025012", (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            LOGGER.error("EAL025012", (Throwable)e);
            return null;
        }
        return result;
    }

    protected static ApplicationContext getApplicationContext(String ... batchBeanFileName) {
        ApplicationContext ctx = null;
        Class<?> clazz = null;
        Constructor<?> constructor = null;
        try {
            clazz = cl.loadClass(APPLICATION_CONTEXT);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("EAL025013", (Throwable)e);
            return null;
        }
        try {
            Class[] arrClass = new Class[]{String[].class};
            constructor = clazz.getConstructor(arrClass);
        }
        catch (SecurityException e) {
            LOGGER.error("EAL025014", (Throwable)e);
            return null;
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("EAL025015", (Throwable)e);
            return null;
        }
        try {
            Object[] array = new Object[]{batchBeanFileName};
            ctx = (ApplicationContext)constructor.newInstance(array);
            return ctx;
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("WAL025002", (Throwable)e);
        }
        catch (InstantiationException e) {
            LOGGER.warn("WAL025002", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("WAL025002", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOGGER.warn("WAL025002", (Throwable)e);
        }
        catch (RuntimeException e) {
            LOGGER.warn("WAL025002", (Throwable)e);
        }
        return ctx;
    }

    protected String getBeanFileName(String jobAppCd, BatchJobData jobRecord) {
        StringBuilder str = new StringBuilder();
        String classpath = PropertyUtil.getProperty((String)BEAN_DEFINITION_BUSINESS_CLASSPATH_KEY);
        str.append((classpath = this.replaceString(classpath, jobAppCd, jobRecord)) == null ? "" : classpath);
        str.append(jobAppCd == null ? "" : jobAppCd);
        str.append(PROPERTY_BEAN_FILENAME_SUFFIX);
        return str.toString();
    }

    protected String replaceString(String value, String jobAppCd, BatchJobData jobRecord) {
        String result = value;
        if (result != null && jobAppCd != null && result.length() != 0 && jobAppCd.length() != 0) {
            HashMap<String, String> kv = new HashMap<String, String>();
            StringBuilder sb = new StringBuilder();
            StringBuilder sb2 = new StringBuilder();
            sb.setLength(0);
            sb.append(REPLACE_STRING_PREFIX);
            sb.append(REPLACE_STRING_JOB_APP_CD);
            sb.append(REPLACE_STRING_SUFFIX);
            kv.put(sb.toString(), jobAppCd);
            sb.setLength(0);
            sb.append(REPLACE_STRING_PREFIX);
            sb.append(REPLACE_STRING_JOB_APP_CD_UPPER);
            sb.append(REPLACE_STRING_SUFFIX);
            kv.put(sb.toString(), jobAppCd.toUpperCase());
            sb.setLength(0);
            sb.append(REPLACE_STRING_PREFIX);
            sb.append(REPLACE_STRING_JOB_APP_CD_LOWER);
            sb.append(REPLACE_STRING_SUFFIX);
            kv.put(sb.toString(), jobAppCd.toLowerCase());
            for (int i = 1; i <= 20; ++i) {
                sb.setLength(0);
                sb.append(REPLACE_STRING_PREFIX);
                sb.append(REPLACE_STRING_JOB_ARG);
                sb.append(i);
                sb.append(REPLACE_STRING_SUFFIX);
                sb2.setLength(0);
                sb2.append("get");
                sb2.append(FIELD_JOB_ARG);
                sb2.append(i);
                kv.put(sb.toString(), (String)this.getMethod(jobRecord, sb2.toString()));
            }
            for (Map.Entry et : kv.entrySet()) {
                result = result.replaceAll((String)et.getKey(), (String)et.getValue());
            }
        }
        return result;
    }

    protected String getBlogicBeanName(String jobAppCd) {
        StringBuilder str = new StringBuilder();
        if (jobAppCd != null && jobAppCd.length() != 0) {
            str.append(jobAppCd);
            str.append(DEFAULT_BLOGIC_BEAN_NAME_SUFFIX);
        }
        return str.toString();
    }

    protected String getExceptionHandlerBeanName(String jobAppCd) {
        StringBuilder str = new StringBuilder();
        if (jobAppCd != null && jobAppCd.length() != 0) {
            str.append(jobAppCd);
            str.append(DEFAULT_BLOGIC_EXCEPTION_HANDLER_BEAN_NAME_SUFFIX);
        }
        return str.toString();
    }

    protected String getDefaultExceptionHandlerBeanName() {
        return DEFAULT_BLOGIC_EXCEPTION_HANDLER_BEAN_NAME;
    }

    protected ApplicationContext getDefaultApplicationContext() {
        return this.defaultApplicationContext;
    }

    public QueryDAO getSysQueryDAO() {
        return this.sysQueryDAO;
    }

    public UpdateDAO getSysUpdateDAO() {
        return this.sysUpdateDAO;
    }

    public PlatformTransactionManager getSysTransactionManager() {
        return this.sysTransactionManager;
    }

    static {
        cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            LOGGER.error("EAL025002");
        }
    }
}

