/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.collector;

import java.beans.Introspector;
import java.io.Closeable;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import jp.terasoluna.fw.collector.Collector;
import jp.terasoluna.fw.collector.CollectorThreadFactory;
import jp.terasoluna.fw.collector.exception.CollectorExceptionHandler;
import jp.terasoluna.fw.collector.exception.CollectorExceptionHandlerStatus;
import jp.terasoluna.fw.collector.util.CollectorUtility;
import jp.terasoluna.fw.collector.validate.ValidateErrorStatus;
import jp.terasoluna.fw.collector.validate.ValidationErrorHandler;
import jp.terasoluna.fw.collector.vo.DataValueObject;
import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.logger.TLogger;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollector<P>
implements Collector<P>,
Closeable,
Callable<Integer>,
Cloneable {
    private static final TLogger LOGGER = TLogger.getLogger(AbstractCollector.class);
    public static final int DEFAULT_QUEUE_SIZE = 20;
    protected static final int DEFAULT_SLEEP_WAIT = 1;
    protected static final int CURRENT_QUEUE_CHECK_SIZE = 1;
    protected static final int PREVIOUS_QUEUE_CHECK_SIZE = 2;
    protected static AtomicBoolean verboseLog = new AtomicBoolean(false);
    protected int queueSize = 20;
    protected int sleepWait = 1;
    protected Queue<DataValueObject> queue = null;
    protected Queue<DataValueObject> currentQueue = null;
    protected Queue<DataValueObject> previousQueue = null;
    protected volatile Future<?> fo = null;
    protected volatile boolean finish = false;
    protected volatile boolean beginning = false;
    protected Validator validator = null;
    protected ValidationErrorHandler validationErrorHandler = null;
    protected CollectorExceptionHandler exceptionHandler = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() {
        if (this.beginning) {
            return;
        }
        AbstractCollector abstractCollector = this;
        synchronized (abstractCollector) {
            if (!this.beginning) {
                if (this.queue == null) {
                    this.queue = this.createQueue();
                }
                if (this.fo == null) {
                    Callable callable = null;
                    try {
                        callable = (Callable)this.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        SystemException exception = new SystemException((Throwable)e);
                        exception.setMessage("The clone cannot be made.");
                        throw exception;
                    }
                    ExecutorService ex = this.getExecutor();
                    try {
                        this.fo = ex.submit(callable);
                    }
                    catch (Throwable e) {
                        SystemException exception = new SystemException(e);
                        exception.setMessage("The thread cannot be started.");
                        throw exception;
                    }
                    finally {
                        ex.shutdown();
                    }
                }
                this.beginning = true;
            }
        }
    }

    @Override
    public boolean hasNext() {
        this.execute();
        while (true) {
            if (this.queue != null && !this.queue.isEmpty()) {
                return true;
            }
            if (this.fo != null && this.fo.isDone()) {
                if (!verboseLog.get()) break;
                LOGGER.trace("TAL041005");
                break;
            }
            try {
                if (verboseLog.get()) {
                    LOGGER.trace("TAL041006", new Object[]{this.sleepWait});
                }
                Thread.sleep(this.sleepWait);
            }
            catch (InterruptedException e) {
                LOGGER.warn("WAL041003", (Throwable)e);
                break;
            }
        }
        return false;
    }

    @Override
    public P next() {
        this.execute();
        P pn = this.getNext();
        if (pn != null) {
            if (this.previousQueue != null) {
                while (this.previousQueue.size() > 2) {
                    this.previousQueue.remove();
                }
                this.previousQueue.add(new DataValueObject(pn));
            }
            if (this.currentQueue != null) {
                while (this.currentQueue.size() > 1) {
                    this.currentQueue.remove();
                }
                this.currentQueue.add(new DataValueObject(pn));
            }
        }
        DataValueObject value = null;
        do {
            block22: {
                if (this.queue instanceof BlockingQueue) {
                    try {
                        value = (DataValueObject)((BlockingQueue)this.queue).poll(this.sleepWait, TimeUnit.MILLISECONDS);
                        break block22;
                    }
                    catch (InterruptedException e) {
                        LOGGER.warn("WAL041003", (Throwable)e);
                        break;
                    }
                }
                if (this.queue != null) {
                    value = this.queue.poll();
                }
            }
            if (this.fo != null && this.fo.isDone()) break;
            if (value != null || !verboseLog.get() || !LOGGER.isTraceEnabled()) continue;
            LOGGER.trace("TAL041007", new Object[]{this.queue.size()});
        } while (value == null);
        if (value == null) {
            return null;
        }
        if (value.getValue() == null) {
            if (value.getValidateStatus() != null) {
                if (ValidateErrorStatus.END.equals((Object)value.getValidateStatus())) {
                    this.close();
                }
            } else if (value.getThrowable() != null) {
                Throwable throwable = value.getThrowable();
                CollectorExceptionHandlerStatus es = null;
                if (this.exceptionHandler != null) {
                    try {
                        es = this.handleException(value);
                    }
                    catch (Throwable e) {
                        LOGGER.warn("WAL041004", e);
                    }
                }
                if (es == null || CollectorExceptionHandlerStatus.THROW.equals((Object)es)) {
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    throw new SystemException(throwable);
                }
                if (CollectorExceptionHandlerStatus.END.equals((Object)es)) {
                    this.close();
                }
            }
            return null;
        }
        return (P)value.getValue();
    }

    @Override
    public P getNext() {
        this.execute();
        DataValueObject value = null;
        do {
            if (this.queue != null) {
                value = this.queue.peek();
            }
            if (this.fo != null && this.fo.isDone()) break;
            if (value != null) continue;
            try {
                Thread.sleep(this.sleepWait);
            }
            catch (InterruptedException e) {
                LOGGER.warn("WAL041003", (Throwable)e);
                break;
            }
            if (!verboseLog.get() || !LOGGER.isTraceEnabled()) continue;
            LOGGER.trace("TAL041008", new Object[]{this.queue.size()});
        } while (value == null);
        if (value == null) {
            return null;
        }
        if (value.getValue() == null) {
            return null;
        }
        return (P)value.getValue();
    }

    @Override
    public P getPrevious() {
        this.execute();
        if (this.previousQueue != null && this.previousQueue.size() > 1) {
            while (this.previousQueue.size() > 2) {
                this.previousQueue.remove();
            }
            DataValueObject dvo = this.previousQueue.peek();
            if (dvo != null) {
                return (P)dvo.getValue();
            }
        }
        return null;
    }

    @Override
    public P getCurrent() {
        this.execute();
        if (this.currentQueue != null && this.currentQueue.size() > 0) {
            while (this.currentQueue.size() > 1) {
                this.currentQueue.remove();
            }
            DataValueObject dvo = this.currentQueue.peek();
            if (dvo != null) {
                return (P)dvo.getValue();
            }
        }
        return null;
    }

    @Override
    public void close() {
        if (this.fo != null) {
            if (!this.fo.isDone()) {
                this.fo.cancel(true);
            }
            while (true) {
                if (this.fo.isDone()) {
                    if (!verboseLog.get() || !LOGGER.isTraceEnabled()) break;
                    LOGGER.trace("TAL041009", new Object[]{Thread.currentThread().getName()});
                    break;
                }
                try {
                    if (verboseLog.get() && LOGGER.isTraceEnabled()) {
                        LOGGER.trace("TAL041010", new Object[]{this.sleepWait, Thread.currentThread().getName()});
                    }
                    Thread.sleep(this.sleepWait);
                }
                catch (InterruptedException e) {
                    LOGGER.warn("WAL041003", (Throwable)e);
                    break;
                }
            }
        }
    }

    @Override
    public void remove() {
        this.next();
    }

    protected void finalize() throws Throwable {
        if (verboseLog.get() && LOGGER.isTraceEnabled()) {
            LOGGER.trace("TAL041011", new Object[]{Thread.currentThread().getName()});
        }
        super.finalize();
        this.close();
    }

    @Override
    public Iterator<P> iterator() {
        return this;
    }

    protected ExecutorService getExecutor() {
        return Executors.newSingleThreadExecutor(new CollectorThreadFactory());
    }

    protected Queue<DataValueObject> createQueue() {
        if (this.currentQueue == null) {
            this.currentQueue = this.createCurrentQueue();
        }
        if (this.previousQueue == null) {
            this.previousQueue = this.createPreviousQueue();
        }
        return new ArrayBlockingQueue<DataValueObject>(this.queueSize);
    }

    protected Queue<DataValueObject> createCurrentQueue() {
        return new ConcurrentLinkedQueue<DataValueObject>();
    }

    protected Queue<DataValueObject> createPreviousQueue() {
        return new ConcurrentLinkedQueue<DataValueObject>();
    }

    protected Queue<DataValueObject> getQueue() {
        return this.queue;
    }

    protected void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    protected int getSleepWait() {
        return this.sleepWait;
    }

    protected void setSleepWait(int sleepWait) {
        this.sleepWait = sleepWait;
    }

    protected void addQueue(DataValueObject dataValueObject) throws InterruptedException {
        if (!this.isFinish()) {
            ValidateErrorStatus vs = null;
            if (this.validator != null) {
                try {
                    vs = this.validate(dataValueObject);
                }
                catch (Throwable e) {
                    if (this.queue instanceof BlockingQueue) {
                        ((BlockingQueue)this.queue).put(new DataValueObject(e));
                    } else {
                        this.queue.add(new DataValueObject(e));
                    }
                    return;
                }
            }
            if (vs == null || ValidateErrorStatus.CONTINUE.equals((Object)vs)) {
                if (this.queue instanceof BlockingQueue) {
                    ((BlockingQueue)this.queue).put(dataValueObject);
                } else {
                    this.queue.add(dataValueObject);
                }
            } else if (ValidateErrorStatus.END.equals((Object)vs)) {
                this.setFinish();
                DataValueObject errorStop = new DataValueObject(vs);
                if (this.queue instanceof BlockingQueue) {
                    ((BlockingQueue)this.queue).put(errorStop);
                } else {
                    this.queue.add(errorStop);
                }
            }
        }
    }

    protected ValidateErrorStatus validate(DataValueObject dataValueObject) {
        ValidateErrorStatus vs = ValidateErrorStatus.CONTINUE;
        if (this.validator != null) {
            Class<?> clazz = null;
            String objectName = null;
            BindException errors = null;
            if (dataValueObject != null && dataValueObject.getValue() != null && (clazz = dataValueObject.getValue().getClass()) != null && (objectName = clazz.getSimpleName()) != null) {
                objectName = Introspector.decapitalize(objectName);
                errors = new BindException(dataValueObject.getValue(), objectName);
            }
            if (clazz != null && errors != null && this.validator.supports(clazz)) {
                this.validator.validate(dataValueObject.getValue(), errors);
                if (errors.hasErrors()) {
                    vs = this.handleValidationError(dataValueObject, (Errors)errors);
                }
            }
        }
        return vs;
    }

    protected ValidateErrorStatus handleValidationError(DataValueObject dataValueObject, Errors errors) {
        if (this.validationErrorHandler != null) {
            return this.validationErrorHandler.handleValidationError(dataValueObject, errors);
        }
        return ValidateErrorStatus.SKIP;
    }

    protected CollectorExceptionHandlerStatus handleException(DataValueObject dataValueObject) {
        CollectorExceptionHandlerStatus result = null;
        if (this.exceptionHandler != null) {
            result = this.exceptionHandler.handleException(dataValueObject);
        }
        return result;
    }

    protected boolean isFinish() {
        return this.finish;
    }

    protected void setFinish() {
        this.setFinish(true);
    }

    protected void setFinish(boolean finish) {
        this.finish = finish;
    }

    public static void closeQuietly(Collector<?> collector) {
        CollectorUtility.closeQuietly(collector);
    }

    public static void setVerbose(boolean verbose) {
        verboseLog.set(verbose);
    }
}

