/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.collector;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class CollectorThreadFactory
implements ThreadFactory {
    static final AtomicInteger poolNumber = new AtomicInteger(1);
    final ThreadGroup group;
    final AtomicInteger threadNumber = new AtomicInteger(1);
    final String namePrefix;

    public CollectorThreadFactory() {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        StringBuilder prefixSb = new StringBuilder();
        prefixSb.append("CollectorThreadFactory-");
        prefixSb.append(poolNumber.getAndIncrement());
        prefixSb.append("-thread-");
        this.namePrefix = prefixSb.toString();
    }

    public Thread newThread(Runnable r) {
        StringBuilder nameSb = new StringBuilder();
        nameSb.append(this.namePrefix);
        nameSb.append(this.threadNumber.getAndIncrement());
        Thread t = new Thread(this.group, r, nameSb.toString(), 0L);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

