/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.collector.util;

import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import jp.terasoluna.fw.collector.Collector;
import jp.terasoluna.fw.logger.TLogger;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlBreakChecker {
    private static final TLogger LOGGER = TLogger.getLogger(ControlBreakChecker.class);

    protected ControlBreakChecker() {
    }

    public static boolean isPreBreak(Collector<?> collector, String ... keys) {
        if (collector != null) {
            Object current = collector.getCurrent();
            Object other = collector.getPrevious();
            return ControlBreakChecker.isBreakInternal(current, other, null, keys);
        }
        return false;
    }

    public static boolean isBreak(Collector<?> collector, String ... keys) {
        if (collector != null) {
            Object current = collector.getCurrent();
            Object other = collector.getNext();
            return ControlBreakChecker.isBreakInternal(current, other, null, keys);
        }
        return false;
    }

    protected static boolean isBreakInternal(Object current, Object other, Comparator<?>[] comparators, String ... keys) {
        if (keys == null || keys.length == 0) {
            return false;
        }
        if (current != null && other == null || current == null && other != null) {
            return true;
        }
        if (other != null && current != null) {
            for (int keyIndex = 0; keyIndex < keys.length; ++keyIndex) {
                String key = keys[keyIndex];
                Comparator<?> comparator = null;
                if (comparators != null) {
                    if (comparators.length == 1) {
                        comparator = comparators[0];
                    } else if (keyIndex < comparators.length) {
                        comparator = comparators[keyIndex];
                    }
                }
                if (key == null || key.length() == 0) continue;
                Object currentValue = null;
                Object otherValue = null;
                try {
                    currentValue = PropertyUtils.getProperty((Object)current, (String)key);
                }
                catch (Exception e) {
                    ControlBreakChecker.logOutputPropNotFound(e, current, key);
                    continue;
                }
                try {
                    otherValue = PropertyUtils.getProperty((Object)other, (String)key);
                }
                catch (Exception e) {
                    ControlBreakChecker.logOutputPropNotFound(e, other, key);
                    continue;
                }
                if (!(comparator != null ? comparator.compare(currentValue, otherValue) != 0 : !ControlBreakChecker.equalsObjects(currentValue, otherValue))) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<String, Object> getPreBreakKey(Collector<?> collector, String ... keys) {
        if (collector != null) {
            Object current = collector.getCurrent();
            Object other = collector.getPrevious();
            return ControlBreakChecker.getBreakKeyInternal(current, other, null, keys);
        }
        return new LinkedHashMap<String, Object>();
    }

    public static Map<String, Object> getBreakKey(Collector<?> collector, String ... keys) {
        if (collector != null) {
            Object current = collector.getCurrent();
            Object other = collector.getNext();
            return ControlBreakChecker.getBreakKeyInternal(current, other, null, keys);
        }
        return new LinkedHashMap<String, Object>();
    }

    protected static Map<String, Object> getBreakKeyInternal(Object current, Object other, Comparator<?>[] comparators, String ... keys) {
        boolean inBreak = false;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (keys == null || keys.length == 0) {
            return result;
        }
        for (int keyIndex = 0; keyIndex < keys.length; ++keyIndex) {
            String key = keys[keyIndex];
            Comparator<?> comparator = null;
            Object currentValue = null;
            Object otherValue = null;
            if (comparators != null) {
                if (comparators.length == 1) {
                    comparator = comparators[0];
                } else if (keyIndex < comparators.length) {
                    comparator = comparators[keyIndex];
                }
            }
            if (key != null && key.length() != 0) {
                if (current != null) {
                    try {
                        currentValue = PropertyUtils.getProperty((Object)current, (String)key);
                    }
                    catch (Exception e) {
                        ControlBreakChecker.logOutputPropNotFound(e, current, key);
                        continue;
                    }
                }
                if (other != null) {
                    try {
                        otherValue = PropertyUtils.getProperty((Object)other, (String)key);
                    }
                    catch (Exception e) {
                        ControlBreakChecker.logOutputPropNotFound(e, other, key);
                        continue;
                    }
                }
                if (!inBreak) {
                    if (current != null && other == null || current == null && other != null) {
                        inBreak = true;
                    }
                    if (comparator != null) {
                        if (comparator.compare(currentValue, otherValue) != 0) {
                            inBreak = true;
                        }
                    } else if (!ControlBreakChecker.equalsObjects(currentValue, otherValue)) {
                        inBreak = true;
                    }
                }
            }
            if (!inBreak) continue;
            result.put(key, currentValue);
        }
        return result;
    }

    protected static boolean equalsObjects(Object value1, Object value2) {
        if (value1 != null) {
            Class<Class> clazz = value1.getClass();
            if (!(clazz.isAssignableFrom(Class.class) || clazz.isPrimitive() || ControlBreakChecker.isPrimitiveWrapper(clazz))) {
                return EqualsBuilder.reflectionEquals((Object)value1, (Object)value2);
            }
            return value1.equals(value2);
        }
        return value1 == null && value2 == null;
    }

    protected static boolean isPrimitiveWrapper(Class<?> clazz) {
        if (clazz != null) {
            if (Number.class.isAssignableFrom(clazz) && !AtomicInteger.class.isAssignableFrom(clazz) && !AtomicLong.class.isAssignableFrom(clazz) && !AtomicBoolean.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Boolean.class == clazz || Character.class == clazz || String.class == clazz || Date.class == clazz || Void.class == clazz) {
                return true;
            }
        }
        return false;
    }

    protected static void logOutputPropNotFound(Exception e, Object obj, String key) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("WAL041002", new Object[]{key, obj == null ? null : obj.getClass().getSimpleName(), e == null ? null : e.getMessage()});
        }
    }
}

