/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.file.dao.standard;

import java.io.IOException;
import java.util.Map;

import jp.terasoluna.fw.file.dao.FileException;

/**
 * t@CsIuWFNgpȂt@C@\B
 * <p>
 * rWlXWbNȂǂ󂯎t@Cɏo͂B ̃t@CANZX@\Ƃ͈قȂAt@CsIuWFNggȂB
 * </p>
 * <b>pt@CsIuWFNg̃Ame[V</b><br>
 * @D@{@link jp.terasoluna.fw.file.annotation.FileFormat}̐ݒ荀<br>
 * <div align="center">
 * <table width="90%" border="1" bgcolor="#FFFFFF">
 * <tr>
 * <td><b>_ږ</b></td>
 * <td><b>ږ</b></td>
 * <td><b>ftHgl</b></td>
 * <td><b>K{</b></td>
 * </tr>
 * <tr>
 * <td> <code>s؂蕶</code></td>
 * <td> <code>lineFeedChar</code></td>
 * <td> <code>VXe̍s؂蕶</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * <tr>
 * <td> <code>t@CGR[fBO</code></td>
 * <td> <code>fileEncodeing</code></td>
 * <td> <code>VXẽt@CGR[fBO</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * <tr>
 * <td> <code>t@C㏑tO</code></td>
 * <td> <code>overWriteFlg</code></td>
 * <td> <code>false</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * </table>
 * </div> <br>
 * <b>ӎ</b><br>
 * <ul>
 * @
 * <li>؂蕶ƈ͂ݕ̐ݒ͖B</li>
 * </ul>
 */
public class PlainFileLineWriter extends AbstractFileLineWriter<String> {

    /**
     * RXgN^B
     * @param fileName t@C
     * @param clazz p[^NX
     * @param columnFormatterMap eLXg擾[
     */
    @SuppressWarnings("unchecked")
    public PlainFileLineWriter(String fileName, Class clazz,
            Map<String, ColumnFormatter> columnFormatterMap) {
        super(fileName, clazz, columnFormatterMap);

        // 
        super.init();
    }

    /**
     * <code>t</code>̕t@CɏށB
     * @param t 
     * @throws NullPointerException <code>t</code><code>null</code>̏ꍇ
     */
    @Override
    public void printDataLine(String t) {
        checkWriteTrailer();
        try {
            getWriter().write(t);
            getWriter().write(getLineFeedChar());
        } catch (IOException e) {
            throw new FileException("writer control operation was failed.", e,
                    getFileName());
        }
        setWriteData(true);
    }

    /**
     * ؂蕶擾B<br>
     * u0vŌŒB
     * @return ؂蕶
     */
    @Override
    public char getDelimiter() {
        return 0;
    }

    /**
     * ͂ݕ擾B<br>
     * u0vŌŒB
     * @return ͂ݕ
     */
    @Override
    public char getEncloseChar() {
        return 0;
    }

    /**
     * t@CsIuWFNgɃAme[Vݒ肳Ă鎖`FbN邩ǂԂB<br>
     * PlainFileLineWriterł̓`FbNsȂ߁AfalseB
     * @return false
     */
    @Override
    protected boolean isCheckColumnAnnotationCount() {
        return false;
    }
}
