/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.collector.file;

import jp.terasoluna.fw.collector.AbstractCollectorConfig;
import jp.terasoluna.fw.collector.exception.CollectorExceptionHandler;
import jp.terasoluna.fw.collector.validate.ValidationErrorHandler;
import jp.terasoluna.fw.file.dao.FileQueryDAO;

import org.springframework.validation.Validator;

/**
 * FileCollectorݒ荀
 */
public class FileCollectorConfig<P> extends AbstractCollectorConfig {
    /** FileQueryDAO */
    protected FileQueryDAO fileQueryDAO = null;

    /** t@Ci΃pX܂͑΃pX̂ǂ炩j */
    protected String fileName = null;

    /** 1s̕i[t@CsIuWFNgNX */
    protected Class<P> clazz = null;

    /**
     * RXgN^
     * @param fileQueryDAO FileQueryDAOCX^X
     * @param fileName t@Ci΃pX܂͑΃pX̂ǂ炩j
     * @param clazz 1s̕i[t@CsIuWFNgNX
     */
    public FileCollectorConfig(FileQueryDAO fileQueryDAO, String fileName,
            Class<P> clazz) {
        this.fileQueryDAO = fileQueryDAO;
        this.fileName = fileName;
        this.clazz = clazz;
    }

    /**
     * L[TCYݒ肷
     * @param queueSize L[TCY
     * @return FileCollectorConfig&lt;P&gt;
     */
    public FileCollectorConfig<P> addQueueSize(int queueSize) {
        this.setQueueSize(queueSize);
        return this;
    }

    /**
     * CollectorExceptionHandlerݒ肷
     * @param exceptionHandler CollectorExceptionHandler
     * @return FileCollectorConfig&lt;P&gt;
     */
    public FileCollectorConfig<P> addExceptionHandler(
            CollectorExceptionHandler exceptionHandler) {
        this.setExceptionHandler(exceptionHandler);
        return this;
    }

    /**
     * Validatorݒ肷
     * @param validator Validator
     * @return FileCollectorConfig&lt;P&gt;
     */
    public FileCollectorConfig<P> addValidator(Validator validator) {
        this.setValidator(validator);
        return this;
    }

    /**
     * ValidationErrorHandlerݒ肷
     * @param validationErrorHandler ValidationErrorHandler
     * @return FileCollectorConfig&lt;P&gt;
     */
    public FileCollectorConfig<P> addValidationErrorHandler(
            ValidationErrorHandler validationErrorHandler) {
        this.setValidationErrorHandler(validationErrorHandler);
        return this;
    }

    /**
     * FileQueryDAO
     * @return FileQueryDAO
     */
    public FileQueryDAO getFileQueryDAO() {
        return fileQueryDAO;
    }

    /**
     * FileQueryDAO
     * @param fileQueryDAO FileQueryDAO
     */
    public void setFileQueryDAO(FileQueryDAO fileQueryDAO) {
        this.fileQueryDAO = fileQueryDAO;
    }

    /**
     * t@Ci΃pX܂͑΃pX̂ǂ炩j
     * @return t@Ci΃pX܂͑΃pX̂ǂ炩j
     */
    public String getFileName() {
        return fileName;
    }

    /**
     * t@Ci΃pX܂͑΃pX̂ǂ炩j
     * @param fileName t@Ci΃pX܂͑΃pX̂ǂ炩j
     */
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /**
     * 1s̕i[t@CsIuWFNgNX
     * @return 1s̕i[t@CsIuWFNgNX
     */
    public Class<P> getClazz() {
        return clazz;
    }

    /**
     * 1s̕i[t@CsIuWFNgNX
     * @param clazz 1s̕i[t@CsIuWFNgNX
     */
    public void setClazz(Class<P> clazz) {
        this.clazz = clazz;
    }
}
