/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.collector.util;

import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

import jp.terasoluna.fw.collector.Collector;
import jp.terasoluna.fw.collector.LogId;
import jp.terasoluna.fw.logger.TLogger;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.builder.EqualsBuilder;

/**
 * Rg[uCN`FbJ[.<br>
 */
public class ControlBreakChecker {

    /**
     * Log.
     */
    private static final TLogger LOGGER = TLogger
            .getLogger(ControlBreakChecker.class);

    /**
     * RXgN^.
     */
    protected ControlBreakChecker() {
    }

    /**
     * ORg[uCN胁\bh<br>
     * @param collector Collector&lt;P&gt;
     * @param keys String...
     * @return true:Rg[uCNs/false:Rg[uCNȂ
     */
    public static boolean isPreBreak(Collector<?> collector, String... keys) {
        if (collector != null) {
            Object current = collector.getCurrent();
            Object other = collector.getPrevious();

            return isBreakInternal(current, other, null, keys);
        }
        return false;
    }

    /**
     * ㏈Rg[uCN胁\bh<br>
     * @param collector Collector&lt;P&gt;
     * @param keys String...
     * @return true:Rg[uCNs/false:Rg[uCNȂ
     */
    public static boolean isBreak(Collector<?> collector, String... keys) {
        if (collector != null) {
            Object current = collector.getCurrent();
            Object other = collector.getNext();

            return isBreakInternal(current, other, null, keys);
        }
        return false;
    }

    /**
     * Rg[uCN胁\bh<br>
     * @param current Object rIuWFNg
     * @param other Object rIuWFNg
     * @param comparators Comparator&lt;?&gt;[]
     * @param keys String...
     * @return true:Rg[uCNs/false:Rg[uCNȂ
     */
    @SuppressWarnings("unchecked")
    protected static boolean isBreakInternal(Object current, Object other,
            Comparator<?>[] comparators, String... keys) {

        // keyXgnull̏ꍇfalse
        if (keys == null || keys.length == 0) {
            // Rg[uCNȂ
            return false;
        }

        // ЕnullŁAЕnot null̏ꍇtrue
        if ((current != null && other == null)
                || (current == null && other != null)) {
            // Rg[uCN
            return true;
        }

        if (other != null && current != null) {

            for (int keyIndex = 0; keyIndex < keys.length; keyIndex++) {
                String key = keys[keyIndex];
                Comparator<?> comparator = null;

                if (comparators != null) {
                    if (comparators.length == 1) {
                        comparator = comparators[0];
                    } else if (keyIndex < comparators.length) {
                        comparator = comparators[keyIndex];
                    }
                }

                if (key != null && key.length() != 0) {
                    Object currentValue = null;
                    Object otherValue = null;

                    // l擾
                    try {
                        currentValue = PropertyUtils.getProperty(current, key);
                    } catch (Exception e) {
                        logOutputPropNotFound(e, current, key);
                        // Oo͂Ď̍ڂ`FbN
                        continue;
                    }

                    // l擾
                    try {
                        otherValue = PropertyUtils.getProperty(other, key);
                    } catch (Exception e) {
                        logOutputPropNotFound(e, other, key);
                        // Oo͂Ď̍ڂ`FbN
                        continue;
                    }

                    // r
                    if (comparator != null) {
                        if (((Comparator) comparator).compare(currentValue,
                                otherValue) != 0) {
                            return true;
                        }
                    } else {
                        if (!equalsObjects(currentValue, otherValue)) {
                            return true;
                        }
                    }
                }
            }
        }
        // Rg[uCNȂ
        return false;
    }

    /**
     * ORg[uCNL[擾<br>
     * @param collector Collector&lt;P&gt;
     * @param keys String...
     * @return Rg[uCNL[Xg
     */
    public static Map<String, Object> getPreBreakKey(Collector<?> collector,
            String... keys) {
        if (collector != null) {
            Object current = collector.getCurrent();
            Object other = collector.getPrevious();

            return getBreakKeyInternal(current, other, (Comparator<?>[]) null,
                    keys);
        }
        return new LinkedHashMap<String, Object>();
    }

    /**
     * ㏈Rg[uCNL[擾<br>
     * @param collector Collector&lt;P&gt;
     * @param keys String...
     * @return Rg[uCNL[Xg
     */
    public static Map<String, Object> getBreakKey(Collector<?> collector,
            String... keys) {
        if (collector != null) {
            Object current = collector.getCurrent();
            Object other = collector.getNext();

            return getBreakKeyInternal(current, other, (Comparator<?>[]) null,
                    keys);
        }
        return new LinkedHashMap<String, Object>();
    }

    /**
     * Rg[uCNL[擾<br>
     * @param current Object rIuWFNg
     * @param other Object rIuWFNg
     * @param comparators Comparator&lt;?&gt;[]
     * @param keys String...
     * @return Rg[uCNL[Xg
     */
    @SuppressWarnings("unchecked")
    protected static Map<String, Object> getBreakKeyInternal(Object current,
            Object other, Comparator<?>[] comparators, String... keys) {
        boolean inBreak = false;
        Map<String, Object> result = new LinkedHashMap<String, Object>();

        // keyXgnull̏ꍇfalse
        if (keys == null || keys.length == 0) {
            // Rg[uCNȂ
            return result;
        }

        for (int keyIndex = 0; keyIndex < keys.length; keyIndex++) {
            String key = keys[keyIndex];
            Comparator<?> comparator = null;
            Object currentValue = null;
            Object otherValue = null;

            if (comparators != null) {
                if (comparators.length == 1) {
                    comparator = comparators[0];
                } else if (keyIndex < comparators.length) {
                    comparator = comparators[keyIndex];
                }
            }

            if (key != null && key.length() != 0) {

                // l擾
                if (current != null) {
                    try {
                        currentValue = PropertyUtils.getProperty(current, key);
                    } catch (Exception e) {
                        logOutputPropNotFound(e, current, key);
                        // Oo͂Ď̍ڂ`FbN
                        continue;
                    }
                }

                // l擾
                if (other != null) {
                    try {
                        otherValue = PropertyUtils.getProperty(other, key);
                    } catch (Exception e) {
                        logOutputPropNotFound(e, other, key);
                        // Oo͂Ď̍ڂ`FbN
                        continue;
                    }
                }

                if (!inBreak) {
                    // ЕnullŁAЕnot null̏ꍇtrue
                    if ((current != null && other == null)
                            || (current == null && other != null)) {
                        // Rg[uCN
                        inBreak = true;
                    }

                    // r
                    if (comparator != null) {
                        if (((Comparator) comparator).compare(currentValue,
                                otherValue) != 0) {
                            // Rg[uCN
                            inBreak = true;
                        }
                    } else {
                        if (!equalsObjects(currentValue, otherValue)) {
                            // Rg[uCN
                            inBreak = true;
                        }
                    }
                }
            }

            if (inBreak) {
                result.put(key, currentValue);
            }
        }
        return result;
    }

    /**
     * IuWFNgƕʂ̃IuWFNgǂr.<br>
     * @param value1 Object
     * @param value2 Object
     * @return ꍇ:true / łȂꍇ:false
     */
    protected static boolean equalsObjects(Object value1, Object value2) {
        if (value1 != null) {
            Class<? extends Object> clazz = value1.getClass();

            if (!(clazz.isAssignableFrom(Class.class))
                    && !(clazz.isPrimitive()) && !(isPrimitiveWrapper(clazz))) {
                return EqualsBuilder.reflectionEquals(value1, value2);
            }

            return value1.equals(value2);
        } else if (value1 == null && value2 == null) {
            return true;
        }
        return false;
    }

    /**
     * v~eBũbp[NX𔻒肷.<br>
     * @param pt Class&lt;?&gt;
     * @return true:v~eBũbp[NXł / false:v~eBũbp[NXł͂Ȃ
     */
    protected static boolean isPrimitiveWrapper(Class<?> clazz) {
        if (clazz != null) {
            if (Number.class.isAssignableFrom(clazz)
                    && !AtomicInteger.class.isAssignableFrom(clazz)
                    && !AtomicLong.class.isAssignableFrom(clazz)
                    && !AtomicBoolean.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Boolean.class == clazz || Character.class == clazz
                    || String.class == clazz || Date.class == clazz
                    || Void.class == clazz) {
                return true;
            }
        }
        return false;
    }

    /**
     * OóivpeBȂꍇj.<br>
     * @param e Exception
     * @param obj Object
     * @param key String
     */
    protected static void logOutputPropNotFound(Exception e, Object obj,
            String key) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn(LogId.WAL041002, key, obj == null ? null : obj
                    .getClass().getSimpleName(),
                    e == null ? null : e.getMessage());
        }
    }

}
