/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.collector.vo;

import jp.terasoluna.fw.collector.validate.ValidateErrorStatus;

/**
 * DataValueObject.<br>
 * L[Ƀf[^Oi[ۂ̔B
 */
public class DataValueObject {
    /** f[^JEgi擾f[^ڂ̃f[^i1=1jj */
    protected long dataCount = -1;

    /** SQLsʃf[^ */
    protected Object value = null;

    /** O */
    protected Throwable throwable = null;

    /** ̓`FbNXe[^X */
    protected ValidateErrorStatus validateStatus = null;

    /**
     * SQLsʃf[^<br>
     * @param value Object SQLsʃf[^
     */
    public DataValueObject(Object value) {
        this.value = value;
    }

    /**
     * SQLsʃf[^<br>
     * @param value Object SQLsʃf[^
     * @param dataCount long f[^JE^
     */
    public DataValueObject(Object value, long dataCount) {
        this.value = value;
        this.dataCount = dataCount;
    }

    /**
     * O<br>
     * @param throwable Throwable O
     */
    public DataValueObject(Throwable throwable) {
        this.throwable = throwable;
    }

    /**
     * ̓`FbNXe[^X<br>
     * @param validateStatus ValidateStatus ̓`FbNXe[^X
     */
    public DataValueObject(ValidateErrorStatus validateStatus) {
        this.validateStatus = validateStatus;
    }

    /**
     * f[^JEg擾.<br>
     * @return long
     */
    public long getDataCount() {
        return dataCount;
    }

    /**
     * SQLsʃf[^<br>
     * @return SQLsʃf[^
     */
    public Object getValue() {
        return value;
    }

    /**
     * O<br>
     * @return O
     */
    public Throwable getThrowable() {
        return throwable;
    }

    /**
     * ̓`FbNXe[^X<br>
     * @return ̓`FbNXe[^X
     */
    public ValidateErrorStatus getValidateStatus() {
        return validateStatus;
    }

}
