/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.web;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.web.MockServletOutputStream;
import com.mockrunner.util.common.CaseAwareMap;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class MockHttpServletResponse
implements HttpServletResponse {
    private PrintWriter writer;
    private MockServletOutputStream outputStream;
    private Map headers;
    private Locale locale;
    private String characterEncoding;
    private int bufferSize;
    private boolean wasErrorSent;
    private boolean wasRedirectSent;
    private int errorCode;
    private int statusCode;
    private List cookies;

    public MockHttpServletResponse() {
        this.resetAll();
    }

    public void resetAll() {
        this.headers = new CaseAwareMap();
        this.characterEncoding = "ISO-8859-1";
        this.bufferSize = 8192;
        this.wasErrorSent = false;
        this.wasRedirectSent = false;
        this.errorCode = 200;
        this.statusCode = 200;
        this.cookies = new ArrayList();
        this.outputStream = new MockServletOutputStream(this.characterEncoding);
        try {
            this.writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)((Object)this.outputStream), this.characterEncoding), true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new NestedApplicationException(unsupportedEncodingException);
        }
    }

    public String encodeURL(String string) {
        return string;
    }

    public String encodeRedirectUrl(String string) {
        return string;
    }

    public String encodeRedirectURL(String string) {
        return string;
    }

    public String encodeUrl(String string) {
        return string;
    }

    public PrintWriter getWriter() throws IOException {
        return this.writer;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public String getOutputStreamContent() {
        return this.outputStream.getContent();
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public void addDateHeader(String string, long l) {
        Date date = new Date(l);
        String string2 = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US).format(date);
        this.addHeader(string, string2);
    }

    public void addHeader(String string, String string2) {
        ArrayList<String> arrayList = (ArrayList<String>)this.headers.get(string);
        if (null == arrayList) {
            arrayList = new ArrayList<String>();
            this.headers.put(string, arrayList);
        }
        arrayList.add(string2);
    }

    public void addIntHeader(String string, int n) {
        String string2 = new Integer(n).toString();
        this.addHeader(string, string2);
    }

    public boolean containsHeader(String string) {
        return this.headers.containsKey(string);
    }

    public void sendError(int n, String string) throws IOException {
        this.errorCode = n;
        this.wasErrorSent = true;
    }

    public void sendError(int n) throws IOException {
        this.errorCode = n;
        this.wasErrorSent = true;
    }

    public void sendRedirect(String string) throws IOException {
        this.setHeader("Location", string);
        this.wasRedirectSent = true;
    }

    public void setDateHeader(String string, long l) {
        Date date = new Date(l);
        String string2 = DateFormat.getDateInstance().format(date);
        this.setHeader(string, string2);
    }

    public void setHeader(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.headers.put(string, arrayList);
        arrayList.add(string2);
    }

    public void setIntHeader(String string, int n) {
        String string2 = new Integer(n).toString();
        this.setHeader(string, string2);
    }

    public void setStatus(int n, String string) {
        this.statusCode = n;
    }

    public void setStatus(int n) {
        this.statusCode = n;
    }

    public void flushBuffer() throws IOException {
        this.writer.flush();
        this.outputStream.flush();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String string) {
        this.characterEncoding = string;
        this.outputStream.setEncoding(string);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
        this.errorCode = 200;
        this.statusCode = 200;
        this.clearHeaders();
        this.resetBuffer();
    }

    public void resetBuffer() {
        this.outputStream.clearContent();
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public void setContentLength(int n) {
        this.setIntHeader("Content-Length", n);
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public void setContentType(String string) {
        this.setHeader("Content-Type", string);
    }

    public Enumeration getHeaderNames() {
        return new Vector(this.headers.keySet()).elements();
    }

    public List getHeaderList(String string) {
        return (List)this.headers.get(string);
    }

    public String getHeader(String string) {
        List list = this.getHeaderList(string);
        if (null == list || 0 == list.size()) {
            return null;
        }
        return (String)list.get(0);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public List getCookies() {
        return this.cookies;
    }

    public boolean wasErrorSent() {
        return this.wasErrorSent;
    }

    public boolean wasRedirectSent() {
        return this.wasRedirectSent;
    }
}

