/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.filter.mockrunner;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import org.activemq.filter.mockrunner.BooleanExpression;
import org.activemq.filter.mockrunner.Expression;
import org.activemq.filter.mockrunner.PropertyExpression;

public abstract class UnaryExpression
implements Expression {
    private static final BigDecimal BD_LONG_MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE);
    protected Expression right;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public static Expression createNegate(Expression expression) {
        return new UnaryExpression(expression){

            public Object evaluate(Message message) throws JMSException {
                Object object = this.right.evaluate(message);
                if (object == null) {
                    return null;
                }
                if (object instanceof Number) {
                    return UnaryExpression.negate((Number)object);
                }
                return null;
            }

            public String getExpressionSymbol() {
                return "-";
            }
        };
    }

    public static BooleanExpression createInExpression(PropertyExpression propertyExpression, List list, final boolean bl) {
        Collection collection = list.size() == 0 ? null : (list.size() < 5 ? list : new HashSet(list));
        final List list2 = collection;
        return new BooleanUnaryExpression(propertyExpression){

            public Object evaluate(Message message) throws JMSException {
                Object object = this.right.evaluate(message);
                if (object == null) {
                    return null;
                }
                if (object.getClass() != (class$java$lang$String == null ? (class$java$lang$String = UnaryExpression.class$("java.lang.String")) : class$java$lang$String)) {
                    return null;
                }
                if ((list2 != null && list2.contains(object)) ^ bl) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.right);
                stringBuffer.append(" ");
                stringBuffer.append(this.getExpressionSymbol());
                stringBuffer.append(" ( ");
                int n = 0;
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (n != 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(e);
                    ++n;
                }
                stringBuffer.append(" )");
                return stringBuffer.toString();
            }

            public String getExpressionSymbol() {
                if (bl) {
                    return "NOT IN";
                }
                return "IN";
            }
        };
    }

    public static BooleanExpression createNOT(BooleanExpression booleanExpression) {
        return new BooleanUnaryExpression(booleanExpression){

            public Object evaluate(Message message) throws JMSException {
                Boolean bl = (Boolean)this.right.evaluate(message);
                if (bl == null) {
                    return null;
                }
                return bl != false ? Boolean.FALSE : Boolean.TRUE;
            }

            public String getExpressionSymbol() {
                return "NOT";
            }
        };
    }

    public static BooleanExpression createBooleanCast(Expression expression) {
        return new BooleanUnaryExpression(expression){

            public Object evaluate(Message message) throws JMSException {
                Object object = this.right.evaluate(message);
                if (object == null) {
                    return null;
                }
                if (!object.getClass().equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = UnaryExpression.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    return Boolean.FALSE;
                }
                return object;
            }

            public String getExpressionSymbol() {
                return "NOT";
            }
        };
    }

    private static Number negate(Number number) {
        Class<?> clazz = number.getClass();
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = UnaryExpression.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer(-number.intValue());
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = UnaryExpression.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(-number.longValue());
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = UnaryExpression.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(-number.floatValue());
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = UnaryExpression.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(-number.doubleValue());
        }
        if (clazz == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = UnaryExpression.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            BigDecimal bigDecimal = (BigDecimal)number;
            if (BD_LONG_MIN_VALUE.compareTo(bigDecimal = bigDecimal.negate()) == 0) {
                return new Long(Long.MIN_VALUE);
            }
            return bigDecimal;
        }
        throw new RuntimeException("Don't know how to negate: " + number);
    }

    public UnaryExpression(Expression expression) {
        this.right = expression;
    }

    public Expression getRight() {
        return this.right;
    }

    public void setRight(Expression expression) {
        this.right = expression;
    }

    public String toString() {
        return "(" + this.getExpressionSymbol() + " " + this.right.toString() + ")";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public abstract String getExpressionSymbol();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static abstract class BooleanUnaryExpression
    extends UnaryExpression
    implements BooleanExpression {
        public BooleanUnaryExpression(Expression expression) {
            super(expression);
        }
    }
}

