/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.ex.unit.util;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.terasoluna.fw.ex.unit.common.DefaultProperties;
import jp.terasoluna.fw.ex.unit.common.PropertyKeys;
import jp.terasoluna.fw.ex.unit.io.Comparison;
import jp.terasoluna.fw.ex.unit.io.InputSource;
import jp.terasoluna.fw.ex.unit.io.impl.CollectionSource;
import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;
import jp.terasoluna.fw.service.thin.BLogicResult;
import junit.framework.Assert;
import junitx.framework.ArrayAssert;
import junitx.framework.FileAssert;
import junitx.framework.ObjectAssert;
import junitx.framework.StringAssert;
import junitx.framework.ThrowableAssert;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.beans.BeanWrapperImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertUtils {
    private static String getIsNullMessage(String target) {
        return String.valueOf(target) + " is null";
    }

    private static String getNotEqualsMessage(Object expected, Object actual) {
        return "expected :<" + expected + "> was not:<" + actual + ">";
    }

    public static void assertReflectionEquals(Object expected, Object actual) {
        if (expected instanceof String && actual instanceof String) {
            Assert.assertEquals((String)((String)expected), (String)((String)actual));
            return;
        }
        Assert.assertTrue((String)AssertUtils.getNotEqualsMessage(ToStringBuilder.reflectionToString((Object)expected), ToStringBuilder.reflectionToString((Object)actual)), (boolean)EqualsBuilder.reflectionEquals((Object)expected, (Object)actual));
    }

    public static void assertReflectionEquals(Object expected, Object actual, String[] excludeFields) {
        if (expected instanceof String && actual instanceof String) {
            Assert.assertEquals((String)((String)expected), (String)((String)actual));
            return;
        }
        Assert.assertTrue((String)AssertUtils.getNotEqualsMessage(ToStringBuilder.reflectionToString((Object)expected), ToStringBuilder.reflectionToString((Object)actual)), (boolean)EqualsBuilder.reflectionEquals((Object)expected, (Object)actual, (String[])excludeFields));
    }

    public static void assertReflectionEquals(Object expected, Object actual, boolean testTransients) {
        if (expected instanceof String && actual instanceof String) {
            Assert.assertEquals((String)((String)expected), (String)((String)actual));
            return;
        }
        Assert.assertTrue((String)AssertUtils.getNotEqualsMessage(ToStringBuilder.reflectionToString((Object)expected), ToStringBuilder.reflectionToString((Object)actual)), (boolean)EqualsBuilder.reflectionEquals((Object)expected, (Object)actual, (boolean)testTransients));
    }

    public static <T> void assertInputEquals(InputSource<T> expected, InputSource<T> actual) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("expected"), expected);
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("actual"), actual);
        Comparison comparison = expected.compare(actual);
        Assert.assertTrue((String)comparison.getMessage(), (Comparison.Result.EQUAL == comparison.getResult() ? 1 : 0) != 0);
    }

    public static <T> void assertInputEquals(InputSource<T> expected, Collection<T> actual) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("actual"), actual);
        AssertUtils.assertInputEquals(expected, new CollectionSource<T>(actual));
    }

    public static void assertBLogicResultEquals(String expectedResultString, Object expectedResultObject, BLogicResult actual) {
        AssertUtils.assertBLogicResultStringEquals(expectedResultString, actual);
        AssertUtils.assertBLogicResultObjectEquals(expectedResultObject, actual);
    }

    public static void assertBLogicResultObjectEquals(Object expectedResultObject, BLogicResult actual) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("actual"), (Object)actual);
        if (expectedResultObject instanceof Map && actual.getResultObject() instanceof Map) {
            AssertUtils.assertMapEquals((Map)expectedResultObject, (Map)actual.getResultObject());
        } else {
            PropertyDescriptor[] pds;
            Object actualResultObject = actual.getResultObject();
            if (actualResultObject == null) {
                Assert.assertNull((String)"expectedResultObject must be null because actualResultObject is null", (Object)expectedResultObject);
            }
            BeanWrapperImpl actualBw = new BeanWrapperImpl(actualResultObject);
            BeanWrapperImpl expectedBw = new BeanWrapperImpl(expectedResultObject);
            PropertyDescriptor[] propertyDescriptorArray = pds = actualBw.getPropertyDescriptors();
            int n = pds.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                String propName = pd.getName();
                Object actualProp = actualBw.getPropertyValue(propName);
                Object expectedProp = expectedBw.getPropertyValue(propName);
                if (actualProp instanceof Map && expectedProp instanceof Map) {
                    AssertUtils.assertMapEquals((Map)expectedProp, (Map)actualProp);
                } else if (actualProp instanceof Collection && expectedProp instanceof Collection) {
                    AssertUtils.assertCollectionEquals((Collection)expectedProp, (Collection)actualProp);
                } else {
                    AssertUtils.assertReflectionEquals(expectedProp, actualProp);
                }
                ++n2;
            }
        }
    }

    public static void assertBLogicResultStringEquals(String expectedResultString, BLogicResult actual) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("actual"), (Object)actual);
        Assert.assertEquals((String)"[resultString]", (String)expectedResultString, (String)actual.getResultString());
    }

    public static void assertBLogicSuccessResultEquals(Object expectedResultObject, BLogicResult actual) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("actual"), (Object)actual);
        Assert.assertEquals((String)DefaultProperties.getValue(PropertyKeys.SUCCESS_STRING), (String)actual.getResultString());
        AssertUtils.assertBLogicResultObjectEquals(expectedResultObject, actual);
    }

    public static void assertBLogicSuccess(BLogicResult result) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("result"), (Object)result);
        Assert.assertEquals((String)DefaultProperties.getValue(PropertyKeys.SUCCESS_STRING), (String)result.getResultString());
    }

    public static void assertBLogicFailureResultEquals(Object expectedResultObject, BLogicResult actual) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("actual"), (Object)actual);
        Assert.assertEquals((String)DefaultProperties.getValue(PropertyKeys.FAILURE_STRING), (String)actual.getResultString());
        AssertUtils.assertBLogicResultObjectEquals(expectedResultObject, actual);
    }

    public static void assertBLogicFailure(BLogicResult result) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("result"), (Object)result);
        Assert.assertEquals((String)DefaultProperties.getValue(PropertyKeys.FAILURE_STRING), (String)result.getResultString());
    }

    public static void assertBLogicMessageEquals(String expectedKey, Object[] expectedValues, boolean expectedResource, BLogicMessage actual) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("actual"), (Object)actual);
        Assert.assertEquals((String)"[key]", (String)expectedKey, (String)actual.getKey());
        AssertUtils.assertArrayEquals(expectedValues, actual.getValues());
        Assert.assertEquals((String)"[resource]", (boolean)expectedResource, (boolean)actual.isResource());
    }

    public static void assertBLogicMessageEquals(String expectedGroupKey, BLogicMessage expectedMessage, BLogicResult actualBLogicResult) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("actualBLogicResult"), (Object)actualBLogicResult);
        BLogicMessages messages = actualBLogicResult.getMessages();
        Assert.assertNotNull((Object)messages);
        BLogicMessage actual = AssertUtils.getBLogicMessage(expectedGroupKey, messages);
        AssertUtils.assertBLogicMessageEquals(expectedMessage, actual);
    }

    public static void assertBLogicMessageEquals(String expectedGroupKey, String expectedMessageKey, BLogicResult result) {
        AssertUtils.assertBLogicMessageEquals(expectedGroupKey, new BLogicMessage(expectedMessageKey), result);
    }

    public static void assertBLogicMessageEquals(String expectedGroupKey, String expectedMessageKey, Object[] expectedMessageValues, BLogicResult result) {
        AssertUtils.assertBLogicMessageEquals(expectedGroupKey, new BLogicMessage(expectedMessageKey, expectedMessageValues), result);
    }

    public static void assertBLogicMessageEquals(String expectedGroupKey, String expectedMessageKey, boolean expectedResource, BLogicResult result) {
        AssertUtils.assertBLogicMessageEquals(expectedGroupKey, new BLogicMessage(expectedMessageKey, expectedResource), result);
    }

    public static void assertBLogicErrorMessageEquals(String expectedGroupKey, BLogicMessage expectedMessage, BLogicResult result) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("result"), (Object)result);
        BLogicMessages messages = result.getErrors();
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("errors"), (Object)messages);
        BLogicMessage actual = AssertUtils.getBLogicMessage(expectedGroupKey, messages);
        AssertUtils.assertBLogicMessageEquals(expectedMessage, actual);
    }

    public static void assertBLogicErrorMessageEquals(String expectedGroupKey, String expectedMessageKey, BLogicResult result) {
        AssertUtils.assertBLogicErrorMessageEquals(expectedGroupKey, new BLogicMessage(expectedMessageKey), result);
    }

    public static void assertBLogicErrorMessageEquals(String expectedGroupKey, String expectedMessageKey, Object[] expectedMessageValues, BLogicResult result) {
        AssertUtils.assertBLogicErrorMessageEquals(expectedGroupKey, new BLogicMessage(expectedMessageKey, expectedMessageValues), result);
    }

    public static void assertBLogicErrorMessageEquals(String expectedGroupKey, String expectedMessageKey, boolean expectedResource, BLogicResult result) {
        AssertUtils.assertBLogicErrorMessageEquals(expectedGroupKey, new BLogicMessage(expectedMessageKey, expectedResource), result);
    }

    private static BLogicMessage getBLogicMessage(String groupKey, BLogicMessages messages) {
        Iterator groupItr = messages.getGroup();
        Iterator messageItr = messages.get();
        while (messageItr.hasNext()) {
            if (!groupItr.hasNext()) break;
            BLogicMessage message = (BLogicMessage)messageItr.next();
            String group = (String)groupItr.next();
            if (groupKey == null || !groupKey.equals(group)) continue;
            return message;
        }
        return null;
    }

    public static void assertBLogicMessageEquals(BLogicMessage expected, BLogicMessage actual) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("expected"), (Object)expected);
        AssertUtils.assertBLogicMessageEquals(expected.getKey(), expected.getValues(), expected.isResource(), actual);
    }

    public static void assertStringContains(String substring, String actual) {
        StringAssert.assertContains((String)substring, (String)actual);
    }

    public static void assertStringContains(String message, String substring, String actual) {
        StringAssert.assertContains((String)message, (String)substring, (String)actual);
    }

    public static void assertStringNotContains(String substring, String actual) {
        StringAssert.assertNotContains((String)substring, (String)actual);
    }

    public static void assertStringNotContains(String message, String substring, String actual) {
        StringAssert.assertNotContains((String)message, (String)substring, (String)actual);
    }

    public static void assertStringStartsWith(String substring, String actual) {
        StringAssert.assertStartsWith((String)substring, (String)actual);
    }

    public static void assertStringStartsWith(String message, String substring, String actual) {
        StringAssert.assertStartsWith((String)message, (String)substring, (String)actual);
    }

    public static void assertStringNotStartsWith(String substring, String actual) {
        StringAssert.assertNotStartsWith((String)substring, (String)actual);
    }

    public static void assertStringNotStartsWith(String message, String substring, String actual) {
        StringAssert.assertNotStartsWith((String)message, (String)substring, (String)actual);
    }

    public static void assertStringEndsWith(String substring, String actual) {
        StringAssert.assertEndsWith((String)substring, (String)actual);
    }

    public static void assertStringEndsWith(String message, String substring, String actual) {
        StringAssert.assertEndsWith((String)message, (String)substring, (String)actual);
    }

    public static void assertStringNotEndsWith(String substring, String actual) {
        StringAssert.assertNotEndsWith((String)substring, (String)actual);
    }

    public static void assertStringNotEndsWith(String message, String substring, String actual) {
        StringAssert.assertNotEndsWith((String)message, (String)substring, (String)actual);
    }

    public static void assertArrayEquals(Object[] expected, Object[] actual) {
        if (expected == null && actual == null) {
            return;
        }
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("expected"), (Object)expected);
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("actual"), (Object)actual);
        Assert.assertEquals((String)"size", (int)expected.length, (int)actual.length);
        int i = 0;
        while (i < expected.length) {
            Object e = expected[i];
            Object a = actual[i];
            AssertUtils.assertReflectionEquals(e, a);
            ++i;
        }
    }

    public static void assertArrayEquals(double[] expected, double[] actual, double delta) {
        ArrayAssert.assertEquals((double[])expected, (double[])actual, (double)delta);
    }

    public static void assertArrayEquals(String message, double[] expected, double[] actual, double delta) {
        ArrayAssert.assertEquals((String)message, (double[])expected, (double[])actual, (double)delta);
    }

    public static void assertArrayEquals(String message, float[] expected, float[] actual, float delta) {
        ArrayAssert.assertEquals((String)message, (float[])expected, (float[])actual, (float)delta);
    }

    public static void assertArrayEquals(float[] expected, float[] actual, float delta) {
        ArrayAssert.assertEquals((float[])expected, (float[])actual, (float)delta);
    }

    public static void assertArrayEquals(String message, long[] expected, long[] actual) {
        ArrayAssert.assertEquals((String)message, (long[])expected, (long[])actual);
    }

    public static void assertArrayEquals(long[] expected, long[] actual) {
        ArrayAssert.assertEquals((long[])expected, (long[])actual);
    }

    public static void assertArrayEquals(String message, int[] expected, int[] actual) {
        ArrayAssert.assertEquals((String)message, (int[])expected, (int[])actual);
    }

    public static void assertArrayEquals(int[] expected, int[] actual) {
        ArrayAssert.assertEquals((int[])expected, (int[])actual);
    }

    public static void assertArrayEquals(String message, short[] expected, short[] actual) {
        ArrayAssert.assertEquals((String)message, (short[])expected, (short[])actual);
    }

    public static void assertArrayEquals(short[] expected, short[] actual) {
        ArrayAssert.assertEquals((short[])expected, (short[])actual);
    }

    public static void assertArrayEquals(String message, char[] expected, char[] actual) {
        ArrayAssert.assertEquals((String)message, (char[])expected, (char[])actual);
    }

    public static void assertArrayEquals(char[] expected, char[] actual) {
        ArrayAssert.assertEquals((char[])expected, (char[])actual);
    }

    public static void assertArrayEquals(String message, boolean[] expected, boolean[] actual) {
        ArrayAssert.assertEquals((String)message, (boolean[])expected, (boolean[])actual);
    }

    public static void assertArrayEquals(boolean[] expected, boolean[] actual) {
        ArrayAssert.assertEquals((boolean[])expected, (boolean[])actual);
    }

    public static void assertArrayEquals(String message, byte[] expected, byte[] actual) {
        ArrayAssert.assertEquals((String)message, (byte[])expected, (byte[])actual);
    }

    public static void assertArrayEquals(byte[] expected, byte[] actual) {
        ArrayAssert.assertEquals((byte[])expected, (byte[])actual);
    }

    public static void assertCollectionSizeEquals(int expectedSize, Collection<?> actual) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("actual"), actual);
        Assert.assertEquals((String)"[size]", (int)expectedSize, (int)actual.size());
    }

    public static void assertCollectionEmpty(Collection<?> actual) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("actual"), actual);
        Assert.assertTrue((String)"actual is not empty", (boolean)actual.isEmpty());
    }

    public static void assertCollectionNotEmpty(Collection<?> actual) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("actual"), actual);
        Assert.assertFalse((String)"actual is empty", (boolean)actual.isEmpty());
    }

    public static void assertCollectionEquals(Collection<?> expected, Collection<?> actual) {
        if (expected == null && actual == null) {
            return;
        }
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("actual"), actual);
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("expected"), expected);
        Assert.assertEquals((String)"size", (int)expected.size(), (int)actual.size());
        Iterator<?> expectedIterator = expected.iterator();
        Iterator<?> actualIterator = actual.iterator();
        while (expectedIterator.hasNext()) {
            Object e = expectedIterator.next();
            Object a = actualIterator.next();
            AssertUtils.assertReflectionEquals(e, a);
        }
    }

    public static void assertCollectionContains(Collection<?> actual, Object value) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("actual"), actual);
        Assert.assertTrue((String)("actual does not contain " + value), (boolean)actual.contains(value));
    }

    public static void assertMapEquals(Map<?, ?> expected, Map<?, ?> actual) {
        if (expected == null && actual == null) {
            return;
        }
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("actual"), actual);
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("expected"), expected);
        int actualSize = actual.size();
        int expectedSize = expected.size();
        Assert.assertEquals((String)"size", (int)actualSize, (int)expectedSize);
        for (Map.Entry<?, ?> e : expected.entrySet()) {
            Object expectedKey = e.getKey();
            Object expectedValue = e.getValue();
            Assert.assertTrue((String)("key = " + expectedKey + " is not found in actual"), (boolean)actual.containsKey(expectedKey));
            AssertUtils.assertReflectionEquals(expectedValue, actual.get(expectedKey));
        }
    }

    public static void assertMapEquals(Object[] expectedKeys, Object[] expectedValues, Map<?, ?> actual) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("expectedValues"), (Object)expectedValues);
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("expectedKeys"), (Object)expectedKeys);
        int keySize = expectedKeys.length;
        int valSize = expectedValues.length;
        Assert.assertEquals((String)"keySize and valueSize are wrong", (int)keySize, (int)valSize);
        HashMap<Object, Object> expected = new HashMap<Object, Object>();
        int i = 0;
        while (i < expectedKeys.length) {
            expected.put(expectedKeys[i], expectedValues[i]);
            ++i;
        }
        AssertUtils.assertMapEquals(expected, actual);
    }

    public static void assertMapSizeEquals(int expectedSize, Map<?, ?> actual) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("actual"), actual);
        Assert.assertEquals((String)"[size]", (int)expectedSize, (int)actual.size());
    }

    public static void assertObjectInstanceOf(String message, Class<?> expected, Object actual) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("actual"), (Object)actual);
        ObjectAssert.assertInstanceOf((String)message, expected, (Object)actual);
    }

    public static void assertObjectInstanceOf(Class<?> expected, Object actual) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("actual"), (Object)actual);
        ObjectAssert.assertInstanceOf(expected, (Object)actual);
    }

    public static void assertObjectNotInstanceOf(String message, Class<?> expected, Object actual) {
        ObjectAssert.assertNotInstanceOf((String)message, expected, (Object)actual);
    }

    public static void assertObjectNotInstanceOf(Class<?> expected, Object actual) {
        ObjectAssert.assertNotInstanceOf(expected, (Object)actual);
    }

    public static void assertThrowableEquals(String message, Throwable expected, Throwable actual) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("actual"), (Object)actual);
        ThrowableAssert.assertEquals((String)message, (Throwable)expected, (Throwable)actual);
    }

    public static void assertThrowableEquals(Throwable expected, Throwable actual) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("actual"), (Object)actual);
        ThrowableAssert.assertEquals((Throwable)expected, (Throwable)actual);
    }

    public static void assertThrowableSimilar(String message, Throwable expected, Throwable actual) {
        ThrowableAssert.assertSimilar((String)message, (Throwable)expected, (Throwable)actual);
    }

    public static void assertThrowableSimilar(Throwable expected, Throwable actual) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("actual"), (Object)actual);
        ThrowableAssert.assertSimilar((Throwable)expected, (Throwable)actual);
    }

    public static void assertDateEquals(Date expected, Date actual) {
        if (expected == null && actual == null) {
            return;
        }
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("expected"), (Object)expected);
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("actual"), (Object)actual);
        Assert.assertEquals((long)expected.getTime(), (long)actual.getTime());
    }

    public static void assertDateEquals(String expected, Date actual) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("expected"), (Object)expected);
        AssertUtils.assertDateEquals(Timestamp.valueOf(expected), actual);
    }

    public static void assertDateNearEquals(Date expected, Date actual, long errorInMillisec) {
        if (expected == null && actual == null) {
            return;
        }
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("expected"), (Object)expected);
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("actual"), (Object)actual);
        Assert.assertTrue((String)("error beteween expected and actual is over " + errorInMillisec), (Math.abs(expected.getTime() - actual.getTime()) <= errorInMillisec ? 1 : 0) != 0);
    }

    public static void assertDateNearEquals(String expected, Date actual, long errorInMillisec) {
        Assert.assertNotNull((String)AssertUtils.getIsNullMessage("expected"), (Object)expected);
        AssertUtils.assertDateNearEquals(Timestamp.valueOf(expected), actual, errorInMillisec);
    }

    public static void assertFileEquals(String message, File expected, File actual) {
        FileAssert.assertEquals((String)message, (File)expected, (File)actual);
    }

    public static void assertFileEquals(File expected, File actual) {
        FileAssert.assertEquals((File)expected, (File)actual);
    }

    public static void assertFileBinaryEquals(File expected, File actual) {
        FileAssert.assertBinaryEquals((File)expected, (File)actual);
    }

    public static void assertFileBinaryEquals(String message, File expected, File actual) {
        FileAssert.assertBinaryEquals((String)message, (File)expected, (File)actual);
    }
}

