/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.dao.ibatis;

import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.fw.dao.SqlHolder;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.dao.ibatis.UpdateDAOiBatisImpl}
 * NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * UpdateDAOC^tF[XiBATISpNXB
 * <p>
 *
 * @see jp.terasoluna.fw.dao.ibatis.UpdateDAOiBatisImpl
 */
public class UpdateDAOiBatisImplTest extends TestCase {

    /**
     * eXgΏۃNX
     */
    private UpdateDAOiBatisImpl dao = new UpdateDAOiBatisImpl();

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(UpdateDAOiBatisImplTest.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        dao = new UpdateDAOiBatisImpl();
        LogUTUtil.flush();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        dao = null;
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public UpdateDAOiBatisImplTest(String name) {
        super(name);
    }

    /**
     * testExecute01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() sqlID:"sqlId"<br>
     *         () bindParams:"1"<br>
     *         () update̖߂l:1<br>
     *
     * <br>
     * ҒlF(߂l) E:1<br>
     *         (ԕω) updatěďomF:sqlIdAbindParamsŌĂяoĂ鎖mF<br>
     *
     * <br>
     * update𐳏ɌĂяoAʂԋpꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testExecute01() throws Exception {
        // O
        dao.setSqlMapClientTemplate(new UpdateDAOiBatisImpl_SqlMapClientTemplateStub01());

        // eXg{
        int i = dao.execute("sqlId", "1");

        // 
        assertEquals(1, i);
        UpdateDAOiBatisImpl_SqlMapClientTemplateStub01 sqlMapTemp = (UpdateDAOiBatisImpl_SqlMapClientTemplateStub01) dao
                .getSqlMapClientTemplate();
        assertTrue(sqlMapTemp.isCalled());
        assertEquals("sqlId", sqlMapTemp.getStatementName());
        assertEquals("1", sqlMapTemp.getParameterObject());
    }

    /**
     * testAddBatch01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() sqlID:"sqlID1"<br>
     *         () bindParams:"1"<br>
     *         () batchSqls.get()ɂĎ擾ListusqlHoldersv:null<br>
     *         
     * <br>
     * ҒlF(ԕω) batchSqls.get()ɂĎ擾ListusqlHoldersv:List[0] = <br>
     *                        SqlHolder(sqlID="sqlID1",bindParams="1")<br>
     *         
     * <br>
     * sqlHoldersnull̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings({"unchecked","deprecation"})
    public void testAddBatch01() throws Exception {
        // O

        // eXg{
        dao.addBatch("sqlID1", "1");

        // 
        Object obj = UTUtil.getPrivateField(dao, "batchSqls");
        List<SqlHolder> sqlHolders
            = ((ThreadLocal<List<SqlHolder>>) obj).get();
        SqlHolder sqlHolder = sqlHolders.get(0);
        assertEquals("sqlID1", sqlHolder.getSqlID());
        assertEquals("1", sqlHolder.getBindParams());
    }

    /**
     * testAddBatch02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() sqlID:"sqlID2"<br>
     *         () bindParams:"2"<br>
     *         () batchSqls.get()ɂĎ擾ListusqlHoldersv:Not Null<br>
     *                List[0] = <br>
     *                    SqlHolder(sqlID="sqlID1",bindParams="1")<br>
     *         
     * <br>
     * ҒlF(ԕω) batchSqls.get()ɂĎ擾ListusqlHoldersv:List[0] = <br>
     *                        SqlHolder(sqlID="sqlID1",bindParams="1")<br>
     *                    List[1] = <br>
     *                        SqlHolder(sqlID="sqlID2",bindParams="2")<br>
     *         
     * <br>
     * sqlHoldersNot null̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings({"unchecked","deprecation"})
    public void testAddBatch02() throws Exception {
        // O
        dao.setSqlMapClientTemplate(
                new UpdateDAOiBatisImpl_SqlMapClientTemplateStub01());
        ThreadLocal<List<SqlHolder>> batchSqls
            = new ThreadLocal<List<SqlHolder>>();
        List<SqlHolder> sqlHolders = new ArrayList<SqlHolder>();
        sqlHolders.add(new SqlHolder("sqlID1","1"));
        batchSqls.set(sqlHolders);
        UTUtil.setPrivateField(dao, "batchSqls", batchSqls);

        // eXg{
        dao.addBatch("sqlID2", "2");

        // 
        Object obj = UTUtil.getPrivateField(dao, "batchSqls");
        sqlHolders = ((ThreadLocal<List<SqlHolder>>) obj).get();
        SqlHolder sqlHolder = sqlHolders.get(0);
        assertEquals("sqlID1", sqlHolder.getSqlID());
        assertEquals("1", sqlHolder.getBindParams());
        sqlHolder = sqlHolders.get(1);
        assertEquals("sqlID2", sqlHolder.getSqlID());
        assertEquals("2", sqlHolder.getBindParams());
    }

    /**
     * testExecuteBatch01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() batchSqls.get()ɂĎ擾ListusqlHoldersv:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *                    bZ[WFNo batch sql. Call #addBatch(String, Object) at least 1 time.<br>
     *         (ԕω) O:bZ[W<br>
     *                    No batch sql. Call #addBatch(String, Object) at least 1 time.<br>
     *         
     * <br>
     * sqlHoldersAnull̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testExecuteBatch01() throws Exception {
        // O

        // eXg{
        try {
            dao.executeBatch();
            fail("eXgs");
        } catch (IllegalArgumentException e) {
            // 
            assertEquals("No SqlMapClient specified", e.getMessage());
        }
    }

    /**
     * testExecuteBatch02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() batchSqls.get()ɂĎ擾ListusqlHoldersv:size = 0<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *                    bZ[WFNo batch sql. Call #addBatch(String, Object) at least 1 time.<br>
     *         (ԕω) O:bZ[W<br>
     *                    No batch sql. Call #addBatch(String, Object) at least 1 time.<br>
     *         
     * <br>
     * sqlHoldersAsize=0̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testExecuteBatch02() throws Exception {
        // O
        dao.setSqlMapClientTemplate(
                new UpdateDAOiBatisImpl_SqlMapClientTemplateStub01());
        ThreadLocal<List<SqlHolder>> batchSqls
            = new ThreadLocal<List<SqlHolder>>();
        List<SqlHolder> sqlHolders = new ArrayList<SqlHolder>();
        batchSqls.set(sqlHolders);
        UTUtil.setPrivateField(dao, "batchSqls", batchSqls);

        // eXg{
        int i = dao.executeBatch();

        // 
        assertEquals(1, i);
        UpdateDAOiBatisImple_SqlMapSessionImpl sqlMap
            = (UpdateDAOiBatisImple_SqlMapSessionImpl) dao
                .getSqlMapClientTemplate().getSqlMapClient().openSession();
        assertTrue(sqlMap.isStartBatchCalled());
        assertFalse(sqlMap.isUpdateCalled());
        assertTrue(sqlMap.isExecuteBatchCalled());
    }

    /**
     * testExecuteBatch03()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() batchSqls.get()ɂĎ擾ListusqlHoldersv:size = 1<br>
     *         
     * <br>
     * ҒlF(߂l) int:1<br>
     *         (ԕω) startBatcȟďomF:Ăяo邱ƂmFB<br>
     *         (ԕω) addBatcȟďomF:Ăяo邱ƂmFB<br>
     *         (ԕω) executeBatcȟďomF:Ăяo邱ƂmFB<br>
     *         (ԕω) batchSqls.get()ɂĎ擾ListusqlHoldersv:null<br>
     *         
     * <br>
     * sqlHoldersAsize=1̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testExecuteBatch03() throws Exception {
        // O
        dao.setSqlMapClientTemplate(new UpdateDAOiBatisImpl_SqlMapClientTemplateStub01());
        ThreadLocal<List<SqlHolder>> batchSqls = new ThreadLocal<List<SqlHolder>>();
        List<SqlHolder> sqlHolders = new ArrayList<SqlHolder>();
        sqlHolders.add(new SqlHolder("sqlID1","1"));
        batchSqls.set(sqlHolders);
        UTUtil.setPrivateField(dao, "batchSqls", batchSqls);

        // eXg{
        int i = dao.executeBatch();

        // 
        assertEquals(1, i);
        UpdateDAOiBatisImple_SqlMapSessionImpl sqlMap
            = (UpdateDAOiBatisImple_SqlMapSessionImpl) dao
                .getSqlMapClientTemplate().getSqlMapClient().openSession();
        assertTrue(sqlMap.isStartBatchCalled());
        assertTrue(sqlMap.isUpdateCalled());
        assertTrue(sqlMap.isExecuteBatchCalled());
        List<String> id = sqlMap.getId();
        List<Object> param = sqlMap.getParam();
        assertEquals("sqlID1", id.get(0));
        assertEquals("1", param.get(0));
    }

    /**
     * testExecuteBatch04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() batchSqls.get()ɂĎ擾ListusqlHoldersv:size = 3<br>
     *         
     * <br>
     * ҒlF(߂l) int:3<br>
     *         (ԕω) startBatcȟďomF:Ăяo邱ƂmFB<br>
     *         (ԕω) addBatcȟďomF:Ăяo邱ƂmFB<br>
     *         (ԕω) executeBatcȟďomF:Ăяo邱ƂmFB<br>
     *         (ԕω) batchSqls.get()ɂĎ擾ListusqlHoldersv:null<br>
     *         
     * <br>
     * sqlHoldersAsize=3̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testExecuteBatch04() throws Exception {
        // O
        dao.setSqlMapClientTemplate(new UpdateDAOiBatisImpl_SqlMapClientTemplateStub01());
        ThreadLocal<List<SqlHolder>> batchSqls = new ThreadLocal<List<SqlHolder>>();
        List<SqlHolder> sqlHolders = new ArrayList<SqlHolder>();
        sqlHolders.add(new SqlHolder("sqlID1","1"));
        sqlHolders.add(new SqlHolder("sqlID2","2"));
        sqlHolders.add(new SqlHolder("sqlID3","3"));
        batchSqls.set(sqlHolders);
        UTUtil.setPrivateField(dao, "batchSqls", batchSqls);

        // eXg{
        int i = dao.executeBatch();

        // 
        assertEquals(1, i);
        UpdateDAOiBatisImple_SqlMapSessionImpl sqlMap
            = (UpdateDAOiBatisImple_SqlMapSessionImpl) dao
                .getSqlMapClientTemplate().getSqlMapClient().openSession();
        assertTrue(sqlMap.isStartBatchCalled());
        assertTrue(sqlMap.isUpdateCalled());
        assertTrue(sqlMap.isExecuteBatchCalled());
        List<String> id = sqlMap.getId();
        List<Object> param = sqlMap.getParam();
        assertEquals("sqlID1", id.get(0));
        assertEquals("sqlID2", id.get(1));
        assertEquals("sqlID3", id.get(2));
        assertEquals("1", param.get(0));
        assertEquals("2", param.get(1));
        assertEquals("3", param.get(2));
    }

    /**
     * testExecuteBatchList01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() sqlHolders:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WFNo SqlMapClient specified<br>
     *         
     * <br>
     * sqlHoldersAnull̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExecuteBatchList01() throws Exception {
        // O

        // eXg{
        try {
            dao.executeBatch(null);
            fail("eXgs");
        } catch (IllegalArgumentException e) {
            // 
            assertEquals("No SqlMapClient specified", e.getMessage());
        }
    }

    /**
     * testExecuteBatchList02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() sqlHolders:size=0<br>
     *         
     * <br>
     * ҒlF(ԕω) startBatcȟďomF:Ăяo邱ƂmFB<br>
     *         (ԕω) updatěďomF:ĂяoȂ<br>
     *         (ԕω) executeBatcȟďomF:Ăяo邱ƂmFB<br>
     *         
     * <br>
     * sqlHoldersAsize=0̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExecuteBatchList02() throws Exception {
        // O
        dao.setSqlMapClientTemplate(
                new UpdateDAOiBatisImpl_SqlMapClientTemplateStub01());
        List<SqlHolder> sqlHolders = new ArrayList<SqlHolder>();

        // eXg{
        int i = dao.executeBatch(sqlHolders);

        // 
        assertEquals(1, i);
        UpdateDAOiBatisImple_SqlMapSessionImpl sqlMap
            = (UpdateDAOiBatisImple_SqlMapSessionImpl) dao
                .getSqlMapClientTemplate().getSqlMapClient().openSession();
        assertTrue(sqlMap.isStartBatchCalled());
        assertFalse(sqlMap.isUpdateCalled());
        assertTrue(sqlMap.isExecuteBatchCalled());
    }

    /**
     * testExecuteBatchList03()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() sqlHolders:size=1<br>
     *         
     * <br>
     * ҒlF(߂l) int:1<br>
     *         (ԕω) startBatcȟďomF:Ăяo邱ƂmFB<br>
     *         (ԕω) updatěďomF:Ăяo邱ƂmFB<br>
     *         (ԕω) executeBatcȟďomF:Ăяo邱ƂmFB<br>
     *         (ԕω) batchSqls.get()ɂĎ擾ListusqlHoldersv:null<br>
     *         
     * <br>
     * sqlHoldersAsize=1̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExecuteBatchList03() throws Exception {
        // O
        dao.setSqlMapClientTemplate(new UpdateDAOiBatisImpl_SqlMapClientTemplateStub01());
        List<SqlHolder> sqlHolders = new ArrayList<SqlHolder>();
        sqlHolders.add(new SqlHolder("sqlID1","1"));

        // eXg{
        int i = dao.executeBatch(sqlHolders);

        // 
        assertEquals(1, i);
        UpdateDAOiBatisImple_SqlMapSessionImpl sqlMap
            = (UpdateDAOiBatisImple_SqlMapSessionImpl) dao
                .getSqlMapClientTemplate().getSqlMapClient().openSession();
        assertTrue(sqlMap.isStartBatchCalled());
        assertTrue(sqlMap.isUpdateCalled());
        assertTrue(sqlMap.isExecuteBatchCalled());
        List<String> id = sqlMap.getId();
        List<Object> param = sqlMap.getParam();
        assertEquals("sqlID1", id.get(0));
        assertEquals("1", param.get(0));
    }

    /**
     * testExecuteBatchList04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() sqlHolders:size=3<br>
     *         
     * <br>
     * ҒlF(߂l) int:3<br>
     *         (ԕω) startBatcȟďomF:Ăяo邱ƂmFB<br>
     *         (ԕω) updatěďomF:Ăяo邱ƂmFB<br>
     *         (ԕω) executeBatcȟďomF:Ăяo邱ƂmFB<br>
     *         (ԕω) batchSqls.get()ɂĎ擾ListusqlHoldersv:null<br>
     *         
     * <br>
     * sqlHoldersAsize=3̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExecuteBatchList04() throws Exception {
        // O
        dao.setSqlMapClientTemplate(new UpdateDAOiBatisImpl_SqlMapClientTemplateStub01());
        List<SqlHolder> sqlHolders = new ArrayList<SqlHolder>();
        sqlHolders.add(new SqlHolder("sqlID1","1"));
        sqlHolders.add(new SqlHolder("sqlID2","2"));
        sqlHolders.add(new SqlHolder("sqlID3","3"));

        // eXg{
        int i = dao.executeBatch(sqlHolders);

        // 
        assertEquals(1, i);
        UpdateDAOiBatisImple_SqlMapSessionImpl sqlMap
            = (UpdateDAOiBatisImple_SqlMapSessionImpl) dao
                .getSqlMapClientTemplate().getSqlMapClient().openSession();
        assertTrue(sqlMap.isStartBatchCalled());
        assertTrue(sqlMap.isUpdateCalled());
        assertTrue(sqlMap.isExecuteBatchCalled());
        List<String> id = sqlMap.getId();
        List<Object> param = sqlMap.getParam();
        assertEquals("sqlID1", id.get(0));
        assertEquals("sqlID2", id.get(1));
        assertEquals("sqlID3", id.get(2));
        assertEquals("1", param.get(0));
        assertEquals("2", param.get(1));
        assertEquals("3", param.get(2));
    }

}
