/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.executor.concurrent;

import jp.terasoluna.fw.batch.executor.concurrent.BatchServantImpl;
import junit.framework.TestCase;

/**
 * O<br>
 * <br>
 * 
 * EWuǗe[uɃWuo^Ă邱ƁB<br>
 * EbeanDeftH_ɃWuBean`t@C݂邱ƁB<br>
 * EBean`t@Cɐݒ肳ꂽrWlXWbN݂邱<br>
 * 
 */
public class BatchServantImplTest extends TestCase {


	
	/**
	 * testRun01()<br>
	 * <br>
	 * OԁFWuǗe[ũWuV[PXR[h0000000001o^Ă邱<br>
	 * OԁFWuǗe[ũWuƖR[hB000001o^Ă邱<br>
	 * <br>
	 * eXgTvFɃWus邱ƂmF<br>
	 * <br>
	 * mFځFWuV[PXR[h<br>
	 * mFځFrWlXWbNʂ<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testRun01() throws Exception {

		BatchServantImpl exe = new BatchServantImpl();


		exe.setJobSequenceId("0000000001");
		exe.run();

		assertEquals(0, exe.getResult().getBlogicStatus());
		assertEquals("0000000001", exe.getJobSequenceId());
		
	}

	/**
	 * testRun02()<br>
	 * <br>
	 * OԁFWuǗe[ũWuV[PXR[h0000000000o^ĂȂ<br>
	 * <br>
	 * eXgTvFɃWus邱ƂmF<br>
	 * <br>
	 * mFځFrWlXWbNʂ<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testRun02() throws Exception {

		BatchServantImpl exe = new BatchServantImpl();
		exe.setJobSequenceId("0000000000");
		exe.run();

		assertEquals(-1, exe.getResult().getBlogicStatus());
	}



	/**
	 * testRun03()<br>
	 * <br>
	 * OԁFWuǗe[ũWuV[PXR[h0000000002o^Ă邱<br>
	 * OԁFWuǗe[ũWuƖR[hB000002o^Ă邱<br>
	 * <br>
	 * eXgTvFɃWus邱ƂmF<br>
	 * <br>
	 * mFځFrWlXWbNʂ<br>
	 * <br>
	 * 
	 * @throws Exception
	 */	public void testRun03() throws Exception {

		BatchServantImpl exe = new BatchServantImpl();
		exe.setJobSequenceId("0000000002");
		exe.run();

		assertEquals(1, exe.getResult().getBlogicStatus());
	}


}
