/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.terasoluna.fw.ex.unit.mock.file;

import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.fw.ex.unit.mock.AbstractMockDao;
import jp.terasoluna.fw.file.dao.FileLineIterator;
import jp.terasoluna.fw.file.dao.FileQueryDAO;

/**
 * {@link FileQueryDAO}̃bNNXB
 * 
 * <p>
 * {@link FileQueryDAO#execute(String, Class)}̕Ԃl
 * {@link MockFileQueryDao#addResult(FileLineIterator)}ɂĐݒł܂B
 * 
 * {@link FileQueryDAO#execute(String, Class)}ɓnꂽ̏
 * {@link MockFileQueryDao#getFileDaoParams()}Ŏ擾ł܂B
 * </p>
 * <p>
 * ȉɗ܂B<br>
 * ̃t@C<code>TestData</code>NXɃ}bsOꍇA
 * </p>
 * 
 * <pre>
 * aaa1,bbb1
 * aaa2,bbb2
 * </pre>
 * <p>
 * eXg͈ȉ̂悤ɋLq܂B
 * </p>
 * 
 * <pre>
 * // bN
 * MockFileQueryDao fileQueryDao = new MockFileQueryDao();
 * MockFileLineIterator&lt;TestData&gt; fileLineIterator = new MockFileLineIterator&lt;TestData&gt;();
 * // eXgf[^p
 * TestData data1 = new TestData();
 * data1.setTest1(&quot;aaa1&quot;);
 * data1.setTest2(&quot;bbb1&quot;);
 * TestData data2 = new TestData();
 * data2.setTest1(&quot;aaa2&quot;);
 * data2.setTest2(&quot;bbb2&quot;);
 * // eXgf[^ݒ
 * fileLineIterator.addResult(data1);
 * fileLineIterator.addResult(data2);
 * fileQueryDao.addResult(fileLineIterator);
 * 
 * XxxBLogic blogic = new XxxBLogic();
 * blogic.setFileQueryDAO(fileQueryDao);
 * blogic.execute(XXXX); // eXg\bhs
 * 
 * // ̓t@C̊mF
 * assertEquals(&quot;input.csv&quot;, fileQueryDao.getFileDaoParams().get(0).getFileName());
 * </pre>
 */
public class MockFileQueryDao extends AbstractMockDao implements FileQueryDAO {

    /**
     * \bhs񃊃Xg
     */
    private List<FileDaoParam> fileDaoParams = new ArrayList<FileDaoParam>();

    /**
     * <p>
     * FileQueryDAO#execute() ̃bN\bhB
     * </p>
     *  params Ɋi[Aresults̐擪 IuWFNgoĕԋp܂B
     * 
     * @param fileName t@C
     * @param clazz NX
     * @return s
     */
    @SuppressWarnings("unchecked")
    public <T> FileLineIterator<T> execute(String fileName, Class<T> clazz) {

        FileDaoParam param = new FileDaoParam();
        param.setFileName(fileName);
        param.setClazz(clazz);
        this.fileDaoParams.add(param);

        Object result = poll();

        if (result != null && result instanceof FileLineIterator) {
            return (FileLineIterator<T>) result;
        } else {
            throw new ClassCastException(
                    "FileLineIterator was expected but the actual was "
                            + result);
        }

    }

    /**
     * <p>
     * \bhs񃊃Xgԋp܂B
     * </p>
     * 
     * @return \bhs񃊃Xg
     */
    public List<FileDaoParam> getFileDaoParams() {
        return this.fileDaoParams;
    }

    /*
     * (non-Javadoc)
     * 
     * @see jp.terasoluna.fw.ex.unit.mock.AbstractMockDao#clear()
     */
    public void clear() {
        super.clear();
        fileDaoParams.clear();
    }

    /**
     * {@link FileQueryDAO#execute(String, Class)}̕ԂlƂȂ
     * {@link FileLineIterator}ݒ肵܂B
     * 
     * @param fileLineIterator {@link FileQueryDAO#execute(String, Class)}
     *            ̕ԂlƂȂ{@link FileLineIterator}IuWFNg
     */
    public void addResult(FileLineIterator<?> fileLineIterator) {
        super.addResult(fileLineIterator);
    }
}
