/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.terasoluna.fw.exception;

import java.util.Locale;

import jp.terasoluna.fw.logger.TLogger;

/**
 * ėpONX
 * 
 * <p>
 * bZ[W̊Ǘ@{@link TLogger}ƓlłB<br>
 * Aݒt@C<code>META-INF/terasoluna-logger.properties</code>ł͂ȂA <code>META-INF/terasoluna-exception.properties</code>ɂȂ܂B
 * </p>
 */
@SuppressWarnings("serial")
public class TException extends Exception {
    /**
     * bZ[WID
     */
    private final String messageId;
    /**
     * up[^
     */
    private final Object[] args;

    /**
     * RXgN^
     * 
     * @param messageId bZ[WID
     * @param args up[^
     */
    public TException(String messageId, Object... args) {
        super(getMessage(messageId, ExceptionConfig.getLocale(), args));
        this.messageId = messageId;
        this.args = args;
    }

    /**
     * RXgN^
     * 
     * @param messageId bZ[WId
     * @param cause NO
     * @param args up[^
     */
    public TException(String messageId, Throwable cause, Object... args) {
        super(getMessage(messageId, ExceptionConfig.getLocale(), args), cause);
        this.messageId = messageId;
        this.args = args;
    }

    /**
     * bZ[W擾܂B
     * 
     * @param messageId bZ[WID
     * @param locale P[
     * @param args up[^
     * @return bZ[W
     */
    protected static String getMessage(String messageId, Locale locale,
            Object... args) {
        return ExceptionConfig.MESSAGE_MANAGER.getMessage(true, messageId,
                locale, args);
    }

    /**
     * bZ[WID擾܂
     * 
     * @return bZ[WID
     */
    public String getMessageId() {
        return messageId;
    }

    /**
     * up[^擾܂B
     * 
     * @return up[^
     */
    public Object[] getArgs() {
        return args;
    }
}
