/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.io.impl;

import java.beans.PropertyDescriptor;
import java.sql.ResultSet;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.sql.DataSource;

import jp.terasoluna.fw.ex.unit.exception.UTRuntimeException;
import jp.terasoluna.fw.ex.unit.util.AssertUtils;
import jp.terasoluna.fw.ex.unit.util.DateConvertUtils;
import jp.terasoluna.fw.ex.unit.util.ReflectionUtils;

import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.Assert;

/**
 * DB̓\[XIuWFNg𐶐܂B <br>
 * RXgN^܂setterɂĈȉ̃p[^w肵܂B܂{@link AbstractInputSource}
 * Őݒ\ȃp[^wł܂B <br>
 * <table border=1>
 * <tr>
 * <th>p[^</th>
 * <th></th>
 * <th>ݒӏ</th>
 * <th>K{</th>
 * </tr>
 * <tr>
 * <td>jdbcTemplate</td>
 * <td>{@link JdbcTemplate}IuWFNgB{@link DataSource} IuWFNgݒ肳ĂKv܂B</td>
 * <td>RXgN^</td>
 * <td></td>
 * </tr>
 * <tr>
 * <td>clazz</td>
 * <td>{@link ResultSet}}bsOBeañNX</td>
 * <td>RXgN^</td>
 * <td></td>
 * </tr>
 * <tr>
 * <td>sql</td>
 * <td>}bsOsf[^擾邽߂SQLBIɎw肵Ȃꍇ uselect * from e[uvs܂B</td>
 * <td>RXgN^ or setter</td>
 * <td>rowMapperw肷ꍇ́</td>
 * </tr>
 * <tr>
 * <td>tableName</td>
 * <td>}bsOsf[^擾Ώۂ̃e[uBftHgł̓}bsOΏۃNX
 * {@link Class#getSimpleName()}Ŏ擾܂B</td>
 * <td>RXgN^ or setter</td>
 * <td>&nbsp;</td>
 * </tr>
 * <tr>
 * <td>rowMapper</td>
 * <td>SQLsʂ̊e{@link ResultSet}IuWFNg}bsO邽߂{@link RowMapper}
 * IuWFNgBftHgł{@link BeanPropertyRowMapper}
 * gp܂(<strong>vSpring2.5ȏ</strong>)B</td>
 * <td>RXgN^</td>
 * <td>&nbsp;</td>
 * </tr>
 * <tr>
 * <td>isConvertDate</td>
 * <td>}bsOIuWFNgjava.util.Date^tB[hɑ΂āAjava.util.
 * Dateg^(java.sql.TimestampAjava.sql.DateAjava.sql.Time
 * )}bsOꂽꍇjava.util.Date^ɖ߂sǂ̃tOB
 * Boolean.TRUE܂null̏ꍇ́A}bsONXjava.util.Date^tB[hɃ}bsOꂽ
 * java.util.Date^gNX̃IuWFNgA java.util.Date^ɕϊătB[hɐݒ肵܂BftHgnullł
 * Bϊsv̏ꍇBoolean.FALSEݒ肵ĂB(u ӎvQ)</td>
 * <td>setter</td>
 * <td>&nbsp;</td>
 * </tr>
 * </table>
 * 
 * <pre>
 * ȉ̗ɂĎgp@܂B
 * 
 * DBpersone[u̓eȉƂ܂B
 * 
 * 
 * ID,NAME,ADDRESS
 * 1,c,
 * 2,,
 * 3,Rc,_ސ
 * 4,R{,
 * 
 * ɑ΂ă}bsONXȉƂ܂B
 * 
 * public class Person {
 *   private Integer id;
 *   private Sring name;
 *   private String address;
 *   // setter/getter͗
 * }
 * 
 * yf[^r@\z
 * 
 * Ɩ̌ʂƂPersonNX̃Xg쐬ۂɁAPersone[u̓eҒlƂȂꍇÂ悤ɔr邱Ƃł܂B
 * 
 * // DB̓\[X쐬
 * DbSource&lt;Person&gt; source = new DbSource&lt;Person&gt;(jdbcTemplate, Person.class);
 * // Ɩ̌
 * List&lt;Person&gt; result = ...;
 * // Ɩ̌ʂƃe[u̓er
 * {@link AssertUtils}.assertInputEquals(source, result);
 * 
 * yf[^ۑ@\z
 *  // DBɊi[Ăf[^csvt@Cɕۑ܂
 *  source.to(new {@link CsvTarget}&lt;Person&gt;(&quot;person.csv&quot;, Person.class));
 *  
 *  ̗Ńf[^擾SQLύXꍇÂ悤setterɂĐݒł܂
 *  source.setSql(&quot;SELECT id, name FROM person ORDER BY name&quot;);
 *  
 *  <hr>
 *  ӎ
 * {NXłDBւ̖₢킹ʂIuWFNgɃ}bsO邽߂{@link RowMapper}gp܂A
 * <strong>ftHgł{@link RowMapper}̎dlɂ炸A}bsONXjava.util.Date^tB[hɃ}bsOꂽ
 * java.util.Date^gNX(java.sql.TimestampAjava.sql.DateAjava.sql.Time)̃IuWFNgAjava.util.Date^ɕϊătB[hɐݒ肵܂B</strong>
 * 
 * Ȃ킿{@link RowMapper}java.util.Date^̃tB[hɑ΂āA
 * {@link ResultSet#getTimestamp(int)}̌ʂݒ肵ꍇ́Aϊɂ
 * ݒ肳ꂽjava.sql.TimestampIuWFNgjava.util.DateIuWFNg쐬
 * ݒ肵܂B
 * ({NX̃ftHgRowMapperł{@link BeanPropertyRowMapper}
 * java.util.DatetB[hɑ΂java.sql.TimestampIuWFNgݒ肷dlƂȂĂ܂B)
 * 
 * {@link AbstractInputSource#compare(jp.terasoluna.fw.ex.unit.io.InputSource)}ɂIuWFNgm̔rɂāA
 * ^ႤꍇɕsvƔf邽߂̏łB
 * iBatisłjava.util.Date^̃tB[hւ̃f[^̃}bsO̍ۂɁAjava.sql.Timestampjava.util.Dateɕϊ邽߁A
 * ̏ɍ킹Ă܂B
 * 
 * ̕ϊɂĖɂȂ̂́A
 * {NX擾IuWFNgƔrΏۂ̃IuWFNgiΏۏ̌ʓIuWFNgjjava.util.DatetB[h
 * ΂ĈӐ}Ijava.sql.TimestampIuWFNgݒ肳ĂꍇÂ悤ȎdlOR}bp[gpĂꍇłB
 * ̏ꍇAϊs킸{@link RowMapper}̎dlʂ̌ʂ𓾂邽߂{@link #setIsConvertDate(Boolean)}{@link Boolean#FALSE}ݒ肵ĂB
 * 
 * ΏۏeRowMapper̎eɂĈȉ̃p^[ɂđΉ@܂B
 * 
 * <table border=1>
 * <tr>
 * <th></th><th colspan=3>RowMapperݒ肷java.util.DatetB[hւ̒l</th>
 * </tr>
 * <tr>
 * <th rowspan=3>ΏۏŐݒ肷java.util.DatetB[hւ̒l</th>
 * <th>&nbsp;</th>
 * <th>java.util.DateIuWFNgݒ</th>
 * <th>java.sql.TimestampIuWFNgݒ</th>
 * </tr>
 * <tr>
 * <th>java.util.DateIuWFNgݒ</th>
 * <td>p^[A</td>
 * <td>p^[B</td>
 * </tr>
 * <tr>
 * <th>java.sql.TimestampIuWFNgݒ</th>
 * <td>p^[C</td>
 * <td>p^[D</td>
 * </tr>
 * </table>
 * 
 * <dl>
 * <dt>p^[A</dt>
 * <dd>ǉݒ͕svłBΏۏiBatisDBf[^擾AƎRowMapperjava.util.DatetB[hɑ΂āAnew Date(rs.getTimestamp().getTime());̂悤ɐݒ肵Ăꍇ̃p^[ɂ܂B
 * Aϊ͕svł邽{@link #setIsConvertDate(Boolean)}Boolean.FALSEݒ肵P̃eXg̐\͗ǂȂ܂B</dd>
 * <dt>p^[B</dt>
 * <dd>ǉݒ͕svłB<strong>ftHgőz肵Ăp^[</strong>łBΏۏiBatisDBf[^擾ARowMapper{@link BeanPropertyRowMapper}(ftHg)gpĂꍇ͂̃p^[łB</dd>
 * <dt>p^[C</dt>
 * <dd><strong>RowMapperł̓eXgł܂BʂRowMapperݒ肵ĂB</strong>ΏۏŕԋpIuWFNgjava.util.DatetB[hjava.sql.TimestampIuWFNgݒ肵AƎRowMapperjava.util.DatetB[hɑ΂āAnew Date(rs.getTimestamp().getTime());̂悤ɐݒ肵Ăꍇ̃p^[ɂ܂B</dd>
 * <dt>p^[D</dt>
 * <dd><strong>K{@link #setIsConvertDate(Boolean)}Boolean.FALSEݒ肵ĂB</strong>ΏۏŕԋpIuWFNgjava.util.DatetB[hjava.sql.TimestampIuWFNgݒ肵ARowMapper{@link BeanPropertyRowMapper}(ftHg)gpĂꍇ͂̃p^[łB</dd>
 * </dl>
 * 
 * Ejava.sql.Date
 * Ejava.sql.Time
 * ̏ꍇɂĂΏۏeRowMapper̎e̊֌Wɑ΂Ή@java.sql.Timestamp̏ꍇƓlłB
 * LȊOjava.util.DateƎg^tB[hɎIuWFNgւ̃}bsOɂ͖{NX͑ΉĂ܂B
 * </pre>
 */
public class DbSource<T> extends AbstractInputSource<T> {
    protected final JdbcTemplate template;
    protected final Class<T> clazz;
    protected final RowMapper rowMapper;
    protected String sql;
    private Boolean isConvertDate = null;

    /**
     * }bsOIuWFNgjava.util.Date^tB[hɑ΂āAjava.util.
     * Dateg^(java.sql.TimestampAjava.sql.DateAjava.sql.Time
     * )}bsOꂽꍇjava.util.Date^ɖ߂sǂ̃tOݒ肵܂B
     * 
     * @param isConvertDate
     *            }bsOIuWFNgjava.util.Date^tB[hɑ΂āAjava.util.
     *            Dateg^(java.sql.TimestampAjava.sql.DateAjava.sql.Time
     *            )}bsOꂽꍇjava.util.Date^ɖ߂sǂ̃tO
     *            (Boolean.FALSȄꍇ͕ϊ܂ BBoolean.TRUE܂null̏ꍇ͕ϊ܂B)
     */
    public void setIsConvertDate(Boolean isConvertDate) {
        this.isConvertDate = isConvertDate;
    }

    /**
     * RXgN^B<br> {@link RowMapper}{@link BeanPropertyRowMapper}gp܂B
     * 
     * @param template
     *            JDBCev[g
     * @param tableName
     *            }bsOsf[^擾Ώۂ̃e[u
     * @param clazz
     *            sf[^}bsONX
     */
    public DbSource(JdbcTemplate template, String tableName, Class<T> clazz) {
        super.header = ReflectionUtils.createFiledNames(clazz);
        this.template = template;
        this.clazz = clazz;
        this.sql = "select * from " + tableName;
        this.rowMapper = new BeanPropertyRowMapper(clazz, false);
    }

    /**
     * RXgN^
     * 
     * @param template
     *            JDBCev[g
     * @param clazz
     *            sf[^}bsONX
     */
    public DbSource(JdbcTemplate template, Class<T> clazz) {
        this(template, clazz.getSimpleName(), clazz);
    }

    /**
     * RXgN^
     * 
     * @param template
     *            JDBCev[g
     * @param clazz
     *            sf[^}bsONX
     * @param sql
     *            }bsOsf[^擾邽߂SQL
     * @param rowMapper
     *            SQLsʂ̊e{@link ResultSet}IuWFNg}bsO邽߂{@link RowMapper}
     *            IuWFNg
     */
    public DbSource(JdbcTemplate template, Class<T> clazz, String sql,
            RowMapper rowMapper) {
        super.header = ReflectionUtils.createFiledNames(clazz);
        this.template = template;
        this.clazz = clazz;
        this.sql = sql;
        this.rowMapper = rowMapper;
    }

    /**
     * DB₢킹ʂCe[^ŕԋp܂B
     * 
     * <pre>
     * sqlrowMapper{@link JdbcTemplate#query(String, RowMapper)}sA
     * ̌ʂCe[^ŕԋp܂B
     * (ׂĂ̍sf[^ɓWJĂCe[^쐬_ɒӂĂB)
     * 
     * {@link DbSource}́u ӎvQƂĂB
     * </pre>
     * 
     * @return Ce[^
     */
    // @Override
    @SuppressWarnings("unchecked")
    public Iterator<T> getIterator() {
        Assert.notNull(template);
        List<T> items = template.query(sql, rowMapper);

        for (T item : items) {
            // java.util.Date^̃tB[hɑ΂āAJdbcTemplate#query̌java.sql.TimestampAjava.sql.DateAjava.sql.Time^IuWFNg}bsOꂽꍇA
            // java.util.Date^IuWFNgɖ߂s
            if (isConvertDate == null || isConvertDate == Boolean.TRUE) {
                BeanWrapper bw = new BeanWrapperImpl(clazz);
                isConvertDate = Boolean.FALSE; // DatetB[h邩`FbN𖈃[vōsȂ߂̃tO
                for (PropertyDescriptor pd : bw.getPropertyDescriptors()) {
                    Class<?> propertyType = pd.getPropertyType();
                    if (Date.class == propertyType) {
                        isConvertDate = Boolean.TRUE;
                        try {
                            Date d = (Date) pd.getReadMethod().invoke(item);
                            // java.util.Date^ɕϊ
                            Date value = DateConvertUtils.convertDateValue(d,
                                    Date.class);
                            pd.getWriteMethod().invoke(item, value);
                        } catch (Exception e) {
                            throw new UTRuntimeException(e);
                        }
                    }
                }
            }
        }
        return items.iterator();
    }

    /**
     * }bsOsf[^擾邽߂SQLݒ肵܂B
     * 
     * @param sql
     *            }bsOsf[^擾邽߂SQL
     */
    public void setSql(String sql) {
        this.sql = sql;
    }
}
