/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

import jp.terasoluna.fw.ex.unit.exception.PopulationFailedException;

/**
 * tϊ[eBeBB
 * 
 */
public class DateConvertUtils {

    /**
     * t^̃IuWFNgΏۂ̃NX̃IuWFNgɕϊ܂B <br>
     * ϊNXjava.util.DateAjava.sql.TimestampAjava.sql.DateAjava.
     * sql.TimeNXȊȌꍇA{@link PopulationFailedException}X[܂B<br>
     * {\bh͓p̂߁AeXgɂ͎gpȂłB
     * 
     * 
     * 
     * @param d
     *            ϊIuWFNg
     * @param propertyType
     *            ϊNX
     * @return ϊ̃IuWFNg
     * @throws PopulationFailedException
     *             ϊNXjava.util.DateAjava.sql.TimestampAjava.sql.DateAjava.
     *             sql.TimeNXȊȌꍇ
     */
    public static Date convertDateValue(Date d,
            Class<? extends Date> propertyType)
            throws PopulationFailedException {
        Date value = null;
        if (d != null) {
            // java.util.Date^炻ꂼ̃tB[h
            if (d.getClass() == propertyType) {
                value = d;
            } else if (java.util.Date.class == propertyType) {
                value = new java.util.Date(d.getTime());
            } else if (java.sql.Date.class == propertyType) {
                value = utilDateToSqlDate(d);
            } else if (java.sql.Timestamp.class == propertyType) {
                value = new Timestamp(d.getTime());
            } else if (java.sql.Time.class == propertyType) {
                value = new Time(d.getTime());
            } else {
                // ƎgDate^̏ꍇ͗OX[
                throw new PopulationFailedException(propertyType
                        + " is not supported to populate");
            }
        }
        return value;
    }

    /**
     * java.util.DateNXjava.sql.Date^ɕϊ܂B
     * 
     * @param d
     *            t
     * @return java.sql.Date^̓t
     */
    public static java.sql.Date utilDateToSqlDate(java.util.Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
        java.sql.Date sqlDate = new java.sql.Date(cal.getTimeInMillis());
        return sqlDate;
    }
}
