/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.util;

import org.apache.commons.lang.StringUtils;

/**
 * sf[^z؂蕶pČ{@link LineJoiner}NXłB
 * 
 */
public class DefaultLineJoiner implements LineJoiner {
    /**
     * ؂蕶
     */
    private final String delimiter;

    /**
     * RXgN^B<br>
     * ؂蕶w肵܂B
     * 
     * @param delimiter
     *            ؂蕶
     */
    public DefaultLineJoiner(String delimiter) {
        super();
        this.delimiter = delimiter;
    }

    public String join(String[] stringArray) {
        return StringUtils.join(stringArray, delimiter);
    }

}
