/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation.springmodules;

import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.ValidatorResults;

/**
 * Jakarta CommonsValidatorpNX
 * 
 * <p>
 * validate()\bhI[o[ChĂB
 * eNXvalidate()\bhĂяoۂ
 * validation.xmlȂǂ̋Lq~XɂAof[gOꍇA
 * ̗OCX^X𑮐ɕێB
 * </p>
 * 
 * <p>
 * gpOclear()\bhŏꍇ̓XbhZ[tƂĎgp\B
 * </p>
 * 
 * <p>
 * {NX́ACommonsValidatorExɂĐB
 * ܂AɕێOCX^X́A
 * DefaultValidatorFactoryExɂėpB
 * </p>
 * 
 * <p>
 * {NX𗘗pꍇɕKvBean`t@C̐ݒɂẮA
 * DefaultValidatorFactoryExJavaDoc̋LqQƂ̂ƁB
 * </p>
 * 
 * 
 */
public class CommonsValidatorEx extends Validator {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = -7315991856716383283L;
    
    /**
     * XMLf[^̌؎ɔO
     */
    private ValidatorException validatorException = null;

    /**
     * RXgN^
     * @param resources ؃\[X
     * @param formName tH[
     */
    public CommonsValidatorEx(ValidatorResources resources, String formName) {
        super(resources, formName);
    }

    /**
     * XMLf[^̌؎ɔO擾
     * @return XMLf[^̌؎ɔO
     */
    public ValidatorException getValidatorException() {
        return validatorException;
    }

    /**
     * ؃\bh
     * Validatorvalidate()\bhĂяoA 
     * G[NX̑ɐݒ肵ăX[B 
     * @return ،
     * @throws XMLf[^̌؎ɔO
     */
    @Override
    public ValidatorResults validate() throws ValidatorException {
        try {
            return super.validate();
        } catch (ValidatorException e) {
            // XMLf[^̌؎ɗOꍇ́A
            // OvalidatorExceptionɕێAX[
            validatorException = e;
            throw e;
        }
    }
    
    /**
     * NA\bh
     * Validatorclear()\bhĂяoA 
     * NXvalidatorExceptionnullɐݒ肵܂B 
     */
    @Override
    public void clear() {
        super.clear();
        this.validatorException = null;
    }
}
