/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation.springmodules;

import junit.framework.TestCase;

import org.springframework.validation.Errors;

/**
 * {@link jp.terasoluna.fw.validation.springmodules.
 * BaseMultiFieldValidator} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * փ`FbNsȂۃNXB<br>
 * OFΏۂ̃IuWFNgAG[IuWFNgNulllɂȂȂB
 * <p>
 * 
 * @see jp.terasoluna.fw.validation.springmodules.
 * BaseMultiFieldValidator
 */
public class BaseMultiFieldValidatorTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(BaseMultiFieldValidatorTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public BaseMultiFieldValidatorTest(String name) {
        super(name);
    }

    /**
     * testValidate01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() obj:not null<br>
     *         () error:not null<br>
     *         () super.validateij:G[Ȃp^[<br>
     *                ierrorserrors.hasErrors()\bh
     *                FALSEɂȂ悤ɂj<br>
     *         
     * <br>
     * ҒlF(ԕω) super.validateij:
     *         \bhĂяo邱ƂmFB<br>
     *         (ԕω) validateMultiField():
     *         \bhĂяo邱ƂmFB
     *         󂯎ƂmFB<br>
     *         
     * <br>
     * Pڃ`FbNŃG[A
     * փ`FbN\bhsp^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testValidate01() throws Exception {
        // O --------------------------------------------------------------
        BaseMultiFieldValidatorImpl01 validator = 
            new BaseMultiFieldValidatorImpl01();
        
        // ValidatorFactory̍쐬
        BaseMultiFieldValidator_ValidatorFactoryStub01 factory =
            new BaseMultiFieldValidator_ValidatorFactoryStub01();
        BaseMutiFieldValidator_ValidatorStub01 commonsValidator =
            new BaseMutiFieldValidator_ValidatorStub01();
        factory.setValidator(commonsValidator);
        
        // ݒ
        validator.setValidatorFactory(factory);
        
        // \bh
        Object obj = new Object();
        Errors errors = 
            new BaseMultiFieldValidator_BindExceptionStub01(obj, "");

        // eXg{ ----------------------------------------------------------
        validator.validate(obj, errors);

        // 
        assertTrue(commonsValidator.isValidate);
        assertSame(obj, validator.obj);
        assertSame(errors, validator.errors);
    }

    /**
     * testValidate02()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() obj:not null<br>
     *         () error:not null<br>
     *         () super.validateij:G[p^[<br>
     *                ierrorserrors.hasErrors()\bh
     *                TRUEɂȂ悤ɂj<br>
     *         
     * <br>
     * ҒlF(ԕω) super.validateij:
     *          \bhĂяo邱ƂmFB
     *          󂯎ƂmFB<br>
     *         (ԕω) validateMultiField():
     *         \bhĂяoȂƂmFB<br>
     *         
     * <br>
     * Pڃ`FbNŃG[A
     * փ`FbN\bhsȂp^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testValidate02() throws Exception {
        // O --------------------------------------------------------------
        BaseMultiFieldValidatorImpl01 validator = 
            new BaseMultiFieldValidatorImpl01();
        
        // ValidatorFactory̍쐬
        BaseMultiFieldValidator_ValidatorFactoryStub01 factory =
            new BaseMultiFieldValidator_ValidatorFactoryStub01();
        BaseMutiFieldValidator_ValidatorStub01 commonsValidator =
            new BaseMutiFieldValidator_ValidatorStub01();
        factory.setValidator(commonsValidator);
        
        // ݒ
        validator.setValidatorFactory(factory);
        
        // \bh
        Object obj = new Object();
        Errors errors = 
            new BaseMultiFieldValidator_BindExceptionStub02(obj, "");

        // eXg{ ----------------------------------------------------------
        validator.validate(obj, errors);

        // 
        assertTrue(commonsValidator.isValidate);
        assertSame(null, validator.obj);
        assertSame(null, validator.errors);
    }

}
