/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.ex.unit.util;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import jp.terasoluna.fw.ex.unit.exception.UTRuntimeException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderUtils {
    protected static volatile ClassLoader previousClassLoader = null;

    private static Method getAddURLMethod() {
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            return method;
        }
        catch (Exception e) {
            throw new UTRuntimeException(e);
        }
    }

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static void setClassLoader(ClassLoader cl) {
        Thread.currentThread().setContextClassLoader(cl);
    }

    public static void addClassPath(URL url) {
        Assert.notNull((Object)url);
        ClassLoader cl = ClassLoaderUtils.getClassLoader();
        URLClassLoader newCl = null;
        if (cl instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)cl;
            newCl = new URLClassLoader(ucl.getURLs(), cl);
        } else {
            newCl = new URLClassLoader(null, cl);
        }
        Method method = ClassLoaderUtils.getAddURLMethod();
        try {
            method.invoke((Object)newCl, url);
        }
        catch (Exception e) {
            throw new UTRuntimeException(e);
        }
        previousClassLoader = cl;
        ClassLoaderUtils.setClassLoader(newCl);
    }

    public static void resetClassLoader() {
        if (previousClassLoader != null) {
            ClassLoaderUtils.setClassLoader(previousClassLoader);
        }
    }

    public static void addClassPath(File file) {
        Assert.notNull((Object)file);
        try {
            if (file.exists()) {
                ClassLoaderUtils.addClassPath(file.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new UTRuntimeException(e);
        }
    }

    public static void addClassPath(String path) {
        Assert.notNull((Object)path);
        ClassLoaderUtils.addClassPath(new File(path));
    }

    public static void addPathIfExists(List<String> destPaths, List<String> srcPaths) {
        Assert.notNull(destPaths);
        Assert.notNull(srcPaths);
        ClassLoader cl = ClassLoaderUtils.getClassLoader();
        for (String path : srcPaths) {
            if (path == null || cl.getResource(path) == null) continue;
            destPaths.add(path);
        }
    }
}

