/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.security.Principal;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;


/**
 *  HttpServletRequest ̃bNAbvNXB
 * <BR><BR>
 * ɁAAction NXeXgۂɗpB
 * 
 * <pre>
 * [gp]
 * // p[^̗p
 * ActionMapping mapping = new ActionMapping();
 * SampleActionForm form = new SampleActionForm();
 * MockHttpServletRequest req = new MockHttpServletRequest();
 * MockHttpServletResponse res = new MockHttpServletResponse();
 * 
 * // perform̌Ăяo
 * SampleAction action = new SampleAction();
 * action.execute(mapping, form, req, res);
 * </pre>
 * 
 */
public class MockHttpServletRequest extends MockServletRequest 
                                     implements HttpServletRequest {

    /**
     * T[ubgی삷邽߂ɎgpF̖ؕO
     */
    private String authType = null;

    /**
     * Cookie
     */
    private Cookie[] cookies = null;

    /**
     * HTTPwb_i[}bv
     */
    private Map httpHeaderMap = new HashMap();

    /**
     * \bh GETAPOSTAPUTȂǂȂ ftHgPOST
     */
    private String method = "POST";

    /**
     * NCAg URL Ɋ֘AtđMAǉ̃pX
     */
    private String pathInfo = null;
     
    /**
     * T[ubǧŃNG[̑OɂǉpX
     */
    private String pathTranslated = null;

    /**
     * ReLXgpX ftHg""
     */
    private String contextPath = "";

    /**
     * NG[XgO
     */
    private String queryString = null;

    /**
     * [UF؂Ăꍇ̃OC
     */
    private String remoteUser = null;

    /**
     * [U[[i[}bv
     */
    private Map roleMap = new HashMap();

    /**
     * ZbVID
     */
    private String requestedSessionId = null;

    /**
     * NGXgURI
     */
    private String requestURI = null;

    /**
     * NGXgURL
     */
    private StringBuffer requestURL = null;

    /**
     * T[ubgpX
     */
    private String servletPath = null;

    /**
     * ێHTTPZbV
     */
    HttpSession httpSession = new MockHttpSession();

    /**
     * @see javax.servlet.http.HttpServletRequest#getAuthType()
     */
    public String getAuthType() {
        return authType;
    }

    /**
     * T[ubgی삷邽߂ɎgpF̖ؕO
     * ݒ肷B
     *
     * @param authType F̖ؕO
     */
    public void setAuthType(String authType) {
        this.authType = authType;
    }
    
    /**
     * @see javax.servlet.http.HttpServletRequest#getAuthType()
     */
    public Cookie[] getCookies() {
        return cookies;
    }

    /**
     * Cookieݒ肷B
     * 
     * @param cookies ݒ肵Cookie̔z
     */
    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    /**
     * HTTPwb_̓e擾B
     *
     * @param name p[^
     * @return HTTPwb_
     */
    public String getHeader(String name) {
        String header = null;
        if (name != null && httpHeaderMap.get(name) != null) {
            header = (String) httpHeaderMap.get(name);
        }
        return header;
    }

    /**
     * HTTPwb_̓eݒ肷B
     *
     * @param name p[^
     * @param value p[^l
     */
    public void setHeader(String name, String value) {
        if (value != null) {
            httpHeaderMap.put(name, value);
        } else {
            httpHeaderMap.remove(name);
        }
    }

    /**
     * @see javax.servlet.http.HttpServletRequest#getHeaders(String)
     */
    public Enumeration getHeaders(String name) {
        Set set = new HashSet();
        Iterator iter = this.httpHeaderMap.values().iterator();
        while (iter.hasNext()) {
            if (name != null && ((String) iter.next()).equals(name)) {
                set.add(iter.next());
            }
        }
        return Collections.enumeration(set);
    }

    /**
     * ̃NGXgɊ܂܂SẴwb_EnumerationԂ܂B
     *
     * @return ̃NGXgƂƂɑMꂽSẴwb_ EnumerationB
     */
    public Enumeration getHeaderNames() {
        Set set = new HashSet();
        Iterator iter = this.httpHeaderMap.keySet().iterator();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        return Collections.enumeration(set);
    }

    /**
     * @see javax.servlet.http.HttpServletRequest#getIntHeader(String)
     */
    public int getIntHeader(String name) {
        int header = -1;
        if (name != null && httpHeaderMap.get(name) != null) {
            Object obj = (Object) httpHeaderMap.get(name);
            if (obj instanceof Integer) {
                header = ((Integer) obj).intValue();
            } else {
                throw new NumberFormatException("is not Integer");
            }
        }
        return header;
    }

    /**
     * @see javax.servlet.http.HttpServletRequest#getMethod()
     */
    public String getMethod() {
        return this.method;
    }

    /**
     * \bhݒ
     *
     * @param method GETAPOSTAPUT Ȃ
     */
    public void setMethod(String method) {
        this.method = method;
    }

    /**
     * @see javax.servlet.http.HttpServletRequest#getPathInfo()
     */
    public String getPathInfo() {
        return pathInfo;
    }

    /**
     * NCAg URL Ɋ֘AtđMAǉ̃pX̐ݒ
     *
     * @param pathInfo ǉ̃pX
     */
    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }
    
    /**
     * @see javax.servlet.http.HttpServletRequest#getPathTranslated()
     */
    public String getPathTranslated() {
        return this.pathTranslated;
    }
    
    /**
     * T[ubǧŃNG[̑OɂǉpX
     * ۂ̃pXɕϊĂݒ肷邱ƁB
     *
     * @param pathTranslated ۂ̃pXɕϊǉpX
     */
    public void setPathTranslated(String pathTranslated) {
        this.pathTranslated = pathTranslated;
    }

    /**
     * @see javax.servlet.http.HttpServletRequest#getContextPath()
     */
    public String getContextPath() {
        return this.contextPath;
    }

    /**
     * ReLXgpXݒB
     * ReLXgpX́u/vŎn܂邪A
     * u/vŏIȂɒӂ邱ƁB
     *
     * @param contextPath ݒ肵ReLXgpX
     */
    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    /**
     * @see javax.servlet.http.HttpServletRequest#getQueryString()
     */
    public String getQueryString() {
        return queryString;
    }

    /**
     * NG[XgOݒ
     *
     * @param queryString NG[XgO
     */
    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    /**
     * @see javax.servlet.http.HttpServletRequest#getRemoteUser()
     */
    public String getRemoteUser() {
        return remoteUser;
    }

    /**
     * [UF؂Ăꍇ̃OCݒ肷B
     *
     * @param remoteUser [UF؂Ăꍇ̃OC
     */
    public void getRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    /**
     * @see javax.servlet.http.HttpServletRequest#isUserInRole(String)
     */
    public boolean isUserInRole(String role) {
        boolean inRole = false;
        if (role != null) {
            Boolean tmpInRole = (Boolean) roleMap.get(role);
            if (tmpInRole != null) {
                inRole = tmpInRole.booleanValue();
            }
        }
        return inRole;
    }

    /**
     * F؂ꂽ[Uw肳ꂽ_Iȁu[vɊ܂܂Ă邩ǂ
     * ݒ肷B
     *
     * @param role [
     * @param isUserInRole [U[Ɋ܂܂邩ǂ
     */
    public void setUserInRole(String role, boolean isUserInRole) {
        roleMap.put(role, new Boolean(isUserInRole));
    }

    /**
     * @see javax.servlet.http.HttpServletRequest#getRequestedSessionId()
     */
    public String getRequestedSessionId() {
        return requestedSessionId;
    }

    /**
     * ZbVIDݒ肷B
     *
     * @param requestedSessionId ZbVID
     */
    public void setRequestedSessionId(String requestedSessionId) {
        this.requestedSessionId = requestedSessionId;
    }

    /**
     * @see javax.servlet.http.HttpServletRequest#getRequestURI()
     */
    public String getRequestURI() {
        return this.requestURI;
    }

    /**
     * HTTP v̍ŏ̍sɂ邱̗v URL ́A
     * vgRNG[܂ł̕ݒ肵܂B
     * ̐ݒQƂĂB 
     *
     * HTTP v̍ŏ̍s ݒ肷ׂl
     * POST /some/path.html HTTP/1.1   /some/path.html  
     * GET http://foo.bar/a.html HTTP/1.0   /a.html  
     * HEAD /xyz?a=b HTTP/1.1   /xyz
     * 
     * @param requestURI NGXgURI̕  
     */
    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }
    
    /**
     * @see javax.servlet.http.HttpServletRequest#getRequestURI()
     */
    public StringBuffer getRequestURL() {
        return requestURL;
    }
    
    /**
     * NGXgURLݒ
     *
     * @param requestURL http://n܂URL
     */
    public void setRequestURL(StringBuffer requestURL) {
        this.requestURL = requestURL;
    }
    
    /**
     * @see javax.servlet.http.HttpServletRequest#getRequestURI()
     */
    public String getServletPath() {
        return this.servletPath;
    }

    /**
     * T[ubgpXݒ
     *
     * URLhttp://localhost:7001/sample1/common/blank.jspł
     * T[ubgpX/common/blank.jspƂȂlɐݒ肷邱ƁB
     *
     * @param servletPath T[ubgpX
     */
    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }
    
    /**
     * @see javax.servlet.http.HttpServletRequest#getSession(boolean)
     */
    public HttpSession getSession(boolean create) {
        if (create && httpSession == null) {
            httpSession = new MockHttpSession();
        }
        return httpSession;
    }
    
    /**
     * @see javax.servlet.http.HttpServletRequest#getSession(boolean)
     */
    public HttpSession getSession() {
        return httpSession;
    }
    
    /**
     * HttpSessionݒ肷B
     *
     * @param httpSession HTTPZbVIuWFNg
     */
    public void setSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }
    
    /**
     * @see javax.servlet.http.HttpServletRequest#getUserPrincipal()
     */
    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException(
            "getUserPrincipal() IS Not Supported!");
    }
    
    /**
     * @see javax.servlet.http.HttpServletRequest#getDateHeader(String)
     */
    public long getDateHeader(String name) {
        throw new UnsupportedOperationException(
            "getDateHeader() IS Not Supported!");
    }

    /**
     * @see javax.servlet.http.HttpServletRequest
     * #isRequestedSessionIdValid()
     */
    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException(
            "isRequestedSessionIdValid() IS Not Supported!");
    }
    
    /**
     * @see javax.servlet.http.HttpServletRequest#
     * isRequestedSessionIdFromCookie()
     */
    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException(
            "isRequestedSessionIdFromCookie() IS Not Supported!");
    }
    
    /**
     * @see javax.servlet.http.HttpServletRequest#
     * isRequestedSessionIdFromURL()
     */
    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException(
            "isRequestedSessionIdFromURL() IS Not Supported!");
    }
    
    /**
     * @see javax.servlet.http.HttpServletRequest#
     * isRequestedSessionIdFromUrl()
     */
    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException(
            "isRequestedSessionIdFromUrl() IS Not Supported!");
    }

}
