/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.message;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.message.DBMessage} NX̃ubN{bNXeXgB
 * <p>
 * <h4>yNX̊Tvz</h4>
 * bZ[W\[XێNXB
 * <p>
 * 
 * @see jp.terasoluna.fw.message.DBMessage
 * @version 2005/12/5
 */
public class DBMessageTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * 
     * @param args
     *            java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DBMessageTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name
     *            ̃eXgP[X̖OB
     */
    public DBMessageTest(String name) {
        super(name);
    }

    /**
     * testDBMessage01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() code:"abc"<br>
     * () language:"def"<br>
     * () country:"ghi"<br>
     * () variant:"jkl"<br>
     * () message:"mno"<br>
     * <br>
     * ҒlF(ԕω) code:"abc"<br>
     * (ԕω) language:"def"<br>
     * (ԕω) country:"ghi"<br>
     * (ԕω) variant:"jkl"<br>
     * (ԕω) message:"mno"<br>
     * <br>
     * Ƃė^ꂽlɂȂ邩mFB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testDBMessage01()
            throws Exception {
        // O
        DBMessage db = new DBMessage("abc", "def", "ghi", "jkl", "mno");

        // eXg{

        // 
        assertEquals("abc", UTUtil.getPrivateField(db, "code"));
        assertEquals("def", UTUtil.getPrivateField(db, "language"));
        assertEquals("ghi", UTUtil.getPrivateField(db, "country"));
        assertEquals("jkl", UTUtil.getPrivateField(db, "variant"));
        assertEquals("mno", UTUtil.getPrivateField(db, "message"));
    }

    /**
     * testGetCode01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() code:"abc"<br>
     * <br>
     * ҒlF(߂l) String:"abc"<br>
     * <br>
     * n1̂݃eXg <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetCode01() throws Exception {
        // O
        DBMessage db = new DBMessage(null, null, null, null, null);
        UTUtil.setPrivateField(db, "code", "abc");
        
        // eXg{
        String returnCode = db.getCode();

        // 
        assertEquals("abc", returnCode);
    }

    /**
     * testGetLanguage01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() language:"abc"<br>
     * <br>
     * ҒlF(߂l) String:"abc"<br>
     * <br>
     * n1̂݃eXg <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetLanguage01() throws Exception {
        // O
        DBMessage db = new DBMessage(null, null, null, null, null);
        UTUtil.setPrivateField(db, "language", "abc");
        
        // eXg{
        String returnLanguage = db.getLanguage();

        // 
        assertEquals("abc", returnLanguage);
    }

    /**
     * testGetCountry01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() country:"abc"<br>
     * <br>
     * ҒlF(߂l) String:"abc"<br>
     * <br>
     * n1̂݃eXg <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetCountry01() throws Exception {
        // O
        DBMessage db = new DBMessage(null, null, null, null, null);
        UTUtil.setPrivateField(db, "country", "abc");
        
        // eXg{
        String returnCountry = db.getCountry();
        // 
        assertEquals("abc", returnCountry);
    }

    /**
     * testGetVariant01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() variant:"abc"<br>
     * <br>
     * ҒlF(߂l) String:"abc"<br>
     * <br>
     * n1̂݃eXg <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetVariant01() throws Exception {
        // O
        DBMessage db = new DBMessage(null, null, null, null, null);
        UTUtil.setPrivateField(db, "variant", "abc");
        
        // eXg{
        String returnVariant = db.getVariant();

        // 
        assertEquals("abc", returnVariant);
    }

    /**
     * testGetMessage01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() message:"abc"<br>
     * <br>
     * ҒlF(߂l) String:"abc"<br>
     * <br>
     * n1̂݃eXg <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetMessage01() throws Exception {
        // O
        DBMessage db = new DBMessage(null, null, null, null, null);
        UTUtil.setPrivateField(db, "message", "abc");
        
        // eXg{
        String returnMessage = db.getMessage();
        
        // 
        assertEquals("abc", returnMessage);
    }
}
