/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.codelist;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import jp.terasoluna.fw.web.codelist.LocaleCodeBean;
import org.springframework.jdbc.object.MappingSqlQuery;

public class DBCodeListQuery
extends MappingSqlQuery {
    public DBCodeListQuery(DataSource dataSource, String sql) {
        super(dataSource, sql);
    }

    protected Object mapRow(ResultSet rs, int rowNum) throws SQLException {
        return this.createCodeBean(rs);
    }

    private LocaleCodeBean createCodeBean(ResultSet rs) throws SQLException {
        LocaleCodeBean cb = new LocaleCodeBean();
        int columnCount = rs.getMetaData().getColumnCount();
        if (columnCount > 0) {
            String id = rs.getString(1);
            if (id == null) {
                id = "";
            }
            cb.setId(id);
        }
        if (columnCount > 1) {
            String name = rs.getString(2);
            if (name == null) {
                name = "";
            }
            cb.setName(name);
        }
        if (columnCount > 2) {
            String language = rs.getString(3);
            if (language == null) {
                language = "";
            }
            cb.setLanguage(language);
        }
        if (columnCount > 3) {
            String country = rs.getString(4);
            if (country == null) {
                country = "";
            }
            cb.setCountry(country);
        }
        if (columnCount > 4) {
            String variant = rs.getString(5);
            if (variant == null) {
                variant = "";
            }
            cb.setVariant(variant);
        }
        return cb;
    }
}

