/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.actions;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.fw.web.struts.actions.ActionEx;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ForwardAction
extends ActionEx {
    private static Log log = LogFactory.getLog(ForwardAction.class);
    private static final String FORWARD_ERRORPAGE_ERROR = "error.forward.errorpage";
    private static final String FORWARD_SUCCESS = "success";
    private static final String FORWARD_ACTION_CONTEXT_RELATIVE_KEY = "forwardAction.contextRelative";

    public ActionForward doExecute(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"doExecute() called.");
        }
        String path = mapping.getParameter();
        ActionForward retVal = null;
        if (path == null) {
            retVal = mapping.findForward(FORWARD_SUCCESS);
            if (retVal == null) {
                try {
                    res.sendError(404);
                }
                catch (IOException e) {
                    log.error((Object)"Error page(404) forwarding failed.");
                    throw new SystemException((Throwable)e, FORWARD_ERRORPAGE_ERROR);
                }
                return null;
            }
            return retVal;
        }
        retVal = new ActionForward(path);
        String contextRelativeStr = PropertyUtil.getProperty((String)FORWARD_ACTION_CONTEXT_RELATIVE_KEY, (String)Boolean.FALSE.toString());
        Boolean contextRelative = new Boolean(contextRelativeStr);
        retVal.setContextRelative(contextRelative.booleanValue());
        if (log.isDebugEnabled()) {
            StringBuilder debugLog = new StringBuilder();
            debugLog.append("contextRelative:");
            debugLog.append(contextRelative);
            log.debug((Object)debugLog.toString());
        }
        return retVal;
    }
}

