/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.form;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import jp.terasoluna.fw.beans.JXPathIndexedBeanWrapperImpl;
import jp.terasoluna.fw.util.ClassLoadException;
import jp.terasoluna.fw.util.ClassUtil;
import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.fw.web.struts.form.ActionFormUtil;
import jp.terasoluna.fw.web.struts.form.MultiFieldValidator;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.GenericTypeValidator;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.RequestUtils;
import org.apache.struts.validator.FieldChecks;
import org.apache.struts.validator.Resources;
import org.apache.struts.validator.validwhen.ValidWhen;

public class FieldChecksEx
extends FieldChecks {
    private static final long serialVersionUID = -5669122584668175380L;
    private static Log log = LogFactory.getLog(FieldChecksEx.class);
    public static final String INDEX = "##INDEX";
    protected static String hankakuKanaList = "\uff71\uff72\uff73\uff74\uff75\uff67\uff68\uff69\uff6a\uff6b\uff76\uff77\uff78\uff79\uff7a\uff7b\uff7c\uff7d\uff7e\uff7f\uff80\uff81\uff82\uff6f\uff83\uff84\uff85\uff86\uff87\uff88\uff89\uff8a\uff8b\uff8c\uff8d\uff8e\uff8f\uff90\uff91\uff92\uff93\uff94\uff95\uff96\uff6c\uff6d\uff6e\uff97\uff98\uff99\uff9a\uff9b\uff9c\uff66\uff9d\uff9f\uff9e\uff70\uff65\uff64\uff61\uff62\uff63";
    protected static String zenkakuKanaList = "\u30a2\u30a4\u30a6\u30f4\u30a8\u30aa\u30a1\u30a3\u30a5\u30a7\u30a9\u30ab\u30ad\u30af\u30b1\u30b3\u30f5\u30f6\u30ac\u30ae\u30b0\u30b2\u30b4\u30b5\u30b7\u30b9\u30bb\u30bd\u30b6\u30b8\u30ba\u30bc\u30be\u30bf\u30c1\u30c4\u30c6\u30c8\u30c0\u30c2\u30c5\u30c7\u30c9\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30d0\u30d3\u30d6\u30d9\u30dc\u30d1\u30d4\u30d7\u30da\u30dd\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e3\u30e5\u30e7\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30ee\u30f0\u30f1\u30f2\u30c3\u30f3\u30fc";
    protected static final String HANKAKU_KANA_LIST_KEY = "validation.hankaku.kana.list";
    protected static final String ZENKAKU_KANA_LIST_KEY = "validation.zenkaku.kana.list";
    protected static final String ZENKAKU_BEGIN_U00_LIST = "\uff3c\uffe0\uffe1\u00a7\u00a8\uffe2\u00b0\u00b1\u00b4\u00b6\u00d7\u00f7";

    protected static boolean isHankakuKana(char c) {
        return hankakuKanaList.indexOf(c) >= 0;
    }

    protected static boolean isHankaku(char c) {
        return c <= '\u00ff' && ZENKAKU_BEGIN_U00_LIST.indexOf(c) < 0 || FieldChecksEx.isHankakuKana(c);
    }

    protected static boolean isZenkaku(char c) {
        return !FieldChecksEx.isHankaku(c);
    }

    protected static boolean isZenkakuKana(char c) {
        return zenkakuKanaList.indexOf(c) >= 0;
    }

    public static boolean validateAlphaNumericString(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Field fieldClone = (Field)field.clone();
        fieldClone.addVar("mask", "^[0-9a-zA-Z]*$", "false");
        return FieldChecksEx.validateMask((Object)bean, (ValidatorAction)va, (Field)fieldClone, (ActionMessages)errors, (Validator)validator, (HttpServletRequest)request);
    }

    public static boolean validateCapAlphaNumericString(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Field fieldClone = (Field)field.clone();
        fieldClone.addVar("mask", "^[0-9A-Z]*$", "false");
        return FieldChecksEx.validateMask((Object)bean, (ValidatorAction)va, (Field)fieldClone, (ActionMessages)errors, (Validator)validator, (HttpServletRequest)request);
    }

    public static boolean validateNumber(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        if (bean == null) {
            log.error((Object)"bean is null.");
            return true;
        }
        String integerLength = field.getVarValue("integerLength");
        String scaleStr = field.getVarValue("scale");
        String isAccordedInteger = field.getVarValue("isAccordedInteger");
        String isAccordedScale = field.getVarValue("isAccordedScale");
        String value = null;
        value = FieldChecksEx.isString((Object)bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (FieldChecksEx.isHankaku(chars[i])) continue;
            errors.add(field.getKey(), Resources.getActionMessage((Validator)validator, (HttpServletRequest)request, (ValidatorAction)va, (Field)field));
            return false;
        }
        if (GenericValidator.isInt((String)integerLength)) {
            try {
                BigDecimal bd = new BigDecimal(value);
                BigInteger bi = bd.toBigInteger().abs();
                int length = bi.toString().length();
                int checkLength = Integer.valueOf(integerLength);
                if (length > checkLength) {
                    errors.add(field.getKey(), Resources.getActionMessage((Validator)validator, (HttpServletRequest)request, (ValidatorAction)va, (Field)field));
                    return false;
                }
                if (isAccordedInteger != null && "true".equals(isAccordedInteger) && length != checkLength) {
                    errors.add(field.getKey(), Resources.getActionMessage((Validator)validator, (HttpServletRequest)request, (ValidatorAction)va, (Field)field));
                    return false;
                }
            }
            catch (NumberFormatException nfe) {
                errors.add(field.getKey(), Resources.getActionMessage((Validator)validator, (HttpServletRequest)request, (ValidatorAction)va, (Field)field));
                return false;
            }
        }
        if (GenericValidator.isInt((String)scaleStr)) {
            int scale = 0;
            int checkScale = 0;
            try {
                BigDecimal bd = new BigDecimal(value);
                scale = bd.scale();
                checkScale = Integer.valueOf(scaleStr);
            }
            catch (NumberFormatException e) {
                errors.add(field.getKey(), Resources.getActionMessage((Validator)validator, (HttpServletRequest)request, (ValidatorAction)va, (Field)field));
                return false;
            }
            if (scale > checkScale) {
                errors.add(field.getKey(), Resources.getActionMessage((Validator)validator, (HttpServletRequest)request, (ValidatorAction)va, (Field)field));
                return false;
            }
            if (isAccordedScale != null && "true".equals(isAccordedScale) && scale != checkScale) {
                errors.add(field.getKey(), Resources.getActionMessage((Validator)validator, (HttpServletRequest)request, (ValidatorAction)va, (Field)field));
                return false;
            }
        }
        return true;
    }

    public static boolean validateHankakuKanaString(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        if (bean == null) {
            log.error((Object)"bean is null.");
            return true;
        }
        String value = null;
        value = FieldChecksEx.isString((Object)bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (FieldChecksEx.isHankakuKana(chars[i])) continue;
            errors.add(field.getKey(), Resources.getActionMessage((Validator)validator, (HttpServletRequest)request, (ValidatorAction)va, (Field)field));
            return false;
        }
        return true;
    }

    public static boolean validateHankakuString(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        if (bean == null) {
            log.error((Object)"bean is null.");
            return true;
        }
        String value = null;
        value = FieldChecksEx.isString((Object)bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (FieldChecksEx.isHankaku(chars[i])) continue;
            errors.add(field.getKey(), Resources.getActionMessage((Validator)validator, (HttpServletRequest)request, (ValidatorAction)va, (Field)field));
            return false;
        }
        return true;
    }

    public static boolean validateZenkakuString(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        if (bean == null) {
            log.error((Object)"bean is null.");
            return true;
        }
        String value = null;
        value = FieldChecksEx.isString((Object)bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (FieldChecksEx.isZenkaku(chars[i])) continue;
            errors.add(field.getKey(), Resources.getActionMessage((Validator)validator, (HttpServletRequest)request, (ValidatorAction)va, (Field)field));
            return false;
        }
        return true;
    }

    public static boolean validateZenkakuKanaString(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        if (bean == null) {
            log.error((Object)"bean is null.");
            return true;
        }
        String value = null;
        value = FieldChecksEx.isString((Object)bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (FieldChecksEx.isZenkakuKana(chars[i])) continue;
            errors.add(field.getKey(), Resources.getActionMessage((Validator)validator, (HttpServletRequest)request, (ValidatorAction)va, (Field)field));
            return false;
        }
        return true;
    }

    public static boolean validateProhibited(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        if (bean == null) {
            log.error((Object)"bean is null.");
            return true;
        }
        String prohibitedStr = field.getVarValue("chars");
        if (prohibitedStr == null || "".equals(prohibitedStr)) {
            return true;
        }
        String value = null;
        value = FieldChecksEx.isString((Object)bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (prohibitedStr.indexOf(chars[i]) < 0) continue;
            errors.add(field.getKey(), Resources.getActionMessage((Validator)validator, (HttpServletRequest)request, (ValidatorAction)va, (Field)field));
            return false;
        }
        return true;
    }

    public static boolean validateNumericString(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Field fieldClone = (Field)field.clone();
        fieldClone.addVar("mask", "^[0-9]*$", "false");
        return FieldChecksEx.validateMask((Object)bean, (ValidatorAction)va, (Field)fieldClone, (ActionMessages)errors, (Validator)validator, (HttpServletRequest)request);
    }

    public static boolean validateStringLength(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        if (bean == null) {
            log.error((Object)"bean is null.");
            return true;
        }
        String lengthStr = field.getVarValue("stringLength");
        if (lengthStr == null || "".equals(lengthStr)) {
            return true;
        }
        String value = null;
        value = FieldChecksEx.isString((Object)bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        int checkLength = 0;
        try {
            checkLength = Integer.valueOf(lengthStr);
        }
        catch (NumberFormatException e) {
            log.error((Object)"stringLength is not numeric(integer).", (Throwable)e);
            return true;
        }
        if (value.length() != checkLength) {
            errors.add(field.getKey(), Resources.getActionMessage((Validator)validator, (HttpServletRequest)request, (ValidatorAction)va, (Field)field));
            return false;
        }
        return true;
    }

    public static boolean validateByteLength(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        if (bean == null) {
            log.error((Object)"bean is null.");
            return true;
        }
        String value = null;
        value = FieldChecksEx.isString((Object)bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        String lengthStr = field.getVarValue("byteLength");
        if (lengthStr == null || "".equals(lengthStr)) {
            if (log.isInfoEnabled()) {
                log.info((Object)"length is not specified.");
            }
            return true;
        }
        int checkLength = 0;
        try {
            checkLength = Integer.valueOf(lengthStr);
        }
        catch (NumberFormatException e) {
            log.error((Object)"byteLength is not numeric(integer).", (Throwable)e);
            return true;
        }
        String encoding = field.getVarValue("encoding");
        int bytesLength = FieldChecksEx.getByteLength(value, encoding);
        if (bytesLength != checkLength) {
            errors.add(field.getKey(), Resources.getActionMessage((Validator)validator, (HttpServletRequest)request, (ValidatorAction)va, (Field)field));
            return false;
        }
        return true;
    }

    public static boolean validateByteRange(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        if (bean == null) {
            log.error((Object)"bean is null.");
            return true;
        }
        String value = null;
        value = FieldChecksEx.isString((Object)bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        String encoding = field.getVarValue("encoding");
        int bytesLength = FieldChecksEx.getByteLength(value, encoding);
        int min = 0;
        String minStr = field.getVarValue("minByte");
        if (!GenericValidator.isBlankOrNull((String)minStr)) {
            try {
                min = Integer.parseInt(minStr);
            }
            catch (NumberFormatException e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        int max = Integer.MAX_VALUE;
        String maxStr = field.getVarValue("maxByte");
        if (!GenericValidator.isBlankOrNull((String)maxStr)) {
            try {
                max = Integer.parseInt(maxStr);
            }
            catch (NumberFormatException e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        if (!GenericValidator.isInRange((int)bytesLength, (int)min, (int)max)) {
            errors.add(field.getKey(), Resources.getActionMessage((Validator)validator, (HttpServletRequest)request, (ValidatorAction)va, (Field)field));
            return false;
        }
        return true;
    }

    public static boolean validateDateRange(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        if (bean == null) {
            log.error((Object)"bean is null.");
            return true;
        }
        String value = null;
        value = FieldChecksEx.isString((Object)bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        String datePattern = field.getVarValue("datePattern");
        String datePatternStrict = field.getVarValue("datePatternStrict");
        Locale locale = RequestUtils.getUserLocale((HttpServletRequest)request, null);
        Date result = null;
        try {
            result = datePattern != null && datePattern.length() > 0 ? GenericTypeValidator.formatDate((String)value, (String)datePattern, (boolean)false) : (datePatternStrict != null && datePatternStrict.length() > 0 ? GenericTypeValidator.formatDate((String)value, (String)datePatternStrict, (boolean)true) : GenericTypeValidator.formatDate((String)value, (Locale)locale));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage((Validator)validator, (HttpServletRequest)request, (ValidatorAction)va, (Field)field));
            return false;
        }
        String startDateStr = field.getVarValue("startDate");
        String endDateStr = field.getVarValue("endDate");
        if (startDateStr == null && endDateStr == null) {
            return true;
        }
        if (startDateStr != null && startDateStr.length() > 0) {
            Date startDate = null;
            startDate = datePattern != null && datePattern.length() > 0 ? GenericTypeValidator.formatDate((String)startDateStr, (String)datePattern, (boolean)false) : (datePatternStrict != null && datePatternStrict.length() > 0 ? GenericTypeValidator.formatDate((String)startDateStr, (String)datePatternStrict, (boolean)true) : GenericTypeValidator.formatDate((String)startDateStr, (Locale)locale));
            if (startDate == null) {
                errors.add(field.getKey(), Resources.getActionMessage((Validator)validator, (HttpServletRequest)request, (ValidatorAction)va, (Field)field));
                return false;
            }
            if (result.before(startDate)) {
                errors.add(field.getKey(), Resources.getActionMessage((Validator)validator, (HttpServletRequest)request, (ValidatorAction)va, (Field)field));
                return false;
            }
        }
        if (endDateStr != null && endDateStr.length() > 0) {
            Date endDate = null;
            endDate = datePattern != null && datePattern.length() > 0 ? GenericTypeValidator.formatDate((String)endDateStr, (String)datePattern, (boolean)false) : (datePatternStrict != null && datePatternStrict.length() > 0 ? GenericTypeValidator.formatDate((String)endDateStr, (String)datePatternStrict, (boolean)true) : GenericTypeValidator.formatDate((String)endDateStr, (Locale)locale));
            if (endDate == null) {
                errors.add(field.getKey(), Resources.getActionMessage((Validator)validator, (HttpServletRequest)request, (ValidatorAction)va, (Field)field));
                return false;
            }
            if (result.after(endDate)) {
                errors.add(field.getKey(), Resources.getActionMessage((Validator)validator, (HttpServletRequest)request, (ValidatorAction)va, (Field)field));
                return false;
            }
        }
        return true;
    }

    public static boolean validateMultiField(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        if (bean == null) {
            log.error((Object)"bean is null.");
            return true;
        }
        String value = null;
        value = FieldChecksEx.isString((Object)bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        String multiFieldValidatorClass = field.getVarValue("multiFieldValidator");
        if (multiFieldValidatorClass == null || "".equals(multiFieldValidatorClass)) {
            log.error((Object)"var value[multiFieldValidator] is required.");
            throw new IllegalArgumentException("var value[multiFieldValidator] is required.");
        }
        MultiFieldValidator mfv = null;
        try {
            mfv = (MultiFieldValidator)ClassUtil.create((String)multiFieldValidatorClass);
        }
        catch (ClassLoadException e) {
            log.error((Object)"var value[multiFieldValidator] is invalid.", (Throwable)e);
            throw new IllegalArgumentException("var value[multiFieldValidator] is invalid.", e);
        }
        catch (ClassCastException e) {
            log.error((Object)"var value[multiFieldValidator] is invalid.", (Throwable)e);
            throw new IllegalArgumentException("var value[multiFieldValidator] is invalid.", e);
        }
        String fields = field.getVarValue("fields");
        ArrayList<String> valueList = new ArrayList<String>();
        if (fields != null) {
            StringTokenizer st = new StringTokenizer(fields, ",");
            while (st.hasMoreTokens()) {
                String f = st.nextToken();
                f = f.trim();
                valueList.add(ValidatorUtils.getValueAsString((Object)bean, (String)f));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("dependent fields:" + valueList));
        }
        String[] values = new String[valueList.size()];
        valueList.toArray(values);
        boolean result = mfv.validate(value, values);
        if (!result) {
            errors.add(field.getKey(), Resources.getActionMessage((Validator)validator, (HttpServletRequest)request, (ValidatorAction)va, (Field)field));
            return false;
        }
        return true;
    }

    public static boolean validateArraysIndex(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        int methodArgCount = 6;
        boolean totalResult = true;
        try {
            Class[] paramClass = FieldChecksEx.getParamClass(va);
            if (paramClass == null) {
                log.error((Object)"Can not get class pattern.");
                return true;
            }
            if (paramClass.length == 0) {
                log.error((Object)"Class pattern length is zero.");
                return true;
            }
            Method method = FieldChecksEx.getMethod(va, paramClass);
            if (method == null) {
                log.error((Object)"Can not get validateMethod.");
                return true;
            }
            ActionForm form = FieldChecksEx.getActionForm(request);
            if (form == null) {
                log.error((Object)"Can not get ActionForm.");
                return true;
            }
            Object[] argParams = new Object[methodArgCount];
            argParams[0] = form;
            argParams[1] = va;
            argParams[3] = errors;
            argParams[4] = validator;
            argParams[5] = request;
            JXPathIndexedBeanWrapperImpl wrapper = new JXPathIndexedBeanWrapperImpl((Object)form);
            Map propertyMap = wrapper.getIndexedPropertyValues(field.getKey());
            int index = 0;
            for (String key : propertyMap.keySet()) {
                Field indexedField = (Field)field.clone();
                indexedField.setIndexedListProperty(null);
                indexedField = FieldChecksEx.getArrayIndexField(indexedField, index);
                indexedField.setKey(key);
                indexedField.setProperty(key);
                argParams[2] = indexedField;
                Object resultObj = method.invoke(FieldChecksEx.class, argParams);
                if (!FieldChecksEx.isValid(resultObj)) {
                    totalResult = false;
                }
                ++index;
            }
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"", (Throwable)e);
            return true;
        }
        catch (IllegalAccessException e) {
            log.error((Object)"", (Throwable)e);
            return true;
        }
        catch (InvocationTargetException e) {
            log.error((Object)"", (Throwable)e);
            return true;
        }
        return totalResult;
    }

    protected static ActionForm getActionForm(HttpServletRequest request) {
        String formName = ActionFormUtil.getActionFormName(request);
        if (formName == null) {
            return null;
        }
        Object obj = request.getSession(true).getAttribute(formName);
        ActionForm form = null;
        if (obj instanceof ActionForm) {
            form = (ActionForm)obj;
        }
        if (form == null && (obj = request.getAttribute(formName)) instanceof ActionForm) {
            form = (ActionForm)obj;
        }
        return form;
    }

    protected static Class[] getParamClass(ValidatorAction va) {
        String methodParams = va.getMethodParams();
        if (methodParams == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(methodParams, ",");
        Class[] paramClass = new Class[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            try {
                String key = st.nextToken().trim();
                paramClass[i] = ClassUtils.getClass((String)key);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)"", (Throwable)e);
                return null;
            }
            ++i;
        }
        return paramClass;
    }

    protected static Method getMethod(ValidatorAction va, Class[] paramClass) {
        String methodNameSource = va.getName();
        if (methodNameSource == null || "".equals(methodNameSource)) {
            return null;
        }
        char[] chars = methodNameSource.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        String validate = "validate" + new String(chars);
        String methodName = validate.substring(0, validate.length() - "Array".length());
        Method method = null;
        try {
            method = FieldChecksEx.class.getMethod(methodName, paramClass);
        }
        catch (NoSuchMethodException e) {
            try {
                method = ValidWhen.class.getMethod(methodName, paramClass);
            }
            catch (NoSuchMethodException e1) {
                log.error((Object)"", (Throwable)e);
                log.error((Object)"", (Throwable)e1);
                return null;
            }
        }
        return method;
    }

    protected static boolean isValid(Object result) {
        boolean isValid = false;
        if (!(result instanceof Boolean)) {
            return true;
        }
        Boolean valid = (Boolean)result;
        isValid = valid;
        return isValid;
    }

    protected static Field getArrayIndexField(Field field, int pos) {
        Field cloneField = (Field)field.clone();
        Arg argParam = null;
        String argStr = null;
        argParam = cloneField.getArg(0);
        if (argParam != null) {
            argStr = argParam.getKey();
            cloneField.getArg(0).setKey(FieldChecksEx.replaceIndexString(argStr, pos + 1));
        }
        if ((argParam = cloneField.getArg(1)) != null) {
            argStr = argParam.getKey();
            cloneField.getArg(1).setKey(FieldChecksEx.replaceIndexString(argStr, pos + 1));
        }
        if ((argParam = cloneField.getArg(2)) != null) {
            argStr = argParam.getKey();
            cloneField.getArg(2).setKey(FieldChecksEx.replaceIndexString(argStr, pos + 1));
        }
        if ((argParam = cloneField.getArg(3)) != null) {
            argStr = argParam.getKey();
            cloneField.getArg(3).setKey(FieldChecksEx.replaceIndexString(argStr, pos + 1));
        }
        return cloneField;
    }

    protected static String replaceIndexString(String arg, int pos) {
        if (arg == null) {
            return null;
        }
        if (INDEX.equalsIgnoreCase(arg)) {
            return Integer.toString(pos);
        }
        return arg;
    }

    protected static int getByteLength(String value, String encoding) {
        if (value == null || "".equals(value)) {
            return 0;
        }
        byte[] bytes = null;
        if (encoding == null || "".equals(encoding)) {
            bytes = value.getBytes();
        } else {
            try {
                bytes = value.getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)(encoding + " is not supported."));
                }
                bytes = value.getBytes();
            }
        }
        return bytes == null ? 0 : bytes.length;
    }

    public static String getHankakuKanaList() {
        return hankakuKanaList;
    }

    public static String getZenkakuKanaList() {
        return zenkakuKanaList;
    }

    static {
        String value = null;
        value = PropertyUtil.getProperty((String)HANKAKU_KANA_LIST_KEY);
        if (value != null) {
            hankakuKanaList = value;
        }
        if ((value = PropertyUtil.getProperty((String)ZENKAKU_KANA_LIST_KEY)) != null) {
            zenkakuKanaList = value;
        }
    }
}

