/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.taglib;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import jp.terasoluna.fw.web.codelist.CodeBean;
import jp.terasoluna.fw.web.codelist.CodeListLoader;
import jp.terasoluna.fw.web.taglib.TagUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.RequestUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class WriteCodeValueTag
extends TagSupport {
    private static final long serialVersionUID = 8199383777405058816L;
    private static Log log = LogFactory.getLog(WriteCodeValueTag.class);
    private String codeList = null;
    private String key = null;
    private String name = null;
    private String property = null;
    private String scope = null;

    public void setName(String name) {
        this.name = name;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setCodeList(String codeList) {
        this.codeList = codeList;
    }

    public int doStartTag() throws JspException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"doStartTag() called.");
        }
        if ("".equals(this.codeList) || this.codeList == null) {
            log.error((Object)"codeList is required.");
            throw new JspTagException("codeList is required.");
        }
        if (this.key == null && this.name == null) {
            log.error((Object)"key and name is required.");
            throw new JspTagException("key and name is required.");
        }
        String codeKey = null;
        if (this.key == null && this.name != null) {
            if (TagUtil.lookup(this.pageContext, this.name, this.scope) == null) {
                log.error((Object)("bean id:" + this.name + " is not defined."));
                throw new JspTagException("bean id:" + this.name + " is not defined.");
            }
            Object bean = null;
            try {
                bean = TagUtil.lookup(this.pageContext, this.name, this.property, this.scope);
            }
            catch (JspException e) {
                // empty catch block
            }
            if (bean == null) {
                log.error((Object)("Cannot get property[" + this.name + "." + this.property + "]."));
                throw new JspTagException("Cannot get property[" + this.name + "." + this.property + "].");
            }
            codeKey = bean.toString();
        } else {
            codeKey = this.key;
        }
        ServletContext sc = this.pageContext.getServletContext();
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)sc);
        CodeListLoader loader = null;
        if (context.containsBean(this.codeList)) {
            try {
                loader = (CodeListLoader)context.getBean(this.codeList);
            }
            catch (ClassCastException e) {
                String errorMessage = "bean id:" + this.codeList + " is not instance of CodeListLoader.";
                log.error((Object)errorMessage);
                throw new JspTagException(errorMessage, (Throwable)e);
            }
        }
        JspWriter out = this.pageContext.getOut();
        if (loader == null) {
            log.error((Object)("CodeListLoader:" + this.codeList + " is not defined."));
            throw new JspTagException("CodeListLoader:" + this.codeList + " is not defined.");
        }
        Locale locale = RequestUtils.getUserLocale((HttpServletRequest)((HttpServletRequest)this.pageContext.getRequest()), (String)"org.apache.struts.action.LOCALE");
        CodeBean[] codeBeanArray = loader.getCodeBeans(locale);
        if (codeBeanArray == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Codebean is null. CodeListLoader(bean id:" + this.codeList + ")"));
            }
        } else {
            try {
                for (int i = 0; i < codeBeanArray.length; ++i) {
                    if (!codeKey.equals(codeBeanArray[i].getId())) continue;
                    out.print(codeBeanArray[i].getName());
                    break;
                }
            }
            catch (IOException ioe) {
                log.error((Object)"", (Throwable)ioe);
                throw new JspTagException((Throwable)ioe);
            }
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        return 6;
    }

    public void release() {
        super.release();
        this.codeList = null;
        this.key = null;
        this.name = null;
        this.property = null;
        this.scope = null;
    }
}

