/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.UnavailableException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;

/**
 * gActionServletNXłB
 * <p>
 * ChJ[hŎw肵pXɃ}b`Strutsݒt@Cistruts-config.xmlj[h܂B
 * </p>
 * [web.xmlł̐ݒ] <code><pre>
 * {@literal <servlet-class>}jp.terasoluna.fw.supplement.web.struts.action.ActionServletEx{@literal </servlet-class>}
 *   {@literal <init-param>}
 *     {@literal <param-name>}config{@literal </param-name>}
 *     {@literal <param-value>}/WEB-INF{@literal /}**{@literal /}struts-config*.xml{@literal </param-value>}
 *  {@literal </init-param>}
 * </pre></code>
 */
public class ActionServletEx extends ActionServlet {

    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = -559409080495147588L;

    /**
     * OB
     */
    private static Log log = LogFactory.getLog(ActionServletEx.class);

    /**
     * W[ݒ܂B
     * @see org.apache.struts.action.ActionServlet#initModuleConfig(java.lang.String, java.lang.String)
     */
    @Override
    protected ModuleConfig initModuleConfig(String prefix, String paths)
                                                                        throws ServletException {

        if (log.isDebugEnabled()) {
            StringBuilder logSb = new StringBuilder();
            logSb.append("Initializing module path '");
            logSb.append(prefix);
            logSb.append("' configuration from '");
            logSb.append(paths);
            logSb.append("'");
            log.debug(logSb.toString());
        }

        StringBuilder sb = new StringBuilder();

        // J}؂ŕ
        String[] pathAry = paths.split(",");

        for (String path : pathAry) {
            // p^[ɊYt@CT
            sb.append(parseModuleConfigPath(path.trim()));
        }

        // Ṓw,x菜
        if (sb.length() > 0 && ',' == sb.charAt(sb.length() - 1)) {
            sb.setLength(sb.length() - 1);
        }

        return super.initModuleConfig(prefix, sb.toString());
    }

    /**
     * pX̃p^[ɊYpXJ}؂ŘAĕԂ
     * @param locationPattern pX̃p^[
     * @return pX̃p^[ɊYpX̕iJ}؂j
     * @throws UnavailableException
     */
    protected String parseModuleConfigPath(String locationPattern)
                                                                  throws UnavailableException {
        StringBuilder sb = new StringBuilder();
        StringBuilder logSb = new StringBuilder();

        ResourcePatternResolver rpr = new ServletContextResourcePatternResolver(
                getServletContext());
        Resource[] resources = null;

        try {
            resources = rpr.getResources(locationPattern);
        } catch (IOException e) {
            handleConfigException(locationPattern, e);
        }

        for (Resource resource : resources) {
            if (resource instanceof ServletContextResource) {
                ServletContextResource scr = (ServletContextResource) resource;
                sb.append(scr.getPath());
                sb.append(",");

                if (log.isInfoEnabled()) {
                    logSb.setLength(0);
                    logSb.append("Loading Struts module configurations from ");
                    logSb.append(scr.getPath());
                    log.info(logSb.toString());
                }
            }
        }

        return sb.toString();
    }

    /**
     * @param path \[X̃pX
     * @param e O
     * @throws UnavailableException
     */
    protected void handleConfigException(String path, Exception e)
                                                                  throws UnavailableException {
        String msg = internal.getMessage("configParse", path);
        log.error(msg, e);
        throw new UnavailableException(msg);
    }
}
