/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

import jp.terasoluna.fw.web.struts.action.annotation.ActionComponent;
import jp.terasoluna.fw.web.struts.action.resolver.ActionResolver;
import jp.terasoluna.fw.web.struts.action.resolver.ConfigurationReflector;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.core.OrderComparator;
import org.springframework.web.context.WebApplicationContext;

/**
 * DefaultDelegateActionHandler
 * <p>
 * getDelegateActiongۂɗpB
 * </p>
 * @see jp.terasoluna.fw.web.struts.action.DelegatingRequestProcessorEx
 */
public class DefaultDelegateActionHandler implements DelegateActionHandler {
    /** ActionResolverXg */
    protected List<ActionResolver> actionResolverList = null;

    /** ANVpXɑΉActionResolverLbV */
    protected ConcurrentHashMap<String, ActionResolver> pathResolverMap = new ConcurrentHashMap<String, ActionResolver>();

    /** ConfigurationReflector}bv */
    protected Map<?, ?> configReflectorMap = null;

    private Map<Class<? extends Object>, Boolean> actionComponentPresentMap = new ConcurrentHashMap<Class<? extends Object>, Boolean>();

    /** bNIuWFNgiActionResolverXgj */
    protected ReentrantReadWriteLock arLock = new ReentrantReadWriteLock();

    /** bNIuWFNgiConfigurationReflector}bvj */
    protected ReentrantReadWriteLock crLock = new ReentrantReadWriteLock();

    /*
     * (non-Javadoc)
     * @see jp.terasoluna.fw.web.struts.action.handler.DelegateActionHandler#resolveAction(java.lang.String,
     * org.apache.struts.action.Action, org.apache.struts.action.ActionMapping, org.apache.struts.config.ModuleConfig,
     * org.apache.struts.action.ActionServlet, org.springframework.web.context.WebApplicationContext)
     */
    @SuppressWarnings("unchecked")
    public Action resolveAction(String beanName, Action action,
            ActionMapping mapping, ModuleConfig moduleConfig,
            ActionServlet servlet, WebApplicationContext wac) {

        if (action == null) {
            ActionResolver ar = null;

            if (beanName != null) {
                // ActionResolverLbV擾
                ar = pathResolverMap.get(beanName);
                if (ar != null) {
                    // ActionResolvers
                    action = ar.getDelegateAction(beanName, mapping, servlet,
                            wac);
                    if (action == null) {
                        // ANVȂꍇActionResolverQēxȂ߂
                        ar = null;
                    }
                }
            }

            if (ar == null && wac != null) {
                try {
                    this.arLock.readLock().lock();

                    if (this.actionResolverList == null) {
                        try {
                            this.arLock.readLock().unlock();
                            this.arLock.writeLock().lock();

                            // ReiActionResolverQꊇ擾
                            Map<?, ?> actionResolverMap = BeanFactoryUtils
                                    .beansOfTypeIncludingAncestors(wac,
                                            ActionResolver.class);
                            if (!actionResolverMap.isEmpty()) {
                                this.actionResolverList = new ArrayList<ActionResolver>(
                                        (Collection<? extends ActionResolver>) actionResolverMap
                                                .values());
                                Collections.sort(this.actionResolverList,
                                        new OrderComparator());
                            }
                        } finally {
                            this.arLock.readLock().lock();
                            this.arLock.writeLock().unlock();
                        }
                    }
                } finally {
                    this.arLock.readLock().unlock();
                }

                // ActionResolverQ𓪂Ȃ߂
                try {
                    this.arLock.readLock().lock();

                    if (this.actionResolverList != null) {
                        for (ActionResolver actionResolver : this.actionResolverList) {
                            if (actionResolver.supports(beanName, mapping,
                                    servlet, wac)) {
                                // ActionResolvers
                                action = actionResolver.getDelegateAction(
                                        beanName, mapping, servlet, wac);
                            }

                            // Actionł烋[v𔲂
                            if (action != null) {
                                // ActionResolverLbVɊi[
                                pathResolverMap.put(beanName, actionResolver);
                                break;
                            }

                        }
                    }
                } finally {
                    this.arLock.readLock().unlock();
                }
            }
        } else if (action instanceof Action) {
            // Ame[Vt^ANVNXɑ΂ConfigurationReflectors

            Class<? extends Object> targetClass = getTargetClass(action);

            if (isSupportsClass(targetClass)) {
                try {
                    this.crLock.readLock().lock();

                    if (configReflectorMap == null) {
                        try {
                            this.crLock.readLock().unlock();
                            this.crLock.writeLock().lock();
                            // ReiConfigurationReflectorQꊇ擾
                            configReflectorMap = BeanFactoryUtils
                                    .beansOfTypeIncludingAncestors(wac,
                                            ConfigurationReflector.class);
                        } finally {
                            this.crLock.readLock().lock();
                            this.crLock.writeLock().unlock();
                        }
                    }
                } finally {
                    this.crLock.readLock().unlock();
                }

                // ConfigurationReflectorQ𓪂Ȃ߂
                try {
                    this.crLock.readLock().lock();

                    Set<?> ctEs = configReflectorMap.entrySet();
                    for (Object ctObj : ctEs) {
                        if (ctObj instanceof Map.Entry) {
                            Map.Entry<?, ?> ctMe = (Entry<?, ?>) ctObj;

                            if (ctMe.getValue() instanceof ConfigurationReflector) {
                                ConfigurationReflector cr = (ConfigurationReflector) ctMe
                                        .getValue();

                                if (cr.supports(action, beanName, mapping,
                                        servlet, wac)) {
                                    // ConfigurationReflectors
                                    action = cr.setConfiguration(action,
                                            beanName, mapping, servlet, wac);
                                }

                            }
                        }
                    }
                } finally {
                    this.crLock.readLock().unlock();
                }
            }
        }

        return action;
    }

    /**
     * Ώۂ̃NXǂ肷B
     * @param targetClass ΏۃNX
     * @return true or false
     */
    protected boolean isSupportsClass(Class<? extends Object> targetClass) {
        if (targetClass != null) {
            Boolean resultBoolean = this.actionComponentPresentMap
                    .get(targetClass);

            if (resultBoolean != null) {
                return resultBoolean.booleanValue();
            }

            boolean result = targetClass
                    .isAnnotationPresent(ActionComponent.class);
            this.actionComponentPresentMap.put(targetClass, Boolean
                    .valueOf(result));
            return result;
        }
        return false;
    }

    /**
     * IuWFNg̃NX^擾
     * @param targetObject Ώۂ̃IuWFNg
     * @return Ώۂ̃IuWFNg̃NX^
     */
    @SuppressWarnings("unchecked")
    protected Class<? extends Object> getTargetClass(Object targetObject) {
        Class<? extends Object> targetClass = null;

        if (targetObject != null) {
            if (AopUtils.isAopProxy(targetObject)) {
                targetClass = AopUtils.getTargetClass(targetObject);
            } else {
                targetClass = targetObject.getClass();
            }
        }

        return targetClass;
    }

}
