/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action.resolver;

import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.web.context.WebApplicationContext;

/**
 * AbstractActionResolver
 * <p>
 * ANVpX {@link Action} тANV]o̒ۃNXB
 * </p>
 * <p>
 * т {@link Action} Bean`̃XR[v prototype Œ`ĂƁB
 * </p>
 * @see jp.terasoluna.fw.web.struts.action.DelegatingRequestProcessorEx
 * @see jp.terasoluna.fw.web.struts.action.handler.DefaultDelegateActionHandler
 * @see jp.terasoluna.fw.web.struts.action.resolver.ActionResolver
 * @see jp.terasoluna.fw.web.struts.action.resolver.ConfigurationReflector
 */
public abstract class AbstractActionResolver implements ActionResolver {

    /**
     * {@link Action} Bean
     * <p>
     * {@link Action} Bean`̃XR[v prototype Œ`Ă
     * </p>
     */
    protected String actionName = null;

    /** ΏۂƂANVpX̃p^[iK\ŋLqj */
    protected String[] pathPatterns = null;

    /** regex̃LbV */
    protected ConcurrentHashMap<String, Pattern> regexMap = new ConcurrentHashMap<String, Pattern>();

    /** {@link ConfigurationReflector}}bv */
    protected Map<?, ?> configReflectorMap = null;

    /** bNIuWFNg */
    protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    /**
     * ̃NXgp鏇ԁB
     */
    private int order = Integer.MAX_VALUE;

    /*
     * (non-Javadoc)
     * @see jp.terasoluna.fw.web.struts.action.resolver.ActionResolver#supports(java.lang.String,
     * org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionServlet,
     * org.springframework.web.context.WebApplicationContext)
     */
    public boolean supports(String beanName, ActionMapping mapping,
            ActionServlet servlet, WebApplicationContext wac) {
        // ActionBeanƏΏۂƂANVpX̃p^[`FbN
        if (pathPatterns == null || pathPatterns.length == 0
                || actionName == null || actionName.length() == 0
                || beanName == null) {
            return false;
        }

        // ANVpX̃p^[}b`O
        boolean pathMatching = false;
        for (String pathPattern : pathPatterns) {
            if (pathPattern != null && pathPattern.length() != 0) {

                Pattern pt = regexMap.get(pathPattern);
                if (pt == null) {
                    pt = Pattern.compile(pathPattern);
                    regexMap.put(pathPattern, pt);
                }
                Matcher m = null;
                if (pt != null) {
                    m = pt.matcher(beanName);
                }
                if (m != null && m.matches()) {
                    pathMatching = true;
                    break;
                }
            }
        }
        return pathMatching;
    }

    /*
     * (non-Javadoc)
     * @see jp.terasoluna.fw.web.struts.action.resolver.ActionResolver#getDelegateAction(java.lang.String,
     * org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionServlet,
     * org.springframework.web.context.WebApplicationContext)
     */
    public Action getDelegateAction(String beanName, ActionMapping mapping,
            ActionServlet servlet, WebApplicationContext wac) {

        // Bean݃`FbN
        if (!isBeanExist(beanName, mapping, servlet, wac)) {
            return null;
        }

        // LbṼL[擾
        Object key = getActionCacheKey(beanName, mapping, servlet, wac);

        // ActionActionLbV擾
        Action resultAction = getActionCache(key);

        if (resultAction == null) {
            if (!(key instanceof Action)) {
                // ActionRei擾
                resultAction = (Action) wac.getBean(actionName, Action.class);
            }

            // ANVɑ΂ǉ
            resultAction = extensionProcess(key, resultAction, beanName,
                    mapping, servlet, wac);

            // ConfigurationReflectorĂяo
            callConfigurationReflector(key, resultAction, beanName, mapping,
                    servlet, wac);

            if (resultAction != null
                    && isCacheEnabled(key, resultAction, beanName, mapping,
                            servlet, wac)) {
                // ActionLbVɊi[
                putActionCache(key, resultAction);
            }
        }

        return resultAction;
    }

    /**
     * {@link ConfigurationReflector} Ăяo
     * @param key Object ANVLbVL[
     * @param action {@link Action} ΏۃANV
     * @param beanName String Bean
     * @param mapping {@link ActionMapping}
     * @param servlet {@link ActionServlet}
     * @param wac {@link WebApplicationContext}
     */
    protected void callConfigurationReflector(Object key, Action action,
            String beanName, ActionMapping mapping, ActionServlet servlet,
            WebApplicationContext wac) {

        try {
            this.lock.readLock().lock();

            if (configReflectorMap == null) {
                try {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();

                    // ReiConfigurationReflectorQꊇ擾
                    configReflectorMap = BeanFactoryUtils
                            .beansOfTypeIncludingAncestors(wac,
                                    ConfigurationReflector.class);
                } finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
        } finally {
            this.lock.readLock().unlock();
        }

        // ConfigurationReflectorQ𓪂Ȃ߂
        try {
            this.lock.readLock().lock();

            Set<?> ctEs = configReflectorMap.entrySet();
            for (Object ctObj : ctEs) {
                if (ctObj instanceof Map.Entry) {
                    Map.Entry<?, ?> ctMe = (Entry<?, ?>) ctObj;

                    if (ctMe.getValue() instanceof ConfigurationReflector) {
                        ConfigurationReflector cr = (ConfigurationReflector) ctMe
                                .getValue();

                        if (cr
                                .supports(action, beanName, mapping, servlet,
                                        wac)) {
                            // ConfigurationReflectors
                            action = cr.setConfiguration(action, beanName,
                                    mapping, servlet, wac);
                        }

                    }
                }
            }
        } finally {
            this.lock.readLock().unlock();
        }
    }

    /**
     * LbVׂǂ肷
     * @param key Object ANVLbVL[
     * @param action {@link Action} ΏۃANV
     * @param beanName String Bean
     * @param mapping {@link ActionMapping}
     * @param servlet {@link ActionServlet}
     * @param wac {@link WebApplicationContext}
     * @return true:OK false:NG
     */
    protected abstract boolean isCacheEnabled(Object key, Action action,
            String beanName, ActionMapping mapping, ActionServlet servlet,
            WebApplicationContext wac);

    /**
     * Bean݃`FbN
     * @param beanName String Bean
     * @param mapping {@link ActionMapping}
     * @param servlet {@link ActionServlet}
     * @param wac {@link WebApplicationContext}
     * @return true:OK false:NG
     */
    protected abstract boolean isBeanExist(String beanName,
            ActionMapping mapping, ActionServlet servlet,
            WebApplicationContext wac);

    /**
     * ANVLbVL[擾
     * @param beanName String Bean
     * @param mapping {@link ActionMapping}
     * @param servlet {@link ActionServlet}
     * @param wac {@link WebApplicationContext}
     * @return ANVLbVL[
     */
    protected abstract Object getActionCacheKey(String beanName,
            ActionMapping mapping, ActionServlet servlet,
            WebApplicationContext wac);

    /**
     * ANVLbV擾B
     * @param cacheKey ANVLbVL[
     * @return {@link Action} LbVꂽANV
     */
    protected abstract Action getActionCache(Object cacheKey);

    /**
     * ANVLbVɊi[B
     * @param cacheKey Object ANVLbVL[
     * @param action {@link Action} LbVANV
     */
    protected abstract void putActionCache(Object cacheKey, Action action);

    /**
     * ANVɑ΂ǉ
     * @param key Object ANVLbVL[
     * @param action {@link Action} ΏۃANV
     * @param beanName String Bean
     * @param mapping {@link ActionMapping}
     * @param servlet {@link ActionServlet}
     * @param wac {@link WebApplicationContext}
     * @return action {@link Action} σANV
     */
    protected abstract Action extensionProcess(Object key, Action action,
            String beanName, ActionMapping mapping, ActionServlet servlet,
            WebApplicationContext wac);

    /**
     * {@link Action} Bean
     * <p>
     * {@link Action} Bean`̃XR[v prototype Œ`Ă
     * </p>
     * @param actionName {@link Action} Bean
     */
    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    /**
     * ΏۂƂANVpX̃p^[iK\ŋLqj
     * @param pathPattern ΏۂƂANVpX̃p^[
     */
    public void setPathPattern(String pathPattern) {
        this.pathPatterns = new String[] { pathPattern };
    }

    /**
     * ΏۂƂANVpX̃p^[iK\ŋLqj
     * @param pathPatterns the pathPatterns to set
     */
    public void setPathPatterns(String[] pathPatterns) {
        this.pathPatterns = pathPatterns;
    }

    /**
     * orderݒ肷B
     * @param order ̃NXgp鏇ԁB
     */
    public void setOrder(int order) {
        this.order = order;
    }

    /**
     * order擾B
     * @return ̃NXgp鏇ԁB
     */
    public int getOrder() {
        return order;
    }
}
