/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.terasoluna.fw.web.thin.BlockageControlFilter;
import jp.terasoluna.fw.web.thin.ServerBlockageControlFilter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
*
* tH[h̐U蕪sB
*
* <p>
*  NGXgp[^pāAJڐ肷B<br>
*  Struts񋟂ĂDispatchActionALookupDispatchActionƎdlقȂ邽߁Aӂ邱ƁB
* </p>
* <p>
*  ܂ANGXgp[^L[̐ݒBean`t@CŕKvɉčs
*  iftHgl&quot;event&quot;jB
* </p>
* <p>
*  LɋL`t@C
*  NGXgp[^̃L[custom-eventɐݒ肷łB
* </p>
* <p>
* <strong>Bean`t@C̐ݒ</strong>
*  <code><pre>
*  &lt;bean name="/dispatch" scope="prototype"
*    class="jp.terasoluna.fw.web.struts.actions.DispatchAction"&gt;
*    <strong>&lt;property name="event"&gt;
*      &lt;value&gt;custom-event&lt;/value&gt;
*    &lt;/property&gt;</strong>
*  &lt;/bean&gt;
*  </pre></code>
* </p>
* <p>
*  ɁAJڕ肷BD揇ʂ͎̒ʂB
*  <ol>
*   <li>LŎw肵NGXgp[^L[̒l̂A
*       擪&quot;forward_&quot;Ă̂ɂāA
*       &quot;forward_&quot;菜</li>
*   <li>NGXgp[^L[̐擪&quot;forward_&quot;tĂ̂ɂāA
*       &quot;forward_&quot;菜</li>
*   <li>&quot;default&quot;Œ
*   ievent=&quot;XXXX&quot;A&quot;forward_XXXX&quot;Ƃ
*       ݂ȂsȑJڐ悪w肳ꂽꍇȂǁj</li>
*  </ol>
*
*  ĽʁAJڕ&quot;#input&quot;
*  łƂAstruts-config.xmlinputJڐƂȂB<br>
*  &quot;#input&quot;ł͂ȂƂAstruts-config.xmlforwardvf̓eɂJڐ悪肷B
* </p>
* <p>
* <strong>struts-config.xml̐ݒ</strong>
* <code><pre>
*  &lt;action path="/dispatch"
*    name="_sampleForm"
*    scope="session"
*    input="/prev.jsp"&gt;
*    &lt;forward name="regist" path="/userRegist.do"/&gt;
*    &lt;forward name="search" path="/userSearch.do"/&gt;
*    &lt;forward name="update" path="/userUpdate.do"/&gt;
*    &lt;forward name="decide" path="/prev.do"/&gt;
*    &lt;forward name="default" path="/prev.do"/&gt;
*  &lt;/action&gt;
* </pre></code>
* </p>
* <p>
* <strong>JSPł̋Lq</strong>
*  <code><pre>
*  EEE
*  &lt;html:radio property="<strong>custom-event</strong>" value="<strong>forward_regist</strong>"/&gt;
*  &lt;html:radio property="<strong>custom-event</strong>" value="<strong>forward_search</strong>"/&gt;
*  &lt;html:radio property="<strong>custom-event</strong>" value="<strong>forward_update</strong>"/&gt;
*  &lt;html:radio property="<strong>custom-event</strong>" value="<strong>forward_#input</strong>"/&gt;
*  &lt;html:submit property="<strong>forward_decide</strong>" value=""/&gt;
*  &lt;html:submit value="߂"/&gt;
*  EEE
*  </pre></code>
*  NGXgp[^̒l"forward_" + _tH[hƒ`B
* </p>
* <p>
*  esꍇ̑Jڐ͎̒ʂB
*  <ol>
*   <li>1Ԗڂ̃WI{^Čꍇ́A
*   Jڕ&quot;regist&quot;AJڐ&quot;/userRegist.do&quot;</li>
*   <li>4Ԗڂ̃WI{^Čꍇ́A
*   Jڕ&quot;#input&quot;AJڐ&quot;/prev.do&quot;</li>
*   <li>WI{^IAꍇ́A
*   Jڕ&quot;decide&quot;AJڐ&quot;/prev.do&quot;</li>
*   <li>߂ꍇA
*   Jڕ&quot;default&quot;AJڐ&quot;/prev.do&quot;</li>
*  </ol>
* </p>
*
*/
public class DispatchAction extends ActionEx {

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(DispatchAction.class);

    /**
     * NGXgp[^ɐU蕪wȂꍇ́A
     * ftHg̑Jڐ̘_tH[hB
     */
    private static final String FORWARD_DEFAULT = "default";

    /**
     * U蕪wʂ邽߂́A
     * NGXgp[^̃L[̃vtBbNXB
     */
    private static final String FORWARD_PREFIX = "forward_";

    /**
     * Jڐ\vpeBB
     */
    private String event = null;

    /**
     * Jڐ\vpeBݒ肷B
     *
     * @param value JڐvpeB
     */
     public void setEvent(String value) {
         this.event = value;
     }

    /**
     * tH[h̐U蕪sB
     * <p>
     *   tH[hU蕪AT[oǒʉ߃tO
     *   폜B<br>
     *   ۂ̑Jڐ́AdoDetamineForward()肵ĂB
     * </p>
     *
     * @param mapping ANV}bsO
     * @param form ANVtH[
     * @param req <code>HTTP</code>NGXg
     * @param res <code>HTTP</code>X|X
     * @return Jڐ
     */
    @Override
    public ActionForward doExecute(ActionMapping mapping,
                                          ActionForm form,
                                          HttpServletRequest req,
                                          HttpServletResponse res) {
        if (log.isDebugEnabled()) {
            log.debug("doExecute() called.");
        }
        // NGXgɃLZtOݒ肳Ă邱ƂmFA
        // cancelled()\bhs邩ǂ肷B
        if (isCancelled(req)) {
            ActionForward af = cancelled(mapping, form, req, res);
            if (af != null) {
                return af;
            }
        }

        if (event == null) {
            // eventwȂ̎A"event"ftHgƂĐݒ肷B
            event = "event";
        }

        String forward = doDetermineForward(req.getParameterMap(), event);

        ActionForward actionForward = null;
        if ("#input".equalsIgnoreCase(forward)) {
            actionForward = new ActionForward(mapping.getInput());
        } else {
            actionForward = mapping.findForward(forward);
        }

        // tH[h悪ȂꍇA"default" Ŏw肳Ă
        // ANVtH[hԋpB
        if (actionForward == null) {
            if (log.isWarnEnabled()) {
                log.warn("forward name[" + forward + "] is invalid by user request.");
            }
            actionForward = mapping.findForward(FORWARD_DEFAULT);
        }

        // tH[hŕǃ`FbNLƂ邽
        // THRU_FILTERtO폜
        // T[o
        req.removeAttribute(ServerBlockageControlFilter
            .SERVER_BLOCKAGE_THRU_KEY);
        // Ɩ
        req.removeAttribute(BlockageControlFilter.BLOCKAGE_THRU_KEY);

        if (log.isDebugEnabled()) {
            log.debug("forward = " + forward + " (" + ((actionForward == null)
                ? "null" : actionForward.getPath()) + ")");
        }
        return actionForward;
    }

    /**
     * NGXgp[^ɊÂătH[hfBXpb`B
     * paramsnull̏ꍇ́AftHg̕ԋpB
     *
     * @param params NGXgp[^i}bv`j
     * @param event ANV}bsOɎw肳ꂽCxg
     * @return U蕪̘_tH[h
     */
    protected String doDetermineForward(Map params, @SuppressWarnings("hiding") String event) {
        if (params != null) {
            if (exists(params, event)) {
                String[] eventValues = (String[]) params.get(event);
                for (int i = 0; i < eventValues.length; i++) {
                    if (eventValues[i].startsWith(FORWARD_PREFIX)) {
                        return eventValues[i].substring(FORWARD_PREFIX.length());
                    }
                }
            }
            Iterator iter = params.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String) iter.next();
                if (key.startsWith(FORWARD_PREFIX)) {
                    String forward = key.substring(FORWARD_PREFIX.length());
                    if(forward.endsWith(".x") || forward.endsWith(".y")){
                        forward = forward.substring(0, forward.length() - 2);
                    }
                    return forward;
                }
            }
        }
        return FORWARD_DEFAULT;
    }


    /**
     * NGXgp[^ɁAnameŎw肵̂̃p[^
     * ݂Ă邩𔻒肷B
     *
     * @param params NGXgp[^i}bv`j
     * @param name NGXgp[^
     * @return NGXgp[^݂ĂȂ <code>true</code>
     */
    protected boolean exists(Map params, String name) {
        return params.containsKey(name);
    }

    /**
     * NGXgɃLZtOݒ肳Ăꍇ̑Jڐ
     * 肷Bӓ_ƂāAActionForwardnullƂĕԋp邽߁A
     * LZ̑Jڐ́A
     * ̃NXpNX̃I[oCh\bhŎKvB
     *
     * @param mapping ANV}bsO
     * @param form ANVtH[
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @return ANVtH[h
     */
    protected ActionForward cancelled(ActionMapping mapping,
                                      ActionForm form,
                                      HttpServletRequest request,
                                      HttpServletResponse response) {
        return null;
    }

}
