/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.taglib;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.util.IteratorAdapter;

/**
 * IR[hXgAw肳ꂽL[lIuWFNg𒊏oJX^^OB
 * <p>
 * iIR[hXgƂ́Ay[WXR[v⃊NGXgXR[vAZbVXR[vAANVtH[ɕۑꂽ
 * ^̃IuWFNg̏W\iႦ΁uv\JavaBeanListȂǁjB<br>
 * ʏAZNg{bNX`FbN{bNXAWI{^̌ꂽIlIꍇɗpBj
 * </p>
 * <p>
 * IR[hXg璊oIuWFNǵACӂ̃XR[vbeanƂĒ`ÃvpeB\邱ƂłB<br>
 * `邩\邩́Aidݒ肷邩ۂŌ܂B`ƕ\𓯎ɍsƂ͂ȂB<br>
 * Eidݒ肵ꍇAu`vƂē삷BCӂ̃XR[vbeanAсAJn^Oȍ~ŗLObject^̃XNveBOϐ`B<br>
 * Eidݒ肵ȂꍇAu\vƂē삷B̂ƂA\vpeBwritePropertyŎw肵Ȃ΂ȂȂB<br>
 * </p>
 * <p>
 * ̃^O𗘗pɂ́Aȉ4ڂݒ肷B<br>
 * EIR[hXg (collection / collectionName + collectionProperty + collectionScope)<br>
 * EL[vpeB(oɔrvpeB) (keyProperty)<br>
 * Eo(L[vpeBƔrlA邢́AlCollectionz) (condition / conditionName + conditionProperty + conditionScope)<br>
 * E`͕\Ɋւ (id + toScope / writeProperty + filter)<br>
 * Lʓ́u/v̍Eɕꂽ́ArIɗpB
 * </p>
 * <p>
 * ڍׂ͈ȉ̒ʂB<br>
 * <fieldset><legend>uIR[hXgv̐ݒ@</legend>
 * ȉAABAꂩ̕@Őݒ肷B<br>
 * <br>
 * <fieldset><legend>A. ڃIuWFNgݒ肷</legend>
 * gpF<br>
 * Ecollection (K{)<br>
 * <br>
 * s(&lt;%=c%&gt;)EL(${c})𗘗pAcollectionɒڃIuWFNgݒ肷B<br>
 * <br>
 * ݒF<br>
 * collection=&quot;${_SampleForm.deptList}&quot;
 * </fieldset>
 * <br>
 * <fieldset><legend>B. XR[vɂIuWFNgQƂ</legend>
 * gpF<br>
 * EcollectionName (K{)<br>
 * EcollectionProperty (C)<br>
 * EcollectionScope (C)<br>
 * <br>
 * QƂXR[vw肷ꍇ́AcollectionScopeɃXR[v̖Oݒ肷B<br>
 * (collectionScopeȗꍇApagerequestsessionapplication̏ɌB)<br>
 * XR[v̑collectionNameɐݒ肷B<br>
 * collectionNamewIuWFNgIR[hXgłꍇɂ́A
 * collectionProperty͐ݒ肵ȂB<br>
 * collectionNamewIuWFNg̃vpeBIR[hXgłꍇɂ́A
 * collectionPropertyɂāAIR[hXgi[ĂvpeBw肷B<br>
 * <br>
 * ݒF<br>
 * EcollectionName=&quot;_SampleForm&quot; collectionProperty=&quot;deptList&quot;<br>
 * EcollectionName=&quot;deptList&quot; collectionScope=&quot;session&quot;<br>
 * </fieldset>
 * </fieldset>
 * </p>
 * <p>
 * <fieldset><legend>uL[vpeB(oɔrvpeB)v̐ݒ@</legend>
 * gpF<br>
 * EkeyProperty (K{)<br>
 * <br>
 * oɔrvpeB̖OAkeyPropertyɐݒ肷B<br>
 * q́uovƁAkeyPropertyŎw肳ꂽvpeB̒lvJavaBeanoB<br>
 * Ⴆ΁A`FbN{bNXőIڂ𒊏oꍇA
 * `FbN{bNX̒l񋟂ĂvpeB̖OkeyPropertyɐݒ肷B<br>
 * <br>
 * ݒF<br>
 * EkeyProperty=&quot;deptCode&quot;<br>
 * </fieldset>
 * </p>
 * <p>
 * <fieldset><legend>uo(L[vpeBƔrlA邢́AlCollectionz)v̐ݒ@</legend>
 * ȉAABAꂩ̕@Őݒ肷B<br>
 * <br>
 * <fieldset><legend>A. ڃIuWFNgݒ肷</legend>
 * gpF<br>
 * Econdition (K{)<br>
 * <br>
 * s(&lt;%=c%&gt;)EL(${c})𗘗pAconditionɒڃIuWFNgݒ肷B<br>
 * <br>
 * ݒF<br>
 * condition=&quot;${_SampleForm.selectedDeptCode}&quot;
 * </fieldset>
 * <br>
 * <fieldset><legend>B. XR[vɂIuWFNgQƂ</legend>
 * gpF<br>
 * EconditionName (K{)<br>
 * EconditionProperty (C)<br>
 * EconditionScope (C)<br>
 * <br>
 * QƂXR[vw肷ꍇ́AconditionScopeɃXR[v̖Oݒ肷B<br>
 * (conditionScopeȗꍇApagerequestsessionapplication̏ɌB)<br>
 * XR[v̑conditionNameɐݒ肷B<br>
 * conditionNamewIuWFNguovłꍇɂ́A
 * conditionProperty͐ݒ肵ȂB<br>
 * conditionNamewIuWFNg̃vpeBuovłꍇɂ́A
 * conditionPropertyɂāAuovi[ĂvpeBw肷B<br>
 * <br>
 * ݒF<br>
 * EconditionName=&quot;_SampleForm&quot; conditionProperty=&quot;selectedDeptCode&quot;<br>
 * EconditionName=&quot;selectedDeptCode&quot; collectionScope=&quot;session&quot;<br>
 * </fieldset>
 * </fieldset>
 * </p>
 * <p>
 * <fieldset><legend>u`͕\Ɋւv̐ݒ@</legend>
 * `\ɉāAȉ̗lɐݒ肷B<br>
 * <br>
 * <fieldset><legend>`</legend>
 * gpF<br>
 * Eid (K{)<br>
 * EtoScope (C)<br>
 * <br>
 * oʂbeanƂĒ`Ƃ̖Oidɐݒ肷B<br>
 * oʂpageXR[vȊO(Ⴆ΁AsessionXR[v)Ɋi[ꍇ́A
 * toScopeŁAoʂi[XR[vݒ肷B<br>
 * (toScopeȗꍇApageXR[vɒoʂi[B)<br>
 * <br>
 * ݒF<br>
 * Eid=&quot;selectedDept&quot;<br>
 * Eid=&quot;selectedDept&quot; toScope=&quot;session&quot;<br>
 * </fieldset>
 * <br>
 * <fieldset><legend>\</legend>
 * gpF<br>
 * EwriteProperty (K{)<br>
 * Efilter (C)<br>
 * <br>
 * oʂJavaBeańA\vpeB̖OwritePropertyɐݒ肷B<br>
 * \̍ہATj^CY(u&lt;vu&amp;lt;v)sȂꍇ́Afilterfalseݒ肷B<br>
 * <br>
 * ݒF<br>
 * EwriteProperty=&quot;deptName&quot;<br>
 * EwriteProperty=&quot;deptName&quot; filter=&quot;false&quot;<br>
 * </fieldset>
 * </fieldset>
 * </p>
 * <p>
 * LF<br>
 * <pre>
 * `F
 * Euovɓ̒lnꍇAoʂ1JavaBeanƂȂB
 * EuovɒlCollectionznꍇAoʂJavaBeanListƂȂB
 * 
 * \F
 * Euovɂ́A̒lnƂłȂB(CollectionzȊOłȂ΂ȂȂB)
 * 
 * IR[hXg̊eJavaBeañL[vpeB̒lɂāF
 * E^͔Cӂł邪AoɎgplƓ^łȂ΂ȂȂ(ɂ́Aequals΂悢)B
 *   ȂAANVtH[́ANGXgp[^̒lvpeB́A
 *   ʏString₻̔zŒ`邽߁AL[vpeB̒lString^ɂǂB
 * EL[vpeB̒lnull̏ꍇAL[vpeB̒l󕶎(0String)ł̂ƂďB
 *   ́Aȉ̓l̂łB
 *   Enulllhtml:radiohtml:multiboxŏo͂ƁA󕶎񈵂ƂȂ
 *   EANVtH[̔zvpeBZbg@\ŃZbgꍇAzvfnullɂȂ
 *   AnulllKvAnulll͎gpȂƂ𐄏B
 * 
 * IR[hXg̊eJavaBean̏o̓vpeB̒lɂ(writePropertygp)F
 * E^͔CӂłBtoStrinǧʂ\B
 * Eo̓vpeB̒lnull̏ꍇA\(󕶎̏o͂Ɠ`)ƂȂB
 * 
 * IR[hXgƂĎgpł^F
 * Ez
 * Ejava.util.Collection(java.util.ArrayList)
 * Ejava.util.Iterator
 * Ejava.util.Enumeration
 * Ejava.util.Map(java.util.LinkedHashMap)
 * zACollectionAIteratorAEnumeration̊evf́AJavaBeanłB
 * IR[hXǧ^Map̏ꍇAMap.EntryJavaBean̑ƂȂB
 *   āAkeyPropertywritePropertyɂ́A&quot;key&quot;&quot;value&quot;gpłB
 *   ȂAMapkeyMapvalue\ꍇ(keyProperty=&quot;key&quot; writeProperty=&quot;value&quot;ƂȂꍇ)́A
 *   ̃^OgpAbean:write^OŒڃANZXĕ\΂悢B
 * </pre>
 * </p>
 * <p>
 * \lgp̒ӁF<br>
 * <br>
 * ̃^ÓAIR[hXgJavaBean𒊏oB
 * ̂߁Agp@ƁAȌ△ʂȌĂ܂B<br>
 * ȉA\A`p^[Ƃ̉@(p^[)łB<br>
 * <br>
 * <fieldset><legend>Iꂽ`FbN{bNXɑΉl\P[X(oʂ𕡐\P[X)</legend>
 * <br>
 * <fieldset><legend>\A`p^[Flogic:iterateŁuov1oÃ^Oŕ\</legend>
 * <pre>
 * &lt;logic:iterate name=&quot;_SampleForm&quot; property=&quot;selectedDeptCodes&quot; id=&quot;selectedDeptCode&quot;&gt;
 *   &lt;logic:present name=&quot;selectedDeptCode&quot;&gt;
 *   &lt;tr&gt;
 *     &lt;td&gt;
 *       &lt;tl:extract collectionName=&quot;_SampleForm&quot; collectionProperty=&quot;deptList&quot;
 *           keyProperty=&quot;deptCode&quot;
 *           conditionName=&quot;selectedDeptCode&quot;
 *           writeProperty=&quot;deptName&quot;/&gt;
 *     &lt;/td&gt;
 *   &lt;/tr&gt;
 *   &lt;/logic:present&gt;
 * &lt;/logic:iterate&gt;
 * </pre>
 * uov̐AIR[hXg̏sĂ܂߁AB<br>
 * ɓIR[hXgJavaBean100Aʂ50IꂽƂƁA<br>
 * ȂƂA1 + 2 + c + 50 = 1275<br>
 * ň̃P[Xł́A100 + 99 + c + 51 = 3775<br>
 * ̎ŕ\ʂAoŁAtNVAPIgpvpeBANZX1275`3775KvƂȂB<br>
 * </fieldset>
 * <br>
 * <fieldset><legend>p^[FuovƂĒlCollectionznAo(List)logic:iterate1oAbean:write^Oŕ\</legend>
 * <pre>
 * &lt;tl:extract collectionName=&quot;_SampleForm&quot; collectionProperty=&quot;deptList&quot;
 *     keyProperty=&quot;deptCode&quot;
 *     conditionName=&quot;_SampleForm&quot; conditionProperty=&quot;selectedDeptCodes&quot;
 *     id=&quot;selectedDeptList&quot;/&gt;
 * &lt;logic:iterate name=&quot;selectedDeptList&quot; id=&quot;selectedDept&quot;&gt;
 *   &lt;tr&gt;
 *     &lt;td&gt;&lt;bean:write name=&quot;selectedDept&quot; property=&quot;deptName&quot;/&gt;&lt;/td&gt;
 *   &lt;/tr&gt;
 * &lt;/logic:iterate&gt;
 * </pre>
 * IR[hXg̑SJavaBean1񂸂ANZXAuovƏƍB<br>
 * ɓIR[hXgJavaBean100ꍇAʂőIꂽɊւ炸A<br>
 * óAtNVAPIgpvpeBANZX100ōςށB<br>
 * ܂Auov̓^OŏƍpHashSetɕϊ邽߁A
 * ʂőIꂽȂĂAƍւ̉e͊FłB
 * </fieldset>
 * </fieldset>
 * <br>
 * <fieldset><legend>IR[hXgJavaBeanɁA\vpeBP[X</legend>
 * <br>
 * <fieldset><legend>\A`p^[F\vpeB̐Ã^Ogp</legend>
 * <pre>
 * &lt;td&gt;
 *   &lt;tl:extract collectionName=&quot;_SampleForm&quot; collectionProperty=&quot;deptList&quot;
 *       keyProperty=&quot;deptCode&quot;
 *       conditionName=&quot;_SampleForm&quot; conditionProperty=&quot;selectedDeptCode&quot;
 *       writeProperty=&quot;deptName&quot;/&gt;
 * &lt;/td&gt;
 * &lt;td&gt;
 *   &lt;tl:extract collectionName=&quot;_SampleForm&quot; collectionProperty=&quot;deptList&quot;
 *       keyProperty=&quot;deptCode&quot;
 *       conditionName=&quot;_SampleForm&quot; conditionProperty=&quot;selectedDeptCode&quot;
 *       writeProperty=&quot;deptShortName&quot;/&gt;
 * &lt;/td&gt;
 * </pre>
 * \vpeB̐AIR[hXg̏sĂ܂߁AB
 * </fieldset>
 * <br>
 * <fieldset><legend>p^[F̃^OŒoʂ`Abean:write^Oŕ\</legend>
 * <pre>
 * &lt;tl:extract collectionName=&quot;_SampleForm&quot; collectionProperty=&quot;deptList&quot;
 *     keyProperty=&quot;deptCode&quot;
 *     conditionName=&quot;_SampleForm&quot; conditionProperty=&quot;selectedDeptCode&quot;
 *     id=&quot;selectedDept&quot;/&gt;
 * &lt;td&gt;&lt;bean:write name=&quot;selectedDept&quot; property=&quot;deptName&quot; ignore=&quot;true&quot;/&gt;&lt;/td&gt;
 * &lt;td&gt;&lt;bean:write name=&quot;selectedDept&quot; property=&quot;deptShortName&quot; ignore=&quot;true&quot;/&gt;&lt;/td&gt;
 * </pre>
 * IR[hXg̏1񂾂sB
 * </fieldset>
 * </fieldset>
 * </p>
 * @see TagSupport
 */
public class ExtractTag extends TagSupport {

    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = -8216688560283904446L;

    /**
     * IR[hXgIuWFNg
     */
    private Object collection;

    /**
     * IR[hXgIuWFNgA܂͂܂JavaBeańAXR[v̖O
     */
    private String collectionName;

    /**
     * IR[hXgIuWFNgi[ꂽvpeB
     */
    private String collectionProperty;

    /**
     * IR[hXgXR[v
     */
    private String collectionScope;

    /**
     * L[vpeB(oƔrvpeB)
     */
    private String keyProperty;

    /**
     * oIuWFNg
     */
    private Object condition;

    /**
     * oIuWFNgA܂͂܂JavaBeańAXR[v̖O
     */
    private String conditionName;

    /**
     * oIuWFNgi[ꂽvpeB
     */
    private String conditionProperty;

    /**
     * oIuWFNgXR[v
     */
    private String conditionScope;

    /**
     * oʃIuWFNg`ۂ̖O
     */
    private String id;

    /**
     * oʃIuWFNg`XR[v
     */
    private String toScope;

    /**
     * o̓vpeB
     */
    private String writeProperty;

    /**
     * o͂HTMLGXP[v邩ۂ
     */
    private boolean filter = true;

    /**
     * IR[hXgIuWFNg擾B
     * 
     * @return IR[hXgIuWFNg
     */
    public Object getCollection() {
        return collection;
    }

    /**
     * IR[hXgIuWFNgݒ肷B
     * 
     * @param collection
     *            IR[hXgIuWFNg
     */
    public void setCollection(Object collection) {
        this.collection = collection;
    }

    /**
     * IR[hXgIuWFNgA܂͂܂JavaBeańAXR[v̖O擾B
     * 
     * @return IR[hXgIuWFNgA܂͂܂JavaBeańAXR[v̖O
     */
    public String getCollectionName() {
        return collectionName;
    }

    /**
     * IR[hXgIuWFNgA܂͂܂JavaBeańAXR[v̖Oݒ肷B
     * 
     * @param collectionName
     *            IR[hXgIuWFNgA܂͂܂JavaBeańAXR[v̖O
     */
    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    /**
     * IR[hXgIuWFNgi[ꂽvpeB擾B
     * 
     * @return IR[hXgIuWFNgi[ꂽvpeB
     */
    public String getCollectionProperty() {
        return collectionProperty;
    }

    /**
     * IR[hXgIuWFNgi[ꂽvpeBݒ肷B
     * 
     * @param collectionProperty
     *            IR[hXgIuWFNgi[ꂽvpeB
     */
    public void setCollectionProperty(String collectionProperty) {
        this.collectionProperty = collectionProperty;
    }

    /**
     * IR[hXgXR[v擾B
     * 
     * @return IR[hXgXR[v
     */
    public String getCollectionScope() {
        return collectionScope;
    }

    /**
     * IR[hXgXR[vݒ肷B
     * 
     * @param collectionScope
     *            IR[hXgXR[v
     */
    public void setCollectionScope(String collectionScope) {
        this.collectionScope = collectionScope;
    }

    /**
     * L[vpeB(oƔrvpeB)擾B
     * 
     * @return L[vpeB(oƔrvpeB)
     */
    public String getKeyProperty() {
        return keyProperty;
    }

    /**
     * L[vpeB(oƔrvpeB)ݒ肷B
     * 
     * @param keyProperty
     *            L[vpeB(oƔrvpeB)
     */
    public void setKeyProperty(String keyProperty) {
        this.keyProperty = keyProperty;
    }

    /**
     * oIuWFNg擾B
     * 
     * @return oIuWFNg
     */
    public Object getCondition() {
        return condition;
    }

    /**
     * oIuWFNgݒ肷B
     * 
     * @param condition
     *            oIuWFNg
     */
    public void setCondition(Object condition) {
        this.condition = condition;
    }

    /**
     * oIuWFNgA܂͂܂JavaBeańAXR[v̖O擾B
     * 
     * @return oIuWFNgA܂͂܂JavaBeańAXR[v̖O
     */
    public String getConditionName() {
        return conditionName;
    }

    /**
     * oIuWFNgA܂͂܂JavaBeańAXR[v̖Oݒ肷B
     * 
     * @param conditionName
     *            oIuWFNgA܂͂܂JavaBeańAXR[v̖O
     */
    public void setConditionName(String conditionName) {
        this.conditionName = conditionName;
    }

    /**
     * oIuWFNgi[ꂽvpeB擾B
     * 
     * @return oIuWFNgi[ꂽvpeB
     */
    public String getConditionProperty() {
        return conditionProperty;
    }

    /**
     * oIuWFNgi[ꂽvpeBݒ肷B
     * 
     * @param conditionProperty
     *            oIuWFNgi[ꂽvpeB
     */
    public void setConditionProperty(String conditionProperty) {
        this.conditionProperty = conditionProperty;
    }

    /**
     * oIuWFNgXR[v擾B
     * 
     * @return oIuWFNgXR[v
     */
    public String getConditionScope() {
        return conditionScope;
    }

    /**
     * oIuWFNgXR[vݒ肷B
     * 
     * @param conditionScope
     *            oIuWFNgXR[v
     */
    public void setConditionScope(String conditionScope) {
        this.conditionScope = conditionScope;
    }

    /**
     * oʃIuWFNg`ۂ̖O擾B
     * 
     * @return oʃIuWFNg`ۂ̖O
     */
    public String getId() {
        return id;
    }

    /**
     * oʃIuWFNg`ۂ̖Oݒ肷B
     * 
     * @param id
     *            oʃIuWFNg`ۂ̖O
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * oʃIuWFNg`XR[v擾B
     * 
     * @return oʃIuWFNg`XR[v
     */
    public String getToScope() {
        return toScope;
    }

    /**
     * oʃIuWFNg`XR[vݒ肷B
     * 
     * @param toScope
     *            oʃIuWFNg`XR[v
     */
    public void setToScope(String toScope) {
        this.toScope = toScope;
    }

    /**
     * o̓vpeB擾B
     * 
     * @return o̓vpeB
     */
    public String getWriteProperty() {
        return writeProperty;
    }

    /**
     * o̓vpeBݒ肷B
     * 
     * @param writeProperty
     *            o̓vpeB
     */
    public void setWriteProperty(String writeProperty) {
        this.writeProperty = writeProperty;
    }

    /**
     * o͂HTMLGXP[v邩ۂ擾B
     * 
     * @return@o͂HTMLGXP[v邩ۂ
     */
    public boolean isFilter() {
        return filter;
    }

    /**
     * o͂HTMLGXP[v邩ۂݒ肷B
     * 
     * @param filter
     *            o͂HTMLGXP[v邩ۂ
     */
    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    /**
     * IR[hXgAw肳ꂽL[lIuWFNg𒊏oB
     * <p>
     * idݒ肳Ă΁Aʂ̃IuWFNgbeanƂĒ`A
     * idݒ肳ĂȂ΁Aʂ̃IuWFNǵAwritePropertyŎw肳ꂽvpeB\B
     * </p>
     * @return wB <code>SKIP_BODY</code>
     * @throws JspException JSPO
     * @see javax.servlet.jsp.tagext.TagSupport#doStartTag()
     */
    @Override
    public int doStartTag() throws JspException {

        // IR[hXgIuWFNg̉
        Object collection = this.collection;
        if (collection == null) {
            String collectionScope = this.collectionScope;
            if (StringUtils.isEmpty(collectionScope)) {
                collectionScope = null;
            }
            collection = TagUtils.getInstance().lookup(pageContext,
                    collectionName, collectionProperty, collectionScope);
        }
        if (collection == null) {
            JspException e = new JspException(
                    "Failed to find collection. collection object is not set. collectionName: "
                            + collectionName + ", collectionProperty: "
                            + collectionProperty + ", collectionScope: "
                            + collectionScope);
            TagUtils.getInstance().saveException(pageContext, e);
            throw e;
        }

        // oIuWFNg̉
        Object condition = this.condition;
        if (condition == null) {
            String conditionScope = this.conditionScope;
            if (StringUtils.isEmpty(conditionScope)) {
                conditionScope = null;
            }
            condition = TagUtils.getInstance().lookup(pageContext,
                    conditionName, conditionProperty, conditionScope);
        }
        if (condition == null) {
            JspException e = new JspException(
                    "Failed to find condition. condition object is not set. conditionName: "
                            + conditionName + ", conditionProperty: "
                            + conditionProperty + ", conditionScope: "
                            + conditionScope);
            TagUtils.getInstance().saveException(pageContext, e);
            throw e;
        }

        // `\ɂĕK{ƂȂA܂ApłȂ̐ݒmF
        if ((id == null && writeProperty == null)
                || (id != null && writeProperty != null)) {
            JspException e = new JspException(
                    "Illegal usage. It is necessary to specify either of id or writeProperty.");
            TagUtils.getInstance().saveException(pageContext, e);
            throw e;
        }

        // oɎgpAƍpSet̍\z
        Set<Object> conditionSet = null;
        if (condition.getClass().isArray()) {
            condition = Arrays.asList((Object[]) condition);
        }
        if (condition instanceof Collection<?>) {
            conditionSet = new HashSet<Object>((Collection<?>) condition);
        }

        // oidK{(writeProperty͋֎~)
        if (conditionSet != null && id == null) {
            JspException e = new JspException(
                    "Illegal usage. condition is Collection class or Array. In this case, id should not be null.");
            TagUtils.getInstance().saveException(pageContext, e);
            throw e;
        }

        Object resultBean = null;
        List<Object> resultList = null;
        if (conditionSet != null) {
            resultList = new ArrayList<Object>();
        }

        // ƍAo
        Iterator<?> iterator = getIterator(collection);
        while (iterator.hasNext()) {
            Object bean = iterator.next();
            Object beanKey = null;
            try {
                beanKey = PropertyUtils.getProperty(bean, keyProperty);
                // Enulllhtml:radiohtml:multiboxŏo͂ƁA󕶎񈵂ƂȂ
                // EANVtH[̔zvpeBZbg@\ŃZbgꍇAzvfnullɂȂ
                // L𓥂܂AoȂAĒoꂽ肵Ȃ悤Anull͋󕶎rΏۂƂB
                if (beanKey == null) {
                    beanKey = "";
                }
            } catch (IllegalAccessException e) {
                JspException jspe = new JspException(e);
                TagUtils.getInstance().saveException(pageContext, jspe);
                throw jspe;
            } catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                JspException jspe = new JspException(t);
                TagUtils.getInstance().saveException(pageContext, jspe);
                throw jspe;
            } catch (NoSuchMethodException e) {
                JspException jspe = new JspException(e);
                TagUtils.getInstance().saveException(pageContext, jspe);
                throw jspe;
            }
            if (this.id == null) {
                if (!condition.equals(beanKey)) {
                    continue;
                }
                try {
                    Object writeValueObj = PropertyUtils.getProperty(bean,
                            writeProperty);
                    if (writeValueObj == null) {
                        break;
                    }
                    String writeValue = writeValueObj.toString();
                    if (this.filter) {
                        writeValue = TagUtils.getInstance().filter(writeValue);
                    }
                    TagUtils.getInstance().write(pageContext, writeValue);
                } catch (IllegalAccessException e) {
                    JspException jspe = new JspException(e);
                    TagUtils.getInstance().saveException(pageContext, jspe);
                    throw jspe;
                } catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    JspException jspe = new JspException(t);
                    TagUtils.getInstance().saveException(pageContext, jspe);
                    throw jspe;
                } catch (NoSuchMethodException e) {
                    JspException jspe = new JspException(e);
                    TagUtils.getInstance().saveException(pageContext, jspe);
                    throw jspe;
                }
                break;
            } else {
                if (conditionSet == null) {
                    if (condition.equals(beanKey)) {
                        resultBean = bean;
                        break;
                    }
                } else {
                    if (conditionSet.contains(beanKey)) {
                        resultList.add(bean);
                    }
                }
            }
        }
        if (resultList != null) {
            resultBean = resultList;
        }
        if (resultBean != null) {
            int inScope = PageContext.PAGE_SCOPE;
            if (toScope != null) {
                inScope = TagUtils.getInstance().getScope(toScope);
            }
            pageContext.setAttribute(id, resultBean, inScope);
        }
        return SKIP_BODY;
    }

    /**
     * IR[hXg̃Ce[^ԂB
     * 
     * @param collection
     *            IR[hXg
     * 
     * @throws JspException
     *            IR[hXǧ^ɑΉCe[^擾łȂꍇ
     */
    protected Iterator<?> getIterator(Object collection) throws JspException {

        if (collection.getClass().isArray()) {
            collection = Arrays.asList((Object[]) collection);
        }
        if (collection instanceof Collection<?>) {
            return (((Collection<?>) collection).iterator());
        } else if (collection instanceof Iterator<?>) {
            return ((Iterator<?>) collection);
        } else if (collection instanceof Map<?, ?>) {
            return (((Map<?, ?>) collection).entrySet().iterator());
        } else if (collection instanceof Enumeration<?>) {
            return new IteratorAdapter((Enumeration<?>) collection);
        } else {
            throw new JspException("Failed to getIterator: "
                    + collection.toString());
        }
    }

    /**
     * <p>ׂẴAP[gꂽB</p>
     */
    @Override
    public void release() {
        super.release();
        this.collection = null;
        this.collectionName = null;
        this.collectionProperty = null;
        this.collectionScope = null;
        this.keyProperty = null;
        this.condition = null;
        this.conditionName = null;
        this.conditionProperty = null;
        this.conditionScope = null;
        this.id = null;
        this.toScope = null;
        this.writeProperty = null;
        this.filter = true;
    }
}
