/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.struts.action;

import java.util.Iterator;

import jp.terasoluna.fw.ex.exception.BLogicException;
import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;

import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.util.MessageResources;

/**
 * BLogicExceptionp̗OnhNXłB
 * 
 * @version 1.0.0
 */
public abstract class BLogicExceptionHandler extends AbstractExceptionHandler {

    /**
     * BLogicExceptionێBLogicMessagesCX^XA
     * G[bZ[Ẅꗗ\ActionMessages̃CX^X\zĕԂ܂B
     * 
     * @param ex O
     * @param ae ExceptionConfig
     * @param resources bZ[W\[X
     * @return G[bZ[ẄꗗێActionMessagesCX^X
     */
    @Override
    protected ActionMessages getErrors(Exception ex, ExceptionConfig ae,
            MessageResources resources) {
        if (!(ex instanceof BLogicException)) {
            return new ActionMessages();
        }
        BLogicException blex = (BLogicException) ex;
        BLogicMessages blogicMessages = blex.getBLogicMessages();
        boolean resourceExists = resources != null;
        return convertMessages(blogicMessages, resourceExists);
    }

    /**
     * BLogicMessagesActionMessagesɕϊ܂B
     * 
     * @param blogicMessages BLogicMessagesCX^X
     * @return G[bZ[ẄꗗێActionMessagesCX^X
     */
    @SuppressWarnings("unchecked")
    protected ActionMessages convertMessages(BLogicMessages blogicMessages,
            boolean resourceExists) {

        if (blogicMessages == null) {
            // blogicMessagesnull̏ꍇAnullԋp
            return null;
        }

        ActionMessages messages = new ActionMessages();
        // BLogicMessages擾pCe[^
        Iterator itr = blogicMessages.get();
        // bZ[WO[v擾pCe[^
        Iterator groupItr = blogicMessages.getGroup();
        while (itr.hasNext()) {

            // BLogicMessage擾
            BLogicMessage blogicMessage = (BLogicMessage) itr.next();

            // ActionMessage쐬
            ActionMessage actionMessage = null;
            if (blogicMessage.isResource()) {
                actionMessage = new ActionMessage(blogicMessage.getKey(),
                        blogicMessage.getValues());
            } else {
                actionMessage = new ActionMessage(blogicMessage.getKey(),
                        blogicMessage.isResource());
            }

            // bZ[WO[v擾
            String group = (String) groupItr.next();

            // bZ[Wi[
            messages.add(group, actionMessage);
        }
        return messages;
    }

    /**
     * ActionForwardCX^XɁAJڐ惂W[ݒ肵܂B
     * 
     * @param forward Jڐ\ActionForwardCX^X
     * @param ex O
     * @param ae ExceptionConfig
     * @param mapping ANV}bsO
     */
    @Override
    protected void setModule(ActionForward forward, Exception ex,
            ExceptionConfig ae, ActionMapping mapping) {
        // N/A
    }
}
