/*
 *
 *
 * Copyright (c) 2007, 2010 NTT DATA Corporation
 *
 */
package jp.terasoluna.toursample.uc_a01_02.blogic;

import java.util.Calendar;
import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.toursample.common.TourUVO;
import jp.terasoluna.toursample.common.util.DateUtil;
import jp.terasoluna.toursample.uc_a01_02.dto.RP_A01_02_01_01Input;
import jp.terasoluna.toursample.uc_a01_02.dto.RP_A01_02_01_01Output;
import jp.terasoluna.toursample.uc_a01_02.dto.SelectReservationInfoInput;
import jp.terasoluna.toursample.uc_a01_02.dto.SelectReservationInfoOutput;

/**
 * cA[\񃊃Xg擾rWlXWbNB
 * <p>
 * Ef[^x[Xڋq̗\ȉ̏Ŏ擾B<br>
 * @FcA[̏oVXetȍ~̗\<br>
 * Ee\ŃVXetUOǂ肷B<br>
 * ܂Al`̃cA[𔑓`ɕϊB<br>
 * E\̗\񌏐擾B<br>
 * E\񌏐胁bZ[Wݒ肷B
 * </p>
 * 
 * 
 * 
 */
public class RP_A01_02_01_01BLogicImpl implements BLogic<RP_A01_02_01_01Input> {

    /**
     * \񐔂0̏ꍇ̃bZ[WB
     */
    public static final String INFO_NOT_RESERVED = "info.UC_A01_02.00001";

    /**
     * ONXB
     */
    private static final Log log = LogFactory
        .getLog(RP_A01_02_01_01BLogicImpl.class);

    /**
     * \񐔂1ȏ̏ꍇ̃bZ[WB
     */
    public static final String INFO_RESERVED = "info.common.00001";

    /**
     * DAONXB<br>
     * SpringɂCX^Xݒ肳B
     */
    protected QueryDAO queryDAO = null;

    /**
     * QueryDAOݒ肷B
     * 
     * @param queryDAO
     *            QueryDAO
     */
    public void setQueryDAO(QueryDAO queryDAO) {

        this.queryDAO = queryDAO;
    }

    /**
     * \񃊃Xg擾B <BR>
     * OCĂڋqƈv\<BR>
     * \񃊃XgƂĕԋpB
     * 
     * @param param
     *            ڋq
     * @return \񃊃Xg
     */
    public BLogicResult execute(RP_A01_02_01_01Input param) {

        // ڋqԍ\ꗗ擾̈ɐݒ肷B
        SelectReservationInfoInput reservationInfoInput = 
            new SelectReservationInfoInput();
        TourUVO tourUVO = param.getUSER_VALUE_OBJECT();
        reservationInfoInput.setCustomerCode(tourUVO.getCustomerCode());

        // VXet\ꗗ擾̈ɐݒ肷B
        reservationInfoInput.setToday(DateUtil.getTodayDate());

        // f[^x[Xڋq̗\SĎ擾B
        SelectReservationInfoOutput[] reservationInfo = 
            queryDAO.executeForObjectArray("UC_A01_02.selectReservationInfo", 
                                           reservationInfoInput, 
                                           SelectReservationInfoOutput.class);

        // z̐UƔʂɕ\pɕϊB
        for (int i = 0; i < reservationInfo.length; i++) {

            // U擾B
            Date paymentTimeLimit = DateUtil.getOneWeekBeforeDate(reservationInfo[i].getDepDay());
            // VXetƐUr
            // VXetUOfalseAtrue
            // UƃVXetCR[̏ꍇ́Afalse
            Date today = DateUtil.getTodayDate();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(today);
            
            calendar.set(Calendar.HOUR_OF_DAY, 0); 
            calendar.clear(Calendar.MINUTE);
            calendar.clear(Calendar.SECOND);
            calendar.clear(Calendar.MILLISECOND);
            
            reservationInfo[i].setLimitExcessFlag(calendar.getTime().after(paymentTimeLimit));

            // l`̃cA[𔑓`ɕϊB
            reservationInfo[i].setTourDays(DateUtil
                .convertNightDays(reservationInfo[i].getIntTourDays()));
        }

        // \̔z񒷂\񌏐擾B
        Integer reservationsCount = reservationInfo.length;

        // bZ[Wݒ肷B
        BLogicMessages messages = new BLogicMessages();

        // \񌏐 0 info.UC_A01_02.00001
        if (reservationsCount == 0) {
            messages.add(this.getClass().getName(),
                         new BLogicMessage(INFO_NOT_RESERVED));

            if (log.isDebugEnabled()) {
                log.debug("\񌏐 0");
            }

            // \񌏐 1ȏ info.common.00001 [0]= reservationsCount
        } else {
            messages.add(this.getClass().getName(),
                         new BLogicMessage(INFO_RESERVED, reservationsCount));

            if (log.isDebugEnabled()) {
                log.debug("\񌏐 " + reservationsCount + "");
            }
        }

        // cA[\ڍ׏o͒lɃZbgB
        RP_A01_02_01_01Output rp_a01_02_01_01BLogicOutput = 
            new RP_A01_02_01_01Output();
        rp_a01_02_01_01BLogicOutput.setReservationInfo(reservationInfo);
        rp_a01_02_01_01BLogicOutput.setReservationsCount(reservationsCount);

        // ʂZbgB
        BLogicResult result = new BLogicResult();
        result.setResultObject(rp_a01_02_01_01BLogicOutput);
        result.setResultString("success");
        result.setMessages(messages);

        return result;
    }
}