/*
 *
 *
 * Copyright (c) 2007, 2010 NTT DATA Corporation
 *
 */
package jp.terasoluna.toursample.uc_a01_05.blogic;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.toursample.common.blogic.PriceCalculateBLogic;
import jp.terasoluna.toursample.common.blogic.ReserveDetailAcquireBLogic;
import jp.terasoluna.toursample.common.dto.PriceCalculateOutput;
import jp.terasoluna.toursample.common.dto.ReserveDetailAcquireInput;
import jp.terasoluna.toursample.common.dto.ReserveDetailAcquireOutput;
import jp.terasoluna.toursample.common.exception.RecordNotFoundException;
import jp.terasoluna.toursample.common.util.DateUtil;
import jp.terasoluna.toursample.uc_a01_05.dto.RP_A01_05_01_01Input;
import jp.terasoluna.toursample.uc_a01_05.dto.RP_A01_05_01_01Output;

/**
 * [o͏擾rWlXWbNB
 * <p>
 * E\ڍ׏擾rWlXWbN(ʏFCP0006)sB<br>
 * E\񂪂ȂꍇAOsB<br>
 * ONXFRecordNotFoundException<br>
 * EY𕶎ɕϊB<br>
 * Ex𕶎ɕϊB<br>
 * EvZNX(ʏFCP0009)sB<br>
 * Eݒ肷B<br>
 * </p>
 * 
 * 
 */
public class RP_A01_05_01_01BLogicImpl implements RP_A01_05_01_01BLogic {

    /**
     * ONXB
     */
    private static final Log log = 
        LogFactory.getLog(RP_A01_05_01_01BLogicImpl.class);

    /**
     * \ڍ׏擾NXB(ʏCP0006) SpringɂCX^Xݒ肳B
     */
    protected ReserveDetailAcquireBLogic reserveDetailAcquireBLogic = null;

    /**
     * vZNXB(ʏCP0009) SpringɂCX^Xݒ肳B
     */
    protected PriceCalculateBLogic priceCalculateBLogic = null;

    /**
     * vZNXԂB
     * 
     * @return vZNX
     */
    public PriceCalculateBLogic getPriceCalculateBLogic() {

        return priceCalculateBLogic;
    }

    /**
     * vZNXݒ肷B
     * 
     * @param priceCalculateBLogic
     *            vZNX
     */
    public void setPriceCalculateBLogic(
            PriceCalculateBLogic priceCalculateBLogic) {

        this.priceCalculateBLogic = priceCalculateBLogic;
    }

    /**
     * \ڍ׏擾NXԂB
     * 
     * @return \ڍ׏擾NX
     */
    public ReserveDetailAcquireBLogic getReserveDetailAcquireBLogic() {

        return reserveDetailAcquireBLogic;
    }

    /**
     * \ڍ׏擾NXݒ肷B
     * 
     * @param reserveDetailAcquireBLogic
     *            \ڍ׏擾NX
     */
    public void setReserveDetailAcquireBLogic(
            ReserveDetailAcquireBLogic reserveDetailAcquireBLogic) {

        this.reserveDetailAcquireBLogic = reserveDetailAcquireBLogic;
    }

    /**
     * [o͏擾B
     * <p>
     * E\ԍ擾AʏCP0006CP0009sB<br>
     * Eڋq擾B<br>
     * E擾B<br>
     * E擾o͒lɐݒ肷B
     * </P>
     * 
     * @param param
     *            [o͏擾
     * @return [o͏񃊃Xg
     * 
     * @exception
     * jp.terasoluna.toursample.common.exception.RecordNotFoundException
     * f[^x[X擾ʂȂꍇɔ
     */
    public List<RP_A01_05_01_01Output> selectReportData(
            RP_A01_05_01_01Input param) {

        // \ڍ׏擾rWlXWbN̏o͒lNX𐶐B
        RP_A01_05_01_01Output blogicOutput = new RP_A01_05_01_01Output();

        // \ڍ׏擾rWlXWbN̓͒lNX𐶐B
        ReserveDetailAcquireInput reserveDetailAcquireInput = new ReserveDetailAcquireInput();

        // p[^\ԍAڋqIuWFNgoB
        // \ڍ׏擾rWlXWbN̓͒lNXɏݒ肷B
        reserveDetailAcquireInput.setReserveNo(param.getReserveNo());
        reserveDetailAcquireInput.setCustomerCode(param.getTourUVO()
            .getCustomerCode());

        // \ڍ׏擾rWlXWbN(ʏFCP0006)sB
        ReserveDetailAcquireOutput reserveDetailResult = reserveDetailAcquireBLogic
            .execute(reserveDetailAcquireInput);

        // \񂪂ȂꍇAOsB
        // ONXFRecordNotFoundException
        if (reserveDetailResult == null) {

            if (log.isErrorEnabled()) {
                log.error("error.common.00008:\񂪌܂B");
            }

            throw new RecordNotFoundException("error.common.00008");
        }

        // Y𕶎ɕϊB
        String conductor = null;
        if (reserveDetailResult.getConductor()) {
            conductor = "L";

        } else {
            conductor = "";
        }
        
        // x𕶎i"yyyyNMMdd"or"xς"jɕϊB
        String paymentTimeLimit = null;
        if (reserveDetailResult.isTransfer()){
            paymentTimeLimit = "xς";
            
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyNMMdd");
            paymentTimeLimit = sdf.format(reserveDetailResult.
                                                 getPaymentTimeLimit());
        }

        // \o͒lɐݒ肷B
        blogicOutput.setReserveNo(param.getReserveNo());
        blogicOutput.setTourName(reserveDetailResult.getTourName());
        blogicOutput.setReservedDay(reserveDetailResult.getReservedDay());
        blogicOutput.setDepDay(reserveDetailResult.getDepDay());
        blogicOutput.setTourDays(reserveDetailResult.getTourDays());
        blogicOutput.setDepName(reserveDetailResult.getDepName());
        blogicOutput.setArrName(reserveDetailResult.getArrName());
        blogicOutput.setConductor(conductor);
        blogicOutput.setAccomName(reserveDetailResult.getAccomName());
        blogicOutput.setAccomTel(reserveDetailResult.getAccomTel());
        blogicOutput.setTourAbs(reserveDetailResult.getTourAbs());
        blogicOutput.setAdultCount(reserveDetailResult.getAdultCount());
        blogicOutput.setChildCount(reserveDetailResult.getChildCount());
        blogicOutput.setRemarks(reserveDetailResult.getRemarks());
        blogicOutput.setPaymentTimeLimit(paymentTimeLimit);

        // vZNX(ʏFCP0009)sB
        PriceCalculateOutput priceCalcResult = priceCalculateBLogic
            .execute(reserveDetailResult.getBasePrice(), reserveDetailResult
                .getAdultCount(), reserveDetailResult.getChildCount());

        // o͒lɐݒ肷B
        blogicOutput.setAdultUnitPrice(priceCalcResult.getAdultUnitPrice());
        blogicOutput.setChildUnitPrice(priceCalcResult.getChildUnitPrice());
        blogicOutput.setAdultPrice(priceCalcResult.getAdultPrice());
        blogicOutput.setChildPrice(priceCalcResult.getChildPrice());
        blogicOutput.setSumPrice(priceCalcResult.getSumPrice());

        // ڋqo͒lɐݒ肷B
        blogicOutput.setCustomerCode(param.getTourUVO().getCustomerCode());
        blogicOutput.setCustomerKana(param.getTourUVO().getCustomerKana());
        blogicOutput.setCustomerName(param.getTourUVO().getCustomerName());
        blogicOutput.setCustomerBirth(param.getTourUVO().getCustomerBirth());
        blogicOutput.setCustomerJob(param.getTourUVO().getCustomerJob());
        blogicOutput.setCustomerMail(param.getTourUVO().getCustomerMail());
        blogicOutput.setCustomerTel(param.getTourUVO().getCustomerTel());
        blogicOutput.setCustomerPost(param.getTourUVO().getCustomerPost());
        blogicOutput.setCustomerAdd(param.getTourUVO().getCustomerAdd());

        // o͒lɐݒ肷B
        Date printDay = DateUtil.getTodayDate();
        blogicOutput.setPrintDay(printDay);

        // [o͏񃊃Xg𐶐B
        List<RP_A01_05_01_01Output> list = new ArrayList<RP_A01_05_01_01Output>();

        // Xgɒ[o͂B
        list.add(blogicOutput);

        return list;
    }

}