/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.servlet.handler;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.Controller;

/**
 * {@link jp.terasoluna.fw.web.rich.springmvc.servlet.handler.
 * SimpleMappingExceptionResolverEx} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * ONXƃr[̃}bsOsException resolver̊gNXB<br>
 * OF
 * <p>
 * 
 * @see jp.terasoluna.fw.web.rich.springmvc.servlet.handler.
 * SimpleMappingExceptionResolverEx
 */
public class SimpleMappingExceptionResolverExTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(
                SimpleMappingExceptionResolverExTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public SimpleMappingExceptionResolverExTest(String name) {
        super(name);
    }

    /**
     * testAfterPropertiesSet01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C
     * <br><br>
     * ͒lF() this.linkedExceptionMappings:null<br>
     *         () this.exceptionResolveDelegatorClass:not null<br>
     *         () this.exceptionResolveDelegatorMap:LinkedHashMap<br>
     *         
     * <br>
     * ҒlF(ԕω) this.exceptionResolveDelegatorMap:LinkedHashMap<br>
     *         
     * <br>
     * this.linkedExceptionMappingsnull̏ꍇ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAfterPropertiesSet01() throws Exception {
        // O
        SimpleMappingExceptionResolverEx simpleMappingExceptionResolverEx = new SimpleMappingExceptionResolverEx();
        LinkedHashMap linkedExceptionMappings = null;
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "linkedExceptionMappings", linkedExceptionMappings);
        LinkedHashMap exceptionResolveDelegatorMap = (LinkedHashMap)UTUtil.getPrivateField(simpleMappingExceptionResolverEx, "exceptionResolveDelegatorMap");
        // eXg{
        simpleMappingExceptionResolverEx.afterPropertiesSet();
        
        // 
        assertTrue(exceptionResolveDelegatorMap.isEmpty());
    }

    /**
     * testAfterPropertiesSet02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA,C,G
     * <br><br>
     * ͒lF() this.linkedExceptionMappings:not null<br>
     *         () this.exceptionResolveDelegatorClass:null<br>
     *         () this.exceptionResolveDelegatorMap:LinkedHashMap<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException{<br>
     *                      detailMessage= "SimpleMappingExceptionResolverEx must be set exceptionResolveDelegatorClass. Check Spring Bean definition file."<br>
     *                    }<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"SimpleMappingExceptionResolverEx must be set exceptionResolveDelegatorClass. Check Spring Bean definition file."<br>
     *         (ԕω) this.exceptionResolveDelegatorMap:LinkedHashMap<br>
     *         
     * <br>
     * this.exceptionResolveDelegatorClassnull̏ꍇ̃eXgBOX[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAfterPropertiesSet02() throws Exception {
        // O
        SimpleMappingExceptionResolverEx simpleMappingExceptionResolverEx = new SimpleMappingExceptionResolverEx();
        LinkedHashMap<String, Object> linkedExceptionMappings = new LinkedHashMap<String, Object>();
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "linkedExceptionMappings", linkedExceptionMappings);
        
        Class cl = null;
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "exceptionResolveDelegatorClass", cl);
        
        // eXg{
        try {
            simpleMappingExceptionResolverEx.afterPropertiesSet();
            fail();
        } catch (IllegalStateException e) {

            // 
            String message = "SimpleMappingExceptionResolverEx must be set exceptionResolveDelegatorClass. Check Spring Bean definition file.";
            assertEquals(message, e.getMessage());

            // OmF
            assertTrue(LogUTUtil.checkError(message));
        }
    }

    /**
     * testAfterPropertiesSet03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA,E,G
     * <br><br>
     * ͒lF() this.linkedExceptionMappings:not null<br>
     *         () this.exceptionResolveDelegatorClass:java.util.DateNX<br>
     *         () this.exceptionResolveDelegatorMap:LinkedHashMap<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException{<br>
     *                      detailMessage= "java.util.Date is not ExceptionResolveDelegator type. Check Spring Bean definition file."<br>
     *                    }<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"java.util.Date is not ExceptionResolveDelegator type. Check Spring Bean definition file."<br>
     *         (ԕω) this.exceptionResolveDelegatorMap:LinkedHashMap<br>
     *         
     * <br>
     * this.exceptionResolveDelegatorClasš^ExceptionResolveDelegator^łȂꍇ̃eXgBOX[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAfterPropertiesSet03() throws Exception {
        // O
        SimpleMappingExceptionResolverEx simpleMappingExceptionResolverEx = new SimpleMappingExceptionResolverEx();
        LinkedHashMap<String, Object> linkedExceptionMappings = new LinkedHashMap<String, Object>();
        linkedExceptionMappings.put("abc","123");
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "linkedExceptionMappings", linkedExceptionMappings);
        
        Class cl = java.util.Date.class;
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "exceptionResolveDelegatorClass", cl);
        
        // eXg{
        try {
            simpleMappingExceptionResolverEx.afterPropertiesSet();
            fail();
        } catch (IllegalStateException e) {

            // 
            String message = cl.getName() + " is not ExceptionResolveDelegator type. Check Spring Bean definition file.";
            assertEquals(message, e.getMessage());

            // OmF
            assertTrue(LogUTUtil.checkError(message));
        }        
    }

    /**
     * testAfterPropertiesSet04()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA,G
     * <br><br>
     * ͒lF() this.linkedExceptionMappings:not null<br>
     *         () this.exceptionResolveDelegatorClass:RXgNExceptionResolveDelegatorNX<br>
     *         () this.exceptionResolveDelegatorMap:LinkedHashMap<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException{<br>
     *                      detailMessage= this.exceptionResolveDelegatorClass.getName() + " cannot be instantiated. Check Spring Bean definition file.",<br>
     *                      cause= InstantiationException<br>
     *                    }<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WFthis.exceptionResolveDelegatorClass.getName() + " cannot be instantiated. Check Spring Bean definition file.<br>
     *                    OFInstantiationException<br>
     *         (ԕω) this.exceptionResolveDelegatorMap:LinkedHashMap<br>
     *         
     * <br>
     * this.exceptionResolveDelegatorClass̃CX^XɎsꍇ̃eXgBOX[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAfterPropertiesSet04() throws Exception {
        // O
        SimpleMappingExceptionResolverEx simpleMappingExceptionResolverEx = new SimpleMappingExceptionResolverEx();
        LinkedHashMap<String, Object> linkedExceptionMappings = new LinkedHashMap<String, Object>();
        linkedExceptionMappings.put("abc","123");
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "linkedExceptionMappings", linkedExceptionMappings);
        
        // exceptionResolveDelegatorMap
        LinkedHashMap<String, ExceptionResolveDelegator>exceptionResolveDelegatorMap = new LinkedHashMap<String, ExceptionResolveDelegator>();
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "exceptionResolveDelegatorMap", exceptionResolveDelegatorMap);

        Class cl = SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub02.class;
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "exceptionResolveDelegatorClass", cl);
        
        // eXg{
        try {
            simpleMappingExceptionResolverEx.afterPropertiesSet();
            fail();
        } catch (IllegalStateException e) {

            // 
            String message = cl.getName() + " cannot be instantiated. Check Spring Bean definition file.";
            assertEquals(message, e.getMessage());

            // OmF
            assertTrue(LogUTUtil.checkError(message, e.getCause()));
        }        
    }

    /**
     * testAfterPropertiesSet05()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA,G
     * <br><br>
     * ͒lF() this.linkedExceptionMappings:not null<br>
     *         () this.exceptionResolveDelegatorClass:privateȃRXgN^ExceptionResolveDelegatorNX<br>
     *         () this.exceptionResolveDelegatorMap:LinkedHashMap<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException{<br>
     *                      detailMessage= this.exceptionResolveDelegatorClass.getName() + " cannot be instantiated. Check Spring Bean definition file.",<br>
     *                      cause= IllegalAccessException<br>
     *                    }<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WFthis.exceptionResolveDelegatorClass.getName() + " cannot be instantiated. Check Spring Bean definition file.<br>
     *                    OFInstantiationException<br>
     *         (ԕω) this.exceptionResolveDelegatorMap:LinkedHashMap<br>
     *         
     * <br>
     * this.exceptionResolveDelegatorClass̃CX^XɎsꍇ̃eXgBOX[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAfterPropertiesSet05() throws Exception {
        // O
        SimpleMappingExceptionResolverEx simpleMappingExceptionResolverEx = new SimpleMappingExceptionResolverEx();
        LinkedHashMap<String, Object> linkedExceptionMappings = new LinkedHashMap<String, Object>();
        linkedExceptionMappings.put("abc","def");
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "linkedExceptionMappings", linkedExceptionMappings);
        
        // exceptionResolveDelegatorMap
        LinkedHashMap<String, ExceptionResolveDelegator>exceptionResolveDelegatorMap = new LinkedHashMap<String, ExceptionResolveDelegator>();
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "exceptionResolveDelegatorMap", exceptionResolveDelegatorMap);

        Class cl = SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub03.class;
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "exceptionResolveDelegatorClass", cl);
        
        // eXg{
        try {
            simpleMappingExceptionResolverEx.afterPropertiesSet();
            fail();
        } catch (IllegalStateException e) {
            // 
            String message = cl.getName() + " cannot be instantiated. "
                        + "Check Spring Bean definition file.";
            assertEquals(message, e.getMessage());

            // OmF
            assertTrue(LogUTUtil.checkError(message, e.getCause()));
        }        
    }

    /**
     * testAfterPropertiesSet06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,D
     * <br><br>
     * ͒lF() this.linkedExceptionMappings:LinkedHashMap<br>
     *         () this.exceptionResolveDelegatorClass:Ȃ̃RXgN^ExceptionResolveDelegatorNX<br>
     *         () this.exceptionResolveDelegatorMap:LinkedHashMap<br>
     *         
     * <br>
     * ҒlF(ԕω) this.exceptionResolveDelegatorMap:LinkedHashMap<br>
     *         
     * <br>
     * this.linkedExceptionMappings̏ꍇ̃eXgBsȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAfterPropertiesSet06() throws Exception {
        // O
        SimpleMappingExceptionResolverEx simpleMappingExceptionResolverEx = new SimpleMappingExceptionResolverEx();
        LinkedHashMap<String, Object> linkedExceptionMappings = new LinkedHashMap<String, Object>();
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "linkedExceptionMappings", linkedExceptionMappings);
        
        // exceptionResolveDelegatorMap
        LinkedHashMap<String, ExceptionResolveDelegator>exceptionResolveDelegatorMap = new LinkedHashMap<String, ExceptionResolveDelegator>();
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "exceptionResolveDelegatorMap", exceptionResolveDelegatorMap);

        Class cl = jp.terasoluna.fw.web.rich.springmvc.servlet.handler.ExceptionResolveDelegatorImpl.class;
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "exceptionResolveDelegatorClass", cl);
        
        // eXg{
        simpleMappingExceptionResolverEx.afterPropertiesSet();
        
        // 
        assertTrue(exceptionResolveDelegatorMap.isEmpty());
    }

    /**
     * testAfterPropertiesSet07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,D
     * <br><br>
     * ͒lF() this.linkedExceptionMappings:LinkedHashMap {<br>
     *                  "abc"= "123"<br>
     *                }<br>
     *         () this.exceptionResolveDelegatorClass:Ȃ̃RXgN^ExceptionResolveDelegatorNX<br>
     *         () this.exceptionResolveDelegatorMap:LinkedHashMap<br>
     *         () this.exceptionResolveDelegatorParams:HashMap{<br>
     *                 "errorTypeHeaderName"="errorType"<br>
     *                }<br>
     *         
     * <br>
     * ҒlF(ԕω) this.exceptionResolveDelegatorMap:LinkedHashMap{<br>
     *                      "abc"= ExceptionResolveDelegatorCX^X{<br>
     *                        mappingKey= "abc"<br>
     *                        mappingValues= "123"<br>
     *                        paramsMap=HashMap{<br>
     *                          "errorTypeHeaderName"="errorType"<br>
     *                        }<br>
     *                      }<br>
     *                    }<br>
     *         
     * <br>
     * this.linkedExceptionMappings̗vfP̏ꍇ̃eXgBthis.exceptionResolveDelegatorMapɗvf1ǉ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAfterPropertiesSet07() throws Exception {
        // O
        SimpleMappingExceptionResolverEx simpleMappingExceptionResolverEx = new SimpleMappingExceptionResolverEx();
        LinkedHashMap<String, Object> linkedExceptionMappings = new LinkedHashMap<String, Object>();
        linkedExceptionMappings.put("abc", "123");
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "linkedExceptionMappings", linkedExceptionMappings);
        
        // exceptionResolveDelegatorMap
        LinkedHashMap<String, ExceptionResolveDelegator>exceptionResolveDelegatorMap = new LinkedHashMap<String, ExceptionResolveDelegator>();
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "exceptionResolveDelegatorMap", exceptionResolveDelegatorMap);

        Class cl = SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01.class;
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "exceptionResolveDelegatorClass", cl);

        Map<String, String> map = new HashMap<String, String>();
        map.put("errorTypeHeaderName","errorType");
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "exceptionResolveDelegatorParams", map);
        
        // eXg{
        simpleMappingExceptionResolverEx.afterPropertiesSet();
        
        // 
        SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01 result = (SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01)exceptionResolveDelegatorMap.get("abc");
        assertEquals("abc", result.mappingKey);
        assertEquals("123", result.mappingValues);
        assertSame(map, result.paramsMap);
    }

    /**
     * testAfterPropertiesSet08()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,D
     * <br><br>
     * ͒lF() this.linkedExceptionMappings:LinkedHashMap {<br>
     *                  "abc"= "123",<br>
     *                  "def"= "456",<br>
     *                  "ghi"= "789"<br>
     *                }<br>
     *         () this.exceptionResolveDelegatorClass:Ȃ̃RXgN^ExceptionResolveDelegatorNX<br>
     *         () this.exceptionResolveDelegatorMap:LinkedHashMap<br>
     *         () this.exceptionResolveDelegatorParams:HashMap{<br>
     *                 "errorTypeHeaderName"="errorType"<br>
     *                }<br>
     *                         
     * <br>
     * ҒlF(ԕω) this.exceptionResolveDelegatorMap:LinkedHashMap{<br>
     *                      "abc"= ExceptionResolveDelegatorNX{<br>
     *                        mappingKey= "abc"<br>
     *                        mappingValues= "123"<br>
     *                        paramsMap=HashMap{<br>
     *                          "errorTypeHeaderName"="errorType"<br>
     *                        }<br>
     *                      }<br>
     *                      "abc"= ExceptionResolveDelegatorNX{<br>
     *                        mappingKey= "def"<br>
     *                        mappingValues= "456"<br>
     *                        paramsMap=HashMap{<br>
     *                          "errorTypeHeaderName"="errorType"<br>
     *                        }<br>                        
     *                      }<br>
     *                      "abc"= ExceptionResolveDelegatorNX{<br>
     *                        mappingKey= "ghi"<br>
     *                        mappingValues= "789"<br>
     *                        paramsMap=HashMap{<br>
     *                          "errorTypeHeaderName"="errorType"<br>
     *                        }<br>
     *                      }<br>
     *                    }<br>
     *         
     * <br>
     * this.linkedExceptionMappings̗vfP̏ꍇ̃eXgBthis.exceptionResolveDelegatorMapɗvf3ǉ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAfterPropertiesSet08() throws Exception {
        // O
        SimpleMappingExceptionResolverEx simpleMappingExceptionResolverEx = new SimpleMappingExceptionResolverEx();
        LinkedHashMap<String, Object> linkedExceptionMappings = new LinkedHashMap<String, Object>();
        linkedExceptionMappings.put("abc", "123");
        linkedExceptionMappings.put("def", "456");
        linkedExceptionMappings.put("ghi", "789");
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "linkedExceptionMappings", linkedExceptionMappings);
        
        // exceptionResolveDelegatorMap
        LinkedHashMap<String, ExceptionResolveDelegator>exceptionResolveDelegatorMap = new LinkedHashMap<String, ExceptionResolveDelegator>();
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "exceptionResolveDelegatorMap", exceptionResolveDelegatorMap);

        Class cl = SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01.class;
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "exceptionResolveDelegatorClass", cl);
        
        Map<String, String> map = new HashMap<String, String>();
        map.put("errorTypeHeaderName","errorType");
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "exceptionResolveDelegatorParams", map);
        
        // eXg{
        simpleMappingExceptionResolverEx.afterPropertiesSet();
        
        // 
        SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01 result01 = (SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01)exceptionResolveDelegatorMap.get("abc");
        assertEquals("abc", result01.mappingKey);
        assertEquals("123", result01.mappingValues);
        assertSame(map, result01.paramsMap);

        SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01 result02 = (SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01)exceptionResolveDelegatorMap.get("def");
        assertEquals("def", result02.mappingKey);
        assertEquals("456", result02.mappingValues);
        assertSame(map, result02.paramsMap);

        SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01 result03 = (SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01)exceptionResolveDelegatorMap.get("ghi");
        assertEquals("ghi", result03.mappingKey);
        assertEquals("789", result03.mappingValues);
        assertSame(map, result03.paramsMap);

    }

    /**
     * testSetExceptionResolveDelegatorClass01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() exceptionResolveDelegatorClass:exceptionResolveDelegatorClassNX<br>
     *         () this.exceptionResolveDelegatorClass:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.exceptionResolveDelegatorClass:exceptionResolveDelegatorClassNX<br>
     *         
     * <br>
     * ̒lɐݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetExceptionResolveDelegatorClass01() throws Exception {
        // O
        SimpleMappingExceptionResolverEx simpleMappingExceptionResolverEx = new SimpleMappingExceptionResolverEx();
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "exceptionResolveDelegatorClass", null);

        // 
        Class<? extends ExceptionResolveDelegator> cl = jp.terasoluna.fw.web.rich.springmvc.servlet.handler.ExceptionResolveDelegatorImpl.class;
        
        // eXg{
        simpleMappingExceptionResolverEx.setExceptionResolveDelegatorClass(cl);

        // 
        assertEquals(cl, UTUtil.getPrivateField(simpleMappingExceptionResolverEx, "exceptionResolveDelegatorClass"));

    }
    
    /**
     * testSetExceptionResolveDelegatorParams01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() exceptionResolveDelegatorParams:not null<br>
     *         () this.exceptionResolveDelegatorParams:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.exceptionResolveDelegatorParams:Őݒ肳ꂽlݒ肳ĂB<br>
     *         
     * <br>
     * ̒lɐݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetExceptionResolveDelegatorParams01() throws Exception {
        // O
        SimpleMappingExceptionResolverEx simpleMappingExceptionResolverEx = new SimpleMappingExceptionResolverEx();
        UTUtil.setPrivateField(simpleMappingExceptionResolverEx, "exceptionResolveDelegatorParams", null);

        // 
        Map<String, String> map = new HashMap<String, String>();
        
        // eXg{
        simpleMappingExceptionResolverEx.setExceptionResolveDelegatorParams(map);

        // 
        assertEquals(map, 
                UTUtil.getPrivateField(simpleMappingExceptionResolverEx, "exceptionResolveDelegatorParams"));

    }
    
    /**
     * testSetDefaultErrorView01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() defaultErrorView:null<br>
     *         () super.setDefaultErrorViewij:
     *         superNXdefaultErrorView
     *         defaultErrorViewݒ肷B<br>
     *         () logger.isInfoEnabled():true<br>
     *         
     * <br>
     * ҒlF(ԕω) this.defaultErrorView:null<br>
     *         (ԕω) O:Default error view is ' 
     *         + this.defaultErrorView + "'"<br>
     *         
     * <br>
     * defaultErrorViewsetter\bh̃eXgB
     * Null̏ꍇANullZbgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetDefaultErrorView01() throws Exception {
        // O
        SimpleMappingExceptionResolverEx exceptionResolver = 
            new SimpleMappingExceptionResolverEx();
        UTUtil.setPrivateField(exceptionResolver, "defaultErrorView", "");
        setField(SimpleMappingExceptionResolver.class, "defaultErrorView", 
                exceptionResolver, "");

        // eXg{
        exceptionResolver.setDefaultErrorView(null);

        // 
        Object result = UTUtil.getPrivateField(
                exceptionResolver, "defaultErrorView");
        Object superResult = getField(
                SimpleMappingExceptionResolver.class, 
                "defaultErrorView", exceptionResolver);
        assertNull(result);
        assertNull(superResult);
        assertTrue(LogUTUtil.checkInfo("Default error view is 'null'"));
    }

    /**
     * testSetDefaultErrorView02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() defaultErrorView:󕶎<br>
     *         () super.setDefaultErrorViewij:
     *         superNXdefaultErrorView
     *         defaultErrorViewݒ肷B<br>
     *         () logger.isInfoEnabled():true<br>
     *         
     * <br>
     * ҒlF(ԕω) this.defaultErrorView:󕶎<br>
     *         (ԕω) O:Default error view is ' 
     *         + this.defaultErrorView + "'"<br>
     *         
     * <br>
     * defaultErrorViewsetter\bh̃eXgB
     * 󕶎̏ꍇA󕶎@ZbgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetDefaultErrorView02() throws Exception {
        // O
        SimpleMappingExceptionResolverEx exceptionResolver = 
            new SimpleMappingExceptionResolverEx();
        UTUtil.setPrivateField(exceptionResolver, "defaultErrorView", null);
        setField(SimpleMappingExceptionResolver.class, "defaultErrorView", 
                exceptionResolver, null);

        // eXg{
        String value = "";
        exceptionResolver.setDefaultErrorView(value);

        // 
        Object result = UTUtil.getPrivateField(
                exceptionResolver, "defaultErrorView");
        Object superResult = getField(
                SimpleMappingExceptionResolver.class, 
                "defaultErrorView", exceptionResolver);
        assertSame(value, result);
        assertSame(value, superResult);
        assertTrue(LogUTUtil.checkInfo("Default error view is ''"));
    }

    /**
     * testSetDefaultErrorView03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() defaultErrorView:not null<br>
     *         () super.setDefaultErrorViewij:
     *         superNXdefaultErrorView
     *         defaultErrorViewݒ肷B<br>
     *         () logger.isInfoEnabled():true<br>
     *         
     * <br>
     * ҒlF(ԕω) this.defaultErrorView:not null<br>
     *         (ԕω) O:Default error view is ' 
     *         + this.defaultErrorView + "'"<br>
     *         
     * <br>
     * defaultErrorViewsetter\bh̃eXgB
     * NotNull̏ꍇAZbgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetDefaultErrorView03() throws Exception {
        // O
        SimpleMappingExceptionResolverEx exceptionResolver = 
            new SimpleMappingExceptionResolverEx();
        UTUtil.setPrivateField(exceptionResolver, "defaultErrorView", null);
        setField(SimpleMappingExceptionResolver.class, "defaultErrorView", 
                exceptionResolver, null);

        // eXg{
        String value = "test";
        exceptionResolver.setDefaultErrorView(value);

        // 
        Object result = UTUtil.getPrivateField(
                exceptionResolver, "defaultErrorView");
        Object superResult = getField(
                SimpleMappingExceptionResolver.class, 
                "defaultErrorView", exceptionResolver);
        assertSame(value, result);
        assertSame(value, superResult);
        assertTrue(LogUTUtil.checkInfo("Default error view is 'test'"));
    }

    /**
     * testSetMappedHandlers01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() mappedHandlers:null<br>
     *         () super.setMappedHandlersij:
     *         superNXmappedHandlersɈmappedHandlersݒ肷B<br>
     *         
     * <br>
     * ҒlF(ԕω) this.mappedHandlers:null<br>
     *         (ԕω) super.mappedHandlers:null<br>
     *         
     * <br>
     * mappedHandlersset\bh̃eXgB
     * NullSetCX^XƂBw肵lZbgĂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetMappedHandlers01() throws Exception {
        // O
        SimpleMappingExceptionResolverEx exceptionResolver = 
            new SimpleMappingExceptionResolverEx();
        UTUtil.setPrivateField(
                exceptionResolver, "mappedHandlers", new HashSet());
        setField(AbstractHandlerExceptionResolver.class, "mappedHandlers", 
                exceptionResolver, new HashSet());

        // eXg{
        exceptionResolver.setMappedHandlers(null);

        // 
        Object result = UTUtil.getPrivateField(
                exceptionResolver, "mappedHandlers");
        Object superResult = getField(
                AbstractHandlerExceptionResolver.class, 
                "mappedHandlers", exceptionResolver);
        assertNull(result);
        assertNull(superResult);
    }

    /**
     * testSetMappedHandlers02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() mappedHandlers:not null<br>
     *                (vfRj<br>
     *         () super.setMappedHandlersij:
     *         superNXmappedHandlers
     *         mappedHandlersݒ肷B<br>
     *         
     * <br>
     * ҒlF(ԕω) this.mappedHandlers:not null<br>
     *                    (vfRj<br>
     *         (ԕω) super.mappedHandlers:not null<br>
     *                    (vfRj<br>
     *         
     * <br>
     * mappedHandlersset\bh̃eXgB
     * vfRSetCX^XƂBw肵lZbgĂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetMappedHandlers02() throws Exception {
        // O
        SimpleMappingExceptionResolverEx exceptionResolver = 
            new SimpleMappingExceptionResolverEx();
        UTUtil.setPrivateField(exceptionResolver, "mappedHandlers", null);
        setField(AbstractHandlerExceptionResolver.class, "mappedHandlers", 
                exceptionResolver, null);
        Set<Object> set = new HashSet<Object>();
        Object obj1 = new Object();
        Object obj2 = new Object();
        Object obj3 = new Object();
        set.add(obj1);
        set.add(obj2);
        set.add(obj3);

        // eXg{
        exceptionResolver.setMappedHandlers(set);

        // 
        Object result = UTUtil.getPrivateField(
                exceptionResolver, "mappedHandlers");
        Object superResult = getField(
                AbstractHandlerExceptionResolver.class, 
                "mappedHandlers", exceptionResolver);
        assertSame(set, result);
        assertSame(set, superResult);
    }

    /**
     * testSetDefaultStatusCode01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() defaultStatusCode:not null<br>
     *                (QOOj<br>
     *         () super.setDefaultStatusCode(j:
     *         superNXdefaultStatusCode
     *         defaultStatusCodeݒ肷B<br>
     *         
     * <br>
     * ҒlF(ԕω) this.defaultStatusCode:not null<br>
     *                    (QOOj<br>
     *         (ԕω) super.defaultStatusCode:not null<br>
     *                    (QOOj<br>
     *         
     * <br>
     * defaultStatusCodeset\bh̃eXgB
     * lQOOIntegerCX^XƂB
     * w肵lZbgĂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetDefaultStatusCode01() throws Exception {
        // O
        SimpleMappingExceptionResolverEx exceptionResolver = 
            new SimpleMappingExceptionResolverEx();
        UTUtil.setPrivateField(exceptionResolver, "defaultStatusCode", 0);
        setField(SimpleMappingExceptionResolver.class, "defaultStatusCode", 
                exceptionResolver, 0);

        // eXg{
        int value = 200;
        exceptionResolver.setDefaultStatusCode(value);
        
        // 
        Object result = UTUtil.getPrivateField(
                exceptionResolver, "defaultStatusCode");
        Object superResult = getField(
                SimpleMappingExceptionResolver.class, 
                "defaultStatusCode", exceptionResolver);
        assertEquals(value, result);
        assertEquals(value, superResult);
    }

    /**
     * testSetExceptionMappings01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() mappings:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:UnsupportedOperationException<br>
     *         
     * <br>
     * T|[gĂȂ\bh̃eXgBOԂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testSetExceptionMappings01() throws Exception {
        // O
        SimpleMappingExceptionResolverEx exceptionResolver = 
            new SimpleMappingExceptionResolverEx();

        // eXg{
        try {
            exceptionResolver.setExceptionMappings(new Properties());
            fail();
        } catch (UnsupportedOperationException e) {
            // ʊmF
        	return;
        }
    }

    /**
     * testSetLinkedExceptionMappings01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() linkedExceptionMappings:not null<br>
     *         () this.linkedExceptionMappings:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.linkedExceptionMappings:
     * Őݒ肳ꂽlݒ肳ĂB<br>
     *         
     * <br>
     * linkedExceptionMappingssetter\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetLinkedExceptionMappings01() throws Exception {
        // O
        SimpleMappingExceptionResolverEx exceptionResolver = 
            new SimpleMappingExceptionResolverEx();
        UTUtil.setPrivateField(
                exceptionResolver, "linkedExceptionMappings", null);

        // eXg{
        Map<String, Object> map = new HashMap<String, Object>();
        exceptionResolver.setLinkedExceptionMappings(map);
        
        // 
        Object result = UTUtil.getPrivateField(
                exceptionResolver, "linkedExceptionMappings");
        assertSame(map, result);
    }

    /**
     * testResolveException01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C
     * <br><br>
     * ͒lF() request:gpȂ<br>
     *         () response:not null<br>
     *         () handler:not null<br>
     *                iRg[̃CX^Xj<br>
     *         () ex:ExceptionCX^X<br>
     *         () this.mappedHandlers:handlerƓIuWFNgvfɎȂSet<br>
     *         
     * <br>
     * ҒlF(߂l) ModelAndView:null<br>
     *         
     * <br>
     * {NXŏȂnhiRg[j̃eXgBNullԂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testResolveException01() throws Exception {
        // O
        SimpleMappingExceptionResolverEx exceptionResolver = 
            new SimpleMappingExceptionResolverEx();
        Set<Object> set = new HashSet<Object>();
        set.add(new SimpleMappingExceptionResolverEx_ControllerImplStub01());
        UTUtil.setPrivateField(
                exceptionResolver, "mappedHandlers", set);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        Controller controller = 
            new SimpleMappingExceptionResolverEx_ControllerImplStub01();
        ModelAndView mv = exceptionResolver.resolveException(
                request, response, controller, new Exception());

        // 
        assertNull(mv);
    }

    /**
     * testResolveException02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C
     * <br><br>
     * ͒lF() request:gpȂ<br>
     *         () response:not null<br>
     *         () handler:null<br>
     *         () ex:ExceptionCX^X<br>
     *         () this.mappedHandlers:null<br>
     *         () exceptionResolveDelegatorMap:vfMap<br>
     *         () this.defaultErrorView:null<br>
     *         () this.defaultStatusCode:not null<br>
     *                (200)<br>
     *         
     * <br>
     * ҒlF(߂l) ModelAndView:null<br>
     *         
     * <br>
     * nhOOLqĂȂp^[̃eXgBNullԂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testResolveException02() throws Exception {
        // O
        SimpleMappingExceptionResolverEx exceptionResolver = 
            new SimpleMappingExceptionResolverEx();
        UTUtil.setPrivateField(exceptionResolver, "mappedHandlers", null);
        LinkedHashMap exceptionResolveDelegatorMap = new LinkedHashMap();
        UTUtil.setPrivateField(
                exceptionResolver, "exceptionResolveDelegatorMap", exceptionResolveDelegatorMap);
        String defaultErrorViewName = null;
        UTUtil.setPrivateField(exceptionResolver, "defaultErrorView", defaultErrorViewName);
        int statusCode = 200;
        UTUtil.setPrivateField(
                exceptionResolver, "defaultStatusCode", statusCode);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        Exception exception = new Exception();

        // eXg{
        ModelAndView mv = exceptionResolver.resolveException(
                request, response, null, exception);

        // 
        assertNull(mv);
        
    }

    /**
     * testResolveException03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C
     * <br><br>
     * ͒lF() request:gpȂ<br>
     *         () response:not null<br>
     *         () handler:null<br>
     *         () ex:ExceptionCX^X<br>
     *         () this.mappedHandlers:null<br>
     *         () exceptionResolveDelegatorMap:vfPMap<br>
     *                Exception= ExceptionResolveDelegatorCX^X{ viewName= null}<br>
     *         () getDepthij:uOv<br>
     *         () this.defaultErrorView:"default"<br>
     *         () this.defaultStatusCode:not null<br>
     *                (200)<br>
     *         () getModelAndView():getModelAndView()\bhԂr[<br>
     *         () exceptionResolveDelegator.setHeader():ĂяoꂽƂmFB<br>
     *         () exceptionResolveDelegator.addObjectToModel():ĂяoꂽƂmFB<br>
     *         
     * <br>
     * ҒlF(߂l) ModelAndView:ModelAndView<br>
     *                  EviewNameFdefault<br>
     *                  EmodeliMap^j<br>
     *                  exception=ex<br>
     *         (ԕω) response:Xe[^XR[hݒ肳B<br>
     *         
     * <br>
     * nhOOPLqĂAOɑΉExceptionResolveDelegatorviewNamenullݒ肳Ăp^[̃eXgBftHgG[r[ݒ肳ꂽModelAndViewԂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testResolveException03() throws Exception {
        // O
        // Delegator
        SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01 exceptionResolveDelegatorImpl = new SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01();
        exceptionResolveDelegatorImpl.viewName = null;
        
        SimpleMappingExceptionResolverEx exceptionResolver = 
            new SimpleMappingExceptionResolverEx();
        UTUtil.setPrivateField(exceptionResolver, "mappedHandlers", null);
        LinkedHashMap<String, Object> exceptionResolveDelegatorMap = new LinkedHashMap<String, Object>();
        UTUtil.setPrivateField(
                exceptionResolver, "exceptionResolveDelegatorMap", exceptionResolveDelegatorMap);
        exceptionResolveDelegatorMap.put("java.lang.Exception",exceptionResolveDelegatorImpl);
        String defaultErrorViewName = "default";
        UTUtil.setPrivateField(exceptionResolver, "defaultErrorView", defaultErrorViewName);
        int statusCode = 200;
        UTUtil.setPrivateField(
                exceptionResolver, "defaultStatusCode", statusCode);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        Exception exception = new Exception();
        
        // eXg{
        ModelAndView mv = exceptionResolver.resolveException(
                request, response, null, exception);

        // 
        assertEquals(defaultErrorViewName, mv.getViewName());
        assertSame(exception, mv.getModel().get("exception"));
        
        // X^ǔĂяomF
        assertTrue(exceptionResolveDelegatorImpl.isAddObjectToModel);
        assertTrue(exceptionResolveDelegatorImpl.isSetHeader);

        // O mF
        assertTrue(LogUTUtil.checkError("Handled the following exception.",
                exception));
    }

    /**
     * testResolveException04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,D
     * <br><br>
     * ͒lF() request:gpȂ<br>
     *         () response:not null<br>
     *         () handler:not null<br>
     *                iRg[̃CX^Xj<br>
     *         () ex:ExceptionCX^X<br>
     *         () this.mappedHandlers:handlerƓIuWFNgvfɎSet<br>
     *         () exceptionResolveDelegatorMap:vfPMap<br>
     *                Exception= ExceptionResolveDelegatorCX^X{ viewName= "exception"}<br>
     *         () getDepthij:uOv<br>
     *         () this.defaultErrorView:null<br>
     *         () this.defaultStatusCode:not null<br>
     *                (200)<br>
     *         () getModelAndView():getModelAndView()\bhԂr[<br>
     *         () exceptionResolveDelegator.setHeader():ĂяoꂽƂmFB<br>
     *         () exceptionResolveDelegator.addObjectToModel():ĂяoꂽƂmFB<br>
     *         
     * <br>
     * ҒlF(߂l) ModelAndView:ModelAndView<br>
     *                  EviewNameFexception<br>
     *                  EmodeliMap^j<br>
     *                  exception=ex<br>
     *         (ԕω) response:Xe[^XR[hݒ肳B<br>
     *         
     * <br>
     * nhOOPLqĂAOɑΉExceptionResolveDelegatorviewNameɒlݒ肳Ăp^[̃eXgBModelAndViewԂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testResolveException04() throws Exception {
        // O
        // Delegator
        SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01 exceptionResolveDelegatorImpl = new SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01();
        exceptionResolveDelegatorImpl.viewName = "exception";
        
        SimpleMappingExceptionResolverEx exceptionResolver = 
            new SimpleMappingExceptionResolverEx();
        UTUtil.setPrivateField(exceptionResolver, "mappedHandlers", null);
        LinkedHashMap<String, ExceptionResolveDelegator> exceptionResolveDelegatorMap = new LinkedHashMap<String, ExceptionResolveDelegator>();
        UTUtil.setPrivateField(
                exceptionResolver, "exceptionResolveDelegatorMap", exceptionResolveDelegatorMap);
        exceptionResolveDelegatorMap.put("java.lang.Exception",exceptionResolveDelegatorImpl);
        String defaultErrorViewName = null;
        UTUtil.setPrivateField(exceptionResolver, "defaultErrorView", defaultErrorViewName);
        int statusCode = 200;
        UTUtil.setPrivateField(
                exceptionResolver, "defaultStatusCode", statusCode);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        Exception exception = new Exception();
        
        // eXg{
        ModelAndView mv = exceptionResolver.resolveException(
                request, response, null, exception);

        // 
        assertEquals(exceptionResolveDelegatorImpl.viewName, mv.getViewName());
        assertSame(exception, mv.getModel().get("exception"));
        
        // X^ǔĂяomF
        assertTrue(exceptionResolveDelegatorImpl.isAddObjectToModel);
        assertTrue(exceptionResolveDelegatorImpl.isSetHeader);

        // O mF
        assertTrue(LogUTUtil.checkError("Handled the following exception.",
                exception));
    }

    /**
     * testResolveException05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,D
     * <br><br>
     * ͒lF() request:gpȂ<br>
     *         () response:not null<br>
     *         () handler:null<br>
     *         () ex:BindExceptionCX^X<br>
     *         () this.mappedHandlers:null<br>
     *         () exceptionResolveDelegatorMap:vfRMap<br>
     *                OXMappingException= ExceptionResolveDelegatorCX^X{ viewName= "oxmException"},<br>
     *                BindException= ExceptionResolveDelegatorCX^X{ viewName= "bindException"},<br>
     *                Exception= ExceptionResolveDelegatorCX^X{ viewName= "exception"}<br>
     *         () getDepthij:u|Pv<br>
     *                uOv<br>
     *         () this.defaultErrorView:null<br>
     *         () this.defaultStatusCode:not null<br>
     *                (200)<br>
     *         () getModelAndView():getModelAndView()\bhԂr[<br>
     *         () exceptionResolveDelegator.setHeader():ĂяoꂽƂmFB<br>
     *         () exceptionResolveDelegator.addObjectToModel():ĂяoꂽƂmFB<br>
     *         
     * <br>
     * ҒlF(߂l) ModelAndView:ModelAndView<br>
     *                  EviewNameFbindException<br>
     *                  EmodeliMap^j<br>
     *                  exception=ex<br>
     *         (ԕω) response:Xe[^XR[hݒ肳B<br>
     *         
     * <br>
     * nhOORLqĂp^[̃eXgBModelAndViewԂBOLqÔQڈȍ~Ōp^[BModelAndViewԂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testResolveException05() throws Exception {
        // O --------------------------------------------------------------
        // Delegator
        SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01 exceptionResolveDelegatorImpl01 = new SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01();
        exceptionResolveDelegatorImpl01.viewName = "oxmException";
        SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01 exceptionResolveDelegatorImpl02 = new SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01();
        exceptionResolveDelegatorImpl02.viewName = "bindException";
        SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01 exceptionResolveDelegatorImpl03 = new SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01();
        exceptionResolveDelegatorImpl03.viewName = "exception";        
        
        SimpleMappingExceptionResolverEx exceptionResolver = 
            new SimpleMappingExceptionResolverEx();
        // 
        Controller controller =
            new SimpleMappingExceptionResolverEx_ControllerImplStub01(); 
        Set<Object> set = new HashSet<Object>();
        set.add(controller);
        UTUtil.setPrivateField(exceptionResolver, "mappedHandlers", set);
        
        LinkedHashMap<String, ExceptionResolveDelegator> exceptionResolveDelegatorMap = new LinkedHashMap<String, ExceptionResolveDelegator>();
        UTUtil.setPrivateField(
                exceptionResolver, "exceptionResolveDelegatorMap", exceptionResolveDelegatorMap);
        exceptionResolveDelegatorMap.put("jp.terasoluna.fw.oxm.exception.OXMappingException", exceptionResolveDelegatorImpl01);
        exceptionResolveDelegatorMap.put("org.springframework.validation.BindException", exceptionResolveDelegatorImpl02);
        exceptionResolveDelegatorMap.put("java.lang.Exception", exceptionResolveDelegatorImpl03);
        String defaultErrorViewName = null;
        UTUtil.setPrivateField(exceptionResolver, "defaultErrorView", defaultErrorViewName);

        int statusCode = 200;
        UTUtil.setPrivateField(
                exceptionResolver, "defaultStatusCode", statusCode);
        
        // \bh 
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        Exception exception = new BindException(new Object(), "name");
        
        // eXg{ ----------------------------------------------------------
        ModelAndView mv = exceptionResolver.resolveException(
                request, response, controller, exception);

        // 
        assertEquals(exceptionResolveDelegatorImpl02.viewName, mv.getViewName());
        assertSame(exception, mv.getModel().get("exception"));
        
        // X^ǔĂяomF
        assertTrue(exceptionResolveDelegatorImpl02.isAddObjectToModel);
        assertTrue(exceptionResolveDelegatorImpl02.isSetHeader);

        // O mF
        assertTrue(LogUTUtil.checkError("Handled the following exception.",
                exception));
    }

    /**
     * testResolveException06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,D
     * <br><br>
     * ͒lF() request:gpȂ<br>
     *         () response:not null<br>
     *         () handler:null<br>
     *         () ex:BindExceptionCX^X<br>
     *         () this.mappedHandlers:null<br>
     *         () exceptionResolveDelegatorMap:vfPMap<br>
     *                Exception= ExceptionResolveDelegatorCX^X{ viewName= "exception"}<br>
     *         () getDepthij:uPv<br>
     *                ilinkedExceptionMappingsŒ`O̐eNX̗OnhOj<br>
     *         () this.defaultErrorView:null<br>
     *         () this.defaultStatusCode:not null<br>
     *                (200)<br>
     *         () getModelAndView():getModelAndView()\bhԂr[<br>
     *         () exceptionResolveDelegator.setHeader():ĂяoꂽƂmFB<br>
     *         () exceptionResolveDelegator.addObjectToModel():ĂяoꂽƂmFB<br>
     *         
     * <br>
     * ҒlF(߂l) ModelAndView:ModelAndView<br>
     *                  EviewNameFexception<br>
     *                  EmodeliMap^j<br>
     *                  exception=ex<br>
     *         (ԕω) response:Xe[^XR[hݒ肳B<br>
     *         
     * <br>
     * nhOOex̐eNXłꍇ̃p^[̃eXgBModelAndViewԂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testResolveException06() throws Exception {
        // O
        // Delegator
        SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01 exceptionResolveDelegatorImpl = new SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01();
        exceptionResolveDelegatorImpl.viewName = "exception";
        
        SimpleMappingExceptionResolverEx exceptionResolver = 
            new SimpleMappingExceptionResolverEx();
        UTUtil.setPrivateField(exceptionResolver, "mappedHandlers", null);
        LinkedHashMap<String, ExceptionResolveDelegator> exceptionResolveDelegatorMap = new LinkedHashMap<String, ExceptionResolveDelegator>();
        UTUtil.setPrivateField(
                exceptionResolver, "exceptionResolveDelegatorMap", exceptionResolveDelegatorMap);
        exceptionResolveDelegatorMap.put("java.lang.Exception",exceptionResolveDelegatorImpl);
        String defaultErrorViewName = null;
        UTUtil.setPrivateField(exceptionResolver, "defaultErrorView", defaultErrorViewName);
        int statusCode = 200;
        UTUtil.setPrivateField(
                exceptionResolver, "defaultStatusCode", statusCode);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        Exception exception = new BindException(new Object(), "name");
        
        // eXg{
        ModelAndView mv = exceptionResolver.resolveException(
                request, response, null, exception);

        // 
        assertEquals(exceptionResolveDelegatorImpl.viewName, mv.getViewName());
        assertSame(exception, mv.getModel().get("exception"));
        
        // X^ǔĂяomF
        assertTrue(exceptionResolveDelegatorImpl.isAddObjectToModel);
        assertTrue(exceptionResolveDelegatorImpl.isSetHeader);

        // O mF
        assertTrue(LogUTUtil.checkError("Handled the following exception.",
                exception));
    }

    /**
     * testResolveException07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,D
     * <br><br>
     * ͒lF() request:gpȂ<br>
     *         () response:not null<br>
     *         () handler:null<br>
     *         () ex:BindExceptionCX^X<br>
     *         () this.mappedHandlers:null<br>
     *         () exceptionResolveDelegatorMap:vfPMap<br>
     *                OXMappingException= ExceptionResolveDelegatorCX^X{ viewName= "oxmException"}<br>
     *         () getDepthij:u|Pv<br>
     *         () this.defaultErrorView:null<br>
     *         () this.defaultStatusCode:not null<br>
     *                (200)<br>
     *         
     * <br>
     * ҒlF(߂l) ModelAndView:null<br>
     *         (ԕω) response:Xe[^XR[hݒ肳B<br>
     *         
     * <br>
     * nhOOPLqĂ邪AOƈvȂp^[BNullԂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testResolveException07() throws Exception {
        // O
        // Delegator
        SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01 exceptionResolveDelegatorImpl = new SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01();
        exceptionResolveDelegatorImpl.viewName = "oxmException";
        
        SimpleMappingExceptionResolverEx exceptionResolver = 
            new SimpleMappingExceptionResolverEx();
        UTUtil.setPrivateField(exceptionResolver, "mappedHandlers", null);
        LinkedHashMap<String, ExceptionResolveDelegator> exceptionResolveDelegatorMap = new LinkedHashMap<String, ExceptionResolveDelegator>();
        UTUtil.setPrivateField(
                exceptionResolver, "exceptionResolveDelegatorMap", exceptionResolveDelegatorMap);
        exceptionResolveDelegatorMap.put("jp.terasoluna.fw.oxm.exception.OXMappingException",exceptionResolveDelegatorImpl);
        String defaultErrorViewName = null;
        UTUtil.setPrivateField(exceptionResolver, "defaultErrorView", defaultErrorViewName);
        int statusCode = 200;
        UTUtil.setPrivateField(
                exceptionResolver, "defaultStatusCode", statusCode);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        Exception exception = new BindException(new Object(), "name");
        
        // eXg{
        ModelAndView mv = exceptionResolver.resolveException(
                request, response, null, exception);

        // 
        assertNull(mv);
    }
    
    /**
     * testResolveException03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C
     * <br><br>
     * ͒lF() request:gpȂ<br>
     *         () response:not null<br>
     *         () handler:null<br>
     *         () ex:ExceptionCX^X<br>
     *         () this.mappedHandlers:null<br>
     *         () exceptionResolveDelegatorMap:vfPMap<br>
     *                Exception= ExceptionResolveDelegatorCX^X{ viewName= null}<br>
     *         () getDepthij:uOv<br>
     *         () this.defaultErrorView:"default"<br>
     *         () this.defaultStatusCode:not null<br>
     *                (200)<br>
     *         () getModelAndView():getModelAndView()\bhԂr[<br>
     *         () exceptionResolveDelegator.setHeader():ĂяoꂽƂmFB<br>
     *         () exceptionResolveDelegator.addObjectToModel():ĂяoꂽƂmFB<br>
     *         () ethis.outputErrorLogHandledException:false<br>
     *         
     * <br>
     * ҒlF(߂l) ModelAndView:ModelAndView<br>
     *                  EviewNameFdefault<br>
     *                  EmodeliMap^j<br>
     *                  exception=ex<br>
     *         (ԕω) response:Xe[^XR[hݒ肳B<br>
     *         
     * <br>
     * nhOȌG[Oo͂ȂݒɂꍇA
     * G[Oo͂ȂƂmFp^[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testResolveException08() throws Exception {
        // O
        // Delegator
        SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01 exceptionResolveDelegatorImpl = new SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01();
        exceptionResolveDelegatorImpl.viewName = null;
        
        SimpleMappingExceptionResolverEx exceptionResolver = 
            new SimpleMappingExceptionResolverEx();
        UTUtil.setPrivateField(exceptionResolver, "mappedHandlers", null);
        LinkedHashMap<String, Object> exceptionResolveDelegatorMap = new LinkedHashMap<String, Object>();
        UTUtil.setPrivateField(
                exceptionResolver, "exceptionResolveDelegatorMap", exceptionResolveDelegatorMap);
        exceptionResolveDelegatorMap.put("java.lang.Exception",exceptionResolveDelegatorImpl);
        String defaultErrorViewName = "default";
        UTUtil.setPrivateField(exceptionResolver, "defaultErrorView", defaultErrorViewName);
        int statusCode = 200;
        UTUtil.setPrivateField(
                exceptionResolver, "defaultStatusCode", statusCode);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        Exception exception = new Exception();
        
        exceptionResolver.setOutputErrorLogHandledException(false);
        
        // eXg{
        ModelAndView mv = exceptionResolver.resolveException(
                request, response, null, exception);

        // 
        assertEquals(defaultErrorViewName, mv.getViewName());
        assertSame(exception, mv.getModel().get("exception"));
        
        // X^ǔĂяomF
        assertTrue(exceptionResolveDelegatorImpl.isAddObjectToModel);
        assertTrue(exceptionResolveDelegatorImpl.isSetHeader);

        // O mF
        assertFalse(LogUTUtil.checkError("Handled the following exception.",
                exception));
    }

    /**
     * testResolveException09()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C
     * <br><br>
     * ͒lF() request:gpȂ<br>
     *         () response:not null<br>
     *         () handler:null<br>
     *         () ex:ExceptionCX^X<br>
     *         () this.mappedHandlers:null<br>
     *         () exceptionResolveDelegatorMap:vfPMap<br>
     *                Exception= ExceptionResolveDelegatorCX^X{ viewName= null}<br>
     *         () getDepthij:uOv<br>
     *         () this.defaultErrorView:null<br>
     *         () this.defaultStatusCode:not null<br>
     *                (200)<br>
     *         
     * <br>
     * ҒlF(߂l) ModelAndView:null<br>
     *         
     * <br>
     * nhOOPLqĂAOɑΉExceptionResolveDelegatorviewNamenullݒ肳Ăp^[̃eXgBftHgG[r[ݒ肳ĂȂ̂NullԂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testResolveException09() throws Exception {
        // O
        // Delegator
        SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01 exceptionResolveDelegatorImpl = new SimpleMappingExceptionResolverEx_ExceptionResolveDelegatorImplStub01();
        exceptionResolveDelegatorImpl.viewName = null;
        
        SimpleMappingExceptionResolverEx exceptionResolver = 
            new SimpleMappingExceptionResolverEx();
        UTUtil.setPrivateField(exceptionResolver, "mappedHandlers", null);
        LinkedHashMap<String, Object> exceptionResolveDelegatorMap = new LinkedHashMap<String, Object>();
        UTUtil.setPrivateField(
                exceptionResolver, "exceptionResolveDelegatorMap", exceptionResolveDelegatorMap);
        exceptionResolveDelegatorMap.put("java.lang.Exception",exceptionResolveDelegatorImpl);
        String defaultErrorViewName = null;
        UTUtil.setPrivateField(exceptionResolver, "defaultErrorView", defaultErrorViewName);
        int statusCode = 200;
        UTUtil.setPrivateField(
                exceptionResolver, "defaultStatusCode", statusCode);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        Exception exception = new Exception();
        
        // eXg{
        ModelAndView mv = exceptionResolver.resolveException(
                request, response, null, exception);

        // 
        assertNull(mv);
    }
    
    /**
     * tNVgpătB[hɃANZX郁\bhB
     * @param cls ANZXNXB
     * @param fieldName ANZXtB[hB
     * @param target ANZXCX^XB
     * @return tB[hlB
     * @throws NoSuchFieldException
     * @throws IllegalAccessException
     */
    private Object getField(Class cls, String fieldName, Object target) 
            throws NoSuchFieldException, IllegalAccessException {
        Field field = cls.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(target);
    }
    
    /**
     * tNVgpătB[hɃANZX郁\bhB
     * @param cls ANZXNXB
     * @param fieldName ANZXtB[hB
     * @param target ANZXCX^XB
     * @param value ݒ肷lB
     * @throws NoSuchFieldException
     * @throws IllegalAccessException
     */
    private void setField(
            Class cls, String fieldName, Object target, Object value) 
            throws NoSuchFieldException, IllegalAccessException {
        Field field = cls.getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(target, value);
    }

}
