/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.io.impl;

import java.util.Collection;

import jp.terasoluna.fw.ex.unit.io.OutputTarget;

/**
 * {@link Collection}ւ̏o̓^[Qbg쐬܂B
 * 
 * <pre>
 * Cӂ̓̓\[X̃f[^Cӂ{@link Collection}ɕۑ邱Ƃł܂B
 * </pre>
 * 
 */
public class CollectionTarget<T> implements OutputTarget<T> {
    protected final Collection<T> collection;

    /**
     * RXgN^
     * 
     * @param collection
     *            o͐ƂȂRNV
     */
    public CollectionTarget(Collection<T> collection) {
        this.collection = collection;
    }

    public void writeHeader(String[] header) {
        // ܂
    }

    public void write(T obj) {
        collection.add(obj);
    }

    public void close() {
        // ܂
    }

}
